/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.CheckerHelper;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class JTextAreaChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JTextAreaChecker");
    private CheckType[] b = new CheckType[]{CheckType.TEXT, CheckType.LINES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.LINE, CheckType.TEXT, CheckType.LINES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.EDITABLE, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.GEOMETRY};

    public JTextAreaChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JTextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 113).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        return object2 == null ? this.b : this.c;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (JTextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 131).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object2 != null && checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.LINE.getIdentifier().equals(checkType.getIdentifier()) || "line".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
            try {
                String string = ItemRegistry.instance().getItemValue(object, object2);
                return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
            }
            catch (BadItemException badItemException) {
                if (JTextAreaChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 150).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
        }
        JTextArea jTextArea = (JTextArea)object;
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()))) {
            return new StringCheckData("default", Misc.lineSepToLineFeed((String)jTextArea.getText()));
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.LINES.getIdentifier().equals(checkType.getIdentifier()) || "lines".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            int n2;
            Object object3;
            int n3 = 0;
            int n4 = jTextArea.getLineCount();
            if (object2 instanceof Integer && !Client.instance().isCaptureContext()) {
                block20: {
                    n3 = (Integer)object2;
                    object3 = CheckerHelper.instance().getCheckParameters();
                    n2 = -1;
                    if (object3 != null && object3.containsKey("count")) {
                        try {
                            n2 = Integer.parseInt((String)object3.get("count"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (JTextAreaChecker.a.level < 1) break block20;
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 178).add("Bad parameter count: ")).add((String)object3.get("count"))).log();
                        }
                    }
                }
                if (n2 > 0 && n2 <= n4 - (Integer)object2) {
                    n4 = n3 + n2;
                }
            }
            if (JTextAreaChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 185).add("start", n3)).add("count", n4)).log();
            }
            object3 = new String[n4 - n3];
            for (n2 = n3; n2 < n4; ++n2) {
                try {
                    int n5 = jTextArea.getLineStartOffset(n2);
                    int n6 = jTextArea.getLineEndOffset(n2);
                    String string = Util.getCleanElementText((String)jTextArea.getText(n5, n6 - n5));
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    object3[n2 - n3] = string;
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    if (JTextAreaChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 197).add("ex", (Object)badLocationException)).log();
                    }
                    return null;
                }
            }
            if (JTextAreaChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 201).add("lines", object3)).log();
            }
            return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), (String[])object3);
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), jTextArea.isEditable());
        }
        return super.getCheckData(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (JTextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 227).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.LINE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

