/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.check.JComponentChecker;
import de.qfs.apps.qftest.client.awt.s;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.SelectableItemsCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.gui.JTreePathAdapter;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Pair;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class JTreeChecker
extends JComponentChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.check.JTreeChecker");
    private CheckType[] b = new CheckType[]{CheckType.NODES, CheckType.NODES_WITH_SELECTION, CheckType.NESTED_NODES, CheckType.VISIBLE_NESTED_NODES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.TOOLTIP, CheckType.GEOMETRY};
    private CheckType[] c = new CheckType[]{CheckType.NODE, CheckType.NODE_VISIBLE, CheckType.NODE_SELECTED, CheckType.NESTED_SUBNODES, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.NODES, CheckType.NODES_WITH_SELECTION, CheckType.NODE_SELECTED, CheckType.NESTED_NODES, CheckType.VISIBLE_NESTED_NODES, CheckType.VISIBLE, CheckType.ENABLED, CheckType.FOCUSED, CheckType.IMAGE, CheckType.VISIBLE_IMAGE, CheckType.NODE_IMAGE, CheckType.NODE_TOOLTIP, CheckType.TOOLTIP, CheckType.GEOMETRY};

    public JTreeChecker(s s2) {
        super(s2);
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (JTreeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 130).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (!Client.instance().isCaptureContext()) {
            CheckType[] checkTypeArray = new CheckType[this.c.length + 2];
            System.arraycopy(this.c, 0, checkTypeArray, 0, this.c.length);
            checkTypeArray[this.c.length] = CheckType.SELECTED;
            checkTypeArray[this.c.length + 1] = CheckType.TOOLTIP;
            return object2 == null ? this.b : checkTypeArray;
        }
        return object2 == null ? this.b : this.c;
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (JTreeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 160).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        JTree jTree = (JTree)object;
        if (object2 != null) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.NODE.getIdentifier().equals(checkType.getIdentifier()) || "node".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    String string = ItemRegistry.instance().getItemValue(object, object2);
                    return new StringCheckData(CheckType.NODE.getIdentifier(), string);
                }
                catch (BadItemException badItemException) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 174).add("ex", (Object)badItemException)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.NODE_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "node_visible".equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), true);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.NODE_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "node_selected".equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    TreePath treePath = (TreePath)object2;
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), jTree.isPathSelected(treePath));
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 195).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || "node_tooltip".equals(checkType.getIdentifier()) || CheckType.ITEM_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    boolean bl2 = Client.instance().isCaptureContext() && CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier());
                    return new StringCheckData((bl2 ? CheckType.TOOLTIP : CheckType.ITEM_TOOLTIP).getIdentifier(), this.engine.getHelper().getTooltipText(jTree, bl2 ? null : object2));
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 211).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || "node_image".equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    ImageRep imageRep = this.grabImage((Component)object, object2);
                    return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 228).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING_LIST && ((CheckType.NESTED_NODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE_NESTED_NODES.getIdentifier().equals(checkType.getIdentifier())) && !Client.instance().isCaptureContext() || CheckType.NESTED_SUBNODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE_NESTED_SUBNODES.getIdentifier().equals(checkType.getIdentifier()))) {
                boolean bl3 = CheckType.VISIBLE_NESTED_NODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE_NESTED_SUBNODES.getIdentifier().equals(checkType.getIdentifier());
                try {
                    ArrayList arrayList = new ArrayList();
                    TreeUtil.traverse((TreeAdapter)new JTreePathAdapter(jTree.getModel()), (Object)object2, (TraversalCallback)new a(jTree, arrayList, !bl3));
                    return new StringItemsCheckData(bl3 ? CheckType.VISIBLE_NESTED_NODES.getIdentifier() : CheckType.NESTED_NODES.getIdentifier(), arrayList.toArray(new String[0]));
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 254).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST) {
            if (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.NODES.getIdentifier().equals(checkType.getIdentifier()) || "nodes".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier())) {
                try {
                    int n2 = jTree.getRowCount();
                    String[] stringArray = new String[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        TreePath treePath = jTree.getPathForRow(i2);
                        stringArray[i2] = ItemRegistry.instance().getItemValue(object, treePath);
                    }
                    return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 274).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if ((CheckType.NESTED_NODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE_NESTED_NODES.getIdentifier().equals(checkType.getIdentifier())) && (object2 == null || Client.instance().isCaptureContext())) {
                boolean bl4 = CheckType.VISIBLE_NESTED_NODES.getIdentifier().equals(checkType.getIdentifier());
                try {
                    ArrayList arrayList = new ArrayList();
                    TreeUtil.traverse((TreeAdapter)new JTreePathAdapter(jTree.getModel()), (Object)new TreePath(jTree.getModel().getRoot()), (TraversalCallback)new a(jTree, arrayList, !bl4));
                    return new StringItemsCheckData(checkType.getIdentifier(), arrayList.toArray(new String[0]));
                }
                catch (Exception exception) {
                    if (JTreeChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 291).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        if (checkType.getDataType() == CheckDataType.SELECTABLE_STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || "nodes_with_selection".equals(checkType.getIdentifier()) || CheckType.NODES_WITH_SELECTION.getIdentifier().equals(checkType.getIdentifier()))) {
            try {
                int n3 = jTree.getRowCount();
                Object[][] objectArray = new Object[n3][];
                for (int i3 = 0; i3 < n3; ++i3) {
                    TreePath treePath = jTree.getPathForRow(i3);
                    objectArray[i3] = new Object[]{ItemRegistry.instance().getItemValue(object, treePath), Boolean.FALSE, jTree.isRowSelected(i3)};
                }
                return new SelectableItemsCheckData(CheckType.NODES_WITH_SELECTION.getIdentifier(), objectArray, false);
            }
            catch (Exception exception) {
                if (JTreeChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckData(Object,Object,CheckType)", 314).add("ex", (Object)exception)).log();
                }
                return null;
            }
        }
        return super.getCheckData(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (JTreeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 336).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        CheckData checkData = null;
        checkData = CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : this.getCheckData(object, object2, checkType));
        if (checkData == null) {
            return null;
        }
        if (CheckType.NESTED_SUBNODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE_NESTED_SUBNODES.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_TOOLTIP.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }

    public static class a
    implements TraversalCallback {
        private JTree a;
        private ArrayList b;
        private boolean c;
        private String d = "";
        private String e = Client.instance().getOptions().getString("TreeCheckIndent", "+");

        public a(JTree jTree, ArrayList arrayList, boolean bl2) {
            this.a = jTree;
            this.b = arrayList;
            this.c = bl2;
            StringBuffer stringBuffer = new StringBuffer();
        }

        public boolean nodeEntered(Traversal traversal) {
            TreePath treePath;
            block2: {
                treePath = (TreePath)traversal.getNode();
                try {
                    this.b.add(this.d + ItemRegistry.instance().getItemValue(this.a, treePath));
                }
                catch (BadItemException badItemException) {
                    if (a.level < 1) break block2;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "TreeItemTraversal.nodeEntered(Traversal)", 439).add("ex", (Object)badItemException)).log();
                }
            }
            this.d = this.d + this.e;
            return this.c || this.a.isExpanded(treePath);
        }

        public void nodeExited(Traversal traversal) {
            this.d = this.d.substring(0, this.d.length() - 1);
        }
    }
}

