/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.items;

import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.IndexRequiredException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class JEditorPaneItemResolver
implements ItemResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.items.JEditorPaneItemResolver");

    public JEditorPaneItemResolver() {
        if (JEditorPaneItemResolver.a.level >= 7) {
            a.lvlBuild(7, "JEditorPaneItemResolver()", 59).log();
        }
    }

    @Override
    public Object getItem(Object object, int n2, int n3) {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 81).addDetail("element", object)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        if (!(object instanceof JEditorPane)) {
            if (JEditorPaneItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 84).add("Internal error: Not a JEditorPane", object)).log();
            }
            return null;
        }
        JEditorPane jEditorPane = (JEditorPane)object;
        Point point = new Point(n2, n3);
        int n4 = jEditorPane.viewToModel(point);
        if (n4 < 0) {
            return null;
        }
        Element element = jEditorPane.getDocument().getDefaultRootElement();
        while (element.getElementCount() > 0) {
            element = element.getElement(element.getElementIndex(n4));
        }
        int n5 = element.getStartOffset();
        int n6 = element.getEndOffset();
        n4 = (n5 + n6) / 2;
        if (JEditorPaneItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 103).add("index", n4)).log();
        }
        if (n4 < 0) {
            return null;
        }
        return n4;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        int n2;
        int n3;
        block7: {
            if (JEditorPaneItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 123).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
            }
            this.checkItem(object, null);
            JEditorPane jEditorPane = (JEditorPane)object;
            SubItemIndex subItemIndex = subItemIndexArray[0];
            if (subItemIndex == null) {
                throw new IndexRequiredException(true, "JEditorPane");
            }
            Element element = jEditorPane.getDocument().getDefaultRootElement();
            Element element2 = this.findIndex(jEditorPane, element, subItemIndex);
            if (element2 == null) {
                throw new IndexNotFoundException(subItemIndex);
            }
            n3 = element2.getStartOffset();
            n2 = element2.getEndOffset();
            if (Options.cached_OPT_PLAY_SCROLL_ITEM) {
                try {
                    Rectangle rectangle = jEditorPane.modelToView((n3 + n2) / 2);
                    if (rectangle != null) {
                        jEditorPane.scrollRectToVisible(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (JEditorPaneItemResolver.a.level < 3) break block7;
                    ((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 151).add("ex", (Object)badLocationException)).log();
                }
            }
        }
        return (n3 + n2) / 2;
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 169).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JEditorPane jEditorPane = (JEditorPane)object;
        int n2 = (Integer)object2;
        Element element = jEditorPane.getDocument().getDefaultRootElement();
        while (element.getElementCount() > 0) {
            element = element.getElement(element.getElementIndex(n2));
        }
        try {
            int n3 = element.getStartOffset();
            int n4 = element.getEndOffset();
            return Util.getCleanElementText((String)jEditorPane.getText(n3, n4 - n3));
        }
        catch (Exception exception) {
            if (JEditorPaneItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemValue(Object,Object)", 188).add("ex", (Object)exception)).log();
            }
            throw new BadItemException("Internal error");
        }
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 208).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JEditorPane jEditorPane = (JEditorPane)object;
        int n3 = (Integer)object2;
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        Element element = jEditorPane.getDocument().getDefaultRootElement();
        while (element.getElementCount() > 0) {
            element = element.getElement(element.getElementIndex(n3));
        }
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        switch (n2) {
            case 1: 
            case 2: {
                try {
                    String string = Util.getFlatIdentifierText((String)jEditorPane.getText(n4, n5 - n4));
                    if (string.endsWith("\n")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    subItemIndexArray[0] = new SubItemIndex(string, "\\#@&%");
                    break;
                }
                catch (Exception exception) {
                    if (JEditorPaneItemResolver.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemIndex(Object,Object,int)", 237).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            case 3: {
                subItemIndexArray[0] = new SubItemIndex((n4 + n5) / 2);
            }
        }
        if (Options.getInt((String)Options.OPT_RECORD_SUBITEM_TYPE, (int)1) == 1) {
            subItemIndexArray[0].setSuggestNode(true);
        }
        return subItemIndexArray;
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 269).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JEditorPane jEditorPane = (JEditorPane)object;
        int n2 = (Integer)object2;
        Element element = jEditorPane.getDocument().getDefaultRootElement();
        while (element.getElementCount() > 0) {
            element = element.getElement(element.getElementIndex(n2));
        }
        try {
            Rectangle rectangle = jEditorPane.modelToView(element.getStartOffset());
            return new int[]{rectangle.x, rectangle.y};
        }
        catch (Exception exception) {
            if (JEditorPaneItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemLocation(Object,Object)", 288).add("ex", (Object)exception)).log();
            }
            throw new BadItemException("Internal error");
        }
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 307).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        if (JEditorPaneItemResolver.a.level >= 5) {
            ((LevelAwareLogBuilder)a.lvlBuild(5, "getItemSize(Object,Object)", 315).add("Not implemented")).log();
        }
        return new int[]{1, 1};
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 338).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 363).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.checkItem(object, object2);
        return null;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (JEditorPaneItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 389).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        return 0;
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (!(object instanceof JEditorPane)) {
            if (JEditorPaneItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 417).add("Internal error: Not a JEditorPane", object)).log();
            }
            throw new BadItemException("Not a JEditorPane: " + object);
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (JEditorPaneItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 421).add("Internal error: Not an Integer", object2)).log();
            }
            throw new BadItemException("Not an Integer: " + object2);
        }
    }

    protected Element findIndex(JEditorPane jEditorPane, Element element, SubItemIndex subItemIndex) throws TestException {
        if (subItemIndex.getType() == 0 || subItemIndex.getType() == 2) {
            Object object;
            if (element.getElementCount() == 0) {
                Boolean bl2 = ItemRegistry.instance().matchesItemName((Object)jEditorPane, element, subItemIndex, subItemIndex.getIndex());
                if (bl2 != null) {
                    if (bl2.booleanValue()) {
                        if (JEditorPaneItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "findIndex(JEditorPane,Element,SubItemIndex)", 453).add("item matcher matches.")).log();
                        }
                        return element;
                    }
                    return null;
                }
                object = h.a(element);
                if (subItemIndex.matches((String)object)) {
                    return element;
                }
            }
            for (int i2 = 0; i2 < element.getElementCount(); ++i2) {
                object = this.findIndex(jEditorPane, element.getElement(i2), subItemIndex);
                if (object == null) continue;
                return object;
            }
        } else if (subItemIndex.getType() == 1) {
            if (element.getElementCount() == 0) {
                return element;
            }
            return this.findIndex(jEditorPane, element.getElement(element.getElementIndex(subItemIndex.asNumber())), subItemIndex);
        }
        return null;
    }
}

