/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.awt.items;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.awt.data.h;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;

public class JListItemResolver
implements ItemResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.awt.items.JListItemResolver");

    public JListItemResolver() {
        if (JListItemResolver.a.level >= 7) {
            a.lvlBuild(7, "JListItemResolver()", 58).log();
        }
    }

    @Override
    public Object getItem(Object object, int n2, int n3) {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 80).addDetail("element", object)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        if (!(object instanceof JList)) {
            if (JListItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 83).add("Internal error: Not a JList", object)).log();
            }
            return null;
        }
        JList jList = (JList)object;
        Point point = new Point(n2, n3);
        int n4 = jList.locationToIndex(point);
        if (JListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 90).add("index", n4)).log();
        }
        if (n4 < 0) {
            return null;
        }
        return n4;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        Rectangle rectangle;
        int n2;
        SubItemIndex subItemIndex;
        int n3;
        JList jList;
        block7: {
            block6: {
                if (JListItemResolver.a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 110).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                }
                this.checkItem(object, null);
                jList = (JList)object;
                n3 = -1;
                subItemIndex = subItemIndexArray[0];
                n2 = jList.getModel().getSize();
                if (subItemIndex.getType() != 1) break block6;
                n3 = subItemIndex.asNumber();
                if (n3 >= 0) break block7;
                n3 = n2 + n3;
                break block7;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.a(jList, i2, true);
                Boolean bl2 = ItemRegistry.instance().matchesItemName((Object)jList, i2, subItemIndex, subItemIndex.getIndex());
                if (bl2 != null) {
                    if (!bl2.booleanValue()) continue;
                    if (JListItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 135).add("item matcher matches.")).log();
                    }
                    n3 = i2;
                    break;
                }
                if (!subItemIndex.matches(string)) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 < 0 || n3 >= n2) {
            throw new IndexNotFoundException(subItemIndex);
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM && (rectangle = jList.getCellBounds(n3, n3)) != null) {
            jList.scrollRectToVisible(rectangle);
        }
        return n3;
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 178).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JList jList = (JList)object;
        int n2 = (Integer)object2;
        if (n2 < 0 || n2 >= jList.getModel().getSize()) {
            return null;
        }
        return this.c(jList, n2, true);
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 209).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JList jList = (JList)object;
        int n3 = (Integer)object2;
        if (n3 < 0) {
            return null;
        }
        SubItemIndex[] subItemIndexArray = new SubItemIndex[1];
        switch (n2) {
            case 1: {
                boolean bl2;
                int n4 = jList.getModel().getSize();
                String string = this.a(jList, n3, true);
                boolean bl3 = bl2 = string != null && string.length() > 0;
                if (bl2) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        if (i2 == n3 || !Misc.equalOrNull((Object)string, (Object)this.a(jList, i2, true))) continue;
                        bl2 = false;
                        break;
                    }
                }
                subItemIndexArray[0] = bl2 ? new SubItemIndex(string, "\\#@&%") : new SubItemIndex(n3);
                break;
            }
            case 2: {
                subItemIndexArray[0] = new SubItemIndex(this.a(jList, n3, true), "\\#@&%");
                break;
            }
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n3);
            }
        }
        if (Options.getInt((String)Options.OPT_RECORD_SUBITEM_TYPE, (int)1) == 1) {
            subItemIndexArray[0].setSuggestNode(subItemIndexArray[0].getType() == 0);
        }
        return subItemIndexArray;
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 272).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JList jList = (JList)object;
        int n2 = (Integer)object2;
        int n3 = jList.getModel().getSize();
        if (n2 < 0 || n2 >= n3) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        Rectangle rectangle = jList.getCellBounds(n2, n2);
        return new int[]{rectangle.x, rectangle.y};
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 304).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        if (object2 == null) {
            throw new BadItemException("Item is null");
        }
        JList jList = (JList)object;
        int n2 = (Integer)object2;
        int n3 = jList.getModel().getSize();
        if (n2 < 0 || n2 >= n3) {
            throw new BadItemException("Item " + object2 + " does not belong to " + object);
        }
        Rectangle rectangle = jList.getCellBounds(n2, n2);
        return new int[]{rectangle.width, rectangle.height};
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 341).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        this.checkItem(object, object2);
        if (nArray[0] >= 0 && nArray[1] >= 0) {
            if (Client.instance().getOptions().getBoolean("RepositionMiddle", true)) {
                nArray[0] = Integer.MAX_VALUE;
                nArray[1] = Integer.MAX_VALUE;
            } else {
                nArray[0] = Math.min(nArray[0], 1);
                nArray[1] = Math.min(nArray[1], 1);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 377).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.checkItem(object, object2);
        return null;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 403).addDetail("element", object)).addDetail("item", object2)).log();
        }
        this.checkItem(object, object2);
        JList jList = (JList)object;
        int n2 = jList.getModel().getSize();
        if (JListItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemCount(Object,Object)", 409).add("returned count", n2)).log();
        }
        return n2;
    }

    protected void checkItem(Object object, Object object2) throws BadItemException {
        if (!(object instanceof JList)) {
            if (JListItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 433).add("Internal error: Not a JList", object)).log();
            }
            throw new BadItemException("Not a JList: " + object);
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            if (JListItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "checkItem(Object,Object)", 437).add("Internal error: Not an Integer", object2)).log();
            }
            throw new BadItemException("Not an Integer: " + object2);
        }
    }

    private String a(JList jList, int n2, boolean bl2) {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getRowName(JList,int,boolean)", 454).addDetail("list", (Object)jList)).addDetail("row", n2)).addDetail("useRenderer", bl2)).log();
        }
        String string = this.b(jList, n2, bl2);
        return ItemRegistry.instance().getItemName(jList, n2, string);
    }

    private String b(JList jList, int n2, boolean bl2) {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultRowName(JList,int,boolean)", 472).addDetail("list", (Object)jList)).addDetail("row", n2)).addDetail("useRenderer", bl2)).log();
        }
        return h.a(jList, n2, bl2);
    }

    private String c(JList jList, int n2, boolean bl2) {
        if (JListItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultRowValue(JList,int,boolean)", 489).addDetail("list", (Object)jList)).addDetail("row", n2)).addDetail("useRenderer", bl2)).log();
        }
        return h.b(jList, n2, bl2);
    }
}

