/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.bweb.os;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.bweb.a;
import de.qfs.apps.qftest.client.bweb.aq;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsLinux;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsMacOS;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsWin;
import de.qfs.apps.qftest.client.bweb.x;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public abstract class BridgedBrowserNativeFunctions {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctions");
    final x engine;
    @Nullable
    final a browser;
    private final Set knownProcesses = new HashSet();
    int bufferedProcessId = 0;

    protected BridgedBrowserNativeFunctions(x x2, @Nullable a a2) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BridgedBrowserNativeFunctions(BridgedWebEngine,BridgedBrowser)", 58).addDetail("engine", (Object)x2)).addDetail("browser", (Object)a2)).log();
        }
        this.engine = x2;
        this.browser = a2;
    }

    public static BridgedBrowserNativeFunctions create(x x2, @Nullable a a2) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "create(BridgedWebEngine,BridgedBrowser)", 72).addDetail("engine", (Object)x2)).addDetail("browser", (Object)a2)).log();
        }
        if (Misc.OS_IS_WINDOWS) {
            return new BridgedBrowserNativeFunctionsWin(x2, a2);
        }
        if (Misc.OS_IS_MAC_OS_X) {
            return new BridgedBrowserNativeFunctionsMacOS(x2, a2);
        }
        return new BridgedBrowserNativeFunctionsLinux(x2, a2);
    }

    public abstract int getProcessIdOfBrowserWindow();

    public abstract void preload();

    public void restoreMinimizedWindow() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "restoreMinimizedWindow()", 101).log();
        }
    }

    public void bringToFront(boolean bl2) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(boolean)", 111).addDetail("forcedRaise", bl2)).log();
        }
        if (this.browser == null) {
            return;
        }
    }

    public boolean forceCloseBrowserWindow() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "forceCloseBrowserWindow()", 128).log();
        }
        return false;
    }

    public abstract void resetInvalidHandle();

    public Object getHandle() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "getHandle()", 142).log();
        }
        return null;
    }

    public void setWindowPosAndSize(@Nullable Point point, @Nullable Dimension dimension) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowPosAndSize(Point,Dimension)", 149).addDetail("point", (Object)point)).addDetail("size", (Object)dimension)).log();
        }
    }

    public void setWindowPos(int n2, int n3) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowPos(int,int)", 156).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        this.setWindowPosAndSize(new Point(n2, n3), null);
    }

    public void setWindowSize(int n2, int n3) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowSize(int,int)", 163).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        this.setWindowPosAndSize(null, new Dimension(n2, n3));
    }

    public abstract Set getProcessIds(String var1);

    public abstract LinkedHashSet getProcessIdsWithCommandlineFilter(@Nullable BiFunction var1);

    protected abstract void killProcess(int var1);

    public void rememberProcesses(String string) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "rememberProcesses(String)", 191).addDetail("processName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("processName is marked non-null but is null");
        }
        if ("".equals(string)) {
            return;
        }
        Set set = this.getProcessIds(string);
        this.knownProcesses.addAll(set);
    }

    public Set getUnknownProcesses(String string) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getUnknownProcesses(String)", 203).addDetail("processName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("processName is marked non-null but is null");
        }
        if ("".equals(string)) {
            return new HashSet();
        }
        Set set = this.getProcessIds(string);
        set.removeAll(this.knownProcesses);
        return set;
    }

    public int[] screenPosToClientAreaPos(long l2, int[] nArray) {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "screenPosToClientAreaPos(long,int[])", 219).addDetail("handle", l2)).addDetail("screenPos", (Object)nArray)).log();
        }
        return nArray;
    }

    public Point getRenderAreaOrigin() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "getRenderAreaOrigin()", 230).log();
        }
        return null;
    }

    public void detectScrollAreaAsRenderArea() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "detectScrollAreaAsRenderArea()", 238).log();
        }
    }

    protected void registerBrowserProcessId() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "registerBrowserProcessId()", 245).log();
        }
        if (this.browser instanceof aq) {
            aq aq2 = (aq)this.browser;
            boolean bl2 = aq2.getBrowserFactory().H();
            if (BridgedBrowserNativeFunctions.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerBrowserProcessId()", 249).add("directlyConnecting", bl2)).log();
            }
            if (bl2) {
                if (BridgedBrowserNativeFunctions.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "registerBrowserProcessId()", 251).add("Directly connecting, so don't force close browser")).log();
                }
                return;
            }
        }
        this.bufferedProcessId = this.getProcessIdOfBrowserWindow();
        if (this.bufferedProcessId > 0) {
            Client.instance().addSupplementalChildPid(this.bufferedProcessId);
        }
    }

    public int getBufferedProcessId() {
        if (BridgedBrowserNativeFunctions.logger.level >= 7) {
            logger.lvlBuild(7, "getBufferedProcessId()", 53).log();
        }
        return this.bufferedProcessId;
    }
}

