/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.bweb.os;

import de.qfs.apps.qftest.client.bweb.a;
import de.qfs.apps.qftest.client.bweb.ag;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsUnix;
import de.qfs.apps.qftest.client.bweb.x;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.system.LinuxNativeDirect;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class BridgedBrowserNativeFunctionsLinux
extends BridgedBrowserNativeFunctionsUnix {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsLinux");
    private final AtomicReference loadNativeMonitor = new AtomicReference();
    private volatile Integer cachedWindowHandle = null;

    public BridgedBrowserNativeFunctionsLinux(x x2, @Nullable a a2) {
        super(x2, a2);
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BridgedBrowserNativeFunctionsLinux(BridgedWebEngine,BridgedBrowser)", 59).addDetail("engine", (Object)x2)).addDetail("browser", (Object)a2)).log();
        }
        if (Misc.OS_IS_LINUX) {
            Util.invokeAndWaitForSwingHelper(() -> {
                boolean bl2;
                if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "BridgedBrowserNativeFunctionsLinux(BridgedWebEngine,BridgedBrowser)", 65).add("Init LinuxNativeDirect")).log();
                }
                if (this.loadNativeMonitor.get() != null) {
                    if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "BridgedBrowserNativeFunctionsLinux(BridgedWebEngine,BridgedBrowser)", 68).add("LinuxNativeDirect already loaded?")).log();
                    }
                    return;
                }
                Native native_ = Native.instance();
                assert (native_ instanceof LinuxNativeDirect);
                this.loadNativeMonitor.set(native_);
                boolean bl3 = GraphicsEnvironment.isHeadless();
                boolean bl4 = bl2 = bl3 || a2 != null && a2.isHeadless() || Misc.JAVA_IS_ARM;
                if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "BridgedBrowserNativeFunctionsLinux(BridgedWebEngine,BridgedBrowser)", 79).add("systemIsHeadless", bl3)).add("skipInitializeLinuxNative", bl2)).log();
                }
                if (!bl2) {
                    LinuxNativeDirect.GetKeyCodeForModifier((int)0);
                }
                AtomicReference atomicReference = this.loadNativeMonitor;
                synchronized (atomicReference) {
                    this.loadNativeMonitor.notifyAll();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assureNativeLibLoaded() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "assureNativeLibLoaded()", 97).log();
        }
        AtomicReference atomicReference = this.loadNativeMonitor;
        synchronized (atomicReference) {
            while (this.loadNativeMonitor.get() == null) {
                this.loadNativeMonitor.wait();
            }
        }
    }

    @Override
    public void preload() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "preload()", 109).log();
        }
    }

    @Override
    public void resetInvalidHandle() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "resetInvalidHandle()", 117).log();
        }
        if (Integer.valueOf(0).equals(this.cachedWindowHandle)) {
            this.cachedWindowHandle = null;
        }
    }

    @Override
    public Long getHandle() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "getHandle()", 132).log();
        }
        if (this.browser == null) {
            return 0L;
        }
        if (this.browser.isHeadless()) {
            return 0L;
        }
        if (this.cachedWindowHandle != null) {
            return (long)this.cachedWindowHandle;
        }
        this.getWindowHandleDirectly();
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getHandle()", 139).add("cachedWindowHandle", (Object)this.cachedWindowHandle)).log();
        }
        if (this.cachedWindowHandle == null) {
            this.searchForWindowHandle();
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getHandle()", 143).add("cachedWindowHandle", (Object)this.cachedWindowHandle)).log();
            }
        }
        if (this.cachedWindowHandle != null) {
            this.registerBrowserProcessId();
        }
        return (long)this.cachedWindowHandle;
    }

    protected void getWindowHandleDirectly() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "getWindowHandleDirectly()", 156).log();
        }
        if (!(this.browser instanceof ag)) {
            return;
        }
        long l2 = ((ag)((Object)this.browser)).R_();
        if (l2 == 0L) {
            return;
        }
        this.cachedWindowHandle = (int)l2;
    }

    protected void searchForWindowHandle() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "searchForWindowHandle()", 169).log();
        }
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandle()", 171).add("Getting window handle")).dumpStack();
        }
        String string = this.browser.w();
        String string2 = this.browser.e(string);
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandle()", 175).add("titleFromBrowser", string)).add("fullBrowserTitle", string2)).log();
        }
        this.searchForWindowHandle(string2, 0L);
        this.searchForWindowHandle(string2, 100L);
        this.searchForWindowHandle(string2, 150L);
        this.searchForWindowHandle(string2, 250L);
        this.searchForWindowHandle(string2, 500L);
        if (this.cachedWindowHandle == null) {
            this.cachedWindowHandle = 0;
        }
        assert (this.cachedWindowHandle != null);
    }

    private void searchForWindowHandle(String string, long l2) {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "searchForWindowHandle(String,long)", 194).addDetail("browserTitle", string)).addDetail("preDelay", l2)).log();
        }
        if (this.cachedWindowHandle != null) {
            return;
        }
        if (l2 > 0L) {
            block6: {
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    if (BridgedBrowserNativeFunctionsLinux.logger.level < 5) break block6;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "searchForWindowHandle(String,long)", 203).add("e", (Object)interruptedException)).log();
                }
            }
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandle(String,long)", 205).add("preDelay finished")).log();
            }
        }
        this.cachedWindowHandle = this.searchForWindowHandleViaNative(string);
    }

    @Nullable
    protected Integer searchForWindowHandleViaNative(String string) {
        int[] nArray;
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "searchForWindowHandleViaNative(String)", 215).addDetail("browserTitle", string)).log();
        }
        this.assureNativeLibLoaded();
        string = Misc.normalizeCharacters((String)string);
        for (int n2 : nArray = LinuxNativeDirect.GetAllWindows()) {
            String string2 = LinuxNativeDirect.GetWindowText((int)n2);
            string2 = Misc.normalizeCharacters((String)string2);
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandleViaNative(String)", 224).add("windowText", string2)).log();
            }
            if (!this.textContainsAllWordsOfTitel(string2, string)) continue;
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandleViaNative(String)", 226).add("window", n2)).log();
            }
            return n2;
        }
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForWindowHandleViaNative(String)", 230).add("No window handle found")).log();
        }
        return null;
    }

    protected boolean textContainsAllWordsOfTitel(String string, String string2) {
        String[] stringArray;
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "textContainsAllWordsOfTitel(String,String)", 237).addDetail("text", string)).addDetail("title", string2)).log();
        }
        for (String string3 : stringArray = string2.split(" ")) {
            if (string.contains(string3.trim())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getProcessIdOfBrowserWindow() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "getProcessIdOfBrowserWindow()", 251).log();
        }
        if (this.browser == null) {
            return 0;
        }
        if (this.getHandle() == 0L) {
            return 0;
        }
        int n2 = 0;
        if (this.browser instanceof ag) {
            n2 = ((ag)((Object)this.browser)).H_();
        }
        if (n2 != 0) {
            return n2;
        }
        this.assureNativeLibLoaded();
        return LinuxNativeDirect.GetWindowProcessId((int)this.cachedWindowHandle);
    }

    @Override
    public void bringToFront(boolean bl2) {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(boolean)", 270).addDetail("forcedRaise", bl2)).log();
        }
        if (this.browser == null) {
            return;
        }
        if (this.getHandle() == 0L) {
            return;
        }
        this.assureNativeLibLoaded();
        LinuxNativeDirect.SetForeground((int)this.cachedWindowHandle);
    }

    @Override
    public void setWindowPosAndSize(@Nullable Point point, @Nullable Dimension dimension) {
        int[] nArray;
        block7: {
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowPosAndSize(Point,Dimension)", 284).addDetail("point", (Object)point)).addDetail("size", (Object)dimension)).log();
            }
            if (this.browser == null) {
                return;
            }
            if (this.getHandle() == 0L) {
                return;
            }
            this.assureNativeLibLoaded();
            nArray = new int[]{0, 0, 100, 100};
            try {
                int[] nArray2 = LinuxNativeDirect.GetWindowRect((int)this.cachedWindowHandle);
                System.arraycopy(nArray2, 0, nArray, 0, Math.min(nArray.length, nArray2.length));
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsLinux.logger.level < 3) break block7;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "setWindowPosAndSize(Point,Dimension)", 294).add("Could not get window rect", (Object)exception)).log();
            }
        }
        if (point != null) {
            nArray[0] = point.x;
            nArray[1] = point.y;
        }
        if (dimension != null) {
            nArray[2] = dimension.width;
            nArray[3] = dimension.height;
        }
        LinuxNativeDirect.SetWindowRect((int)this.cachedWindowHandle, (int)nArray[0], (int)nArray[1], (int)nArray[2], (int)nArray[3]);
    }

    @Override
    public boolean forceCloseBrowserWindow() {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            logger.lvlBuild(7, "forceCloseBrowserWindow()", 313).log();
        }
        if (this.browser == null) {
            return false;
        }
        if (this.getHandle() == 0L) {
            return false;
        }
        this.assureNativeLibLoaded();
        try {
            LinuxNativeDirect.CloseWindow((int)this.cachedWindowHandle);
        }
        catch (Exception exception) {
            if (BridgedBrowserNativeFunctionsLinux.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "forceCloseBrowserWindow()", 322).add("e", (Object)exception)).log();
            }
            return false;
        }
        return true;
    }

    protected BridgedBrowserNativeFunctionsLinux setCachedWindowHandle(Integer n2) {
        if (BridgedBrowserNativeFunctionsLinux.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCachedWindowHandle(Integer)", 53).addDetail("cachedWindowHandle", (Object)n2)).log();
        }
        this.cachedWindowHandle = n2;
        return this;
    }
}

