/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.bweb.os;

import de.qfs.apps.qftest.client.bweb.BridgedWebHelper;
import de.qfs.apps.qftest.client.bweb.a;
import de.qfs.apps.qftest.client.bweb.ag;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsUnix;
import de.qfs.apps.qftest.client.bweb.x;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.apps.qftest.shared.script.modules.QF;
import de.qfs.lib.axjlib.AXAPI;
import de.qfs.lib.axjlib.AXException;
import de.qfs.lib.axjlib.AXJLib;
import de.qfs.lib.axjlib.appkit.NSRunningApplication;
import de.qfs.lib.axjlib.ui.AXUIElement;
import de.qfs.lib.axjlib.ui.elements.AXApplication;
import de.qfs.lib.axjlib.ui.elements.AXButton;
import de.qfs.lib.axjlib.ui.elements.AXScrollArea;
import de.qfs.lib.axjlib.ui.elements.AXWebArea;
import de.qfs.lib.axjlib.ui.elements.AXWindow;
import de.qfs.lib.axjlib.values.CGPoint;
import de.qfs.lib.axjlib.values.CGSize;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BridgedBrowserNativeFunctionsMacOS
extends BridgedBrowserNativeFunctionsUnix {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsMacOS");
    AXBrowserReference axRef;
    boolean browserWindowDetected = false;
    AXUIElement renderArea;
    static final AtomicBoolean informUserOfTrustedProcess = new AtomicBoolean(true);
    static final AtomicBoolean preloaded = new AtomicBoolean();

    public BridgedBrowserNativeFunctionsMacOS(x x2, @Nullable a a2) {
        super(x2, a2);
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BridgedBrowserNativeFunctionsMacOS(BridgedWebEngine,BridgedBrowser)", 77).addDetail("engine", (Object)x2)).addDetail("browser", (Object)a2)).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "preload()", 85).log();
        }
        AtomicBoolean atomicBoolean = preloaded;
        synchronized (atomicBoolean) {
            if (preloaded.getAndSet(true)) {
                return;
            }
            AXAPI.isProcessTrusted((boolean)informUserOfTrustedProcess.getAndSet(false));
        }
    }

    private boolean detectBrowserWindow() {
        block13: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                logger.lvlBuild(7, "detectBrowserWindow()", 101).log();
            }
            assert (this.browser != null);
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindow()", 104).add("axRef", (Object)this.axRef)).log();
            }
            if (this.browserWindowDetected) {
                return this.axRef != null;
            }
            if (this.browser != null && this.browser.isHeadless()) {
                return false;
            }
            this.preload();
            try {
                boolean bl2 = AXAPI.isProcessTrusted((boolean)informUserOfTrustedProcess.getAndSet(false));
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindow()", 117).add("processTrusted", bl2)).log();
                }
                if (!bl2) {
                    return false;
                }
                this.getBrowserWindowDirectly();
                if (this.axRef == null) {
                    this.searchForBrowserWindow();
                }
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindow()", 126).add("Detected: ")).add((Object)this.axRef)).add(" for browser ")).add(this.browser.c())).dumpStack();
                }
                if (this.axRef != null) {
                    if (this.getProcessIdOfBrowserWindow() == 0) {
                        this.browserUnixId = this.axRef.getPid();
                    }
                    this.registerBrowserProcessId();
                }
            }
            catch (Throwable throwable) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 1) break block13;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "detectBrowserWindow()", 135).add("t", (Object)throwable)).log();
            }
        }
        this.browserWindowDetected = true;
        return this.axRef != null;
    }

    protected void getBrowserWindowDirectly() {
        block4: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                logger.lvlBuild(7, "getBrowserWindowDirectly()", 145).log();
            }
            if (!(this.browser instanceof ag)) {
                return;
            }
            ag ag2 = (ag)((Object)this.browser);
            BridgedWebHelper bridgedWebHelper = (BridgedWebHelper)this.browser.getEngine().getHelper();
            try {
                bridgedWebHelper.invokeWithRawCache(() -> {
                    this.browserUnixId = ag2.H_();
                    String string = ag2.Q_();
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getBrowserWindowDirectly()", 157).add("titleBefore", string)).log();
                    }
                    if (string == null) {
                        return null;
                    }
                    try {
                        Pair pair = this.browser.getWindowPositionAndSize();
                        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getBrowserWindowDirectly()", 163).add("browserUnixId", (Object)this.browserUnixId)).add("titleBefore", string)).add("windowPositionAndSize", (Object)pair)).log();
                        }
                        String string2 = this.browser.Z();
                        String string3 = string + " - " + string2;
                        ag2.e_(string3);
                        String string4 = Misc.normalizeCharacters((String)string3);
                        this.axRef = this.detectBrowserWindowWithPid(string4, pair, this.browserUnixId, string2);
                        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getBrowserWindowDirectly()", 171).add("axRef", (Object)this.axRef)).log();
                        }
                    }
                    finally {
                        ag2.e_(string);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 3) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getBrowserWindowDirectly()", 181).add("ex", (Object)exception)).log();
            }
        }
    }

    protected void searchForBrowserWindow() {
        Object object;
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "searchForBrowserWindow()", 189).log();
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        String string2 = this.browser.w();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow()", 195).add("title", string2)).log();
        }
        if (string2 != null) {
            hashSet.add(string2);
        }
        String string3 = " - QF-Test " + this.browser.Z();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow()", 201).add("calibrationSuffix", string3)).log();
        }
        if (string2.endsWith(string3)) {
            hashSet2.add(string2.substring(0, string2.length() - string3.length()));
        }
        String string4 = this.browser.z();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow()", 208).add("windowTitle", string4)).log();
        }
        if (string4 != null) {
            hashSet.add(string4);
            object = string4.replaceAll(Pattern.quote(string3), "");
            if (!string4.equals(object)) {
                hashSet2.add((String)object);
            }
        }
        object = this.browser.getWindowPositionAndSize();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow()", 218).add("windowPositionAndSize", object)).log();
        }
        if (hashSet.isEmpty()) {
            return;
        }
        String[] stringArray = this.browser.D();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow()", 225).add("bundleIds", (Object)stringArray)).log();
        }
        Pattern pattern = Pattern.compile(hashSet.stream().map(string -> Pattern.quote(Misc.normalizeCharacters((String)string))).collect(Collectors.joining("|")));
        Pattern pattern2 = hashSet2.isEmpty() ? null : Pattern.compile(hashSet2.stream().map(string -> Pattern.quote(Misc.normalizeCharacters((String)string))).collect(Collectors.joining("|")));
        Pattern pattern3 = Pattern.compile(hashSet.stream().map(string -> Pattern.quote(Misc.normalizeCharacters((String)string)) + ".*").collect(Collectors.joining("|")));
        String string5 = this.browser.Z();
        if (this.axRef == null) {
            this.searchForBrowserWindow(pattern, pattern2, (Pair)object, stringArray, string5);
        }
        if (this.axRef == null) {
            this.searchForBrowserWindow(pattern3, null, (Pair)object, stringArray, string5);
        }
        if (this.axRef == null) {
            this.searchForBrowserWindow(pattern, pattern2, null, stringArray, string5);
        }
        if (this.axRef == null) {
            this.searchForBrowserWindow(pattern3, null, null, stringArray, string5);
        }
    }

    protected void searchForBrowserWindow(Object object, @Nullable Pattern pattern, @Nullable Pair pair, String[] stringArray, String string) {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 258).addDetail("windowTitleOrPattern", object)).addDetail("titlePatternForDelayedRetry", (Object)pattern)).addDetail("windowPositionAndSize", (Object)pair)).addDetail("bundleIds", (Object)stringArray)).addDetail("browserUUID", string)).log();
        }
        boolean bl2 = false;
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 269).add("bundleId", string2)).log();
                }
                NSRunningApplication[] nSRunningApplicationArray = AXJLib.INSTANCE.runningApplicationsWithBundleIdentifier(string2);
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 271).add("apps", (Object)nSRunningApplicationArray)).log();
                }
                this.axRef = this.detectBrowserWindowInApps(object, pair, nSRunningApplicationArray, string);
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 273).add("axRef", (Object)this.axRef)).log();
                }
                if (this.axRef != null) break;
                if (pattern == null) continue;
                if (this.detectBrowserWindowInApps(pattern, pair, nSRunningApplicationArray, string) != null) {
                    bl2 = true;
                }
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 282).add("delayedRetry", bl2)).log();
            }
        }
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 286).add("delayedRetry", bl2)).log();
        }
        if (bl2) {
            Misc.safeSleep((long)250L);
            this.searchForBrowserWindow(object, null, pair, stringArray, string);
            return;
        }
        if (this.axRef == null) {
            String[] stringArray2 = AXJLib.INSTANCE.runningApplications();
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 296).add("apps", (Object)stringArray2)).log();
            }
            this.axRef = this.detectBrowserWindowInApps(object, pair, (NSRunningApplication[])stringArray2, string);
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "searchForBrowserWindow(Object,Pattern,Pair<Point, Dimension>,String[],String)", 298).add("axRef", (Object)this.axRef)).log();
            }
        }
    }

    protected AXBrowserReference detectBrowserWindowInApps(Object object, @Nullable Pair pair, NSRunningApplication[] nSRunningApplicationArray, String string) {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "detectBrowserWindowInApps(Object,Pair<Point, Dimension>,NSRunningApplication[],String)", 305).addDetail("windowTitleOrPattern", object)).addDetail("windowPositionAndSize", (Object)pair)).addDetail("apps", (Object)nSRunningApplicationArray)).addDetail("browserUUID", string)).log();
        }
        if (nSRunningApplicationArray == null) {
            return null;
        }
        if (object instanceof String) {
            object = Misc.normalizeCharacters((String)((String)object));
        }
        for (NSRunningApplication nSRunningApplication : nSRunningApplicationArray) {
            AXBrowserReference aXBrowserReference;
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowInApps(Object,Pair<Point, Dimension>,NSRunningApplication[],String)", 317).add("app", (Object)nSRunningApplication)).log();
            }
            int n2 = nSRunningApplication.getProcessIdentifier();
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowInApps(Object,Pair<Point, Dimension>,NSRunningApplication[],String)", 319).add("pid", n2)).log();
            }
            if ((aXBrowserReference = this.detectBrowserWindowWithPid(object, pair, n2, string)) == null) continue;
            return aXBrowserReference;
        }
        return null;
    }

    protected AXBrowserReference detectBrowserWindowWithPid(Object object, @Nullable Pair pair, int n2, String string) {
        block14: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 332).addDetail("normalizedWindowTitleOrPattern", object)).addDetail("windowPositionAndSize", (Object)pair)).addDetail("pid", n2)).addDetail("browserUUID", string)).log();
            }
            if (n2 <= 0) {
                return null;
            }
            Point point = pair == null ? null : (Point)pair.getFirst();
            Dimension dimension = pair == null ? null : (Dimension)pair.getSecond();
            try {
                AXApplication aXApplication = AXAPI.getApplicationAccessibilityObject((int)n2);
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 343).add("appObject", (Object)aXApplication)).log();
                }
                if (aXApplication != null) {
                    List list = aXApplication.getWindows();
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 346).add("windows", (Object)list)).log();
                    }
                    if (list != null) {
                        for (AXUIElement aXUIElement : list) {
                            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 349).add("window", (Object)aXUIElement)).log();
                            }
                            if (!(aXUIElement instanceof AXWindow)) continue;
                            String string2 = Misc.normalizeCharacters((String)aXUIElement.getTitle());
                            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 353).add("windowTitle", string2)).log();
                            }
                            if ((!(object instanceof Pattern) || !((Pattern)object).matcher(string2).matches()) && !object.equals(string2)) continue;
                            if (!(string != null && string2.contains(string) || point == null || dimension == null)) {
                                CGPoint cGPoint = aXUIElement.getPosition();
                                CGSize cGSize = aXUIElement.getSize();
                                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 362).add("position", (Object)cGPoint)).add("size", (Object)cGSize)).log();
                                }
                                if (cGPoint != null && cGSize != null && ((double)Math.round(cGPoint.getX()) != point.getX() || (double)Math.round(cGPoint.getY()) != point.getY() || (double)Math.round(cGSize.getWidth()) != dimension.getWidth() || (double)Math.round(cGSize.getHeight()) != dimension.getHeight())) {
                                    if (BridgedBrowserNativeFunctionsMacOS.logger.level < 9) continue;
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 368).add("geometry mismatch")).log();
                                    continue;
                                }
                            }
                            return new AXBrowserReference(aXApplication, (AXWindow)aXUIElement);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block14;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectBrowserWindowWithPid(Object,Pair<Point, Dimension>,int,String)", 381).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    @Override
    public void restoreMinimizedWindow() {
        block4: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                logger.lvlBuild(7, "restoreMinimizedWindow()", 390).log();
            }
            if (!this.detectBrowserWindow()) {
                return;
            }
            try {
                this.axRef.getWindow().setMinimized(Boolean.valueOf(false));
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "restoreMinimizedWindow()", 396).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public void bringToFront(boolean bl2) {
        block8: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(boolean)", 404).addDetail("forcedRaise", bl2)).log();
            }
            if (this.browser == null) {
                return;
            }
            if (this.browser.isShowingModalDialog()) {
                return;
            }
            if (!this.detectBrowserWindow()) {
                return;
            }
            try {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "bringToFront(boolean)", 413).add("Set Frontmost of: ")).add((Object)this.axRef.getApp())).log();
                }
                this.axRef.getApp().setFrontmost(Boolean.valueOf(true));
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "bringToFront(boolean)", 415).add("Raising: ")).add((Object)this.axRef.getWindow())).log();
                }
                this.axRef.getWindow().raise();
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block8;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "bringToFront(boolean)", 418).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public boolean forceCloseBrowserWindow() {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "forceCloseBrowserWindow()", 426).log();
        }
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "forceCloseBrowserWindow()", 427).add("forceCloseBrowserWindow: ")).add((Object)this.axRef)).add(" for browser ")).add(this.browser.c())).dumpStack();
        }
        if (this.axRef == null) {
            return false;
        }
        assert (preloaded.get());
        try {
            Automac.instance().closeWindow((Object)this.axRef.getWindow());
            return true;
        }
        catch (Exception exception) {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "forceCloseBrowserWindow()", 435).add("ex", (Object)exception)).log();
            }
            return false;
        }
    }

    @Override
    public void setWindowPosAndSize(@Nullable Point point, @Nullable Dimension dimension) {
        block9: {
            block8: {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowPosAndSize(Point,Dimension)", 444).addDetail("point", (Object)point)).addDetail("size", (Object)dimension)).log();
                }
                if (!this.detectBrowserWindow()) {
                    return;
                }
                try {
                    if (point != null) {
                        Automac.instance().setWindowPosition((Object)this.axRef.getWindow(), (float)point.x, (float)point.y);
                    }
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block8;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "setWindowPosAndSize(Point,Dimension)", 451).add("ex", (Object)exception)).log();
                }
            }
            try {
                if (dimension != null) {
                    Automac.instance().setWindowSize((Object)this.axRef.getWindow(), (float)dimension.width, (float)dimension.height);
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "setWindowPosAndSize(Point,Dimension)", 458).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public void resetInvalidHandle() {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "resetInvalidHandle()", 466).log();
        }
        if (this.axRef == null) {
            this.browserWindowDetected = false;
        }
    }

    @Override
    public Object getHandle() {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "getHandle()", 480).log();
        }
        if (!this.detectBrowserWindow()) {
            return null;
        }
        return this.axRef.getWindow();
    }

    @Override
    public Point getRenderAreaOrigin() {
        block6: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                logger.lvlBuild(7, "getRenderAreaOrigin()", 493).log();
            }
            try {
                if (this.renderArea != null) {
                    assert (preloaded.get());
                    CGPoint cGPoint = this.renderArea.getPosition();
                    return new Point((int)cGPoint.getX(), (int)cGPoint.getY());
                }
            }
            catch (Exception exception) {
                if (exception instanceof AXException) {
                    this.renderArea = null;
                }
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block6;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getRenderAreaOrigin()", 504).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    @Override
    public void detectScrollAreaAsRenderArea() {
        block20: {
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
                logger.lvlBuild(7, "detectScrollAreaAsRenderArea()", 513).log();
            }
            if (!this.detectBrowserWindow()) {
                return;
            }
            if (this.axRef == null) {
                return;
            }
            if (this.browser.u()) {
                return;
            }
            this.bringToFront(true);
            Misc.safeSleep((long)100L);
            try {
                CGPoint cGPoint = this.axRef.getWindow().getPosition();
                CGSize cGSize = this.axRef.getWindow().getSize();
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 528).add("windowPosition", (Object)cGPoint)).add("windowSize", (Object)cGSize)).log();
                }
                CGPoint cGPoint2 = new CGPoint((float)((double)cGPoint.getX() + (double)cGSize.getWidth() * 0.8), (float)((double)cGPoint.getY() + (double)cGSize.getHeight() * 0.8));
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 533).add("assumedRenderAreaPostion", (Object)cGPoint2)).log();
                }
                AXUIElement aXUIElement = AXAPI.elementAtPosition((float)cGPoint2.getX(), (float)cGPoint2.getY());
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 536).add("element", (Object)aXUIElement)).log();
                }
                int n2 = aXUIElement.getPid();
                int n3 = this.axRef.getPid();
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 540).add("elementPid", n2)).add("browserPid", n3)).log();
                }
                if (n2 != n3) {
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectScrollAreaAsRenderArea()", 543).add("Wrong app, cannot get render area")).log();
                    }
                    return;
                }
                AXUIElement aXUIElement2 = null;
                while (aXUIElement != null && !(aXUIElement instanceof AXApplication)) {
                    AXUIElement aXUIElement3 = aXUIElement.getParent();
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 551).add("parent", (Object)aXUIElement3)).log();
                    }
                    if (aXUIElement instanceof AXScrollArea || aXUIElement instanceof AXWebArea) {
                        aXUIElement2 = aXUIElement;
                    }
                    aXUIElement = aXUIElement3;
                }
                if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 558).add("area", aXUIElement2)).log();
                }
                if (aXUIElement2 != null) {
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectScrollAreaAsRenderArea()", 560).add("Render area found")).log();
                    }
                    this.renderArea = aXUIElement2;
                } else if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectScrollAreaAsRenderArea()", 563).add("Render Area not found")).log();
                }
            }
            catch (Throwable throwable) {
                if (BridgedBrowserNativeFunctionsMacOS.logger.level < 5) break block20;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectScrollAreaAsRenderArea()", 566).add("t", (Object)throwable)).log();
            }
        }
    }

    @Override
    public int getProcessIdOfBrowserWindow() {
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "getProcessIdOfBrowserWindow()", 589).log();
        }
        if (this.browserUnixId == null) {
            if (this.browser instanceof ag) {
                this.browserUnixId = ((ag)((Object)this.browser)).H_();
            } else {
                return 0;
            }
        }
        return this.browserUnixId;
    }

    public String continueSafariAutomation() {
        Object object;
        AXWindow aXWindow;
        Object object22;
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 7) {
            logger.lvlBuild(7, "continueSafariAutomation()", 610).log();
        }
        if (this.axRef == null) {
            return "No reference of Browser";
        }
        AXApplication aXApplication = this.axRef.getApp();
        List list = aXApplication.getWindows();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "continueSafariAutomation()", 618).add("windows", (Object)list)).log();
        }
        if (Misc.emptyOrNull((Collection)list)) {
            return "No Browser windows";
        }
        AXWindow aXWindow2 = null;
        for (Object object22 : list) {
            if (!(object22 instanceof AXWindow)) continue;
            aXWindow = (AXWindow)object22;
            object = aXWindow.getTitle();
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "continueSafariAutomation()", 629).add("title", (String)object)).log();
            }
            if (!"".equals(object)) continue;
            aXWindow2 = aXWindow;
            break;
        }
        if (aXWindow2 == null) {
            return "Interruption Window not found";
        }
        List list2 = aXWindow2.getChildrenInNavigationOrder();
        if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "continueSafariAutomation()", 642).add("children", (Object)list2)).log();
        }
        object22 = list2.iterator();
        while (object22.hasNext()) {
            block14: {
                aXWindow = (AXUIElement)object22.next();
                if (!(aXWindow instanceof AXButton)) continue;
                object = aXWindow.toString();
                try {
                    object = "'" + aXWindow.getTitle() + "'";
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsMacOS.logger.level < 3) break block14;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "continueSafariAutomation()", 651).add("ex", (Object)exception)).log();
                }
            }
            String string = "Clicking on button to continue automation: " + (String)object;
            if (BridgedBrowserNativeFunctionsMacOS.logger.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "continueSafariAutomation()", 655).add("msg", string)).add("child", (Object)aXWindow)).log();
            }
            QF.logMessage((String)string, (boolean)true, (boolean)false, (boolean)true);
            try {
                ((AXButton)aXWindow).press();
                return string + " with success.";
            }
            catch (Exception exception) {
                return string + " with exception: " + exception.getMessage();
            }
        }
        return "No Button to click on found";
    }

    protected static class AXBrowserReference {
        AXApplication app;
        AXWindow window;

        public int getPid() {
            return this.app.getPid();
        }

        public AXBrowserReference(AXApplication aXApplication, AXWindow aXWindow) {
            if (aXApplication == null) {
                throw new IllegalArgumentException("app is marked non-null but is null");
            }
            if (aXWindow == null) {
                throw new IllegalArgumentException("window is marked non-null but is null");
            }
            this.app = aXApplication;
            this.window = aXWindow;
        }

        public AXApplication getApp() {
            return this.app;
        }

        public AXWindow getWindow() {
            return this.window;
        }

        public AXBrowserReference setApp(AXApplication aXApplication) {
            if (aXApplication == null) {
                throw new IllegalArgumentException("app is marked non-null but is null");
            }
            this.app = aXApplication;
            return this;
        }

        public AXBrowserReference setWindow(AXWindow aXWindow) {
            if (aXWindow == null) {
                throw new IllegalArgumentException("window is marked non-null but is null");
            }
            this.window = aXWindow;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AXBrowserReference)) {
                return false;
            }
            AXBrowserReference aXBrowserReference = (AXBrowserReference)object;
            if (!aXBrowserReference.canEqual(this)) {
                return false;
            }
            AXApplication aXApplication = this.getApp();
            AXApplication aXApplication2 = aXBrowserReference.getApp();
            if (aXApplication == null ? aXApplication2 != null : !aXApplication.equals(aXApplication2)) {
                return false;
            }
            AXWindow aXWindow = this.getWindow();
            AXWindow aXWindow2 = aXBrowserReference.getWindow();
            return !(aXWindow == null ? aXWindow2 != null : !aXWindow.equals(aXWindow2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof AXBrowserReference;
        }

        public int hashCode() {
            int n2 = 1;
            AXApplication aXApplication = this.getApp();
            n2 = n2 * 59 + (aXApplication == null ? 43 : aXApplication.hashCode());
            AXWindow aXWindow = this.getWindow();
            n2 = n2 * 59 + (aXWindow == null ? 43 : aXWindow.hashCode());
            return n2;
        }

        public String toString() {
            return "BridgedBrowserNativeFunctionsMacOS.AXBrowserReference(app=" + String.valueOf(this.getApp()) + ", window=" + String.valueOf(this.getWindow()) + ")";
        }
    }
}

