/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.bweb.os;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import de.qfs.apps.qftest.client.bweb.a;
import de.qfs.apps.qftest.client.bweb.ag;
import de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctions;
import de.qfs.apps.qftest.client.bweb.os.win32.Kernel32;
import de.qfs.apps.qftest.client.bweb.os.win32.Psapi;
import de.qfs.apps.qftest.client.bweb.os.win32.User32;
import de.qfs.apps.qftest.client.bweb.x;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.system.win32.WinApiAccess;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import mmarquee.automation.AutomationException;
import mmarquee.automation.ControlType;
import mmarquee.automation.Element;
import mmarquee.automation.UIAutomation;
import mmarquee.automation.controls.AutomationBase;
import mmarquee.automation.controls.AutomationControlFactory;
import mmarquee.automation.controls.Container;
import mmarquee.automation.controls.ElementBuilder;
import mmarquee.automation.controls.Panel;
import mmarquee.automation.controls.Window;
import mmarquee.automation.pattern.PatternNotFoundException;
import mmarquee.uiautomation.TreeScope;

public class BridgedBrowserNativeFunctionsWin
extends BridgedBrowserNativeFunctions {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.bweb.os.BridgedBrowserNativeFunctionsWin");
    private static final int MAX_BROWSER_HWND_DETECTS = 3;
    @Nullable
    protected WinDef.HWND browserHWnd;
    final AtomicInteger browserHWndDetects = new AtomicInteger(0);
    @Nullable
    protected AutomationBase uiAutoMainWindow;
    @Nullable
    protected AutomationBase uiAutoRenderDoc;
    private static final AtomicReference installedHotfixes = new AtomicReference();
    static final AtomicBoolean preloaded = new AtomicBoolean();
    static boolean canUseUIAutomation = false;
    volatile int processId = 0;

    public BridgedBrowserNativeFunctionsWin(x x2, @Nullable a a2) {
        super(x2, a2);
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BridgedBrowserNativeFunctionsWin(BridgedWebEngine,BridgedBrowser)", 124).addDetail("engine", (Object)x2)).addDetail("browser", (Object)a2)).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "preload()", 132).log();
        }
        AtomicBoolean atomicBoolean = preloaded;
        synchronized (atomicBoolean) {
            if (preloaded.getAndSet(true)) {
                return;
            }
            Util.invokeAndWaitForSwingHelper(() -> {
                this.preloadJNA();
                this.preloadUIAutomation();
            });
        }
    }

    protected void preloadJNA() {
        block3: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "preloadJNA()", 146).log();
            }
            WinApiAccess.instance();
            try {
                User32.INSTANCE.getClass();
                Kernel32.INSTANCE.getClass();
                Psapi.INSTANCE.getClass();
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "preloadJNA()", 154).add("ex", (Object)exception)).log();
            }
        }
    }

    protected void preloadUIAutomation() {
        block3: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "preloadUIAutomation()", 161).log();
            }
            try {
                UIAutomation.getInstance();
                canUseUIAutomation = true;
            }
            catch (NullPointerException nullPointerException) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block3;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "preloadUIAutomation()", 168).add("ex", (Object)nullPointerException)).log();
            }
        }
    }

    @Override
    public void restoreMinimizedWindow() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "restoreMinimizedWindow()", 176).log();
        }
        if (this.browser == null) {
            return;
        }
        this.setBrowserHwnd();
        this.restoreMinimizedBrowserWindowOnWindows(this.browserHWnd);
    }

    protected void setBrowserHwnd() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "setBrowserHwnd()", 190).log();
        }
        assert (this.browser != null);
        if (this.browserHWnd != null) {
            return;
        }
        if (this.browser != null && this.browser.isHeadless()) {
            return;
        }
        int n2 = this.browserHWndDetects.incrementAndGet();
        if (n2 >= 3) {
            if (n2 == 3) {
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "setBrowserHwnd()", 204).add("Maximum browserHwnd detects reached, skipping browserHwndDetection")).log();
                }
            } else if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwnd()", 206).add("skipping browserHwndDetection")).log();
            }
            return;
        }
        this.preload();
        this.getBrowserHwndDirectly();
        if (this.browserHWnd == null) {
            this.getBrowserHwndBySearch();
        }
        if (canUseUIAutomation && !this.browser.u()) {
            this.detectUIAutoObjects();
        }
        this.registerBrowserProcessId();
    }

    private void getBrowserHwndDirectly() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getBrowserHwndDirectly()", 229).log();
        }
        if (!(this.browser instanceof ag)) {
            return;
        }
        long l2 = ((ag)((Object)this.browser)).R_();
        if (l2 == 0L) {
            return;
        }
        this.browserHWnd = new WinDef.HWND(Pointer.createConstant((long)l2));
    }

    protected void getBrowserHwndBySearch() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getBrowserHwndBySearch()", 242).log();
        }
        String string = this.browser.w();
        String string2 = this.browser.A();
        this.setBrowserHwnd(string, string2, 0L);
        this.setBrowserHwnd(string, string2, 100L);
        this.setBrowserHwnd(string, string2, 150L);
        this.setBrowserHwnd(string, string2, 250L);
        this.setBrowserHwnd(string, string2, 500L);
        this.setBrowserHwnd(string, null, 0L);
    }

    private void detectUIAutoObjects() {
        block4: {
            String string;
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "detectUIAutoObjects()", 259).log();
            }
            if ((string = this.browser.C()) != null) {
                try {
                    this.detectUIAutoMainWindow();
                    this.detectUIAutoRenderArea();
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectUIAutoObjects()", 268).add("e", (Object)exception)).log();
                }
            }
        }
    }

    private void detectUIAutoMainWindow() throws AutomationException {
        block11: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "detectUIAutoMainWindow()", 276).log();
            }
            UIAutomation uIAutomation = UIAutomation.getInstance();
            try {
                Element element = null;
                if (this.browserHWnd != null) {
                    block10: {
                        try {
                            element = uIAutomation.getElementFromHandle(this.browserHWnd);
                        }
                        catch (Exception exception) {
                            if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block10;
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectUIAutoMainWindow()", 291).add("ex", (Object)exception)).log();
                        }
                    }
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectUIAutoMainWindow()", 293).add("windowElement", (Object)element)).log();
                    }
                }
                if (element == null) {
                    element = this.getUIAutoMainWindowElementBySearch();
                }
                if (element != null) {
                    this.uiAutoMainWindow = new Window(new ElementBuilder(element));
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectUIAutoMainWindow()", 302).add("uiAutoMainWindow", (Object)this.uiAutoMainWindow)).log();
                    }
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block11;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectUIAutoMainWindow()", 305).add("ex", (Object)exception)).log();
            }
        }
    }

    protected Element getUIAutoMainWindowElementBySearch() throws AutomationException {
        PointerByReference pointerByReference;
        Panel panel;
        Element element;
        block8: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "getUIAutoMainWindowElementBySearch()", 313).log();
            }
            element = null;
            UIAutomation uIAutomation = UIAutomation.getInstance();
            String string = this.browser.A();
            String string2 = this.browser.z();
            int n2 = this.browser.B();
            ControlType controlType = ControlType.fromValue((int)n2);
            panel = uIAutomation.getDesktop();
            PointerByReference pointerByReference2 = uIAutomation.createControlTypeCondition(controlType);
            PointerByReference pointerByReference3 = uIAutomation.createNamePropertyCondition(string2);
            pointerByReference = uIAutomation.createAndCondition(pointerByReference3, pointerByReference2);
            try {
                PointerByReference pointerByReference4 = uIAutomation.createClassNamePropertyCondition(string);
                PointerByReference pointerByReference5 = uIAutomation.createAndCondition(pointerByReference, pointerByReference4);
                element = panel.getElement().findFirst(new TreeScope(2), pointerByReference5);
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block8;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getUIAutoMainWindowElementBySearch()", 335).add("ex", (Object)exception)).log();
            }
        }
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getUIAutoMainWindowElementBySearch()", 337).add("windowElement", (Object)element)).log();
        }
        if (element == null) {
            block9: {
                try {
                    element = panel.getElement().findFirst(new TreeScope(2), pointerByReference);
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block9;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "getUIAutoMainWindowElementBySearch()", 344).add("ex", (Object)exception)).log();
                }
            }
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getUIAutoMainWindowElementBySearch()", 346).add("windowElement", (Object)element)).log();
            }
        }
        return element;
    }

    protected void detectUIAutoRenderArea() throws AutomationException, PatternNotFoundException {
        Element element;
        boolean bl2;
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "detectUIAutoRenderArea()", 355).log();
        }
        this.detectUIAutoRenderArea(this.uiAutoMainWindow);
        boolean bl3 = bl2 = this.uiAutoRenderDoc != null;
        if (bl2) {
            try {
                this.getUiAutoElementOrigin(this.uiAutoRenderDoc);
            }
            catch (InvalidBoundsException invalidBoundsException) {
                bl2 = false;
            }
        }
        if (!bl2 && (element = this.getUIAutoMainWindowElementBySearch()) != null) {
            this.detectUIAutoRenderArea((AutomationBase)new Window(new ElementBuilder(element)));
        }
    }

    protected void detectUIAutoRenderArea(AutomationBase automationBase) throws AutomationException {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "detectUIAutoRenderArea(AutomationBase)", 378).addDetail("baseWindow", (Object)automationBase)).log();
        }
        String string = this.browser.C();
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectUIAutoRenderArea(AutomationBase)", 381).add("renderAreaClass", string)).log();
        }
        if (automationBase != null) {
            Container container = (Container)automationBase;
            try {
                this.uiAutoRenderDoc = this.getControlByClassName(string, container);
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "detectUIAutoRenderArea(AutomationBase)", 387).add("ex", (Object)exception)).log();
                }
                this.uiAutoRenderDoc = null;
            }
            if (this.uiAutoRenderDoc == null) {
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectUIAutoRenderArea(AutomationBase)", 391).add("Try to find the biggest document in the window")).log();
                }
                this.uiAutoRenderDoc = this.getDocumentByControlType(container, DocumentSelectionType.BIGGEST);
            }
        }
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "detectUIAutoRenderArea(AutomationBase)", 396).add("uiAutoRenderDoc", (Object)this.uiAutoRenderDoc)).log();
        }
    }

    protected AutomationBase getDocumentByControlType(Container container, DocumentSelectionType documentSelectionType) throws AutomationException {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getDocumentByControlType(Container,DocumentSelectionType)", 402).addDetail("automationContainer", (Object)container)).addDetail("selectionType", (Object)documentSelectionType)).log();
        }
        AutomationBase automationBase = null;
        AutomationBase automationBase2 = null;
        long l2 = 0L;
        WinDef.RECT rECT = container.getBoundingRectangle();
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDocumentByControlType(Container,DocumentSelectionType)", 408).add("containerBounds", String.format("%d, %d, %d, %d\n", rECT.left, rECT.top, rECT.right, rECT.bottom))).log();
        }
        try {
            UIAutomation uIAutomation = UIAutomation.getInstance();
            PointerByReference pointerByReference = uIAutomation.createControlTypeCondition(ControlType.Document);
            List list = container.getElement().findAll(new TreeScope(7), pointerByReference);
            for (Element element : list) {
                AutomationBase automationBase3 = AutomationControlFactory.get((AutomationBase)container, (Element)element);
                try {
                    long l3;
                    WinDef.RECT rECT2 = automationBase3.getBoundingRectangle();
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDocumentByControlType(Container,DocumentSelectionType)", 417).add("bounds", String.format("%d, %d, %d, %d\n", rECT2.left, rECT2.top, rECT2.right, rECT2.bottom))).log();
                    }
                    if (this.boundsAreInvalid(rECT2)) continue;
                    if (documentSelectionType == DocumentSelectionType.FIRST_VALID) {
                        return automationBase3;
                    }
                    if (automationBase2 == null) {
                        automationBase2 = automationBase3;
                    }
                    if ((l3 = (long)Math.abs((rECT2.right - rECT2.left) * (rECT2.bottom - rECT2.top))) <= l2 || !this.isWithin(rECT2, rECT)) continue;
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getDocumentByControlType(Container,DocumentSelectionType)", 430).add("Is biggest!")).log();
                    }
                    l2 = l3;
                    automationBase = automationBase3;
                }
                catch (AutomationException automationException) {}
            }
        }
        catch (AutomationException automationException) {
            // empty catch block
        }
        if (automationBase == null) {
            return automationBase2;
        }
        return automationBase;
    }

    private boolean isWithin(WinDef.RECT rECT, WinDef.RECT rECT2) {
        return rECT.left >= rECT2.left && rECT.top >= rECT2.top && rECT.right <= rECT2.right && rECT.bottom <= rECT2.bottom;
    }

    protected AutomationBase getControlByClassName(String string, Container container) throws AutomationException {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getControlByClassName(String,Container)", 461).addDetail("renderAreaClass", string)).addDetail("automationContainer", (Object)container)).log();
        }
        return container.getControlByClassName(string);
    }

    protected void setBrowserHwnd(String string, @Nullable String string2, long l2) {
        block11: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBrowserHwnd(String,String,long)", 469).addDetail("title", string)).addDetail("browserWindowClass", string2)).addDetail("preDelay", l2)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("title is marked non-null but is null");
            }
            assert (this.browser != null);
            if (this.browserHWnd != null) {
                return;
            }
            if (l2 > 0L) {
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block11;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "setBrowserHwnd(String,String,long)", 481).add("e", (Object)interruptedException)).log();
                }
            }
        }
        String string3 = this.browser.z();
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwnd(String,String,long)", 487).add("Looking for browser window: ", string3)).add("browserWindowClass", string2)).log();
        }
        this.browserHWnd = User32.INSTANCE.FindWindow(string2, string3);
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwnd(String,String,long)", 490).add("Result of FindWindow: ", (Object)this.browserHWnd)).log();
        }
        if (this.browserHWnd == null) {
            this.setBrowserHwndBySearch(string, string2);
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwnd(String,String,long)", 494).add("Result of setBrowserHwndBySearch: ", (Object)this.browserHWnd)).log();
            }
        }
    }

    protected void setBrowserHwndBySearch(String string, final @Nullable String string2) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBrowserHwndBySearch(String,String)", 501).addDetail("searchTitle", string)).addDetail("browserWindowClass", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("searchTitle is marked non-null but is null");
        }
        assert (this.browser != null);
        final String string3 = Misc.normalizeCharacters((String)string);
        final String string4 = this.browser.y();
        final WinDef.HWND[] hWNDArray = new WinDef.HWND[]{null};
        User32.INSTANCE.EnumWindows(new WinUser.WNDENUMPROC(){

            public boolean callback(WinDef.HWND hWND, Pointer pointer) {
                block9: {
                    try {
                        boolean bl2;
                        int n2 = User32.INSTANCE.GetWindowTextLength(hWND) + 1;
                        if (n2 == 1) {
                            return true;
                        }
                        char[] cArray = new char[n2];
                        User32.INSTANCE.GetWindowText(hWND, cArray, n2);
                        String string = Misc.normalizeCharacters((String)Native.toString((char[])cArray).trim());
                        String string22 = null;
                        if (string2 != null) {
                            char[] cArray2 = new char[255];
                            User32.INSTANCE.GetClassName(hWND, cArray2, 255);
                            string22 = Native.toString((char[])cArray2);
                        }
                        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwndBySearch(String,String).WNDENUMPROC.callback(HWND,Pointer)", 535).add("Detected window: ", string)).add("wClass", string22)).add("hWnd", (Object)hWND)).log();
                        }
                        boolean bl3 = bl2 = string2 == null || string2.equals(string22);
                        if (bl2 && string.startsWith(string3)) {
                            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwndBySearch(String,String).WNDENUMPROC.callback(HWND,Pointer)", 540).add("Possibly matching window: ", string)).add("wClass", string22)).add("hWnd", (Object)hWND)).log();
                            }
                            hWNDArray[0] = hWND;
                            if (string.contains(string4)) {
                                if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwndBySearch(String,String).WNDENUMPROC.callback(HWND,Pointer)", 543).add("Matching window: ", string)).add("wClass", string22)).add("hWnd", (Object)hWND)).log();
                                }
                                BridgedBrowserNativeFunctionsWin.this.browserHWnd = hWND;
                                return false;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (BridgedBrowserNativeFunctionsWin.logger.level < 1) break block9;
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "setBrowserHwndBySearch(String,String).WNDENUMPROC.callback(HWND,Pointer)", 549).add("ex", (Object)throwable)).log();
                    }
                }
                return true;
            }
        }, null);
        if (this.browserHWnd == null) {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setBrowserHwndBySearch(String,String)", 556).add("Browser Window not found, candidate: ")).add((Object)hWNDArray[0])).log();
            }
            if (hWNDArray[0] != null) {
                this.browserHWnd = hWNDArray[0];
            }
        }
    }

    @Override
    public int getProcessIdOfBrowserWindow() {
        int n2;
        block13: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "getProcessIdOfBrowserWindow()", 570).log();
            }
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIdOfBrowserWindow()", 571).add("processId", this.processId)).log();
            }
            if (this.processId > 0) {
                return this.processId;
            }
            n2 = 0;
            try {
                if (this.browser instanceof ag) {
                    n2 = ((ag)((Object)this.browser)).H_();
                }
                if (n2 == 0) {
                    this.setBrowserHwnd();
                    if (this.uiAutoMainWindow != null) {
                        n2 = this.getProcessIdOfBrowserFromUiAutoRenderDoc();
                        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIdOfBrowserWindow()", 587).add("pid", n2)).log();
                        }
                        if (n2 == 0) {
                            this.detectUIAutoRenderArea();
                            n2 = this.getProcessIdOfBrowserFromUiAutoRenderDoc();
                            if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIdOfBrowserWindow()", 592).add("pid", n2)).log();
                            }
                        }
                    }
                }
                if (n2 == 0) {
                    IntByReference intByReference = new IntByReference();
                    User32.INSTANCE.GetWindowThreadProcessId(this.browserHWnd, intByReference);
                    n2 = intByReference.getValue();
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIdOfBrowserWindow()", 602).add("pid", n2)).log();
                    }
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block13;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getProcessIdOfBrowserWindow()", 605).add("ex", (Object)exception)).log();
            }
        }
        this.processId = n2;
        return n2;
    }

    private int getProcessIdOfBrowserFromUiAutoRenderDoc() {
        block6: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "getProcessIdOfBrowserFromUiAutoRenderDoc()", 615).log();
            }
            if (this.uiAutoRenderDoc != null) {
                try {
                    Object object = this.uiAutoRenderDoc.getProcessId();
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIdOfBrowserFromUiAutoRenderDoc()", 620).add("processId", object)).log();
                    }
                    if (object instanceof Number) {
                        return ((Number)object).intValue();
                    }
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block6;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "getProcessIdOfBrowserFromUiAutoRenderDoc()", 625).add("ex", (Object)exception)).log();
                }
            }
        }
        return 0;
    }

    protected void restoreMinimizedBrowserWindowOnWindows(@Nullable WinDef.HWND hWND) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "restoreMinimizedBrowserWindowOnWindows(HWND)", 634).addDetail("hWnd", (Object)hWND)).log();
        }
        if (hWND != null && User32.INSTANCE.IsIconic(hWND)) {
            User32.INSTANCE.ShowWindow(hWND, 9);
        }
    }

    @Override
    public void bringToFront(boolean bl2) {
        block4: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(boolean)", 646).addDetail("forcedRaise", bl2)).log();
            }
            if (this.browser == null) {
                return;
            }
            try {
                this.setBrowserHwnd();
                this.bringWindowToFront(this.browserHWnd, bl2);
            }
            catch (Throwable throwable) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 1) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "bringToFront(boolean)", 653).add("ex", (Object)throwable)).log();
            }
        }
    }

    protected void bringWindowToFront(@Nullable WinDef.HWND hWND, boolean bl2) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "bringWindowToFront(HWND,boolean)", 660).addDetail("hWnd", (Object)hWND)).addDetail("forcedRaise", bl2)).log();
        }
        if (hWND != null) {
            if (bl2) {
                User32.INSTANCE.SetWindowPos(hWND, User32.HWND_TOPMOST, 0, 0, 0, 0, 3);
                User32.INSTANCE.SetWindowPos(hWND, User32.HWND_NOTOPMOST, 0, 0, 0, 0, 3);
            }
            User32.INSTANCE.SetForegroundWindow(hWND);
            if (bl2) {
                User32.INSTANCE.SetActiveWindow(hWND);
                User32.INSTANCE.SetFocus(hWND);
            }
        }
    }

    @Override
    public boolean forceCloseBrowserWindow() {
        block10: {
            block9: {
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                    logger.lvlBuild(7, "forceCloseBrowserWindow()", 682).log();
                }
                if (this.browser == null) {
                    return false;
                }
                if (this.uiAutoMainWindow != null) {
                    try {
                        ((mmarquee.automation.pattern.Window)this.uiAutoMainWindow.requestAutomationPattern(mmarquee.automation.pattern.Window.class)).close();
                        this.uiAutoMainWindow = null;
                        this.uiAutoRenderDoc = null;
                        return true;
                    }
                    catch (Throwable throwable) {
                        if (BridgedBrowserNativeFunctionsWin.logger.level < 3) break block9;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "forceCloseBrowserWindow()", 692).add("ex", (Object)throwable)).log();
                    }
                }
            }
            if (this.browserHWnd != null) {
                try {
                    boolean bl2 = this.forceCloseBrowserWindow(this.browserHWnd);
                    if (bl2) {
                        this.browserHWnd = null;
                    }
                    return bl2;
                }
                catch (Throwable throwable) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 1) break block10;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "forceCloseBrowserWindow()", 704).add("ex", (Object)throwable)).log();
                }
            }
        }
        return false;
    }

    protected boolean forceCloseBrowserWindow(@Nullable WinDef.HWND hWND) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "forceCloseBrowserWindow(HWND)", 714).addDetail("hWnd", (Object)hWND)).log();
        }
        if (hWND != null) {
            return User32.INSTANCE.CloseWindow(hWND);
        }
        return false;
    }

    @Override
    public void resetInvalidHandle() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "resetInvalidHandle()", 725).log();
        }
        if (this.browserHWnd != null && Long.valueOf(0L).equals(this.getHandle())) {
            this.browserHWnd = null;
        }
    }

    @Override
    public Object getHandle() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getHandle()", 736).log();
        }
        try {
            this.setBrowserHwnd();
            if (this.browserHWnd == null) {
                return null;
            }
            Pointer pointer = this.browserHWnd.getPointer();
            return BridgedBrowserNativeFunctionsWin.getPointerAsLong(pointer);
        }
        catch (Throwable throwable) {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getHandle()", 744).add("ex", (Object)throwable)).log();
            }
            return null;
        }
    }

    protected static long getPointerAsLong(Pointer pointer) {
        String string;
        int n2;
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getPointerAsLong(Pointer)", 752).addDetail("pointer", (Object)pointer)).log();
        }
        if ((n2 = (string = pointer.toString()).indexOf("@0x")) < 0) {
            return 0L;
        }
        try {
            String string2 = string.substring(n2 + 3);
            long l2 = Long.parseUnsignedLong(string2, 16);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getPointerAsLong(Pointer)", 764).add("ex", (Object)numberFormatException)).log();
            }
            return 0L;
        }
    }

    @Override
    public void setWindowPosAndSize(@Nullable Point point, @Nullable Dimension dimension) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setWindowPosAndSize(Point,Dimension)", 773).addDetail("point", (Object)point)).addDetail("size", (Object)dimension)).log();
        }
        this.setBrowserHwnd();
        if (this.browserHWnd != null) {
            int n2;
            int n3;
            WinDef.RECT rECT = new WinDef.RECT();
            User32.INSTANCE.GetWindowRect(this.browserHWnd, rECT);
            int n4 = 4;
            if (point != null) {
                rECT.left = point.x;
                rECT.top = point.y;
            }
            if (dimension != null) {
                n3 = dimension.width;
                n2 = dimension.height;
            } else {
                n3 = 0;
                n2 = 0;
                n4 |= 1;
            }
            User32.INSTANCE.SetWindowPos(this.browserHWnd, null, rECT.left, rECT.top, n3, n2, n4);
        }
    }

    private static List enumProcesses() throws Exception {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "enumProcesses()", 806).log();
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int[] nArray = new int[1024];
        WinDef.DWORDByReference dWORDByReference = new WinDef.DWORDByReference();
        boolean bl2 = Psapi.INSTANCE.EnumProcesses(nArray, nArray.length * 32 / 8, dWORDByReference);
        if (!bl2) {
            int n2 = Native.getLastError();
            throw new Exception("EnumProcesses failed. Error: " + n2);
        }
        int n3 = dWORDByReference.getValue().intValue() / 4;
        for (int i2 = 0; i2 < n3; ++i2) {
            linkedList.add(nArray[i2]);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getProcessIds(String string) {
        List list;
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getProcessIds(String)", 830).addDetail("processName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("processName is marked non-null but is null");
        }
        this.preload();
        try {
            list = BridgedBrowserNativeFunctionsWin.enumProcesses();
        }
        catch (Exception exception) {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getProcessIds(String)", 838).add("ex", (Object)exception)).log();
            }
            return Collections.emptySet();
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            WinNT.HANDLE hANDLE = null;
            try {
                hANDLE = Kernel32.INSTANCE.OpenProcess(1040, false, n2);
                if (hANDLE == null) continue;
                char[] cArray = new char[512];
                Psapi.INSTANCE.GetModuleBaseName(hANDLE, new WinDef.HMODULE(), cArray, 512);
                String string2 = Native.toString((char[])cArray);
                if (!"".equals(string2) && BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getProcessIds(String)", 855).add("name", string2)).log();
                }
                if (!string.equalsIgnoreCase(string2)) continue;
                hashSet.add(n2);
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 3) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getProcessIds(String)", 864).add("ex", (Object)exception)).log();
            }
            finally {
                if (hANDLE == null) continue;
                try {
                    Kernel32.INSTANCE.CloseHandle(hANDLE);
                }
                catch (Exception exception) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getProcessIds(String)", 870).add("ex", (Object)exception)).log();
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashSet getProcessIdsWithCommandlineFilter(@Nullable BiFunction biFunction) {
        LinkedHashSet<Integer> linkedHashSet;
        block9: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "getProcessIdsWithCommandlineFilter(BiFunction<Integer, String, Boolean>)", 883).addDetail("filter", (Object)biFunction)).log();
            }
            this.preload();
            linkedHashSet = new LinkedHashSet<Integer>();
            WbemcliUtil.WmiQuery wmiQuery = new WbemcliUtil.WmiQuery("Win32_Process", Win32_Process.class);
            try {
                try {
                    Ole32.INSTANCE.CoInitializeEx(null, 0);
                    WbemcliUtil.WmiResult wmiResult = wmiQuery.execute();
                    for (int i2 = 0; i2 < wmiResult.getResultCount(); ++i2) {
                        try {
                            String string = (String)wmiResult.getValue((Enum)Win32_Process.CommandLine, i2);
                            int n2 = ((Number)wmiResult.getValue((Enum)Win32_Process.ProcessID, i2)).intValue();
                            if (biFunction != null && !((Boolean)biFunction.apply(n2, string)).booleanValue()) continue;
                            linkedHashSet.add(n2);
                            continue;
                        }
                        catch (Exception exception) {
                            if (BridgedBrowserNativeFunctionsWin.logger.level < 5) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "getProcessIdsWithCommandlineFilter(BiFunction<Integer, String, Boolean>)", 902).add("Error while getting process details", (Object)exception)).log();
                        }
                    }
                }
                finally {
                    Ole32.INSTANCE.CoUninitialize();
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 5) break block9;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getProcessIdsWithCommandlineFilter(BiFunction<Integer, String, Boolean>)", 909).add("Error while trying to list processes with command line", (Object)exception)).log();
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void killProcess(int n2) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "killProcess(int)", 919).addDetail("processId", n2)).log();
        }
        WinNT.HANDLE hANDLE = null;
        try {
            hANDLE = Kernel32.INSTANCE.OpenProcess(1, false, n2);
            if (hANDLE != null) {
                Kernel32.INSTANCE.TerminateProcess(hANDLE, 0);
            }
        }
        catch (Exception exception) {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "killProcess(int)", 928).add("ex", (Object)exception)).log();
            }
        }
        finally {
            block16: {
                if (hANDLE != null) {
                    try {
                        Kernel32.INSTANCE.CloseHandle(hANDLE);
                    }
                    catch (Exception exception) {
                        if (BridgedBrowserNativeFunctionsWin.logger.level < 3) break block16;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "killProcess(int)", 934).add("ex", (Object)exception)).log();
                    }
                }
            }
        }
    }

    @Override
    public int[] screenPosToClientAreaPos(long l2, int[] nArray) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "screenPosToClientAreaPos(long,int[])", 943).addDetail("handle", l2)).addDetail("screenPos", (Object)nArray)).log();
        }
        this.preload();
        assert (nArray.length > 2);
        int[] nArray2 = new int[2];
        WinDef.HWND hWND = new WinDef.HWND(new Pointer(l2));
        WinDef.POINT pOINT = new WinDef.POINT(nArray[0], nArray[1]);
        User32.INSTANCE.ScreenToClient(hWND, pOINT);
        nArray2[0] = pOINT.x;
        nArray2[1] = pOINT.y;
        return nArray2;
    }

    @Override
    public Point getRenderAreaOrigin() {
        Point point;
        block12: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "getRenderAreaOrigin()", 960).log();
            }
            this.setBrowserHwnd();
            if (this.uiAutoMainWindow == null) {
                return null;
            }
            point = null;
            try {
                try {
                    point = this.getUiAutoElementOrigin(this.uiAutoRenderDoc);
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRenderAreaOrigin()", 970).add("renderOrigin", (Object)point)).log();
                    }
                }
                catch (InvalidBoundsException invalidBoundsException) {
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 5) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "getRenderAreaOrigin()", 972).add("Render area origin was invalid, retry to find render area")).log();
                    }
                    this.detectUIAutoRenderArea();
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRenderAreaOrigin()", 974).add("uiAutoRenderDoc", (Object)this.uiAutoRenderDoc)).log();
                    }
                    if (this.uiAutoRenderDoc == null) {
                        return null;
                    }
                    point = this.getUiAutoElementOrigin(this.uiAutoRenderDoc);
                    if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRenderAreaOrigin()", 979).add("renderOrigin", (Object)point)).log();
                    }
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 3) break block12;
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getRenderAreaOrigin()", 983).add("ex", (Object)exception)).log();
            }
        }
        if (point == null) {
            this.uiAutoRenderDoc = null;
        }
        return point;
    }

    protected Point getUiAutoElementOrigin(AutomationBase automationBase) throws AutomationException, InvalidBoundsException {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getUiAutoElementOrigin(AutomationBase)", 998).addDetail("uiAutoElement", (Object)automationBase)).log();
        }
        if (automationBase == null) {
            throw new InvalidBoundsException();
        }
        WinDef.RECT rECT = automationBase.getBoundingRectangle();
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getUiAutoElementOrigin(AutomationBase)", 1005).add("bounds", (Object)rECT)).log();
        }
        if (this.boundsAreInvalid(rECT)) {
            throw new InvalidBoundsException();
        }
        return new Point(rECT.left, rECT.top);
    }

    private boolean boundsAreInvalid(WinDef.RECT rECT) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "boundsAreInvalid(RECT)", 1015).addDetail("bounds", (Object)rECT)).log();
        }
        return rECT == null || rECT.left == 0 && rECT.top == 0 && rECT.right == 0 && rECT.bottom == 0;
    }

    private static Set determineInstalledHotfixes() {
        HashSet<String> hashSet;
        block10: {
            if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
                logger.lvlBuild(7, "determineInstalledHotfixes()", 1023).log();
            }
            hashSet = new HashSet<String>();
            try {
                int n2;
                ProcessManager processManager = new ProcessManager("hotfixCheck", new String[]{"wmic", "qfe", "get", "hotfixid"});
                processManager.setCollect(true, true);
                processManager.startProcess();
                boolean bl2 = processManager.waitFor(5000L);
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "determineInstalledHotfixes()", 1030).add("ret", bl2)).log();
                }
                if (bl2) {
                    n2 = processManager.getExitCode();
                } else {
                    processManager.terminateProcess(1);
                    n2 = 1;
                }
                String string = processManager.getProcessOutputString();
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "determineInstalledHotfixes()", 1040).add("exitCode", n2)).log();
                }
                if (BridgedBrowserNativeFunctionsWin.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "determineInstalledHotfixes()", 1041).add("out", string)).log();
                }
                if (string != null) {
                    Pattern pattern = Pattern.compile("KB\\d+");
                    Matcher matcher = pattern.matcher(string);
                    while (matcher.find()) {
                        hashSet.add(matcher.group());
                    }
                }
            }
            catch (Exception exception) {
                if (BridgedBrowserNativeFunctionsWin.logger.level < 1) break block10;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "determineInstalledHotfixes()", 1052).add("ex", (Object)exception)).log();
            }
        }
        return hashSet;
    }

    @Nullable
    public AutomationBase getUiAutoMainWindow() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getUiAutoMainWindow()", 109).log();
        }
        return this.uiAutoMainWindow;
    }

    @Nullable
    public AutomationBase getUiAutoRenderDoc() {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getUiAutoRenderDoc()", 110).log();
        }
        return this.uiAutoRenderDoc;
    }

    protected BridgedBrowserNativeFunctionsWin setUiAutoRenderDoc(@Nullable AutomationBase automationBase) {
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setUiAutoRenderDoc(AutomationBase)", 111).addDetail("uiAutoRenderDoc", (Object)automationBase)).log();
        }
        this.uiAutoRenderDoc = automationBase;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getInstalledHotfixes() {
        Object object;
        if (BridgedBrowserNativeFunctionsWin.logger.level >= 7) {
            logger.lvlBuild(7, "getInstalledHotfixes()", 114).log();
        }
        if ((object = installedHotfixes.get()) == null) {
            AtomicReference atomicReference = installedHotfixes;
            synchronized (atomicReference) {
                object = installedHotfixes.get();
                if (object == null) {
                    Set set = BridgedBrowserNativeFunctionsWin.determineInstalledHotfixes();
                    object = set == null ? installedHotfixes : set;
                    installedHotfixes.set(object);
                }
            }
        }
        return object == installedHotfixes ? null : object;
    }

    protected static class InvalidBoundsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        protected InvalidBoundsException() {
        }
    }

    static enum DocumentSelectionType {
        FIRST_VALID,
        BIGGEST;

    }

    static enum Win32_Process {
        CommandLine,
        ProcessID;

    }
}

