/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.check;

import de.qfs.apps.qftest.client.fx.check.NodeChecker;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.chart.Chart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.XYChart;

public class ChartChecker
extends NodeChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.check.ChartChecker");

    public ChartChecker(j j2) {
        super(j2);
        if (ChartChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "ChartChecker(FxEngine)", 56).addDetail("engine", (Object)j2)).log();
        }
    }

    @Override
    protected boolean isCheckerFor(Object object) {
        if (ChartChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isCheckerFor(Object)", 73).addDetail("target", object)).log();
        }
        return object instanceof Chart;
    }

    @Override
    protected ArrayList getSupportedCheckTypesImpl(Object object, Object object2) {
        if (ChartChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypesImpl(Object,Object)", 89).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        ArrayList arrayList = super.getSupportedCheckTypesImpl(object, object2);
        arrayList.remove(CheckType.TEXT);
        arrayList.add(0, CheckType.TITLE);
        if (object instanceof PieChart) {
            arrayList.add(1, CheckType.LABELS);
            arrayList.add(2, CheckType.DATA_VALUES);
        } else if (object instanceof XYChart) {
            arrayList.add(1, CheckType.ALL_DATA_VALUES);
        }
        return arrayList;
    }

    @Override
    protected CheckData getCheckDataImpl(Object object, Object object2, CheckType checkType) {
        if (ChartChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataImpl(Object,Object,CheckType)", 117).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        Chart chart = (Chart)object;
        if (checkType.getDataType() == CheckDataType.STRING && CheckType.TITLE.getIdentifier().equals(checkType.getIdentifier())) {
            String string = Util.getCleanElementText((String)chart.getTitle());
            return new StringCheckData(CheckType.TITLE.getIdentifier(), string);
        }
        if (object instanceof PieChart && checkType.getDataType() == CheckDataType.STRING_LIST && CheckType.LABELS.getIdentifier().equals(checkType.getIdentifier())) {
            ObservableList observableList = ((PieChart)object).getData();
            String[] stringArray = new String[observableList.size()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = Util.getCleanElementText((String)((PieChart.Data)observableList.get(i2)).getName());
            }
            return new StringItemsCheckData(CheckType.LABELS.getIdentifier(), stringArray);
        }
        if (object instanceof PieChart && checkType.getDataType() == CheckDataType.STRING_LIST && CheckType.DATA_VALUES.getIdentifier().equals(checkType.getIdentifier())) {
            ObservableList observableList = ((PieChart)object).getData();
            String[] stringArray = new String[observableList.size()];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                stringArray[i3] = "" + ((PieChart.Data)observableList.get(i3)).getPieValue();
            }
            return new StringItemsCheckData(CheckType.DATA_VALUES.getIdentifier(), stringArray);
        }
        if (object instanceof XYChart && object2 instanceof XYChart.Series && checkType.getDataType() == CheckDataType.STRING_LIST && CheckType.DATA_VALUES.getIdentifier().equals(checkType.getIdentifier())) {
            ObservableList observableList = ((XYChart.Series)object2).getData();
            String[] stringArray = new String[observableList.size()];
            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                stringArray[i4] = "" + ((XYChart.Data)observableList.get(i4)).getXValue() + ":" + ((XYChart.Data)observableList.get(i4)).getYValue();
            }
            return new StringItemsCheckData(CheckType.DATA_VALUES.getIdentifier(), stringArray);
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (ChartChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 180).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object instanceof XYChart && object2 == null && checkType.getIdentifier().equals(CheckType.ALL_DATA_VALUES.getIdentifier())) {
            ObservableList observableList = ((XYChart)object).getData();
            if (observableList.size() == 0) {
                return null;
            }
            CheckData[] checkDataArray = new CheckData[observableList.size()];
            Object[] objectArray = new Object[observableList.size()];
            for (int i2 = 0; i2 < observableList.size(); ++i2) {
                checkDataArray[i2] = this.getCheckDataImpl(object, observableList.get(i2), CheckType.DATA_VALUES);
                objectArray[i2] = observableList.get(i2);
            }
            return new Pair((Object)checkDataArray, (Object)objectArray);
        }
        return super.getCheckDataAndItem(object, object2, checkType);
    }
}

