/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.fx.check.NodeChecker;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class TabPaneChecker
extends NodeChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.check.TabPaneChecker");

    public TabPaneChecker(j j2) {
        super(j2);
        if (TabPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TabPaneChecker(FxEngine)", 63).addDetail("engine", (Object)j2)).log();
        }
    }

    @Override
    protected boolean isCheckerFor(Object object) {
        return object instanceof TabPane;
    }

    @Override
    protected ArrayList getSupportedCheckTypesImpl(Object object, Object object2) {
        ArrayList arrayList = super.getSupportedCheckTypesImpl(object, object2);
        arrayList.remove(CheckType.TEXT);
        arrayList.add(0, CheckType.CURRENT_TAB);
        arrayList.add(1, CheckType.TABS);
        if (object2 != null) {
            arrayList.add(0, CheckType.TAB);
            arrayList.add(2, CheckType.TAB_VISIBLE);
            arrayList.add(3, CheckType.TAB_SELECTED);
            arrayList.add(4, CheckType.TAB_ENABLED);
            int n2 = arrayList.indexOf(CheckType.IMAGE);
            if (n2 >= 0) {
                arrayList.add(n2 + 1, CheckType.TAB_IMAGE);
                arrayList.add(n2 + 2, CheckType.TAB_TOOLTIP);
            } else {
                arrayList.add(CheckType.TAB_IMAGE);
                arrayList.add(CheckType.TAB_TOOLTIP);
            }
        }
        return arrayList;
    }

    @Override
    protected CheckData getCheckDataImpl(Object object, Object object2, CheckType checkType) throws TestException {
        if (TabPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataImpl(Object,Object,CheckType)", 139).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        TabPane tabPane = (TabPane)object;
        if (object2 != null) {
            if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.TAB.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                String string = this.a(tabPane, object2);
                return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), true);
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), this.isSelected(tabPane, object2));
                }
                catch (Exception exception) {
                    if (TabPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 167).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.TAB_ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_ENABLED.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    int n2 = (Integer)object2;
                    if (n2 < 0 || n2 >= this.getCount(tabPane)) {
                        return null;
                    }
                    return new BooleanCheckData(CheckType.ITEM_ENABLED.getIdentifier(), !((Tab)tabPane.getTabs().get(n2)).isDisabled());
                }
                catch (Exception exception) {
                    if (TabPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 183).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || CheckType.TAB_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_IMAGE_OLD.getIdentifier().equals(checkType.getIdentifier()) || !Client.instance().isCaptureContext() && CheckType.IMAGE.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    ImageRep imageRep = null;
                    try {
                        int[] nArray = this.engine.getHelper().getItemLocationInParent(object, object2);
                        int[] nArray2 = this.engine.getHelper().getItemSize(object, object2);
                        if (TabPaneChecker.a.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckDataImpl(Object,Object,CheckType)", 201).add("ipos", (Object)nArray)).add("isize", (Object)nArray2)).log();
                        }
                        if (nArray == null || nArray2 == null) {
                            imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object);
                        }
                        imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object, nArray[0], nArray[1], nArray2[0], nArray2[1]);
                    }
                    catch (BadItemException badItemException) {
                        if (TabPaneChecker.a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "getCheckDataImpl(Object,Object,CheckType)", 208).add("ex", (Object)badItemException)).log();
                        }
                        imageRep = BaseImageHandler.instance((Object)this.engine).grabImage(object);
                    }
                    return new ImageCheckData(CheckType.ITEM_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                }
                catch (Exception exception) {
                    if (TabPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 215).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING && (CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier()) || "tab_tooltip".equals(checkType.getIdentifier()) || CheckType.TAB_TOOLTIP.getIdentifier().equals(checkType.getIdentifier()))) {
                try {
                    boolean bl2 = Client.instance().isCaptureContext() && CheckType.TOOLTIP.getIdentifier().equals(checkType.getIdentifier());
                    return new StringCheckData((bl2 ? CheckType.TOOLTIP : CheckType.ITEM_TOOLTIP).getIdentifier(), this.engine.getHelper().getTooltipText(object, bl2 ? null : object2));
                }
                catch (Exception exception) {
                    if (TabPaneChecker.a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 231).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
        }
        if (checkType.getDataType() == CheckDataType.STRING && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.CURRENT_ITEM.getIdentifier().equals(checkType.getIdentifier()) || "current_tab".equals(checkType.getIdentifier()) || "tab_current".equals(checkType.getIdentifier()) || "item_current".equals(checkType.getIdentifier()))) {
            int n3 = this.getCount(tabPane);
            int n4 = tabPane.getSelectionModel().getSelectedIndex();
            if (n4 >= 0) {
                String string = this.a(tabPane, n4);
                return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), string);
            }
            return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), null);
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.TABS.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            int n5 = this.getCount(tabPane);
            try {
                String[] stringArray = new String[n5];
                for (int i2 = 0; i2 < n5; ++i2) {
                    stringArray[i2] = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, i2));
                }
                return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
            }
            catch (Exception exception) {
                if (TabPaneChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 264).add("ex", (Object)exception)).log();
                }
                return null;
            }
        }
        return super.getCheckDataImpl(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        if (TabPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 286).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        CheckData checkData = null;
        checkData = CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) ? this.getCheckData(object, null, checkType) : this.getCheckData(object, object2, checkType));
        if (checkData == null) {
            return null;
        }
        if (CheckType.TAB.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_IMAGE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.TAB_TOOLTIP.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }

    private String a(TabPane tabPane, Object object) {
        try {
            return Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(tabPane, object));
        }
        catch (BadItemException badItemException) {
            if (TabPaneChecker.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getTabValue(TabPane,Object)", 330).add("ex", (Object)badItemException)).log();
            }
            return "";
        }
    }

    protected boolean isSelected(TabPane tabPane, Object object) {
        if (TabPaneChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isSelected(TabPane,Object)", 346).addDetail("tabPane", (Object)tabPane)).addDetail("item", object)).log();
        }
        return ((Tab)tabPane.getTabs().get(((Integer)object).intValue())).isSelected();
    }

    protected int getCount(TabPane tabPane) {
        return tabPane.getTabs().size();
    }
}

