/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.fx.check;

import de.qfs.apps.qftest.client.fx.check.TextChecker;
import de.qfs.apps.qftest.client.fx.items.TextItemResolver;
import de.qfs.apps.qftest.client.fx.j;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;
import javafx.scene.control.TextArea;

public class TextAreaChecker
extends TextChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.fx.check.TextAreaChecker");

    public TextAreaChecker(j j2) {
        super(j2);
        if (TextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TextAreaChecker(FxEngine)", 59).addDetail("engine", (Object)j2)).log();
        }
    }

    @Override
    protected boolean isCheckerFor(Object object) {
        return object instanceof TextArea;
    }

    @Override
    protected ArrayList getSupportedCheckTypesImpl(Object object, Object object2) {
        ArrayList arrayList = super.getSupportedCheckTypesImpl(object, object2);
        arrayList.add(1, CheckType.LINES);
        if (object2 != null) {
            arrayList.add(0, CheckType.LINE);
        }
        return arrayList;
    }

    @Override
    protected CheckData getCheckDataImpl(Object object, Object object2, CheckType checkType) throws TestException {
        if (TextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataImpl(Object,Object,CheckType)", 121).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object2 != null && checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.LINE.getIdentifier().equals(checkType.getIdentifier()) || "line".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
            try {
                String string = Util.getCleanElementText((String)ItemRegistry.instance().getItemValue(object, object2));
                return new StringCheckData(CheckType.ITEM.getIdentifier(), string);
            }
            catch (BadItemException badItemException) {
                if (TextAreaChecker.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getCheckDataImpl(Object,Object,CheckType)", 140).add("ex", (Object)badItemException)).log();
                }
                return null;
            }
        }
        TextArea textArea = (TextArea)object;
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (object2 == null && "default".equals(checkType.getIdentifier()) || CheckType.LINES.getIdentifier().equals(checkType.getIdentifier()) || "lines".equals(checkType.getIdentifier()) || CheckType.ITEMS.getIdentifier().equals(checkType.getIdentifier()))) {
            return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), TextItemResolver.getItems(textArea));
        }
        return super.getCheckDataImpl(object, object2, checkType);
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (TextAreaChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 180).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.LINE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

