/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.ios;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.PrivilegedRunnable;
import de.qfs.apps.qftest.client.c.b;
import de.qfs.apps.qftest.client.ios.IOSHelper;
import de.qfs.apps.qftest.client.ios.d.a;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceControl;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceInfo;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceScheme;
import de.qfs.apps.qftest.client.ios.device.IOSSimulator;
import de.qfs.apps.qftest.client.ios.e;
import de.qfs.apps.qftest.client.ios.f;
import de.qfs.apps.qftest.client.ios.g;
import de.qfs.apps.qftest.client.ios.toolkit.IOSElement;
import de.qfs.apps.qftest.client.mobile.MobileEngine;
import de.qfs.apps.qftest.extensions.ExtraFeatureResolver;
import de.qfs.apps.qftest.extensions.RedirectResolver;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.MobileDeviceStartResultException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.extensions.notifications.SharedClientInfo;
import de.qfs.apps.qftest.shared.ios.IOSConnection;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.IOSUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionListener;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.VersionNumber;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class IOSEngine
extends MobileEngine
implements de.qfs.apps.qftest.client.c.f,
OptionListener {
    private static final QFLogger w = new QFLogger("de.qfs.apps.qftest.client.ios.IOSEngine");
    public static final List AVAILABLE_DEVICE_SCHEMES_TYPES = new LinkedList();
    public static final VersionNumber MINIMAL_IOS_VERSION = new VersionNumber(Integer.valueOf(15));
    public static final Pattern TARGET_NAME_INDEX_PATTERN = Pattern.compile("(.*)& *(-?\\d+)");
    private boolean x = Options.cached_OPT_IOS_CHECK_DISPATCH_THREAD;
    private IOSHelper y;
    private de.qfs.apps.qftest.client.c.a z;
    protected b k = null;
    private final LinkedList A = new LinkedList();
    de.qfs.apps.qftest.shared.b.a l = de.qfs.apps.qftest.shared.b.a.a;
    AtomicReference m = new AtomicReference();
    @Nullable
    IOSConnection n;
    @Nullable
    IOSTarget o;
    @Nullable
    IOSSimulator p;
    @Nullable
    IOSDeviceControl q;
    @Nullable
    IOSDeviceInfo r;
    Checker s;
    ExtraFeatureResolver t;
    RedirectResolver u;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOSEngine() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "IOSEngine()", 160).log();
        }
        Object object = a;
        synchronized (object) {
            this.c = "ios";
            if (IOSEngine.instance("ios") == null) {
                IOSEngine.register("ios", (Engine)this);
            }
            int n2 = 0;
            while (true) {
                this.d = "ios" + n2;
                if (IOSEngine.instance(this.d) == null) break;
                ++n2;
            }
            IOSEngine.register(this.d, (Engine)this);
        }
        try {
            Client.instance().pushEngineContext(this);
            this.y = new IOSHelper(this);
            Client.instance().addOptionListener(this);
        }
        finally {
            Client.instance().popEngineContext();
        }
    }

    public static IOSEngine engineFor(Object object) {
        for (Engine engine : IOSEngine.getAllEngines()) {
            if (!engine.isIOS() || !engine.belongsTo(object)) continue;
            return (IOSEngine)engine;
        }
        return null;
    }

    public void connectToIOSDevice(String string) throws TestException {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "connectToIOSDevice(String)", 203).addDetail("requestedName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("requestedName is marked non-null but is null");
        }
        try {
            IOSDeviceScheme iOSDeviceScheme = this.b(string);
            this.l();
            this.i();
            this.j();
            if (this.o.isSimulator()) {
                this.m();
                this.a(iOSDeviceScheme);
            }
            System.out.println("Instrumenting " + this.o.getDisplayName() + ".");
            this.q = iOSDeviceScheme.getDeviceControl(this.o);
            this.q.setPostInstrumentMethod(() -> {
                if (this.p != null) {
                    this.p.initSimulatorAfterConnect();
                }
            });
            this.e();
            this.f();
            this.h();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.g(), "Cleanup iOS Helper"));
        }
        catch (Exception exception) {
            this.l = de.qfs.apps.qftest.shared.b.a.values()[this.l.ordinal() + 1];
            this.m.set(exception);
            if (exception instanceof TestException) {
                throw exception;
            }
            throw new TestException((Throwable)exception);
        }
    }

    @Nullable
    private IOSDeviceScheme b(String string) throws TestException {
        Object object;
        Object object22;
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "selectTarget(String)", 248).addDetail("requestedName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("requestedName is marked non-null but is null");
        }
        this.l = de.qfs.apps.qftest.shared.b.a.b;
        String string2 = IOSEngine.c(string);
        String string3 = string2 == null ? string : string.substring(string2.length() + 1);
        System.out.println("Detecting targets.");
        String[] stringArray = null;
        TestException testException = null;
        for (Object object22 : AVAILABLE_DEVICE_SCHEMES_TYPES) {
            object = (IOSDeviceScheme)Reflector.safeCreateInstance((Class)object22);
            if (object == null || string2 != null && !object.supportsSchemeName(string2)) continue;
            try {
                IOSConnection iOSConnection = object.getConnection();
                this.o = this.a(iOSConnection, string3);
                if (IOSEngine.w.level >= 9) {
                    ((LevelAwareLogBuilder)w.lvlBuild(9, "selectTarget(String)", 266).add("target", (Object)this.o)).log();
                }
                if (this.o == null) continue;
                this.n = iOSConnection;
                stringArray = object;
                break;
            }
            catch (Exception exception) {
                if (IOSEngine.w.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(5, "selectTarget(String)", 273).add("Could not create target: ")).add((Object)exception)).log();
                }
                if (testException != null) continue;
                testException = exception instanceof TestException ? (TestException)((Object)exception) : new TestException((Throwable)exception);
            }
        }
        if (this.o == null) {
            if (testException != null) {
                throw testException;
            }
            throw new TestException((String)(string2 == null ? "No connections available." : "No connection for schemeName '" + string2 + "' available."));
        }
        String string4 = this.o.getUdid();
        object22 = System.getProperty("qftest.ios.targetsInUse", "");
        if (!((String)object22).isEmpty()) {
            object = Misc.fastSplit((String)object22, (char)',');
            int n2 = ((String[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string5 = object[i2];
                if (!string5.trim().equals(string4)) continue;
                throw new TestException("'" + this.o.getDisplayName() + "' already in use.");
            }
        }
        if (!Misc.emptyOrNull((String)(object = System.getProperty("qftest.ios.override.targetOS")))) {
            this.o.overrideOsVersion(VersionNumber.fromString((String)object));
        }
        if (SharedClientInfo.NOTIFIER.level >= 1) {
            SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "iosdeviceudid", "value", string4});
        }
        this.l = de.qfs.apps.qftest.shared.b.a.d;
        return stringArray;
    }

    private void l() throws TestException {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "connectToTarget()", 313).log();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.e;
        System.out.println("Connecting to " + this.o.getDisplayName() + ".");
        this.o.connect();
        if (!this.o.isConnected()) {
            throw new TestException("Could not connect to " + this.o.getDisplayName() + "." + (this.o.isDevice() ? " Make sure the device is still physically connected." : ""));
        }
        this.l = de.qfs.apps.qftest.shared.b.a.g;
    }

    private void m() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "bootSimulator()", 330).log();
        }
        if (!this.o.isBooted()) {
            System.out.println("Booting " + this.o.getDisplayName() + ".");
            this.l = de.qfs.apps.qftest.shared.b.a.h;
            this.o.boot();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.j;
    }

    private void a(IOSDeviceScheme iOSDeviceScheme) throws TestException {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "startSimulator(IOSDeviceScheme)", 344).addDetail("activeScheme", (Object)iOSDeviceScheme)).log();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.k;
        System.out.println("Starting simulator of " + this.o.getDisplayName() + ".");
        this.p = iOSDeviceScheme.getSimulator();
        try {
            this.p.start();
            if (this.o.canFocus()) {
                this.o.focus();
                de.qfs.apps.qftest.client.a.a.c().e();
                de.qfs.apps.qftest.client.a.a.c().a("simulator", "simulator", actionEvent -> this.o.focus());
            }
        }
        catch (Exception exception) {
            throw new TestException("Could not start simulator", (Throwable)exception);
        }
        this.l = de.qfs.apps.qftest.shared.b.a.m;
    }

    protected void e() throws MobileDeviceStartResultException {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "prepareInstrumentation()", 366).log();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.n;
        this.q.prepareInstrumentation();
        this.l = de.qfs.apps.qftest.shared.b.a.p;
    }

    protected void f() throws MobileDeviceStartResultException {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "instrumentDevice()", 376).log();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.q;
        this.g();
        try {
            this.q.instrumentDevice();
        }
        catch (MobileDeviceStartResultException mobileDeviceStartResultException) {
            if (mobileDeviceStartResultException.getState() == de.qfs.apps.qftest.shared.b.a.v && this.q.shouldTryAgentRebuild()) {
                this.q.cleanAgentBuildDir();
                this.e();
                this.l = de.qfs.apps.qftest.shared.b.a.q;
                this.q.instrumentDevice();
            }
            throw mobileDeviceStartResultException;
        }
        this.l = de.qfs.apps.qftest.shared.b.a.s;
    }

    protected void g() {
        block6: {
            if (IOSEngine.w.level >= 7) {
                w.lvlBuild(7, "removeInstrumentation()", 399).log();
            }
            try {
                String string = this.q.getAgentRunnerBundleId();
                if (Misc.emptyOrNull((String)string)) break block6;
                try {
                    this.o.uninstallApp(string);
                }
                catch (IOException iOException) {
                    if (!iOException.getMessage().contains("it is not installed")) {
                        throw iOException;
                    }
                }
            }
            catch (Exception exception) {
                if (IOSEngine.w.level < 3) break block6;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(3, "removeInstrumentation()", 412).add("Could not clean up device agent: ")).add((Object)exception)).log();
            }
        }
    }

    protected void h() throws MobileDeviceStartResultException {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "openSession()", 419).log();
        }
        this.a(3);
    }

    protected void a(int n2) throws MobileDeviceStartResultException {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "openSession(int)", 427).addDetail("retries", n2)).log();
        }
        this.l = de.qfs.apps.qftest.shared.b.a.t;
        this.q.openSession(n2);
        this.r = this.q.getDeviceInfo();
        this.n();
        this.l = de.qfs.apps.qftest.shared.b.a.w;
    }

    private void n() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "attachHandlers()", 441).log();
        }
        this.q.setAgentStopHandler(() -> {
            if (this.o.isSimulator() && !Options.cached_OPT_IOS_RESTART_SIMULATOR) {
                this.asyncSystemExit("Connection to agent lost", -3, 1000);
                return;
            }
            System.out.println("Connection to agent lost. Reinstrumenting...");
            try {
                ((g)this.g).f();
            }
            catch (Exception exception) {
                if (IOSEngine.w.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(5, "attachHandlers()", 453).add("Could not reconnect: ")).add((Object)exception)).log();
                }
                this.asyncSystemExit("Agent connection definitively lost - " + exception.getMessage(), -3, 1000);
            }
        });
        if (this.o.isSimulator()) {
            this.p.setCloseHandler(iOSTarget -> {
                if (!Options.cached_OPT_IOS_RESTART_SIMULATOR) {
                    this.asyncSystemExit("Simulator window closed", -1, 1000);
                    return;
                }
            });
            this.p.attachToTarget(this.o);
        }
        this.j();
    }

    protected void i() throws TestException {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "checkTargetProperties()", 474).log();
        }
        if (this.o == null) {
            return;
        }
        VersionNumber versionNumber = this.o.getOsVersion();
        if (versionNumber == null) {
            Util.logSutWarning((String)("Could not determine iOS version of target '" + this.o.getDisplayName() + "'"));
        } else if (versionNumber.isLowerThan(MINIMAL_IOS_VERSION)) {
            throw new TestException("The target '" + this.o.getDisplayName() + "' has " + versionNumber.getOriginalVersionString() + " installed, but iOS " + String.valueOf(MINIMAL_IOS_VERSION) + " is required to execute tests.");
        }
    }

    protected void j() {
        block15: {
            if (IOSEngine.w.level >= 7) {
                w.lvlBuild(7, "setClientProperties()", 492).log();
            }
            if (this.o == null) {
                return;
            }
            try {
                VersionNumber versionNumber;
                if (SharedClientInfo.NOTIFIER.level >= 1) {
                    SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "devicetype", "value", this.o.getType().getName()});
                }
                if (SharedClientInfo.NOTIFIER.level >= 1) {
                    SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "devicename", "value", this.o.getName()});
                }
                if (SharedClientInfo.NOTIFIER.level >= 1) {
                    SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "devicedisplayname", "value", this.o.getDisplayName()});
                }
                if (SharedClientInfo.NOTIFIER.level >= 1) {
                    SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "deviceudid", "value", this.o.getUdid()});
                }
                if ((versionNumber = this.o.getOsVersion()) != null) {
                    if (SharedClientInfo.NOTIFIER.level >= 1) {
                        SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "version", "value", versionNumber.toString()});
                    }
                    if (SharedClientInfo.NOTIFIER.level >= 1) {
                        SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "mainversion", "value", versionNumber.getMajor()});
                    }
                }
                if (this.r != null) {
                    if (this.r.getUserInterfaceIdiom() != null && SharedClientInfo.NOTIFIER.level >= 1) {
                        SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "devicekind", "value", this.r.getUserInterfaceIdiom().getName()});
                    }
                    if (!Misc.emptyOrNull((String)this.r.getModel()) && SharedClientInfo.NOTIFIER.level >= 1) {
                        SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "devicemodel", "value", this.r.getModel()});
                    }
                    if (!Misc.emptyOrNull((String)this.r.getUserInterfaceStyle()) && SharedClientInfo.NOTIFIER.level >= 1) {
                        SharedClientInfo.NOTIFIER.postNotification(1, "client.property.set", (Object)this, new Object[]{"name", "uistyle", "value", this.r.getUserInterfaceStyle()});
                    }
                }
            }
            catch (Exception exception) {
                if (IOSEngine.w.level < 3) break block15;
                ((LevelAwareLogBuilder)w.lvlBuild(3, "setClientProperties()", 517).add("Could not set client properties: ", (Object)exception)).log();
            }
        }
    }

    @Nullable
    private static String c(String string) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "getSchemeNameFromTarget(String)", 525).addDetail("requestedName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("requestedName is marked non-null but is null");
        }
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            return null;
        }
        return string.substring(0, n2);
    }

    private IOSTarget a(IOSConnection iOSConnection, String string2) throws TestException {
        List list;
        block32: {
            IOSTarget iOSTarget2;
            block33: {
                IOSTarget iOSTarget3;
                block30: {
                    IOSTarget iOSTarget4;
                    block31: {
                        int n2;
                        String string3;
                        IOSTarget.Type type;
                        block28: {
                            IOSTarget iOSTarget5;
                            block29: {
                                block26: {
                                    IOSTarget iOSTarget6;
                                    block27: {
                                        block24: {
                                            IOSTarget iOSTarget7;
                                            block25: {
                                                block22: {
                                                    IOSTarget iOSTarget8;
                                                    block23: {
                                                        block20: {
                                                            IOSTarget iOSTarget9;
                                                            block21: {
                                                                if (IOSEngine.w.level >= 7) {
                                                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(7, "getTargetFromName(IOSConnection,String)", 535).addDetail("connection", (Object)iOSConnection)).addDetail("targetName", string2)).log();
                                                                }
                                                                list = iOSConnection.listTargets();
                                                                iOSTarget3 = null;
                                                                try {
                                                                    block19: {
                                                                        type = null;
                                                                        string3 = string2.trim().toLowerCase();
                                                                        n2 = 0;
                                                                        Matcher matcher = TARGET_NAME_INDEX_PATTERN.matcher(string3);
                                                                        if (matcher.find()) {
                                                                            try {
                                                                                n2 = Integer.parseInt(matcher.group(2));
                                                                                string3 = matcher.group(1);
                                                                            }
                                                                            catch (NumberFormatException numberFormatException) {
                                                                                if (IOSEngine.w.level < 5) break block19;
                                                                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(5, "getTargetFromName(IOSConnection,String)", 551).add("Could not parse target index ")).add(matcher.group(2))).log();
                                                                            }
                                                                        }
                                                                    }
                                                                    if (string3.endsWith("[simulator]")) {
                                                                        type = IOSTarget.Type.SIMULATOR;
                                                                        string3 = string3.substring(0, string3.length() - 11);
                                                                    } else if (string3.endsWith("[device]")) {
                                                                        type = IOSTarget.Type.DEVICE;
                                                                        string3 = string3.substring(0, string3.length() - 8);
                                                                    }
                                                                    string3 = string3.trim();
                                                                    if (IOSEngine.w.level >= 9) {
                                                                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(9, "getTargetFromName(IOSConnection,String)", 563).add("requestedName", string3)).add("requestedIndex", n2)).add("requestedType", (Object)type)).log();
                                                                    }
                                                                    if ((iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> string.replaceAll("[\\(\\)]", "").equalsIgnoreCase(iOSTarget.getUdid()))) == null) break block20;
                                                                    iOSTarget9 = iOSTarget3;
                                                                    if (iOSTarget3 == null) break block21;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    if (iOSTarget3 != null) {
                                                                        iOSTarget3.setDisplayName(IOSUtil.getUniqueName(iOSTarget3, (List)list));
                                                                    }
                                                                    throw throwable;
                                                                }
                                                                iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                                                            }
                                                            return iOSTarget9;
                                                        }
                                                        iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> string.equalsIgnoreCase(IOSUtil.getTargetNameWithUdid((IOSTarget)iOSTarget)));
                                                        if (iOSTarget3 == null) break block22;
                                                        iOSTarget8 = iOSTarget3;
                                                        if (iOSTarget3 == null) break block23;
                                                        iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                                                    }
                                                    return iOSTarget8;
                                                }
                                                iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> string.equalsIgnoreCase(IOSUtil.getTargetNameWithVersion((IOSTarget)iOSTarget)));
                                                if (iOSTarget3 == null) break block24;
                                                iOSTarget7 = iOSTarget3;
                                                if (iOSTarget3 == null) break block25;
                                                iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                                            }
                                            return iOSTarget7;
                                        }
                                        iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> string.equalsIgnoreCase(iOSTarget.getName()));
                                        if (iOSTarget3 == null) break block26;
                                        iOSTarget6 = iOSTarget3;
                                        if (iOSTarget3 == null) break block27;
                                        iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                                    }
                                    return iOSTarget6;
                                }
                                iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> string.equalsIgnoreCase(iOSTarget.getName() + " (" + String.valueOf(iOSTarget.getOsVersion()) + ")"));
                                if (iOSTarget3 == null) break block28;
                                iOSTarget5 = iOSTarget3;
                                if (iOSTarget3 == null) break block29;
                                iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                            }
                            return iOSTarget5;
                        }
                        iOSTarget3 = this.a(list, type, string3, n2, (iOSTarget, string) -> {
                            String string2 = iOSTarget.getName();
                            return string2 != null && string2.toLowerCase().startsWith((String)string);
                        });
                        if (iOSTarget3 == null) break block30;
                        iOSTarget4 = iOSTarget3;
                        if (iOSTarget3 == null) break block31;
                        iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
                    }
                    return iOSTarget4;
                }
                iOSTarget3 = iOSConnection.getTargetByName(string2);
                if (iOSTarget3 == null) break block32;
                if (IOSEngine.w.level >= 9) {
                    ((LevelAwareLogBuilder)w.lvlBuild(9, "getTargetFromName(IOSConnection,String)", 602).add("selectedTarget", (Object)iOSTarget3)).log();
                }
                iOSTarget2 = iOSTarget3;
                if (iOSTarget3 == null) break block33;
                iOSTarget3.setDisplayName(IOSUtil.getUniqueName((IOSTarget)iOSTarget3, (List)list));
            }
            return iOSTarget2;
        }
        throw new TestException("Target '" + string2 + "' not found.\n\nAvailable targets:\n" + list.stream().filter(iOSTarget -> iOSTarget.isIOS()).map(iOSTarget -> "- " + IOSUtil.getUniqueName((IOSTarget)iOSTarget, (List)list) + (iOSTarget.isSimulator() ? " [Simulator]" : " [Device]")).collect(Collectors.joining("\n")));
    }

    @Nullable
    private IOSTarget a(List list, IOSTarget.Type type, String string, int n2, BiFunction biFunction) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)w.lvlBuild(7, "selectTarget(List<? extends IOSTarget>,Type,String,int,BiFunction<IOSTarget, String, Boolean>)", 620).addDetail("targets", (Object)list)).addDetail("requestedType", (Object)type)).addDetail("requestedName", string)).addDetail("requestedIndex", n2)).addDetail("tester", (Object)biFunction)).log();
        }
        ArrayList<IOSTarget> arrayList = new ArrayList<IOSTarget>();
        int n3 = 0;
        for (IOSTarget iOSTarget : list) {
            if (!iOSTarget.isIOS() || type != null && type != iOSTarget.getType() || !((Boolean)biFunction.apply(iOSTarget, string)).booleanValue()) continue;
            if (IOSEngine.w.level >= 9) {
                ((LevelAwareLogBuilder)w.lvlBuild(9, "selectTarget(List<? extends IOSTarget>,Type,String,int,BiFunction<IOSTarget, String, Boolean>)", 635).add("target", (Object)iOSTarget)).log();
            }
            if (n3 == n2) {
                return iOSTarget;
            }
            arrayList.add(iOSTarget);
            ++n3;
        }
        if (n2 < 0) {
            n2 = arrayList.size() + n2;
        }
        if (n2 >= 0 && n2 < arrayList.size()) {
            return (IOSTarget)arrayList.get(n2);
        }
        return null;
    }

    @Override
    public boolean isIOS() {
        return true;
    }

    @Override
    public String getVisibleName() {
        return "iOS";
    }

    public synchronized g createTracker() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "createTracker()", 694).log();
        }
        this.g = new g(this);
        if (this.e != null) {
            ((g)this.g).addEventFilter((f)this.e);
        }
        if (this.f != null) {
            ((g)this.g).addEventFilter((e)this.f);
        }
        return (g)this.g;
    }

    public synchronized f createRecorder() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "createRecorder()", 715).log();
        }
        this.e = new f(this);
        if (this.g != null) {
            ((g)this.g).addEventFilter((f)this.e);
        }
        return (f)this.e;
    }

    public synchronized e createPlayer() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "createPlayer()", 732).log();
        }
        this.f = new e(this);
        if (this.g != null) {
            ((g)this.g).addEventFilter((e)this.f);
        }
        return (e)this.f;
    }

    @Override
    public final ElementHelper getElementHelper() {
        return this.y;
    }

    @Override
    public final IOSHelper getHelper() {
        return this.y;
    }

    @Override
    public void createThreadPool(ThreadGroup threadGroup) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "createThreadPool(ThreadGroup)", 788).addDetail("group", (Object)threadGroup)).log();
        }
        this.k();
        this.z = new de.qfs.apps.qftest.client.c.a(this.k, threadGroup);
        this.z.start();
        super.createThreadPool(threadGroup);
    }

    @Override
    public boolean isEventDispatchThread() {
        return Thread.currentThread() == this.k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeLater(Runnable runnable) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "invokeLater(Runnable)", 824).addDetail("runnable", (Object)runnable)).log();
        }
        IOSEngine iOSEngine = this;
        synchronized (iOSEngine) {
            this.A.addLast(PrivilegedRunnable.asPrivilegedRunnable(runnable));
            if (IOSEngine.w.level >= 9) {
                ((LevelAwareLogBuilder)w.lvlBuild(9, "invokeLater(Runnable)", 828).add("runnablesToDispatch", (Object)this.A)).log();
            }
            if (this.isEventDispatchThread()) {
                if (this.z != null) {
                    this.z.a();
                } else if (IOSEngine.w.level >= 1) {
                    ((LevelAwareLogBuilder)w.lvlBuild(1, "invokeLater(Runnable)", 835).add("Internal error - triggerThreadThread not initialized")).dumpStack();
                }
            } else {
                this.k().triggerThread();
            }
        }
    }

    protected b k() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getEventDispatcher()", 846).log();
        }
        if (this.k == null) {
            this.a("iOSEngine");
        }
        return this.k;
    }

    protected synchronized void a(String string) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "createDispatchThread(String)", 857).addDetail("engineName", string)).log();
        }
        if (this.k != null) {
            return;
        }
        this.k = new b(this, string);
        this.k.setDaemon(true);
        this.k.start();
    }

    @Override
    protected boolean c() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "shouldCheckDispatch()", 871).log();
        }
        return this.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadCallback() {
        Runnable runnable;
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "threadCallback()", 888).log();
        }
        IOSEngine iOSEngine = this;
        synchronized (iOSEngine) {
            if (this.A.isEmpty()) {
                if (IOSEngine.w.level >= 3) {
                    ((LevelAwareLogBuilder)w.lvlBuild(3, "threadCallback()", 893).add("Internal error: No runnable to dispatch")).log();
                }
                return;
            }
            runnable = (Runnable)this.A.removeFirst();
            if (IOSEngine.w.level >= 9) {
                ((LevelAwareLogBuilder)w.lvlBuild(9, "threadCallback()", 897).add("runnable", (Object)runnable)).log();
            }
        }
        runnable.run();
    }

    @Override
    public boolean belongsTo(Object object) {
        return object instanceof IOSElement;
    }

    @Override
    public ImageRep grabDeviceScreenshot() throws Exception {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "grabDeviceScreenshot()", 926).log();
        }
        ImageRep imageRep = null;
        if (this.q != null) {
            imageRep = this.q.grabScreenshot();
        }
        if (imageRep == null && this.o != null) {
            imageRep = this.o.grabScreenshot();
        }
        return imageRep;
    }

    @Override
    public double getScreenScale() {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "getScreenScale()", 947).add("deviceInfo", (Object)this.r)).log();
        }
        return this.r == null ? 1.0 : this.r.getScale();
    }

    public Geometry getScreenSize() {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "getScreenSize()", 957).add("deviceInfo", (Object)this.r)).log();
        }
        return this.r == null ? null : this.r.getScreenSize();
    }

    public void optionsChanged(OptionSet optionSet) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "optionsChanged(OptionSet)", 974).addDetail("options", (Object)optionSet)).log();
        }
        this.x = Options.cached_OPT_IOS_CHECK_DISPATCH_THREAD;
    }

    @Override
    public boolean supportsAction(String string) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "supportsAction(String)", 983).addDetail("action", string)).log();
        }
        return "HOME".equalsIgnoreCase(string);
    }

    public b getDispatchThread() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDispatchThread()", 121).log();
        }
        return this.k;
    }

    public de.qfs.apps.qftest.shared.b.a getDeviceState() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDeviceState()", 130).log();
        }
        return this.l;
    }

    public AtomicReference getDeviceInitError() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDeviceInitError()", 131).log();
        }
        return this.m;
    }

    @Nullable
    public IOSConnection getConnection() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getConnection()", 133).log();
        }
        return this.n;
    }

    @Nullable
    public IOSTarget getTarget() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getTarget()", 135).log();
        }
        return this.o;
    }

    @Nullable
    public IOSSimulator getSimulator() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getSimulator()", 137).log();
        }
        return this.p;
    }

    @Nullable
    public IOSDeviceControl getDeviceControl() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDeviceControl()", 139).log();
        }
        return this.q;
    }

    @Nullable
    public IOSDeviceInfo getDeviceInfo() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDeviceInfo()", 142).log();
        }
        return this.r;
    }

    public Checker getDefaultChecker() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDefaultChecker()", 146).log();
        }
        return this.s;
    }

    public IOSEngine setDefaultChecker(Checker checker) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "setDefaultChecker(Checker)", 146).addDetail("defaultChecker", (Object)checker)).log();
        }
        this.s = checker;
        return this;
    }

    public ExtraFeatureResolver getDefaultExtraFeatureResolver() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDefaultExtraFeatureResolver()", 147).log();
        }
        return this.t;
    }

    public IOSEngine setDefaultExtraFeatureResolver(ExtraFeatureResolver extraFeatureResolver) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "setDefaultExtraFeatureResolver(ExtraFeatureResolver)", 147).addDetail("defaultExtraFeatureResolver", (Object)extraFeatureResolver)).log();
        }
        this.t = extraFeatureResolver;
        return this;
    }

    public RedirectResolver getDefaultRedirectResolver() {
        if (IOSEngine.w.level >= 7) {
            w.lvlBuild(7, "getDefaultRedirectResolver()", 148).log();
        }
        return this.u;
    }

    public IOSEngine setDefaultRedirectResolver(RedirectResolver redirectResolver) {
        if (IOSEngine.w.level >= 7) {
            ((LevelAwareLogBuilder)w.lvlBuild(7, "setDefaultRedirectResolver(RedirectResolver)", 148).addDetail("defaultRedirectResolver", (Object)redirectResolver)).log();
        }
        this.u = redirectResolver;
        return this;
    }

    static {
        AVAILABLE_DEVICE_SCHEMES_TYPES.add(de.qfs.apps.qftest.client.ios.a.a.class);
        AVAILABLE_DEVICE_SCHEMES_TYPES.add(a.class);
    }
}

