/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.ios.device;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.EventLog;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceControl;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceInfo;
import de.qfs.apps.qftest.client.ios.device.IOSDeviceRotation;
import de.qfs.apps.qftest.client.ios.toolkit.IOSElement;
import de.qfs.apps.qftest.client.mobile.b;
import de.qfs.apps.qftest.client.mobile.c;
import de.qfs.apps.qftest.client.mobile.image.JpegUtil;
import de.qfs.apps.qftest.client.mobile.image.MJPEGStreamProcessor;
import de.qfs.apps.qftest.client.mobile.image.ScreenshotSupplier;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.b.a;
import de.qfs.apps.qftest.shared.exceptions.MobileDeviceStartResultException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.g;
import de.qfs.apps.qftest.shared.h;
import de.qfs.apps.qftest.shared.i;
import de.qfs.apps.qftest.shared.ios.IOSApp;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.IOSUtil;
import de.qfs.apps.qftest.shared.ios.idb.IdbProcessClient;
import de.qfs.apps.qftest.shared.m;
import de.qfs.apps.qftest.shared.system.MacOSNative;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.mac.PListAccess;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonArray;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.json.ParseException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionListener;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessEvent;
import de.qfs.lib.util.ProcessListener;
import de.qfs.lib.util.ProcessManager;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class IOSWdaDeviceControl
implements IOSDeviceControl,
MJPEGStreamProcessor.Delegate,
OptionListener {
    private static final QFLogger A = new QFLogger("de.qfs.apps.qftest.client.ios.device.IOSWdaDeviceControl");
    private static final String B = "wdaRequest";
    private static final String C = ".connect";
    private static final String D = ".resultParsing";
    public static final int DEFAULT_VIDEO_STREAM_PORT = 9100;
    private static final String E = "de.qfs.apps.qftest.ios.ida.WebDriverAgentRunner";
    private static final String F = "iDeviceAgent-Runner.app";
    private static final File G = new File(Native.getVersionDir(), "ios/ida");
    private static final String H = "iDeviceAgent.xcodeproj";
    private static final String I = "Underlying Error:";
    private static final String J = "encountered an error (";
    private static final String K = "/WebDriverAgentRunner";
    private static final String[] L = new String[]{"AppIcon60x60@2x.png", "AppIcon76x76@2x~ipad.png"};
    private static final int M = 500;
    BuildOutput a = BuildOutput.NONE;
    private static final String N = "ServerURLHere->";
    private static final String O = "<-ServerURLHere";
    public static final String SPRINGBOARD_APP_ID = "com.apple.springboard";
    public static final Map DEFAULT_SESSION_CAPABILITIES = Misc.mapOf((Object[])new Object[]{"useNativeCachingStrategy", Boolean.TRUE});
    public static final Map DEFAULT_SESSION_SETTINGS = Misc.mapOf((Object[])new Object[]{"screenshotQuality", 10, "mjpegServerFramerate", 10, "mjpegServerScreenshotQuality", 25});
    final Deque b = new ConcurrentLinkedDeque();
    protected volatile String c;
    private volatile int P = 9100;
    boolean d = false;
    String e = null;
    final IOSTarget f;
    String g;
    String h;
    boolean i;
    private ProcessManager Q;
    Runnable j;
    final String k;
    final File l;
    int m = 0;
    private AgentBuildProcessListener R;
    volatile Runnable n;
    JsonObject o = new JsonObject();
    final MJPEGStreamProcessor p;
    final AtomicReference q = new AtomicReference();
    private long S;
    WeakReference r = new WeakReference<Object>(null);
    boolean s;
    int t;
    int u;
    BufferedImage v;
    JsonValue w;
    Date x;
    static final DateFormat y = new SimpleDateFormat("HH:mm:ss.SSS");
    final g z = new g(IOSWDAInvocation.class, Options.cached_OPT_WEB_INVOCATIONS_STACKSIZE * 2);

    public IOSWdaDeviceControl(IOSTarget iOSTarget) {
        this.f = iOSTarget;
        String string = iOSTarget.isSimulator() ? "" : Options.cached_OPT_IOS_AGENT_BUNDLE_ID;
        this.k = Misc.emptyOrNull((String)string) ? E : string;
        this.l = this.b() ? new File(Native.instance().getCacheDirectory(), "ios/ida") : G;
        this.p = new MJPEGStreamProcessor(this);
        EventLog.instance().addInfo("iOS Target", iOSTarget);
        EventLog.instance().addInfo("Device Agent", this);
        Client.instance().addOptionListener(this);
    }

    public void optionsChanged(OptionSet optionSet) {
        this.a(Options.cached_OPT_IOS_PRINT_AGENT_OUTPUT);
        this.s = Options.cached_OPT_IOS_VISUAL_SYNC;
        this.t = Options.cached_OPT_IOS_VISUAL_SYNC_LIMIT;
        this.u = Math.max(1, Options.cached_OPT_IOS_VISUAL_COMPARE_RESOLUTION);
        if (this.s) {
            this.restartScreenshotStream();
        } else {
            this.maybePauseScreenshotStream();
        }
    }

    private void a(int n2) {
        block6: {
            if (IOSWdaDeviceControl.A.level >= 7) {
                ((LevelAwareLogBuilder)A.lvlBuild(7, "setBuildOutputFlag(int)", 223).addDetail("buildOutputProperty", n2)).log();
            }
            if (n2 < 1) {
                return;
            }
            try {
                this.a = BuildOutput.values()[n2 - 1];
            }
            catch (Exception exception) {
                if (IOSWdaDeviceControl.A.level < 3) break block6;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "setBuildOutputFlag(int)", 228).add("Cannot set build output to: ")).add(n2)).log();
            }
        }
        if (this.a == BuildOutput.EXEC || this.a == BuildOutput.ALL) {
            IdbProcessClient.getIdbProcessListener().setStderrStream(System.out);
            IdbProcessClient.getIdbProcessListener().setStdoutStream(System.out);
        } else {
            IdbProcessClient.getIdbProcessListener().setStderrStream(null);
            IdbProcessClient.getIdbProcessListener().setStdoutStream(null);
        }
    }

    @Override
    public String getAgentRunnerBundleId() {
        return this.k + ".xctrunner";
    }

    private boolean b() {
        return !E.equals(this.k);
    }

    public void updateState() {
        this.a(true);
    }

    protected boolean a(boolean bl2) {
        if (IOSWdaDeviceControl.A.level >= 7) {
            ((LevelAwareLogBuilder)A.lvlBuild(7, "updateState(boolean)", 259).addDetail("warnOnError", bl2)).log();
        }
        try {
            JsonValue jsonValue = this.valueRequest("GET", "/status", null);
            JsonObject jsonObject = (JsonObject)jsonValue;
            this.g = jsonObject.getString("state", this.g);
            this.h = jsonObject.getString("message", this.h);
            this.i = jsonObject.getBoolean("ready", this.i);
            String string = de.qfs.apps.qftest.shared.h.a((JsonValue)jsonObject, (String)"sessionId", null);
            if (string != null) {
                if (!string.equals(this.e) && IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "updateState(boolean)", 273).add("Session ID changed!")).add("sessionId", string)).add("previousSessionId", string)).log();
                }
                this.e = string;
            }
            return true;
        }
        catch (Exception exception) {
            int n2;
            int n3 = n2 = bl2 ? 3 : 5;
            if (IOSWdaDeviceControl.A.level >= n3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(n3, "updateState(boolean)", 280).add("Could not update state: ")).add((Object)exception)).add("agentUrl", this.c)).log();
            }
            return false;
        }
    }

    @Override
    public void openSession(int n2) throws MobileDeviceStartResultException {
        if (IOSWdaDeviceControl.A.level >= 7) {
            ((LevelAwareLogBuilder)A.lvlBuild(7, "openSession(int)", 288).addDetail("retries", n2)).log();
        }
        JsonObject jsonObject = new JsonObject();
        JsonObject jsonObject2 = new JsonObject();
        jsonObject.add("capabilities", (JsonValue)jsonObject2);
        jsonObject2.add("alwaysMatch", Json.value((Object)DEFAULT_SESSION_CAPABILITIES));
        Exception exception = null;
        int n3 = n2;
        if (n3 > 0) {
            block14: {
                try {
                    int n4 = 0;
                    for (String string : this.b) {
                        if (IOSWdaDeviceControl.A.level >= 9) {
                            ((LevelAwareLogBuilder)A.lvlBuild(9, "openSession(int)", 300).add("agentUrlCandidate", string)).log();
                        }
                        this.c = string;
                        exception = null;
                        try {
                            JsonValue jsonValue = this.valueRequest("POST", "/session", (JsonValue)jsonObject, Math.max(0, Options.cached_OPT_IOS_IDA_CONNECTION_TIMEOUT), Math.max(0, Options.cached_OPT_IOS_IDA_REQUEST_TIMEOUT));
                            if (jsonValue instanceof JsonObject) {
                                JsonObject jsonObject3 = (JsonObject)jsonValue;
                                this.e = jsonObject3.getString("sessionId", null);
                            }
                            if (!this.isConnected()) {
                                this.a(false);
                            }
                            if (!this.isConnected() || this.e == null) continue;
                            if (n4 > 0) {
                                this.b.remove(string);
                                this.b.addFirst(string);
                            }
                            this.updateSessionSettings(Json.value((Object)DEFAULT_SESSION_SETTINGS).asObject());
                            System.out.println("Opened session " + this.e + " at " + this.c);
                            return;
                        }
                        catch (IOException iOException) {
                            if (exception == null) {
                                exception = iOException;
                            }
                            this.g = "pending";
                        }
                    }
                    boolean bl2 = n3 > 1;
                    int n5 = bl2 ? 5 : 3;
                    int n6 = n5;
                    if (IOSWdaDeviceControl.A.level >= n6) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(n6, "openSession(int)", 335).add("Could not create test session: ")).add((Object)exception)).log();
                    }
                }
                catch (Exception exception2) {
                    if (IOSWdaDeviceControl.A.level >= 3) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "openSession(int)", 337).add("Unexpected error connecting to agent: ")).add((Object)exception2)).log();
                    }
                    if (exception != null) break block14;
                    exception = exception2;
                }
            }
            throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.u, "Could not connect to " + this.c + (String)(exception == null ? "" : ": " + exception.getMessage()));
        }
    }

    @Override
    public JsonValue getCurrentSource(int n2, boolean bl2) throws IOException {
        if (IOSWdaDeviceControl.A.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(7, "getCurrentSource(int,boolean)", 355).addDetail("timeout", n2)).addDetail("useCache", bl2)).log();
        }
        BufferedImage bufferedImage = null;
        if (bl2 && this.s && this.w != null && this.e()) {
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "getCurrentSource(int,boolean)", 359).add("trying cached source")).log();
            }
            bufferedImage = this.getLatestScreenshot();
            int n3 = this.a(this.v, bufferedImage);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "getCurrentSource(int,boolean)", 362).add("similarity", n3)).add("visualSyncLimit", this.t)).log();
            }
            if (n3 > this.t) {
                if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)A.lvlBuild(9, "getCurrentSource(int,boolean)", 364).add("using cached source")).log();
                }
                EventLog.instance().a((Object)"IWDC.getCurrentSource()", (Object)("Reusing source snapshot from " + y.format(this.x)));
                return this.w;
            }
        }
        if (IOSWdaDeviceControl.A.level >= 9) {
            ((LevelAwareLogBuilder)A.lvlBuild(9, "getCurrentSource(int,boolean)", 369).add("Trigger real source fetch")).log();
        }
        EventLog.instance().a((Object)"IWDC.getCurrentSource()", (Object)"Requesting new source snapshot");
        int n4 = Options.cached_OPT_IOS_IDA_CONNECTION_TIMEOUT;
        int n5 = Math.max(0, n2 > 0 ? Math.max((int)((double)n2 * 0.1), n4) : n4);
        int n6 = n2 > 0 ? Math.max(0, n2 - n5) : Math.max(0, Options.cached_OPT_PLAY_TIMEOUT_DEADLOCK * 1000 - 100);
        JsonValue jsonValue = this.valueRequest("GET", this.g("/source/?format=json"), null, n5, n6);
        String string = IOSWdaDeviceControl.b(jsonValue);
        if (!Misc.emptyOrNull((String)string)) {
            if (IOSWdaDeviceControl.A.level >= 3) {
                ((LevelAwareLogBuilder)A.lvlBuild(3, "getCurrentSource(int,boolean)", 380).add("error", string)).log();
            }
            throw new IOException(string);
        }
        this.w = jsonValue;
        if (this.s && bufferedImage == null) {
            bufferedImage = this.getLatestScreenshot();
        }
        this.v = bufferedImage;
        this.x = new Date();
        return jsonValue;
    }

    private int a(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n2;
        block8: {
            n2 = 0;
            if (bufferedImage == null || bufferedImage2 == null) {
                return 0;
            }
            try {
                DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
                int n3 = dataBuffer.getSize();
                DataBuffer dataBuffer2 = bufferedImage2.getData().getDataBuffer();
                long l2 = 0L;
                if (bufferedImage.getWidth() == bufferedImage2.getWidth() && bufferedImage.getHeight() == bufferedImage2.getHeight()) {
                    for (int i2 = 0; i2 < n3 / this.u; ++i2) {
                        if (dataBuffer.getElem(i2 * this.u) != dataBuffer2.getElem(i2 * this.u)) continue;
                        ++l2;
                    }
                    if (IOSWdaDeviceControl.A.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "compareImages(BufferedImage,BufferedImage)", 410).add("sizeA", n3)).add("count", l2)).add("compareResolution", this.u)).log();
                    }
                    n2 = (int)(l2 * (long)this.u * 1000000000L / (long)n3);
                } else if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)A.lvlBuild(9, "compareImages(BufferedImage,BufferedImage)", 413).add("Images have different sizes.")).log();
                }
            }
            catch (Exception exception) {
                if (IOSWdaDeviceControl.A.level < 9) break block8;
                ((LevelAwareLogBuilder)A.lvlBuild(9, "compareImages(BufferedImage,BufferedImage)", 417).add("Could not compare images")).log();
            }
        }
        return n2;
    }

    @Override
    public void gesture(b b2) {
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("actions", (JsonValue)jsonArray);
        List list = b2.a();
        int n2 = 0;
        for (b.b b3 : list) {
            List list2 = b3.a();
            if (list2.isEmpty()) continue;
            JsonObject jsonObject2 = new JsonObject();
            jsonArray.add((JsonValue)jsonObject2);
            jsonObject2.add("type", "pointer");
            jsonObject2.add("id", "finger" + ++n2);
            JsonObject jsonObject3 = new JsonObject();
            jsonObject3.add("pointerType", "touch");
            jsonObject2.add("parameters", (JsonValue)jsonObject3);
            JsonArray jsonArray2 = new JsonArray();
            jsonObject2.add("actions", (JsonValue)jsonArray2);
            b.a a2 = null;
            int n3 = Math.round(b3.c() / (float)list2.size());
            int n4 = (int)b3.b();
            if (n4 > 0) {
                jsonArray2.add((JsonValue)this.b(n4));
            }
            for (b.a a3 : list2) {
                if (a2 == null) {
                    jsonArray2.add((JsonValue)this.a(a3.c(), a3.d(), 0));
                    jsonArray2.add((JsonValue)this.c());
                    if (Options.cached_OPT_IOS_GESTURE_START_DELAY > 0) {
                        this.b(Options.cached_OPT_IOS_GESTURE_START_DELAY);
                    }
                } else if (a3.equals(a2)) {
                    if (n3 > 0) {
                        jsonArray2.add((JsonValue)this.b(n3));
                    }
                } else {
                    jsonArray2.add((JsonValue)this.a(a3.c(), a3.d(), n3));
                }
                a2 = a3;
            }
            jsonArray2.add((JsonValue)this.d());
        }
        this.safeValueRequest("POST", this.g("/actions"), (JsonValue)jsonObject);
    }

    @Override
    public void multiTapGesture(int n2, int n3, int n4) {
        if (n4 < 1) {
            return;
        }
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        jsonObject.add("actions", (JsonValue)jsonArray);
        JsonObject jsonObject2 = new JsonObject();
        jsonArray.add((JsonValue)jsonObject2);
        jsonObject2.add("type", "pointer");
        jsonObject2.add("id", "finger");
        JsonObject jsonObject3 = new JsonObject();
        jsonObject3.add("pointerType", "touch");
        jsonObject2.add("parameters", (JsonValue)jsonObject3);
        JsonArray jsonArray2 = new JsonArray();
        jsonObject2.add("actions", (JsonValue)jsonArray2);
        jsonArray2.add((JsonValue)this.a(n2, n3, 0));
        for (int i2 = 0; i2 < n4; ++i2) {
            jsonArray2.add((JsonValue)this.c());
            jsonArray2.add((JsonValue)this.b(de.qfs.apps.qftest.client.mobile.c.f()));
            jsonArray2.add((JsonValue)this.d());
            jsonArray2.add((JsonValue)this.b(de.qfs.apps.qftest.client.mobile.c.f()));
        }
        this.safeValueRequest("POST", this.g("/actions"), (JsonValue)jsonObject);
    }

    private JsonObject b(int n2) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", "pause");
        jsonObject.add("duration", n2);
        return jsonObject;
    }

    private JsonObject a(int n2, int n3, int n4) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", "pointerMove");
        jsonObject.add("duration", n4);
        jsonObject.add("origin", "viewport");
        jsonObject.add("x", n2);
        jsonObject.add("y", n3);
        return jsonObject;
    }

    private JsonObject c() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", "pointerDown");
        jsonObject.add("button", 0);
        return jsonObject;
    }

    private JsonObject d() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", "pointerUp");
        jsonObject.add("button", 0);
        return jsonObject;
    }

    @Override
    public void type(char[] cArray) {
        if (Misc.emptyOrNull((Object)cArray)) {
            return;
        }
        if ("'".equals(Character.valueOf(cArray[0]))) {
            this.safeValueRequest("POST", this.g("/wda/keyboard/dismiss"), null);
        } else {
            Integer n2;
            String string = Options.getHighestSetOptionName((String[])new String[]{Options.OPT_PLAY_MULTIKEY_EVENT_DELAY_IOS, Options.OPT_PLAY_MULTIKEY_EVENT_DELAY});
            int n3 = Options.getInt((String)string);
            if (n3 <= 0) {
                n2 = null;
            } else {
                n3 = Math.min(n3, 1000);
                n2 = (int)Math.round(1000.0 / (double)n3);
            }
            int n4 = (int)Math.round(1000.0 / (double)(n2 == null ? 60 : n2) * (double)cArray.length * 1.25);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "type(char[])", 576).add("delay", n3)).add("frequency", (Object)n2)).add("additionalTimeout", n4)).log();
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("value", Json.value((Object)cArray));
            if (n2 != null) {
                jsonObject.add("frequency", n2.intValue());
            }
            this.safeValueRequest("POST", this.g("/wda/keys"), (JsonValue)jsonObject, n4);
        }
    }

    @Override
    public void pressButton(IOSDeviceControl.DeviceButton deviceButton) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", deviceButton.a);
        JsonValue jsonValue = this.performWdaAction("pressButton", (JsonValue)jsonObject);
        String string = IOSWdaDeviceControl.a(jsonValue);
        if (string != null) {
            throw new UnsupportedOperationException(string + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
    }

    @Override
    public void goToHomescreen() {
        JsonValue jsonValue = this.safeValueRequest("POST", "/wda/homescreen", null);
        String string = IOSWdaDeviceControl.a(jsonValue);
        if (string != null) {
            throw new UnsupportedOperationException(string + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
    }

    @Override
    public boolean verifyElement(IOSElement iOSElement) {
        JsonValue jsonValue;
        if (IOSWdaDeviceControl.A.level >= 7) {
            ((LevelAwareLogBuilder)A.lvlBuild(7, "verifyElement(IOSElement)", 612).addDetail("element", (Object)iOSElement)).log();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("using", "predicate string");
        String string = iOSElement.getUid();
        if (string == null) {
            return false;
        }
        jsonObject.add("value", "wdUID==\"" + string + "\"");
        JsonValue jsonValue2 = this.safeValueRequest("POST", this.g("/element"), (JsonValue)jsonObject);
        if (IOSWdaDeviceControl.A.level >= 9) {
            ((LevelAwareLogBuilder)A.lvlBuild(9, "verifyElement(IOSElement)", 622).add("result", (Object)jsonValue2)).log();
        }
        if ((jsonValue = de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue2, (Object)"ELEMENT")) == null || !jsonValue.isString()) {
            return false;
        }
        return string.equals(jsonValue.asString());
    }

    @Override
    public JsonValue getAttribute(IOSElement iOSElement, String string) {
        String string2 = string.startsWith("is") ? "wd" + string.substring(2) : string;
        return this.a(iOSElement, "GET", this.a(iOSElement, "/attribute/" + string2), null);
    }

    protected JsonValue a(IOSElement iOSElement, String string, String string2, JsonValue jsonValue) {
        JsonValue jsonValue2 = this.safeValueRequest(string, string2, jsonValue);
        String string3 = IOSWdaDeviceControl.a(jsonValue2);
        if (!Misc.emptyOrNull((String)string3) && "stale element reference".equals(string3) && this.verifyElement(iOSElement)) {
            jsonValue2 = this.safeValueRequest(string, string2, jsonValue);
            string3 = IOSWdaDeviceControl.a(jsonValue2);
        }
        if (!Misc.emptyOrNull((String)string3)) {
            throw new IllegalStateException(IOSWdaDeviceControl.b(jsonValue2));
        }
        return jsonValue2;
    }

    @Nullable
    private static String a(JsonValue jsonValue) {
        String string = null;
        if (jsonValue instanceof JsonObject) {
            string = ((JsonObject)jsonValue).getString("error", null);
        }
        return string;
    }

    @Nullable
    private static String b(JsonValue jsonValue) {
        Object object = null;
        if (jsonValue instanceof JsonObject) {
            object = ((JsonObject)jsonValue).getString("error", null);
            String string = ((JsonObject)jsonValue).getString("message", null);
            if (!Misc.emptyOrNull((String)string)) {
                object = (String)object + "\n\n" + string;
            }
        }
        return object;
    }

    public JsonValue performRawAction(String string, JsonValue jsonValue) {
        return this.safeValueRequest("POST", this.g("/" + string), jsonValue);
    }

    public JsonValue performWdaAction(String string, JsonValue jsonValue) {
        return this.safeValueRequest("POST", this.g("/wda/" + string), jsonValue);
    }

    public JsonValue performRawAction(IOSElement iOSElement, String string, JsonValue jsonValue) {
        return this.a(iOSElement, "POST", this.a(iOSElement, "/" + string), jsonValue);
    }

    public JsonValue performWdaAction(IOSElement iOSElement, String string, JsonValue jsonValue) {
        return this.a(iOSElement, "POST", this.b(iOSElement, "/" + string), jsonValue);
    }

    JsonValue a() {
        try {
            JsonValue jsonValue = this.safeValueRequest("GET", this.g("/wda/screen"), null);
            String string = IOSWdaDeviceControl.b(jsonValue);
            if (!Misc.emptyOrNull((String)string)) {
                if (IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "getScreenInfo()", 697).add("error", string)).log();
                }
                return null;
            }
            return jsonValue;
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getScreenInfo()", 702).add("Could not get screen info", (Object)exception)).add("target", (Object)this.f)).log();
            }
            return null;
        }
    }

    @Override
    public IOSDeviceInfo getDeviceInfo() {
        try {
            JsonValue jsonValue = this.safeValueRequest("GET", "/wda/device/info", null);
            String string = IOSWdaDeviceControl.b(jsonValue);
            if (!Misc.emptyOrNull((String)string)) {
                if (IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "getDeviceInfo()", 714).add("error", string)).log();
                }
                return null;
            }
            IOSDeviceInfo iOSDeviceInfo = IOSDeviceInfo.fromJson(jsonValue);
            iOSDeviceInfo.addScreenInfo(this.a());
            return iOSDeviceInfo;
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getDeviceInfo()", 721).add("Could not get device info", (Object)exception)).add("target", (Object)this.f)).log();
            }
            return null;
        }
    }

    @Override
    public IOSApp getActiveAppInfo() {
        try {
            JsonValue jsonValue = this.safeValueRequest("GET", "/wda/activeAppInfo", null);
            String string = IOSWdaDeviceControl.b(jsonValue);
            if (!Misc.emptyOrNull((String)string)) {
                if (IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "getActiveAppInfo()", 733).add("error", string)).log();
                }
                return null;
            }
            IOSApp iOSApp = IOSApp.fromJson((JsonValue)jsonValue);
            return iOSApp;
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getActiveAppInfo()", 739).add("Could not get app info", (Object)exception)).add("target", (Object)this.f)).log();
            }
            return null;
        }
    }

    @Override
    public IOSDeviceRotation getDeviceRotation() {
        try {
            JsonValue jsonValue = this.safeValueRequest("GET", "/rotation", null);
            String string = IOSWdaDeviceControl.b(jsonValue);
            if (!Misc.emptyOrNull((String)string)) {
                if (IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "getDeviceRotation()", 751).add("error", string)).log();
                }
                return null;
            }
            return IOSDeviceRotation.fromJson(jsonValue);
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getDeviceRotation()", 756).add("Could not get device info", (Object)exception)).add("target", (Object)this.f)).log();
            }
            return null;
        }
    }

    @Override
    public void setDeviceRotation(IOSDeviceRotation iOSDeviceRotation) throws TestException {
        if (iOSDeviceRotation == null) {
            return;
        }
        JsonValue jsonValue = this.safeValueRequest("POST", "/rotation", iOSDeviceRotation.asJsonValue());
        String string = IOSWdaDeviceControl.b(jsonValue);
        if (!Misc.emptyOrNull((String)string)) {
            if (IOSWdaDeviceControl.A.level >= 3) {
                ((LevelAwareLogBuilder)A.lvlBuild(3, "setDeviceRotation(IOSDeviceRotation)", 769).add("error", string)).log();
            }
            throw new TestException(string);
        }
    }

    @Override
    @Nullable
    public ImageRep grabScreenshot() {
        BufferedImage bufferedImage;
        String string;
        ImageRep imageRep;
        block5: {
            imageRep = null;
            string = this.f.getName();
            if (this.e()) {
                try {
                    bufferedImage = this.getLatestScreenshot();
                    if (bufferedImage instanceof BufferedImage) {
                        BufferedImage bufferedImage2 = bufferedImage;
                        imageRep = new ImageRep(string, bufferedImage2);
                    }
                }
                catch (Exception exception) {
                    if (IOSWdaDeviceControl.A.level < 3) break block5;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "grabScreenshot()", 792).add("Could not use stream image: ")).add((Object)exception)).log();
                }
            }
        }
        if (imageRep == null) {
            bufferedImage = this.safeValueRequest("GET", "/screenshot", null);
            imageRep = this.a(string, (JsonValue)bufferedImage);
            this.a(imageRep);
        }
        return imageRep;
    }

    private boolean e() {
        return System.currentTimeMillis() - this.S < 500L;
    }

    @Override
    public ImageRep grabScreenshot(IOSElement iOSElement) {
        JsonValue jsonValue = this.a(iOSElement, "GET", this.a(iOSElement, "/screenshot"), null);
        String string = this.f.getName() + "(" + iOSElement.toString() + ")";
        ImageRep imageRep = this.a(string, jsonValue);
        return imageRep;
    }

    @Override
    public void storeLastScreenshot(byte[] byArray) {
        this.S = System.currentTimeMillis();
        this.a(byArray);
    }

    private void a(Object object) {
        this.q.set(object);
        ScreenshotSupplier.Observer observer = (ScreenshotSupplier.Observer)this.r.get();
        if (observer != null) {
            observer.screenshotAvailable(this);
        }
    }

    @Override
    @Nullable
    public BufferedImage getLatestScreenshot() {
        Object v2 = this.q.get();
        if (v2 instanceof byte[]) {
            byte[] byArray = (byte[])v2;
            try {
                return JpegUtil.getImageFromBytes(byArray);
            }
            catch (IOException iOException) {
                if (IOSWdaDeviceControl.A.level >= 5) {
                    ((LevelAwareLogBuilder)A.lvlBuild(5, "getLatestScreenshot()", 843).add("e", (Object)iOException)).log();
                }
            }
        } else if (v2 instanceof ImageRep) {
            ImageRep imageRep = (ImageRep)v2;
            return imageRep.asBufferedImage();
        }
        return null;
    }

    @Override
    public boolean subscribeScreenshotStream(ScreenshotSupplier.Observer observer) {
        if (this.r.get() == null) {
            this.r = new WeakReference<ScreenshotSupplier.Observer>(observer);
        }
        this.restartScreenshotStream();
        return this.r.get() == observer;
    }

    @Override
    public void unsubscribeScreenshotStream(ScreenshotSupplier.Observer observer) {
        this.r = new WeakReference<Object>(null);
        this.maybePauseScreenshotStream();
    }

    @Override
    public boolean isSubscribedToScreenshotStream(ScreenshotSupplier.Observer observer) {
        return this.r.get() == observer;
    }

    @Override
    public void restartScreenshotStream() {
        if (this.isConnected() && (this.s || this.r.get() != null)) {
            this.p.start();
        }
    }

    public void maybePauseScreenshotStream() {
        if (!this.s && this.r.get() == null) {
            this.p.pause();
        }
    }

    @Override
    public void pauseScreenshotStream() {
        this.p.pause();
    }

    @Override
    public URL getScreenVideoStreamUrl() {
        String string = this.c;
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        int n2 = string.lastIndexOf(58);
        if (n2 > -1) {
            string = string.substring(0, n2);
        }
        try {
            return new URL(string + ":" + this.P);
        }
        catch (MalformedURLException malformedURLException) {
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getScreenVideoStreamUrl()", 909).add("Could not build video stream url: ")).add((Object)malformedURLException)).log();
            }
            return null;
        }
    }

    private ImageRep a(String string, JsonValue jsonValue) {
        if (jsonValue == null || !jsonValue.isString()) {
            return null;
        }
        InputStream inputStream = Base64.getDecoder().wrap(new StringBufferInputStream(jsonValue.asString()));
        ImageRep imageRep = BaseImageHandler.instance().getHelper().pngDecode(inputStream);
        if (imageRep != null) {
            imageRep.setName(string);
        }
        return imageRep;
    }

    @Override
    public void prepareInstrumentation() throws MobileDeviceStartResultException {
        Object object;
        Object object2;
        Iterable iterable;
        if (IOSWdaDeviceControl.A.level >= 7) {
            A.lvlBuild(7, "prepareInstrumentation()", 933).log();
        }
        AgentBuildProcessListener agentBuildProcessListener = new AgentBuildProcessListener(this);
        if (this.b()) {
            try {
                ProcessManager.runProcess((String[])new String[]{"/usr/bin/rsync", "-a", "--inplace", "--delete", G.getAbsolutePath(), this.l.getParentFile().getAbsolutePath()}, (int)Options.cached_OPT_XCODE_BUILD_TIMEOUT, (ProcessListener)agentBuildProcessListener);
                iterable = new File(this.l, "iDeviceAgent.xcodeproj/project.pbxproj").toPath();
                object2 = Files.lines((Path)iterable, StandardCharsets.UTF_8);
                try {
                    object = object2.map(string -> string.replace(E, this.k)).collect(Collectors.toList());
                    Files.write((Path)iterable, (Iterable<? extends CharSequence>)object, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.o, "Could not prepare instrumentation (Code " + runProcessException.getExitCode() + "):\n" + runProcessException.getOutput());
            }
            catch (IOException iOException) {
                throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.o, "Could not patch agent code: " + String.valueOf(iOException));
            }
        }
        iterable = this.d("build-for-testing");
        object2 = Options.cached_OPT_XCODE_DEVELOPMENT_TEAM;
        if (this.f.isDevice()) {
            if (Misc.emptyOrNull((String)object2)) {
                throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.o, "To test applications on real devices, please specify your developer team (Option OPT_XCODE_DEVELOPMENT_TEAM).\n\n  The Team ID is a unique 10-character string generated by Apple that is assigned to your team.\n  You can find your Team ID using your developer account.\n  Sign in to https://developer.apple.com/account, and scroll to the Membership details.\n  Your Team ID appears in the Membership Information section under the team name.\n  You can also find your team ID listed under the \"Organizational Unit\" field\n  in your iPhone Developer certificate in your keychain.");
            }
            object = Options.cached_OPT_XCODE_CODE_SIGN_IDENTITY;
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "prepareInstrumentation()", 980).add("teamId", (String)object2)).add("signIdentity", (String)object)).log();
            }
            if (Options.cached_OPT_XCODE_ALLOW_PROVISIONING_UPDATES) {
                iterable.add("-allowProvisioningUpdates");
            }
            if (Options.cached_OPT_XCODE_ALLOW_PROVISIONING_DEVICE_REGISTRATION) {
                iterable.add("-allowProvisioningDeviceRegistration");
            }
            iterable.add("DEVELOPMENT_TEAM=" + (String)object2);
            if (!Misc.emptyOrNull((String)object)) {
                iterable.add("CODE_SIGN_IDENTITY=" + (String)object);
            }
            iterable.add("CODE_SIGNING_REQUIRED=YES");
        }
        System.out.print("Building instrumentation ...");
        try {
            boolean bl2 = Options.cached_OPT_IOS_BRAND_AGENT;
            if (bl2) {
                this.a((ProcessListener)agentBuildProcessListener);
            }
            String string2 = ProcessManager.runProcess((String[])iterable.toArray(new String[iterable.size()]), (int)Options.cached_OPT_XCODE_BUILD_TIMEOUT, (ProcessListener)agentBuildProcessListener);
            if (bl2) {
                this.a(string2, agentBuildProcessListener);
            }
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.o, "Could not build instrumentation (Code " + runProcessException.getExitCode() + "):\n" + runProcessException.getOutput());
        }
        System.out.println();
    }

    private void a(String string, AgentBuildProcessListener agentBuildProcessListener) {
        File file = IOSWdaDeviceControl.b(string);
        String string2 = IOSWdaDeviceControl.c(string);
        boolean bl2 = this.f.isSimulator();
        if (file != null && (bl2 || string2 != null)) {
            if (!this.a(file, string2, !bl2, (ProcessListener)agentBuildProcessListener)) {
                ++this.m;
            }
        } else if (!bl2) {
            ++this.m;
            System.out.println("\nWarning: Could not sign device agent, test execution might fail.");
        }
    }

    private void a(ProcessListener processListener) throws ProcessManager.RunProcessException {
        block3: {
            File file;
            if (!this.f.isSimulator() && (file = new File(this.f() + "/Build/Products/Debug-iphoneos/iDeviceAgent-Runner.app")).exists()) {
                try {
                    ProcessManager.runProcess((String[])new String[]{IOSUtil.getCodesignPath(), "--remove-signature", file.getAbsolutePath()}, (int)0, (ProcessListener)processListener);
                }
                catch (ProcessManager.RunProcessException runProcessException) {
                    if (IOSWdaDeviceControl.A.level < 3) break block3;
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "maybeRemoveAgentSigning(ProcessListener)", 1040).add("Could not remove signature")).log();
                }
            }
        }
    }

    @Nullable
    private static File b(String string) {
        int n2 = string.lastIndexOf("/iDeviceAgent-Runner.app");
        int n3 = n2 + F.length() + 1;
        if (n2 > -1) {
            do {
                n2 = Math.max(string.lastIndexOf(" /", n2), string.lastIndexOf("\n/", n2));
                String string2 = string.substring(n2 + 1, n3);
                File file = new File(string2 = string2.replace("\\ ", " ").replace("\\\\", "\\\\"));
                if (!file.exists()) continue;
                return file;
            } while (n2 > -1);
        }
        return null;
    }

    @Nullable
    private static String c(String string) {
        int n2 = string.lastIndexOf("codesign");
        if (n2 > -1 && (n2 = string.indexOf("/iDeviceAgent-Runner.app", n2)) > -1) {
            int n3 = n2 + F.length() + 1;
            if ((n2 = string.lastIndexOf("\n", n2)) > -1) {
                return IOSWdaDeviceControl.a(string.substring(n2, n3).trim());
            }
        }
        return null;
    }

    static String a(String object) {
        if (((String)object).indexOf(92) == -1) {
            return object;
        }
        int n2 = ((String)object).indexOf("\\ ");
        if (n2 > 0) {
            n2 = ((String)object).lastIndexOf(" ", n2);
            int n3 = n2 + 1;
            int n4 = ((String)object).indexOf(" ", n3);
            while (n4 > n3 && n4 < ((String)object).length() - 1 && ((String)object).charAt(n4 - 1) == '\\') {
                n4 = ((String)object).indexOf(" ", n4 + 1);
            }
            if (n4 == -1) {
                n4 = ((String)object).length();
            }
            String string = "~~SPACE-MARKER" + new Random().nextInt() + "~~";
            object = ((String)object).substring(0, n3) + "\"" + ((String)object).substring(n3, n4).replace("\\ ", string) + "\"" + ((String)object).substring(n4);
            return IOSWdaDeviceControl.a((String)object).replace(string, " ");
        }
        String string = "~~BACKSLASH-MARKER" + new Random().nextInt() + "~~";
        object = ((String)object).replace("\\\\", string).replace("\\", "").replace(string, "\\");
        return object;
    }

    private boolean a(File file, String string, boolean bl2, ProcessListener processListener) {
        block15: {
            File file2;
            if (IOSWdaDeviceControl.A.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(7, "patchAgent(File,String,boolean,ProcessListener)", 1105).addDetail("appFile", (Object)file)).addDetail("codesignCommand", string)).addDetail("force", bl2)).addDetail("processListener", (Object)processListener)).log();
            }
            if ((file2 = new File(file, "Info.plist")).exists()) {
                Map map = PListAccess.instance().getContent(file2);
                if (map == null || map.isEmpty()) {
                    if (IOSWdaDeviceControl.A.level >= 3) {
                        ((LevelAwareLogBuilder)A.lvlBuild(3, "patchAgent(File,String,boolean,ProcessListener)", 1110).add("Error reading info content")).log();
                    }
                    return false;
                }
                String string2 = Globals.getResources().getExtendedString("ios.device.agent.name", null, "QF-Test Agent");
                if (string2.equals(map.get("CFBundleName")) && !bl2) {
                    if (IOSWdaDeviceControl.A.level >= 9) {
                        ((LevelAwareLogBuilder)A.lvlBuild(9, "patchAgent(File,String,boolean,ProcessListener)", 1116).add("Already patched")).log();
                    }
                    return false;
                }
                if (map != null) {
                    map.put("CFBundleName", string2);
                }
                try {
                    LinkedList<String> linkedList = new LinkedList<String>();
                    for (String string3 : L) {
                        File file3 = new File(String.valueOf(this.l) + K, string3);
                        if (!file3.exists()) continue;
                        try {
                            de.qfs.lib.util.Files.copyFile((File)file3, (File)new File(file, string3));
                            linkedList.add(string3.substring(0, Math.min(string3.indexOf("."), string3.indexOf("@"))));
                        }
                        catch (Exception exception) {
                            if (IOSWdaDeviceControl.A.level < 3) continue;
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "patchAgent(File,String,boolean,ProcessListener)", 1133).add("Could not copy icons: ")).add((Object)exception)).log();
                        }
                    }
                    if (!linkedList.isEmpty()) {
                        Map map2 = Misc.mapOf((Object[])new Object[]{"CFBundlePrimaryIcon", Misc.mapOf((Object[])new Object[]{"CFBundleIconFiles", linkedList, "CFBundleIconName", "AppIcon"})});
                        map.put("CFBundleIcons", map2);
                        map.put("CFBundleIcons~ipad", map2);
                    }
                    PListAccess.instance().setXmlContent(map, file2);
                    if (Misc.emptyOrNull((String)string)) {
                        IOSUtil.adhocSignApp((File)file, (ProcessListener)processListener);
                    } else {
                        ProcessManager.runProcess((String)string, (int)Options.cached_OPT_XCODE_BUILD_TIMEOUT, (ProcessListener)processListener);
                    }
                    return true;
                }
                catch (Exception exception) {
                    if (IOSWdaDeviceControl.A.level < 1) break block15;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "patchAgent(File,String,boolean,ProcessListener)", 1152).add("Could not patch device agent: ")).add((Object)exception)).log();
                }
            }
        }
        return false;
    }

    private List d(String string) {
        List list = Misc.fillList(new ArrayList(), (Object[])new String[]{IOSUtil.getXcodebuildPath(), string, "-project", new File(this.l, H).getAbsolutePath(), "-scheme", "WebDriverAgentRunner", "-destination", "id=" + this.f.getUdid(), "-derivedDataPath", this.f(), "IPHONEOS_DEPLOYMENT_TARGET=" + String.valueOf(this.f.getOsVersion()), "GCC_TREAT_WARNINGS_AS_ERRORS=0", "COMPILER_INDEX_STORE_ENABLE=NO"});
        if (IOSWdaDeviceControl.A.level >= 9) {
            ((LevelAwareLogBuilder)A.lvlBuild(9, "getBuildCommand(String)", 1172).add("command", (Object)list)).log();
        }
        return list;
    }

    private String f() {
        String string = Options.cached_OPT_XCODE_BUILD_DIRECTORY;
        String string2 = Util.getCacheDir() + "/ios/ida-build" + (this.f.isSimulator() ? "-sim" : "-device");
        if (string != null) {
            File file = new File(string);
            if (file.isDirectory() || file.mkdirs()) {
                return string;
            }
            if (IOSWdaDeviceControl.A.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(1, "getBuildDir()", 1185).add("Cannot use build dir ")).add(string)).add(", falling back to ")).add(string2)).log();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instrumentDevice() throws MobileDeviceStartResultException {
        if (IOSWdaDeviceControl.A.level >= 7) {
            A.lvlBuild(7, "instrumentDevice()", 1192).log();
        }
        System.out.print("Starting test environment on " + this.f.getName() + " ...");
        this.R = new AgentBuildProcessListener(this);
        List list = this.d("test-without-building");
        int n2 = this.a(list);
        try {
            this.d = false;
            this.Q = ProcessManager.startProcess((String[])list.toArray(new String[list.size()]), (ProcessListener)this.R);
            Iterator iterator = this.b;
            synchronized (iterator) {
                while (this.b.isEmpty() && !this.d) {
                    this.b.wait(Options.cached_OPT_XCODE_BUILD_TIMEOUT);
                }
            }
            this.R.b = false;
            System.out.println();
            if (this.d) {
                Object object;
                block19: {
                    iterator = "?";
                    object = "?";
                    try {
                        String string = this.Q.getProcessOutputString();
                        Util.logSutMessage((String)("Instrumentation output:\n" + string));
                        iterator = IOSWdaDeviceControl.e(string);
                        this.Q.waitFor(1000L);
                        object = "" + this.Q.getExitCode();
                        if (string != null && string.contains("Failed to install or launch the test runner")) {
                            throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.v, "Could not start test (Code " + (String)object + "):\nFailed to install or launch the test runner.");
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (IOSWdaDeviceControl.A.level < 9) break block19;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "instrumentDevice()", 1226).add("Process not terminated: ")).add((Object)illegalStateException)).log();
                    }
                }
                throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.u, "Could not start test (Code " + (String)object + "):\n" + (String)((Object)iterator));
            }
            this.m = 0;
            this.P = n2;
            System.out.println("Device Agent available at " + String.valueOf(this.b));
            this.R.c = true;
            if (this.j != null) {
                this.j.run();
            }
            iterator = this.b.iterator();
            while (iterator.hasNext()) {
                String string;
                this.c = string = (String)iterator.next();
                boolean bl2 = this.a(!iterator.hasNext());
                if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "instrumentDevice()", 1249).add("success", bl2)).add("urlCandidate", string)).log();
                }
                if (!bl2 || !this.isConnected()) continue;
                this.b.remove(string);
                this.b.addFirst(string);
                System.out.println("Connected to " + this.c);
                this.restartScreenshotStream();
                break;
            }
        }
        catch (MobileDeviceStartResultException mobileDeviceStartResultException) {
            throw mobileDeviceStartResultException;
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 3) {
                ((LevelAwareLogBuilder)A.lvlBuild(3, "instrumentDevice()", 1264).add("ex", (Object)exception)).log();
            }
            throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.u, "Could not start test environment");
        }
        finally {
            this.R.b = false;
        }
    }

    private static String e(String object) {
        if (object == null) {
            return "No detailed information available";
        }
        object = IOSWdaDeviceControl.a((String)object, "its profile has not been explicitly trusted by the user.", " To do so, open the 'Settings' app and navigate to 'General' -> 'VPN & Device Management' (or 'Profiles') -> and trust the corresponding developer certificate.");
        object = IOSWdaDeviceControl.a((String)object, I);
        if (((String)(object = IOSWdaDeviceControl.a((String)object, J))).contains("could not bind to session, launchd_sim may have crashed")) {
            object = (String)object + "\n\nIf the simulator crashes, it might help to clean the CoreSimulator cache by removing all data\nfrom %s.\n\nAlso ensure that your /tmp directory has the correct access right by executing\n\n      sudo chmod 1777 /tmp\n\nFinally, it might help to start the Simulator app directly and launch the simulated device once from there.\n".formatted(String.valueOf(((MacOSNative)Native.instance()).getDirectoryFromUserSearchPath(5, false)) + "/Developer/CoreSimulator/Caches");
        } else if (((String)object).contains("Timed out waiting for all destinations matching the provided destination specifier to become available")) {
            object = (String)object + "\n\nMake sure that the Developer Mode has been enabled on the device. To enable it, open the 'Settings' app and navigate to 'Privacy & Security' -> 'Developer Mode'.\n";
        }
        return object;
    }

    private static String a(String string, String string2, String string3) {
        if (string.contains(string2)) {
            string = string.replaceAll(string2, string2 + string3);
        }
        return string;
    }

    private static String a(String string, String string2) {
        if (string.contains(string2)) {
            int n2 = string.lastIndexOf(string2);
            if ((n2 = IOSWdaDeviceControl.f(string = string.substring(n2 + string2.length()).trim())) > -1) {
                string = string.substring(0, n2);
            }
        }
        return string;
    }

    private static int f(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '(') {
                ++n2;
            } else if (cArray[i2] == ')') {
                --n2;
            }
            if (n2 >= 0) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean shouldTryAgentRebuild() {
        return this.m == 1;
    }

    @Override
    public void cleanAgentBuildDir() throws MobileDeviceStartResultException {
        File file = new File(this.f());
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)file);
        }
        catch (IOException iOException) {
            if (IOSWdaDeviceControl.A.level >= 3) {
                ((LevelAwareLogBuilder)A.lvlBuild(3, "cleanAgentBuildDir()", 1352).add("ex", (Object)iOException)).log();
            }
            throw new MobileDeviceStartResultException(de.qfs.apps.qftest.shared.b.a.o, "Could clean agent build directory:\n" + iOException.getMessage());
        }
    }

    private int a(List list) {
        int n2;
        int n3 = Options.cached_OPT_IOS_AGENT_PORT;
        if (n3 != 0) {
            list.add("USE_PORT=" + n3);
        }
        if ((n2 = Options.cached_OPT_IOS_VIDEO_STREAM_PORT) == 0) {
            int n4 = n2 = this.f.isSimulator() ? Misc.getFreeTcpPort() : 9100;
        }
        if (n2 != 0) {
            list.add("MJPEG_SERVER_PORT=" + n2);
        }
        if (IOSWdaDeviceControl.A.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "selectConnectionPorts(List<String>)", 1376).add("agentPort", n3)).add("videoStreamPort", n2)).log();
        }
        return n2;
    }

    @Override
    public void disconnect() {
        block6: {
            if (IOSWdaDeviceControl.A.level >= 7) {
                A.lvlBuild(7, "disconnect()", 1383).log();
            }
            this.pauseScreenshotStream();
            if (this.Q != null) {
                try {
                    this.Q.terminateProcess(0);
                }
                catch (IllegalStateException illegalStateException) {
                    if (IOSWdaDeviceControl.A.level >= 9) {
                        ((LevelAwareLogBuilder)A.lvlBuild(9, "disconnect()", 1389).add("ex", (Object)illegalStateException)).log();
                    }
                }
                catch (Exception exception) {
                    if (IOSWdaDeviceControl.A.level < 1) break block6;
                    ((LevelAwareLogBuilder)A.lvlBuild(1, "disconnect()", 1391).add("Error terminating test process", (Object)exception)).log();
                }
            }
        }
        this.Q = null;
        this.c = null;
        this.b.clear();
        this.g = "disconnected";
        this.n = null;
        this.d = false;
    }

    @Override
    public boolean isConnected() {
        return "success".equals(this.g);
    }

    @Override
    public JsonObject updateSessionSettings(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("modifiedSettings is marked non-null but is null");
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("settings", Json.value((Object)jsonObject));
        try {
            JsonValue jsonValue = this.valueRequest("POST", this.g("/appium/settings"), (JsonValue)jsonObject2, Math.max(0, Options.cached_OPT_IOS_IDA_CONNECTION_TIMEOUT), Math.max(0, Options.cached_OPT_IOS_IDA_REQUEST_TIMEOUT));
            String string = IOSWdaDeviceControl.b(jsonValue);
            if (!Misc.emptyOrNull((String)string)) {
                if (IOSWdaDeviceControl.A.level >= 3) {
                    ((LevelAwareLogBuilder)A.lvlBuild(3, "updateSessionSettings(JsonObject)", 1418).add("error", string)).log();
                }
                throw new UnsupportedOperationException(string);
            }
            if (jsonValue instanceof JsonObject) {
                this.o = (JsonObject)jsonValue;
            }
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not update settings", exception);
        }
        return this.o;
    }

    @Override
    public boolean isLocked() {
        JsonValue jsonValue = this.safeValueRequest("GET", "/wda/locked", null);
        String string = IOSWdaDeviceControl.a(jsonValue);
        if (string != null) {
            throw new UnsupportedOperationException(string + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        return false;
    }

    @Override
    public IOSWdaDeviceControl setLocked(boolean bl2) {
        JsonValue jsonValue = this.safeValueRequest("POST", "/wda/" + (bl2 ? "lock" : "unlock"), null);
        String string = IOSWdaDeviceControl.a(jsonValue);
        if (string != null) {
            throw new UnsupportedOperationException(string + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
        return this;
    }

    @Override
    public boolean clear(IOSElement iOSElement) {
        try {
            JsonValue jsonValue = this.a(iOSElement, "POST", this.a(iOSElement, "/clear"), null);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "clear(IOSElement)", 1460).add("response", (Object)jsonValue)).log();
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (IOSWdaDeviceControl.A.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(5, "clear(IOSElement)", 1462).add("Could not clear element: ")).add((Object)illegalStateException)).log();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean scroll(IOSDeviceControl.ScrollDirection scrollDirection, double d2) {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.set("direction", scrollDirection.toString().toLowerCase());
            jsonObject.set("distance", d2);
            JsonValue jsonValue = this.safeValueRequest("POST", "/wda/scroll", (JsonValue)jsonObject);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "scroll(ScrollDirection,double)", 1475).add("response", (Object)jsonValue)).log();
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (IOSWdaDeviceControl.A.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(5, "scroll(ScrollDirection,double)", 1477).add("Could not scroll: ")).add((Object)illegalStateException)).log();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean scrollIntoView(IOSElement iOSElement) {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.set("toVisible", true);
            JsonValue jsonValue = this.a(iOSElement, "POST", this.b(iOSElement, "/scroll"), (JsonValue)jsonObject);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "scrollIntoView(IOSElement)", 1489).add("response", (Object)jsonValue)).log();
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (IOSWdaDeviceControl.A.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(5, "scrollIntoView(IOSElement)", 1491).add("Could not scroll element: ")).add((Object)illegalStateException)).log();
            }
            return false;
        }
        return true;
    }

    @Override
    public void setClipboard(String string, String string2) {
        JsonValue jsonValue;
        String string3;
        if (string == null) {
            return;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("content", string);
        if (!Misc.emptyOrNull((String)string2)) {
            jsonObject.add("contentType", string2);
        }
        if (!Misc.emptyOrNull((String)(string3 = IOSWdaDeviceControl.b(jsonValue = this.safeValueRequest("POST", "/wda/setPasteboard", (JsonValue)jsonObject))))) {
            if (IOSWdaDeviceControl.A.level >= 3) {
                ((LevelAwareLogBuilder)A.lvlBuild(3, "setClipboard(String,String)", 1520).add("error", string3)).log();
            }
            throw new UnsupportedOperationException(string3 + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
    }

    @Override
    public String getClipboard(String string) {
        JsonValue jsonValue;
        String string2;
        JsonObject jsonObject = new JsonObject();
        if (!Misc.emptyOrNull((String)string)) {
            jsonObject.add("contentType", string);
        }
        if ((string2 = IOSWdaDeviceControl.a(jsonValue = this.safeValueRequest("POST", "/wda/getPasteboard", (JsonValue)jsonObject))) != null) {
            throw new UnsupportedOperationException(string2 + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        return null;
    }

    @Override
    public int launchApp(String string, Collection collection, Map map) throws IOException {
        JsonValue jsonValue;
        String string2;
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("bundleId", string);
        if (!Misc.emptyOrNull((Collection)collection)) {
            jsonObject.add("arguments", Json.value((Object)collection));
        }
        if (!Misc.emptyOrNull((Map)map)) {
            jsonObject.add("environment", Json.value((Object)map));
        }
        if ((string2 = de.qfs.apps.qftest.shared.h.a((JsonValue)(jsonValue = this.performWdaAction("apps/launch", (JsonValue)jsonObject)), (String)"error", null)) != null) {
            throw new IOException(string2 + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
        IOSApp iOSApp = this.getActiveAppInfo();
        if (iOSApp == null || !string.equals(iOSApp.getBundleId())) {
            Misc.safeSleep((long)500L);
            iOSApp = this.getActiveAppInfo();
            if (iOSApp != null && !string.equals(iOSApp.getBundleId())) {
                throw new IOException("Could not start " + string + ", active app: " + iOSApp.getBundleId());
            }
        }
        return iOSApp == null ? 0 : iOSApp.getPid();
    }

    @Override
    public void stopApp(String string) throws IOException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("bundleId", string);
        JsonValue jsonValue = this.performWdaAction("apps/terminate", (JsonValue)jsonObject);
        String string2 = de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"error", null);
        if (string2 != null) {
            throw new IOException(string2 + ":\n\n" + de.qfs.apps.qftest.shared.h.a((JsonValue)jsonValue, (String)"message", (String)""));
        }
    }

    public JsonValue safeValueRequest(String string, String string2, JsonValue jsonValue) {
        return this.safeValueRequest(string, string2, jsonValue, 0);
    }

    public JsonValue safeValueRequest(String string, String string2, JsonValue jsonValue, int n2) {
        return this.safeValueRequest(string, string2, jsonValue, Math.max(0, Options.cached_OPT_IOS_IDA_CONNECTION_TIMEOUT), Math.max(0, Options.cached_OPT_IOS_IDA_REQUEST_TIMEOUT + n2));
    }

    public JsonValue safeValueRequest(String string, String string2, JsonValue jsonValue, int n2, int n3) {
        try {
            return this.valueRequest(string, string2, jsonValue, n2, n3);
        }
        catch (Exception exception) {
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "safeValueRequest(String,String,JsonValue,int,int)", 1609).add("Could not request " + string + " " + string2, (Object)exception)).log();
            }
            return null;
        }
    }

    public JsonValue valueRequest(String string, String string2, JsonValue jsonValue) throws IOException {
        return this.valueRequest(string, string2, jsonValue, Math.max(0, Options.cached_OPT_IOS_IDA_CONNECTION_TIMEOUT), Math.max(0, Options.cached_OPT_IOS_IDA_REQUEST_TIMEOUT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JsonValue valueRequest(String string, String string2, JsonValue jsonValue, int n2, int n3) throws IOException {
        try {
            String string3;
            de.qfs.apps.qftest.shared.m.a().a(B);
            if (IOSWdaDeviceControl.A.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(7, "valueRequest(String,String,JsonValue,int,int)", 1622).addDetail("method", string)).addDetail("route", string2)).addDetail("postArgs", (Object)jsonValue)).addDetail("connectTimeout", n2)).addDetail("readTimeout", n3)).log();
            }
            if ((string3 = this.c) == null) {
                throw new IOException("Not connected");
            }
            IOSWDAInvocation iOSWDAInvocation2 = (IOSWDAInvocation)this.z.a((T iOSWDAInvocation) -> {
                iOSWDAInvocation.a = string;
                iOSWDAInvocation.b = string2;
                iOSWDAInvocation.c = jsonValue;
                iOSWDAInvocation.e = Thread.currentThread();
                iOSWDAInvocation.d = null;
            });
            URL uRL = new URL(string3 + string2);
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)A.lvlBuild(9, "valueRequest(String,String,JsonValue,int,int)", 1638).add("url", (Object)uRL)).log();
            }
            int n4 = Math.max(200, Options.cached_OPT_PLAY_TIMEOUT_DEADLOCK * 1000);
            n2 = Math.max(100, Math.min(n2, n4 - 100));
            n3 = Math.max(100, Math.min(n3, n4 - n2 - 100));
            if (IOSWdaDeviceControl.A.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "valueRequest(String,String,JsonValue,int,int)", 1643).add("maxTimeout", n4)).add("connectTimeout", n2)).add("readTimeout", n3)).log();
            }
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            try {
                InputStreamReader inputStreamReader;
                if (IOSWdaDeviceControl.A.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(5, "valueRequest(String,String,JsonValue,int,int)", 1648).add("Calling ")).add((Object)uRL)).log();
                }
                de.qfs.apps.qftest.shared.m.a().a(C);
                try {
                    block50: {
                        iOSWDAInvocation2.setState(g.a.a.b);
                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod(string);
                        httpURLConnection.setRequestProperty("Content-Type", "application/json");
                        if (n2 > 0) {
                            httpURLConnection.setConnectTimeout(n2);
                        }
                        if (n3 > 0) {
                            httpURLConnection.setReadTimeout(n3);
                        }
                        httpURLConnection.setDoOutput(true);
                        httpURLConnection.setAllowUserInteraction(true);
                        if ("POST".equalsIgnoreCase(string)) {
                            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), Misc.UTF8_CHARSET);){
                                if (jsonValue != null) {
                                    jsonValue.writeTo((Writer)outputStreamWriter);
                                }
                                outputStreamWriter.flush();
                            }
                        }
                        httpURLConnection.connect();
                        int n5 = httpURLConnection.getResponseCode();
                        if (IOSWdaDeviceControl.A.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "valueRequest(String,String,JsonValue,int,int)", 1677).add("responseCode", n5)).add("url", (Object)uRL)).log();
                        }
                        try {
                            inputStream = httpURLConnection.getInputStream();
                        }
                        catch (IOException iOException) {
                            if (IOSWdaDeviceControl.A.level < 9) break block50;
                            ((LevelAwareLogBuilder)A.lvlBuild(9, "valueRequest(String,String,JsonValue,int,int)", 1682).add("ex", (Object)iOException)).log();
                        }
                    }
                    if (inputStream == null) {
                        inputStream = httpURLConnection.getErrorStream();
                    }
                }
                finally {
                    de.qfs.apps.qftest.shared.m.a().b(C);
                }
                iOSWDAInvocation2.setState(g.a.a.a);
                JsonValue jsonValue2 = null;
                if (inputStream != null) {
                    de.qfs.apps.qftest.shared.m.a().a(D);
                    try {
                        inputStreamReader = new InputStreamReader(inputStream, Misc.UTF8_CHARSET);
                        try {
                            try {
                                jsonValue2 = Json.parse((Reader)inputStreamReader);
                            }
                            catch (ParseException parseException) {
                                if (IOSWdaDeviceControl.A.level >= 3) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(3, "valueRequest(String,String,JsonValue,int,int)", 1699).add("Error parsing result: ", (Object)parseException)).add("url", (Object)uRL)).log();
                                }
                            }
                        }
                        finally {
                            inputStreamReader.close();
                        }
                    }
                    finally {
                        de.qfs.apps.qftest.shared.m.a().b(D);
                    }
                }
                if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)A.lvlBuild(9, "valueRequest(String,String,JsonValue,int,int)", 1705).add("result", jsonValue2)).log();
                }
                iOSWDAInvocation2.setState(g.a.a.c);
                iOSWDAInvocation2.d = jsonValue2;
                if (jsonValue2 instanceof JsonObject) {
                    inputStreamReader = (JsonObject)jsonValue2;
                    JsonValue jsonValue3 = inputStreamReader.get("value");
                    if (jsonValue3 instanceof JsonObject) {
                        ((JsonObject)jsonValue3).add("sessionId", inputStreamReader.get("sessionId"));
                    }
                    JsonValue jsonValue4 = jsonValue3;
                    return jsonValue4;
                }
                inputStreamReader = jsonValue2;
                return inputStreamReader;
            }
            catch (Exception exception) {
                iOSWDAInvocation2.excepted(exception);
                throw exception;
            }
            finally {
                iOSWDAInvocation2.callEndTimestamp = System.currentTimeMillis();
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            de.qfs.apps.qftest.shared.m.a().b(B);
        }
    }

    private String g(String string) {
        return "/session/" + this.e + string;
    }

    private String a(IOSElement iOSElement, String string) {
        return "/session/" + this.e + "/element/" + iOSElement.getUid() + string;
    }

    private String b(IOSElement iOSElement, String string) {
        return "/session/" + this.e + "/wda/element/" + iOSElement.getUid() + string;
    }

    public String toString() {
        String string = this.z.dumpBuffer();
        return string == null ? "---" : "\n" + string;
    }

    public String getAgentUrl() {
        return this.c;
    }

    public String getWdaState() {
        return this.g;
    }

    public String getWdaMessage() {
        return this.h;
    }

    public boolean isWdaReady() {
        return this.i;
    }

    @Override
    public IOSWdaDeviceControl setPostInstrumentMethod(Runnable runnable) {
        this.j = runnable;
        return this;
    }

    public String getAgentBundleId() {
        return this.k;
    }

    @Override
    public IOSWdaDeviceControl setAgentStopHandler(Runnable runnable) {
        this.n = runnable;
        return this;
    }

    @Override
    public JsonObject getSessionSettings() {
        return this.o;
    }

    public g getInvocationTracker() {
        return this.z;
    }

    static final class BuildOutput
    extends Enum {
        public static final /* enum */ BuildOutput NONE = new BuildOutput("NONE", 0);
        public static final /* enum */ BuildOutput INSTRUMENT = new BuildOutput("INSTRUMENT", 1);
        public static final /* enum */ BuildOutput EXEC = new BuildOutput("EXEC", 2);
        public static final /* enum */ BuildOutput ALL = new BuildOutput("ALL", 3);
        private static final /* synthetic */ BuildOutput[] a;

        public static BuildOutput[] values() {
            return (BuildOutput[])a.clone();
        }

        public static BuildOutput valueOf(String string) {
            return Enum.valueOf(BuildOutput.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private BuildOutput() {
            void var2_-1;
            void var1_-1;
        }

        private static /* synthetic */ BuildOutput[] a() {
            return new BuildOutput[]{NONE, INSTRUMENT, EXEC, ALL};
        }

        static {
            a = BuildOutput.a();
        }
    }

    public static class IOSWDAInvocation
    extends g.a {
        String a;
        String b;
        JsonValue c;
        JsonValue d;
        Thread e;

        protected String a() {
            return this.a + ":" + this.d();
        }

        private String d() {
            int n2;
            Object object = this.b;
            if (this.b.startsWith("/session/")) {
                object = ((String)object).substring(((String)object).indexOf(47, 9));
            }
            if ((n2 = ((String)object).indexOf("/element/")) > 0) {
                object = ((String)object).substring(0, n2 + 9) + ":uuid" + ((String)object).substring(((String)object).indexOf(47, n2 + 10));
            }
            return object;
        }

        protected String b() {
            return this.a(this.e());
        }

        private String e() {
            StringBuffer stringBuffer = new StringBuffer(this.b);
            if (this.c != null) {
                stringBuffer.append("(").append(this.truncate(this.c.toString())).append(")");
            }
            if (this.d != null) {
                stringBuffer.append(" -> ").append(this.truncate(this.d.toString()));
            }
            return stringBuffer.toString();
        }

        protected String c() {
            return this.e.getName() + ": " + super.c();
        }
    }

    final class AgentBuildProcessListener
    extends i {
        final IOSWdaDeviceControl a;
        boolean b;
        boolean c;
        boolean d;

        public AgentBuildProcessListener(IOSWdaDeviceControl iOSWdaDeviceControl2) {
            super(A.getOwnerName() + ".Process");
            this.b = true;
            this.c = false;
            this.d = true;
            this.a = iOSWdaDeviceControl2;
        }

        protected void a(String string, boolean bl2) {
            boolean bl3;
            if (IOSWdaDeviceControl.A.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(7, "AgentBuildProcessListener.lineReceived(String,boolean)", 1771).addDetail("line", string)).addDetail("isStderr", bl2)).log();
            }
            super.a(string, bl2);
            boolean bl4 = bl3 = IOSWdaDeviceControl.this.a == BuildOutput.ALL || this.b && IOSWdaDeviceControl.this.a == BuildOutput.INSTRUMENT || !this.b && IOSWdaDeviceControl.this.a == BuildOutput.EXEC;
            if (bl3) {
                if (this.d) {
                    System.out.println();
                    this.d = false;
                }
                System.out.println("Agent: " + string);
            }
            if (this.b && !bl3) {
                System.out.print(".");
            }
            this.a(string);
            this.c(string);
            this.d(string);
            this.e(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(String string) {
            int n2;
            int n3 = string.indexOf(IOSWdaDeviceControl.N);
            if (n3 > -1 && (n2 = string.indexOf(IOSWdaDeviceControl.O)) > n3) {
                String string2 = string.substring(n3 + IOSWdaDeviceControl.N.length(), n2);
                if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)A.lvlBuild(9, "AgentBuildProcessListener.detectServerUrl(String)", 1800).add("url", string2)).log();
                }
                this.a.b.add(string2);
                String string3 = string.substring(n2);
                if (this.b(string3)) {
                    Deque deque = this.a.b;
                    synchronized (deque) {
                        this.a.b.notifyAll();
                    }
                }
            }
        }

        private boolean b(String string) {
            Pattern pattern = Pattern.compile("<-ServerURLHere \\((\\d+)/(\\d+)\\)");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) {
                return true;
            }
            try {
                boolean bl2;
                boolean bl3 = bl2 = Integer.valueOf(matcher.group(1)) >= Integer.valueOf(matcher.group(2));
                if (IOSWdaDeviceControl.A.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)A.lvlBuild(9, "AgentBuildProcessListener.isLastAddress(String)", 1819).add("lineEnd", string)).add("isLastAddress", bl2)).log();
                }
                return bl2;
            }
            catch (Exception exception) {
                if (IOSWdaDeviceControl.A.level >= 5) {
                    ((LevelAwareLogBuilder)A.lvlBuild(5, "AgentBuildProcessListener.isLastAddress(String)", 1822).add("Could not parse address counter", (Object)exception)).log();
                }
                return true;
            }
        }

        private void c(String string) {
            if (string.contains("\tLost connection to DTServiceHub")) {
                System.out.println("Connection to device or simulator lost.");
            }
            if (string.contains("Restarting after unexpected exit, crash, or test timeout")) {
                System.out.println("Unexpected agent exit detected - Trying to restart.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void d(String string) {
            if (string.contains("** TEST EXECUTE FAILED **") || string.contains("error: Failed to build project")) {
                this.a.d = true;
                Deque deque = this.a.b;
                synchronized (deque) {
                    this.a.b.notifyAll();
                }
            }
        }

        private void e(String string) {
            if (string.contains("Waiting for the destination to become ready.")) {
                System.out.println("\n\n##################################################\n## Please unlock your device to start the test! ##\n##################################################\n");
            }
        }

        public void processTerminated(ProcessEvent processEvent) {
            if (this.c && IOSWdaDeviceControl.this.n != null) {
                IOSWdaDeviceControl.this.n.run();
            }
        }
    }
}

