/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.Tracker;
import de.qfs.apps.qftest.client.mobile.MobileHelper;
import de.qfs.apps.qftest.client.mobile.toolkit.MobileComponent;
import de.qfs.apps.qftest.client.mobile.v;
import de.qfs.apps.qftest.extensions.ResolverRegistry;
import de.qfs.apps.qftest.shared.data.ElementInfo;
import de.qfs.apps.qftest.shared.exceptions.ModalDialogException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.m;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.ComparingWeakReference;
import de.qfs.lib.util.MessageCollector;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.MultiMap;
import de.qfs.lib.util.Pair;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class MobileTracker
extends Tracker {
    private static final QFLogger Q = new QFLogger("de.qfs.apps.qftest.client.mobile.MobileTracker");
    public static final String HIERARCHY_PARSING = "hierarchyParsing";
    public static final String REUSE_COMPONENT_CALCULATION = "reuseComponentCalculation";
    protected static final DateFormat T = new SimpleDateFormat("HH:mm:ss.SSS");
    protected ArrayList U = new ArrayList();
    protected ArrayList V = new ArrayList();
    protected MultiMap W = new MultiMap();
    protected int X;
    protected int Y;
    protected int Z;

    @Override
    public abstract MobileHelper getHelper();

    @Override
    public void optionsChanged(OptionSet optionSet) {
        super.optionsChanged(optionSet);
        this.I = Options.getBoolean((String)this.d());
    }

    protected abstract String d();

    public void addEventFilter(Object object) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)Q.lvlBuild(7, "addEventFilter(EF)", 131).addDetail("filter", object)).log();
        }
        this.addEventFilter(object, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventFilter(Object object, int n2) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(7, "addEventFilter(EF,int)", 149).addDetail("filter", object)).addDetail("eventType", n2)).log();
        }
        MobileTracker mobileTracker = this;
        synchronized (mobileTracker) {
            Pair pair = new Pair(object, (Object)n2);
            this.U.remove(pair);
            this.U.add(0, pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventFilter(Object object) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)Q.lvlBuild(7, "removeEventFilter(EF)", 170).addDetail("filter", object)).log();
        }
        MobileTracker mobileTracker = this;
        synchronized (mobileTracker) {
            this.U.removeIf(pair -> pair.getFirst() == object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventFilter(Object object, int n2) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(7, "removeEventFilter(EF,int)", 189).addDetail("filter", object)).addDetail("eventType", n2)).log();
        }
        MobileTracker mobileTracker = this;
        synchronized (mobileTracker) {
            this.U.remove(new Pair(object, (Object)n2));
        }
    }

    @Override
    public ArrayList getToplevels() {
        return (ArrayList)this.V.clone();
    }

    @Override
    protected boolean a(int n2, int n3, int n4, int n5, long l2, int n6, long l3) {
        if (MobileTracker.Q.level >= 9) {
            ((LevelAwareLogBuilder)Q.lvlBuild(9, "shouldRescanToplevels(int,int,int,int,long,int,long)", 218).add("averageRescanTime", this.N)).log();
        }
        return this.N == 0L || n3 == 1 || l2 >= 2L * this.N || n2 < n6;
    }

    @Override
    public void maybeRescanToplevels() {
        try {
            Client.instance().pushEngineContext(this.getEngine());
            this.maybeRescan();
        }
        finally {
            Client.instance().popEngineContext();
        }
    }

    public boolean maybeRescan() {
        if (!this.e()) {
            return false;
        }
        long l2 = System.currentTimeMillis() - this.M;
        if (MobileTracker.Q.level >= 9) {
            ((LevelAwareLogBuilder)Q.lvlBuild(9, "maybeRescan()", 254).add("timeSinceLastRescan", l2)).log();
        }
        if (this.M == 0L || l2 > (long)this.X || this.V.isEmpty()) {
            this.getEngine().safeInvokeNow(new v(this), new Class[0]);
            return true;
        }
        return false;
    }

    protected boolean e() {
        return true;
    }

    @Override
    protected boolean d(Object object) {
        return false;
    }

    public void checkModal(Object object) throws ModalDialogException {
    }

    @Override
    protected boolean isTheActiveWindow(Object object) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(MessageCollector messageCollector, boolean bl2, int n2, long l2) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(7, "_rescanToplevels(MessageCollector,boolean,int,long)", 345).addDetail("collector", (Object)messageCollector)).addDetail("clear", bl2)).addDetail("calls", n2)).addDetail("timestamp", l2)).dumpStack();
        }
        this.getEngine().checkDispatch("_rescanToplevels");
        de.qfs.apps.qftest.shared.m.a().a(".rescan");
        try {
            block18: {
                this.V.clear();
                this.W.clear();
                boolean bl3 = this.a(messageCollector, bl2);
                if (bl3) break block18;
                if (n2 == 0) {
                    Misc.safeSleep((long)1000L);
                } else {
                    if (n2 >= this.Y) {
                        System.err.println(T.format(new Date()) + " Connection to device lost and retry limit exceeded, giving up");
                        throw new StopRescanningException("Rescan retry limit exceeded. Connection lost?");
                    }
                    if (n2 >= this.Z) {
                        System.err.println(T.format(new Date()) + "Connection to device lost, try to re-instrument");
                        try {
                            this.f();
                        }
                        catch (Throwable throwable) {
                            throw new StopRescanningException("Reinstrumenting device failed", throwable);
                        }
                    }
                }
                this.a(messageCollector, bl2, n2 + 1, l2);
                return;
            }
            try {
                TreeAdapter treeAdapter = this.getHelper().getAdapter();
                for (Object e2 : this.V) {
                    TreeUtil.traverse((TreeAdapter)treeAdapter, e2, (TraversalCallback)new a());
                    TreeUtil.traverse((TreeAdapter)treeAdapter, e2, (TraversalCallback)new c());
                    TreeUtil.traverse((TreeAdapter)treeAdapter, e2, (TraversalCallback)new b());
                }
            }
            catch (Throwable throwable) {
                if (messageCollector != null) {
                    messageCollector.logError("Exception during rescan:" + throwable.getMessage() + "\n" + Log.getStackTrace((Throwable)throwable));
                }
                if (MobileTracker.Q.level >= 1) {
                    ((LevelAwareLogBuilder)Q.lvlBuild(1, "_rescanToplevels(MessageCollector,boolean,int,long)", 390).add("ex", (Object)throwable)).log();
                }
                if (throwable instanceof StopRescanningException) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        finally {
            de.qfs.apps.qftest.shared.m.a().b(".rescan");
        }
    }

    protected abstract boolean a(MessageCollector var1, boolean var2) throws TestException;

    protected abstract void f() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTopLvlChange(MessageCollector messageCollector, Object object) {
        block15: {
            List list = null;
            try {
                de.qfs.apps.qftest.shared.m.a().a(HIERARCHY_PARSING);
                try {
                    try {
                        list = this.f(object);
                    }
                    catch (Exception exception) {
                        if (MobileTracker.Q.level >= 1) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(1, "notifyTopLvlChange(MessageCollector,Object)", 425).add("ParsingFailure: ")).add("hierarchySource", object)).log();
                        }
                        throw exception;
                    }
                    if (MobileTracker.Q.level >= 9) {
                        ((LevelAwareLogBuilder)Q.lvlBuild(9, "notifyTopLvlChange(MessageCollector,Object)", 428).add("roots", (Object)list)).log();
                    }
                }
                finally {
                    de.qfs.apps.qftest.shared.m.a().b(HIERARCHY_PARSING);
                }
                if (list == null) break block15;
                de.qfs.apps.qftest.shared.m.a().a(REUSE_COMPONENT_CALCULATION);
                Client.instance().pushEngineContext(this.getEngine());
                try {
                    for (MobileComponent mobileComponent : this.V) {
                        mobileComponent.invalidateChildren();
                    }
                    this.V.clear();
                    this.V.addAll(list);
                }
                finally {
                    Client.instance().popEngineContext();
                    de.qfs.apps.qftest.shared.m.a().b(REUSE_COMPONENT_CALCULATION);
                }
            }
            catch (Throwable throwable) {
                if (messageCollector != null) {
                    messageCollector.logError("Exception during XML parsing:" + throwable.getMessage() + "\n" + Log.getStackTrace((Throwable)throwable));
                }
                if (MobileTracker.Q.level < 1) break block15;
                ((LevelAwareLogBuilder)Q.lvlBuild(1, "notifyTopLvlChange(MessageCollector,Object)", 451).add("Error during toplevel change", (Object)throwable)).log();
            }
        }
    }

    protected abstract List f(Object var1) throws Exception;

    @Override
    public void internalRescanToplevels(MessageCollector messageCollector, boolean bl2) {
        try {
            Client.instance().pushEngineContext(this.getEngine());
            this.a(messageCollector, bl2, 0, System.currentTimeMillis());
        }
        finally {
            Client.instance().popEngineContext();
        }
    }

    @Override
    protected List a(ElementInfo elementInfo, boolean bl2, de.qfs.apps.qftest.client.b.b b2, boolean bl3, MessageCollector messageCollector) {
        HashSet hashSet = new HashSet(this.V);
        return this.a(elementInfo, hashSet, hashSet.size(), bl2, b2, -1.0, bl3, messageCollector, "", 0, false);
    }

    @Override
    protected boolean a(Object object, boolean bl2) {
        if (object instanceof MobileComponent) {
            MobileComponent mobileComponent = (MobileComponent)object;
            return this.getHelper().isVisible(mobileComponent);
        }
        return true;
    }

    @Override
    protected Collection a(String string, boolean bl2) {
        if (MobileTracker.Q.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(7, "getNamedElements(String,boolean)", 507).addDetail("name", string)).addDetail("forRegexp", bl2)).log();
        }
        HashSet hashSet = new HashSet();
        Collection collection = this.a(this.W, string, bl2);
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object t2 = ((WeakReference)iterator.next()).get();
            if (t2 == null) continue;
            hashSet.add(t2);
        }
        return hashSet.size() == 0 ? null : hashSet;
    }

    @Override
    protected boolean b(List list) {
        return false;
    }

    @Override
    protected Pair a(Object object, String[] stringArray) {
        if (MobileTracker.Q.level >= 3) {
            ((LevelAwareLogBuilder)Q.lvlBuild(3, "getElementsOfClass(Object,String[])", 538).add("Shouldn't be called anymore")).log();
        }
        return this.a(object, stringArray, false);
    }

    @Override
    protected Pair a(Object object, String[] stringArray, boolean bl2) {
        this.getEngine().checkDispatch();
        MobileHelper mobileHelper = this.getHelper();
        Object[] objectArray = mobileHelper.getElementsByClassName(object, stringArray);
        if (MobileTracker.Q.level >= 9) {
            ((LevelAwareLogBuilder)Q.lvlBuild(9, "getElementsOfClass(Object,String[],boolean)", 549).add("children", (Object)objectArray)).log();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block0: for (Object object2 : objectArray) {
            if (!bl2 && !mobileHelper.isVisible(object2)) {
                if (MobileTracker.Q.level < 9) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(9, "getElementsOfClass(Object,String[],boolean)", 556).add("Invisible: ")).add(object2)).log();
                continue;
            }
            Object object3 = mobileHelper.getParentElement(object2);
            while (object3 != null) {
                if (MobileTracker.Q.level >= 9) {
                    ((LevelAwareLogBuilder)Q.lvlBuild(9, "getElementsOfClass(Object,String[],boolean)", 561).add("tmp", object3)).log();
                }
                if (object3 == object) {
                    if (MobileTracker.Q.level >= 9) {
                        ((LevelAwareLogBuilder)Q.lvlBuild(9, "getElementsOfClass(Object,String[],boolean)", 563).add("good one")).log();
                    }
                    arrayList.add(object2);
                    continue block0;
                }
                if (mobileHelper.isInterestingParent(object3)) {
                    if (MobileTracker.Q.level >= 9) {
                        ((LevelAwareLogBuilder)Q.lvlBuild(9, "getElementsOfClass(Object,String[],boolean)", 568).add("interesting parent - bad one")).log();
                    }
                    arrayList2.add(object2);
                    continue block0;
                }
                if ((object3 = mobileHelper.getParentElement(object3)) != null || MobileTracker.Q.level < 3) continue;
                ((LevelAwareLogBuilder)Q.lvlBuild(3, "getElementsOfClass(Object,String[],boolean)", 574).add("Oops. Child outside parentElement???")).log();
            }
        }
        return new Pair(arrayList, arrayList2);
    }

    @Override
    protected boolean a(Object object, ElementInfo elementInfo) {
        Object object2 = Client.instance().getContext(Client.CONTEXT_REPLAY);
        if (MobileTracker.Q.level >= 9) {
            ((LevelAwareLogBuilder)Q.lvlBuild(9, "shouldResolveItem(Object,ElementInfo)", 599).add("ctxt", object2)).log();
        }
        if (object2 == Client.CONTEXT_REPLAY_CHECK || object2 == Client.CONTEXT_REPLAY_FETCH) {
            if (MobileTracker.Q.level >= 9) {
                ((LevelAwareLogBuilder)Q.lvlBuild(9, "shouldResolveItem(Object,ElementInfo)", 602).add("In check, fetch or highlight")).log();
            }
            return false;
        }
        return true;
    }

    public static class StopRescanningException
    extends Exception {
        public StopRescanningException(String string) {
            super(string);
        }

        public StopRescanningException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public class a
    implements TraversalCallback {
        public boolean nodeEntered(Traversal traversal) {
            MobileTracker.this.getHelper().getClassInfo(traversal.getNode());
            return true;
        }

        public void nodeExited(Traversal traversal) {
        }
    }

    public class c
    implements TraversalCallback {
        public boolean nodeEntered(Traversal traversal) {
            ResolverRegistry.instance().overrideClasses(traversal.getNode(), MobileTracker.this.getHelper());
            return true;
        }

        public void nodeExited(Traversal traversal) {
        }
    }

    public class b
    implements TraversalCallback {
        public boolean nodeEntered(Traversal traversal) {
            Object object = traversal.getNode();
            String string = MobileTracker.this.getHelper().getName(object);
            if (!Misc.emptyOrNull((String)string)) {
                if (MobileTracker.Q.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)Q.lvlBuild(9, "NameScanner.nodeEntered(Traversal)", 694).add("elem", object)).add("name", string)).log();
                }
                MobileTracker.this.W.remove((Object)string, (Object)new ComparingWeakReference(object));
                MobileTracker.this.W.put((Object)string, (Object)new ComparingWeakReference(object));
            }
            return true;
        }

        public void nodeExited(Traversal traversal) {
        }
    }
}

