/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile.checks;

import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.mobile.MobileEngine;
import de.qfs.apps.qftest.client.mobile.toolkit.MobileComponent;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.QFSChecker;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.GeometryCheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;

public abstract class MobileChecker
implements Checker,
QFSChecker {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.client.mobile.checks.MobileChecker");
    final MobileEngine a;

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 121).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (object instanceof MobileComponent) {
            MobileComponent mobileComponent = (MobileComponent)object;
            ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
            if (mobileComponent.hasText()) {
                arrayList.add(CheckType.TEXT);
            }
            arrayList.add(CheckType.VISIBLE);
            arrayList.add(CheckType.ENABLED);
            if (mobileComponent.isSelectable()) {
                arrayList.add(CheckType.SELECTED);
            }
            if (mobileComponent.isCheckable()) {
                arrayList.add(CheckType.CHECKED);
            }
            if (mobileComponent.isFocusable()) {
                arrayList.add(CheckType.FOCUSED);
            }
            arrayList.add(CheckType.IMAGE);
            arrayList.add(CheckType.GEOMETRY);
            this.getAdditionalCheckTypes(mobileComponent, arrayList);
            return arrayList.toArray(new CheckType[arrayList.size()]);
        }
        return null;
    }

    protected void getAdditionalCheckTypes(MobileComponent mobileComponent, ArrayList arrayList) {
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getAdditionalCheckTypes(MobileComponent,ArrayList<CheckType>)", 164).addDetail("com", (Object)mobileComponent)).addDetail("types", (Object)arrayList)).log();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 179).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object instanceof MobileComponent) {
            MobileComponent mobileComponent;
            Object object3;
            block35: {
                if (object2 != null) {
                    object3 = ItemRegistry.instance().getElement(object, object2);
                    if (object3 instanceof MobileComponent) {
                        mobileComponent = (MobileComponent)object3;
                        break block35;
                    } else {
                        if (MobileChecker.b.level >= 3) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 191).add("Cannot resolve target ")).add(object)).add(" and item ")).add(object2)).add(" to AndroidComponent, got: ")).add(object3)).log();
                        }
                        return null;
                    }
                }
                mobileComponent = (MobileComponent)object;
            }
            if (!mobileComponent.isValid()) {
                throw new RetryException(new TestException("Component got invalidated!"), 0L, false);
            }
            if ((CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()) || "default".equals(checkType.getIdentifier())) && checkType.getDataType() == CheckDataType.STRING) {
                object3 = Util.getCleanElementText((String)this.a.getHelper().getWholeText(mobileComponent));
                if (MobileChecker.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 206).add("text", (String)object3)).log();
                }
                return new StringCheckData("default", (String)object3);
            }
            if (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.BOOLEAN) {
                boolean bl2 = this.a.getHelper().isVisible(mobileComponent);
                if (MobileChecker.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 211).add("visible: ", bl2)).log();
                }
                return new BooleanCheckData(CheckType.VISIBLE.getIdentifier(), bl2);
            }
            if (CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.BOOLEAN) {
                boolean bl3 = this.a.getHelper().isEnabled(mobileComponent);
                if (MobileChecker.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 216).add("enabled:", bl3)).log();
                }
                return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), bl3);
            }
            if (CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.BOOLEAN) {
                if (mobileComponent.isCheckable()) {
                    if (MobileChecker.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 222).add("checked:", mobileComponent.isChecked())).log();
                    }
                    return new BooleanCheckData(CheckType.SELECTED.getIdentifier(), mobileComponent.isChecked());
                }
                if (mobileComponent.isSelectable()) {
                    if (MobileChecker.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 225).add("selected:", mobileComponent.isSelected())).log();
                    }
                    return new BooleanCheckData(CheckType.SELECTED.getIdentifier(), mobileComponent.isSelected());
                }
            } else {
                if (CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.BOOLEAN) {
                    if (mobileComponent.isCheckable()) {
                        if (MobileChecker.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 235).add("checked:", mobileComponent.isChecked())).log();
                        }
                        return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), mobileComponent.isChecked());
                    }
                    if (MobileChecker.b.level >= 3) {
                        ((LevelAwareLogBuilder)b.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 238).add("WRN: checked check on non checkable element!")).log();
                    }
                    return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), false);
                }
                if (CheckType.FOCUSED.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.BOOLEAN) {
                    if (mobileComponent.isFocusable()) {
                        if (MobileChecker.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 247).add("focused:", mobileComponent.isFocused())).log();
                        }
                        return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), mobileComponent.isFocused());
                    }
                    if (MobileChecker.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 250).add("DBG: focused check on non focusable element!")).log();
                    }
                    return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), false);
                }
                if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(checkType.getIdentifier()) || checkType.getDataType() == CheckDataType.IMAGE)) {
                    try {
                        if (MobileChecker.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 274).add("Image check")).log();
                        }
                        object3 = mobileComponent.getScreenshot(this.a);
                        return new ImageCheckData("default", (ImageRep)object3, -1, -1, -1, -1, -1, -1, false);
                    }
                    catch (Throwable throwable) {
                        if (MobileChecker.b.level >= 3) {
                            ((LevelAwareLogBuilder)b.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 283).add("t", (Object)throwable)).log();
                        }
                        return null;
                    }
                }
                if (CheckType.GEOMETRY.getIdentifier().equals(checkType.getIdentifier()) && checkType.getDataType() == CheckDataType.GEOMETRY) {
                    object3 = mobileComponent.getVisibleFrame();
                    return new GeometryCheckData(CheckType.GEOMETRY.getIdentifier(), ((Geometry)object3).x, ((Geometry)object3).y, ((Geometry)object3).width, ((Geometry)object3).height);
                }
            }
            if ((object3 = this.getCheckData(mobileComponent, checkType)) != null) {
                return object3;
            }
            if (MobileChecker.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "getCheckData(Object,Object,CheckType)", 305).add("type not found!")).log();
            }
        }
        return null;
    }

    protected CheckData getCheckData(MobileComponent mobileComponent, CheckType checkType) {
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getCheckData(MobileComponent,CheckType)", 314).addDetail("com", (Object)mobileComponent)).addDetail("type", (Object)checkType)).log();
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 333).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        return new Pair((Object)checkData, null);
    }

    public MobileChecker(MobileEngine mobileEngine) {
        if (MobileChecker.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "MobileChecker(MobileEngine)", 48).addDetail("engine", (Object)mobileEngine)).log();
        }
        if (mobileEngine == null) {
            throw new IllegalArgumentException("engine is marked non-null but is null");
        }
        this.a = mobileEngine;
    }
}

