/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile.image;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;

public class JpegUtil {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.mobile.image.JpegUtil");

    public static BufferedImage getImageFromBytes(byte[] byArray) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            BufferedImage bufferedImage;
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            if (memoryCacheImageInputStream == null) {
                throw new IOException("Can't create an ImageInputStream!");
            }
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(memoryCacheImageInputStream);
            if (!iterator.hasNext()) {
                BufferedImage bufferedImage2 = null;
                return bufferedImage2;
            }
            ImageReader imageReader = iterator.next();
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            imageReader.setInput(memoryCacheImageInputStream, true, false);
            try {
                bufferedImage = imageReader.read(0, imageReadParam);
            }
            catch (RuntimeException runtimeException) {
                throw new IIOException(runtimeException.toString(), runtimeException);
            }
            finally {
                imageReader.dispose();
                memoryCacheImageInputStream.close();
            }
            if (bufferedImage == null) {
                memoryCacheImageInputStream.close();
            }
            try {
                int n2 = JpegUtil.a(byArray);
                BufferedImage bufferedImage3 = JpegUtil.a(bufferedImage, n2);
                return bufferedImage3;
            }
            catch (Exception exception) {
                if (JpegUtil.a.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getImageFromBytes(byte[])", 77).add("No orientation info found:")).add((Object)exception)).log();
                }
                BufferedImage bufferedImage4 = bufferedImage;
                byteArrayInputStream.close();
                return bufferedImage4;
            }
        }
    }

    protected static int a(byte[] byArray) throws IOException {
        JpegImageMetadata jpegImageMetadata = (JpegImageMetadata)new JpegImageParser().getMetadata(byArray);
        TiffField tiffField = jpegImageMetadata == null ? null : jpegImageMetadata.findExifValue((TagInfo)TiffTagConstants.TIFF_TAG_ORIENTATION);
        return tiffField == null ? 0 : tiffField.getIntValue();
    }

    protected static BufferedImage a(BufferedImage bufferedImage, int n2) {
        Object object;
        Object object2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        double d2 = (n3 - n4) / 2;
        switch (n2) {
            case 3: {
                new AffineTransform().rotate(Math.PI, n3 / 2, n4 / 2);
            }
            case 6: {
                object2 = new AffineTransform();
                ((AffineTransform)object2).rotate(1.5707963267948966, n3 / 2, n4 / 2);
                ((AffineTransform)object2).translate(d2, d2);
                Object object3 = object2;
                break;
            }
            case 8: {
                object2 = new AffineTransform();
                ((AffineTransform)object2).rotate(-1.5707963267948966, n3 / 2, n4 / 2);
                ((AffineTransform)object2).translate(-d2, -d2);
                Object object3 = object2;
                break;
            }
            default: {
                Object object3 = object = null;
            }
        }
        if (object == null) {
            return bufferedImage;
        }
        object2 = new AffineTransformOp((AffineTransform)object, null);
        BufferedImage bufferedImage2 = new BufferedImage(n2 == 3 ? bufferedImage.getWidth() : bufferedImage.getHeight(), n2 == 3 ? bufferedImage.getHeight() : bufferedImage.getWidth(), bufferedImage.getType());
        ((AffineTransformOp)object2).filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

