/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile.image;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;

public class MJPEGStreamProcessor
extends DaemonThread {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.mobile.image.MJPEGStreamProcessor");
    public static final byte MJPEG_IMAGE_START = -39;
    public static final byte MJPEG_IMAGE_END = -40;
    public static final int INITIAL_RECONNECT_SILENT_TIME = 500;
    public static final int MAX_RECONNECT_SILENT_TIME = 5000;
    private final Delegate b;
    private boolean c = false;
    private InputStream d;
    private final Object e = new Object();
    private long f = Long.MAX_VALUE;
    private HttpURLConnection g;
    private volatile long h = 500L;

    public MJPEGStreamProcessor(Delegate delegate) {
        super("MJPEG stream processing thread");
        if (MJPEGStreamProcessor.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "MJPEGStreamProcessor(Delegate)", 47).addDetail("delegate", (Object)delegate)).log();
        }
        this.b = delegate;
    }

    public synchronized void start() {
        if (MJPEGStreamProcessor.a.level >= 7) {
            a.lvlBuild(7, "start()", 54).log();
        }
        this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(boolean bl2) {
        block7: {
            if (MJPEGStreamProcessor.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "start(boolean)", 59).addDetail("forceStart", bl2)).log();
            }
            try {
                if (!bl2 && this.f <= 0L) break block7;
                Object object = this.e;
                synchronized (object) {
                    this.connectInputStream();
                    this.f = 0L;
                    this.e.notifyAll();
                }
            }
            catch (Exception exception) {
                if (MJPEGStreamProcessor.a.level < 9) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(9, "start(boolean)", 70).add("ex", (Object)exception)).log();
            }
        }
        if (!this.isAlive()) {
            super.start();
        }
    }

    public void pause() {
        if (MJPEGStreamProcessor.a.level >= 7) {
            a.lvlBuild(7, "pause()", 77).log();
        }
        this.a(Long.MAX_VALUE);
    }

    private void a(long l2) {
        block3: {
            if (MJPEGStreamProcessor.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "pause(long)", 81).addDetail("duration", l2)).log();
            }
            try {
                this.f = Math.max(Long.MAX_VALUE, System.currentTimeMillis() + l2);
                this.disconnectVideoStream();
            }
            catch (Exception exception) {
                if (MJPEGStreamProcessor.a.level < 9) break block3;
                ((LevelAwareLogBuilder)a.lvlBuild(9, "pause(long)", 87).add("ex", (Object)exception)).log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (MJPEGStreamProcessor.a.level >= 7) {
            a.lvlBuild(7, "finish()", 91).log();
        }
        MJPEGStreamProcessor mJPEGStreamProcessor = this;
        synchronized (mJPEGStreamProcessor) {
            this.pause();
            this.c = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void connectInputStream() {
        URL uRL;
        if (MJPEGStreamProcessor.a.level >= 7) {
            a.lvlBuild(7, "connectInputStream()", 100).log();
        }
        if ((uRL = this.b.getScreenVideoStreamUrl()) == null) {
            return;
        }
        this.disconnectVideoStream();
        try {
            this.g = (HttpURLConnection)uRL.openConnection();
            this.d = this.g.getInputStream();
            this.h = 500L;
        }
        catch (Exception exception) {
            if (MJPEGStreamProcessor.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "connectInputStream()", 114).add("ex", (Object)exception)).log();
            }
            this.h = Math.min(2L * this.h, 5000L);
        }
    }

    public void disconnectVideoStream() {
        block8: {
            block7: {
                if (MJPEGStreamProcessor.a.level >= 7) {
                    a.lvlBuild(7, "disconnectVideoStream()", 119).log();
                }
                try {
                    if (this.d != null) {
                        this.d.close();
                    }
                }
                catch (Exception exception) {
                    if (MJPEGStreamProcessor.a.level < 5) break block7;
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "disconnectVideoStream()", 126).add("Could not close screenshot input stream", (Object)exception)).log();
                }
            }
            try {
                if (this.g != null) {
                    this.g.disconnect();
                }
            }
            catch (Exception exception) {
                if (MJPEGStreamProcessor.a.level < 5) break block8;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "disconnectVideoStream()", 133).add("Could not close screenshot input stream connection", (Object)exception)).log();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block21: {
            if (MJPEGStreamProcessor.a.level >= 7) {
                a.lvlBuild(7, "run()", 137).log();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = 0;
            boolean bl2 = false;
            try {
                while (!this.c) {
                    block20: {
                        Object object = this.e;
                        synchronized (object) {
                            while (this.f > System.currentTimeMillis()) {
                                block19: {
                                    try {
                                        this.e.wait(Math.max(1L, this.f - System.currentTimeMillis()));
                                    }
                                    catch (InterruptedException interruptedException) {
                                        if (MJPEGStreamProcessor.a.level < 9) break block19;
                                        ((LevelAwareLogBuilder)a.lvlBuild(9, "run()", 151).add("ex", (Object)interruptedException)).log();
                                    }
                                }
                                byteArrayOutputStream.reset();
                            }
                        }
                        if (this.d == null) {
                            this.connectInputStream();
                        }
                        if (this.d != null) {
                            try {
                                n2 = this.d.read(byArray);
                                if (n2 != -1) {
                                    for (int i2 = 0; i2 < n2; ++i2) {
                                        if (bl2) {
                                            byteArrayOutputStream.write(byArray[i2]);
                                            if (byArray[i2] != -1 || i2 >= n2 - 1 || byArray[i2 + 1] != -39) continue;
                                            bl2 = false;
                                            byte[] byArray2 = byteArrayOutputStream.toByteArray();
                                            byteArrayOutputStream.reset();
                                            this.b.storeLastScreenshot(byArray2);
                                            continue;
                                        }
                                        if (byArray[i2] != -1 || i2 >= n2 - 1 || byArray[i2 + 1] != -40) continue;
                                        bl2 = true;
                                        byteArrayOutputStream.write(byArray[i2]);
                                        byteArrayOutputStream.write(byArray[i2 + 1]);
                                        ++i2;
                                    }
                                }
                            }
                            catch (SocketException socketException) {
                                if (this.f == 0L) {
                                    this.a(true);
                                }
                            }
                            catch (Exception exception) {
                                if (MJPEGStreamProcessor.a.level < 9) break block20;
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "run()", 186).add("ex", (Object)exception)).log();
                            }
                        }
                    }
                    if (this.d != null || this.f != 0L) continue;
                    this.a(this.h);
                }
            }
            catch (Exception exception) {
                if (MJPEGStreamProcessor.a.level < 9) break block21;
                ((LevelAwareLogBuilder)a.lvlBuild(9, "run()", 194).add("ex", (Object)exception)).log();
            }
        }
    }

    public static interface Delegate {
        public URL getScreenVideoStreamUrl();

        public void storeLastScreenshot(byte[] var1);
    }
}

