/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.mobile.toolkit;

import de.qfs.apps.qftest.client.mobile.MobileEngine;
import de.qfs.apps.qftest.shared.Geometry;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import java.util.List;

public interface MobileComponent {
    public ImageRep getScreenshot(MobileEngine var1) throws Exception;

    public MobileComponent getParent();

    public void invalidate();

    public void invalidateChildren();

    public boolean isValid();

    public boolean isEnabled();

    default public boolean isVisibleToUser() {
        return this.isVisibleToUser(false);
    }

    public boolean isVisibleToUser(boolean var1);

    public String getText();

    public String getClassName();

    public List getSuperClasses();

    public Geometry getFrame();

    public Geometry getFrameInParent();

    public Geometry getVisibleFrame();

    public boolean isPassword();

    public boolean isMultiLine();

    public boolean isCheckable();

    public boolean isChecked();

    public boolean isEditable();

    public boolean isSelectable();

    public boolean isSelected();

    public boolean isFocusable();

    public boolean isFocused();

    default public boolean hasKeyboardFocus() {
        return this.isFocused();
    }

    default public boolean hasText() {
        return true;
    }

    public boolean isWebView();

    default public MobileComponent getToplevel() {
        MobileComponent mobileComponent;
        MobileComponent mobileComponent2 = this;
        while ((mobileComponent = mobileComponent2.getParent()) != null) {
            mobileComponent2 = mobileComponent;
        }
        return mobileComponent2;
    }
}

