/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.resolvers.web;

import de.qfs.apps.qftest.client.ElementHelper;
import de.qfs.apps.qftest.client.resolvers.web.ExtjsResolver_3_1_0;
import de.qfs.apps.qftest.client.resolvers.web.generic.GenericEnabledHandler;
import de.qfs.apps.qftest.client.resolvers.web.generic.GenericInterestingParentHandler;
import de.qfs.apps.qftest.client.resolvers.web.generic.GenericMainAndWholeTextHandler;
import de.qfs.apps.qftest.client.resolvers.web.generic.GenericTableAndTreeAndTreeTableHandler;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;

public class ExtjsResolver_3_1_1
extends ExtjsResolver_3_1_0 {
    private static final QFLogger k = new QFLogger("de.qfs.apps.qftest.client.resolvers.web.ExtjsResolver_3_1_1");

    @Override
    public void preBasicResolverInstall() {
        if (ExtjsResolver_3_1_1.k.level >= 7) {
            k.lvlBuild(7, "preBasicResolverInstall()", 59).log();
        }
        super.preBasicResolverInstall();
        this.c.setGenericEnabledHandler(new ExtjsGenericEnabledHandler());
        this.c.setGenericInterestingParentHandler(new ExtjsGenericInterestingParentHandler());
        this.c.setGenericTableAndTreeAndTreeTableHandler(new ExtjsGenericTableAndTreeAndTreeTableHandler());
        this.c.setSimpleGenericMainAndWholeTextHandler(new ExtjsGenericMainAndWholeTextHandler());
    }

    @Override
    public void postBasicResolverInstall() {
        if (ExtjsResolver_3_1_1.k.level >= 7) {
            k.lvlBuild(7, "postBasicResolverInstall()", 80).log();
        }
        super.postBasicResolverInstall();
        this.c.addResolverProperties("attributesToGenericClasses", "class=%.*x-datepicker-date.*=Link,class=%.*x-monthpicker-item-inner.*=Link,class=%.*x-treelist.*=Tree,class=%.*x-treelist-row.*=TreeNode,class=%.*x-treelist-item-expander.*=Expander:TreeNodeExpander,class=%.*x-btn-arrow-el.*=Button,class=%.*x-tree-elbow-line.*=Spacer:TreeNodeSpacer,class=%.*x-tree-elbow-empty.*=Spacer:TreeNodeSpacer,");
        this.c.addResolverProperties("genericClasses", "x-box-scroller=Button,x-form-type-radio=RadioButton,x-form-type-checkbox=CheckBox,x-grid3-hd=TableHeaderCell,x-grid3-hd-row=TableHeader,x-grid3-cell=TableCell,x-grid3-row=TableRow,x-grid3=Table,");
        this.c.addResolverProperties("ignoreClasses", "x-grid-item-alt,%x-tab-bar.*,%x-docked.*,%x-.*scroll.*,%x-.*touch.*,x-autocontainer-innerCt,x-horizontal,x-top,x-scroller,x-tree-elbow-img,x-form-checkbox,x-form-radio,x-form-radio-default,x-form-checkbox-default,x-form-cb,x-form-cb-input,x-form-cb-default,x-keyboard-mode,x-opera,");
        this.c.addResolverProperties("redirectClasses", "x-form-radio=false,x-form-checkbox=false,");
        this.c.addResolverProperties("volatileClasses", "TableCell,TreeNode,");
        this.c.updateResolverProperties("treeResolver", "treeIndentationMode=treeOnlySpacer");
        this.c.updateResolverProperties("treeResolver", "postExpansionDelay=1000");
        System.setProperty("qftest.web.inject_js", "window.MSPointerEvent = null;window.PointerEvent = null;");
    }

    public class ExtjsGenericInterestingParentHandler
    extends GenericInterestingParentHandler {
        @Override
        public Boolean isInterestingParent(Object object, boolean bl2) {
            if (bl2 && object instanceof DomNode && "SPAN".equals(((DomNode)object).getName()) && ((DomNode)object).hasCSSClass("x-form-checkbox")) {
                if (k.level >= 9) {
                    ((LevelAwareLogBuilder)k.lvlBuild(9, "ExtjsGenericInterestingParentHandler.isInterestingParent(Object,boolean)", 339).add("x-form-checkbox override", object)).log();
                }
                return Boolean.FALSE;
            }
            return null;
        }
    }

    public class ExtjsGenericMainAndWholeTextHandler
    extends GenericMainAndWholeTextHandler {
        @Override
        public String getTextBase(Object object) {
            Node[] nodeArray;
            if (k.level >= 7) {
                ((LevelAwareLogBuilder)k.lvlBuild(7, "ExtjsGenericMainAndWholeTextHandler.getTextBase(Object)", 280).addDetail("element", object)).log();
            }
            if (!(object instanceof DomNode)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            if (domNode.isMatchingClass("Item:TabPanelItem") && (nodeArray = domNode.getChildrenByTagName("SPAN")) != null && nodeArray.length == 2) {
                String string = nodeArray[0].getText();
                return Util.getCleanElementText((String)string);
            }
            if (domNode.isMatchingClass(new String[]{"TreeNode", "TableCell"})) {
                for (Node node : nodeArray = domNode.getElementsByTagName("SPAN")) {
                    DomNode domNode2 = (DomNode)node;
                    String string = domNode2.getAttribute("class");
                    if (string == null || !string.contains("x-tree-node-text")) continue;
                    return Util.getCleanElementText((String)domNode2.getText());
                }
            }
            return super.getTextBase(object);
        }
    }

    public class ExtjsGenericTableAndTreeAndTreeTableHandler
    extends GenericTableAndTreeAndTreeTableHandler {
        @Override
        public int calculateNodeIndentation(DomNode domNode, DomNode domNode2) {
            ElementHelper.Geometry geometry;
            DomNode domNode3;
            if ("x-treelist-row".equals(domNode2.getClassName()) && (domNode3 = this.getTextNode(domNode, domNode2)) != null && (geometry = this.C.getLocationInParent(domNode3, domNode)) != null) {
                return geometry.x;
            }
            return super.calculateNodeIndentation(domNode, domNode2);
        }
    }

    public class ExtjsGenericEnabledHandler
    extends GenericEnabledHandler {
        @Override
        public Boolean isEnabled(Object object, boolean bl2) {
            String string;
            if (k.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)k.lvlBuild(7, "ExtjsGenericEnabledHandler.isEnabled(Object,boolean)", 184).addDetail("element", object)).addDetail("enabled", bl2)).log();
            }
            if (!(object instanceof DomNode)) {
                return false;
            }
            DomNode domNode = (DomNode)object;
            if (domNode.isValid() && domNode.isShowing() && domNode.isMatchingClass("Item:TabPanelItem") && (string = domNode.getAttribute("class")) != null && string.contains("disabled")) {
                return false;
            }
            return null;
        }
    }
}

