/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.resolvers.web;

import de.qfs.apps.qftest.client.resolvers.web.ZKResolver_1_0_0;
import de.qfs.apps.qftest.client.resolvers.web.ZKResolver_1_1_1;
import de.qfs.apps.qftest.client.resolvers.web.generic.GenericTooltipHandler;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public class ZKResolver_1_2_0
extends ZKResolver_1_1_1 {
    private static final QFLogger g = new QFLogger("de.qfs.apps.qftest.client.resolvers.web.ZKResolver_1_2_0");

    @Override
    public void preBasicResolverInstall() {
        if (ZKResolver_1_2_0.g.level >= 7) {
            g.lvlBuild(7, "preBasicResolverInstall()", 62).log();
        }
        super.preBasicResolverInstall();
        this.c.setGenericMainAndWholeTextHandler(new ZKGenericMainAndWholeTextHandler());
        this.c.setGenericChecker(new ZKGenericChecker());
        this.c.setGenericTooltipHandler(new ZKTooltipHandler());
    }

    @Override
    public void postBasicResolverInstall() {
        if (ZKResolver_1_2_0.g.level >= 7) {
            g.lvlBuild(7, "postBasicResolverInstall()", 82).log();
        }
        super.postBasicResolverInstall();
        this.c.getGenericTableAndTreeAndTreeTableHandler().setAutoExpansionClickMode("semihard");
        this.c.addResolverProperties("tagsToGenericClasses", "LI=MenuItem@::ancestor=Menu,");
    }

    public class ZKGenericChecker
    extends ZKResolver_1_0_0.ZKGenericChecker {
        public ZKGenericChecker() {
            super(ZKResolver_1_2_0.this);
        }

        @Override
        public boolean isEnabled(DomNode domNode, DomNode domNode2) {
            String string;
            if (g.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "ZKGenericChecker.isEnabled(DomNode,DomNode)", 271).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
            }
            if (domNode2.isMatchingClass("Item") || domNode2.isMatchingClass("TreeNode")) {
                String string2 = domNode2.getAttribute("class");
                if (!Misc.emptyOrNull((String)string2) && string2.indexOf("-disabled") != -1) {
                    return false;
                }
            } else if (domNode2.isMatchingClass("TableCell") && !Misc.emptyOrNull((String)(string = domNode2.getAttribute("class")))) {
                if (string.indexOf("-disabled") != -1) {
                    return false;
                }
                Node node = domNode2.getAncestorOfClass("TableRow");
                if (node != null && !Misc.emptyOrNull((String)(string = node.getAttribute("class"))) && string.indexOf("-disabled") != -1) {
                    return false;
                }
            }
            return super.isEnabled(domNode, domNode2);
        }
    }

    public class ZKTooltipHandler
    extends GenericTooltipHandler {
        @Override
        public String getTooltip(DomNode domNode, String string) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            block13: {
                if (g.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(7, "ZKTooltipHandler.getTooltip(DomNode,String)", 174).addDetail("element", (Object)domNode)).addDetail("tooltip", string)).log();
                }
                object4 = null;
                try {
                    object4 = domNode.callJS("var w = zk.Widget.$(_qf_node); return (w == null ? w : w.getTooltip());");
                }
                catch (TestException testException) {
                    if (g.level < 3) break block13;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)g.lvlBuild(3, "ZKTooltipHandler.getTooltip(DomNode,String)", 182).add("e", (Object)testException)).add("Couldn't read ZK tooltip.")).log();
                }
            }
            DocumentNode documentNode = domNode.getDocument();
            if (object4 != null) {
                object3 = object4.toString();
                if (g.level >= 9) {
                    ((LevelAwareLogBuilder)g.lvlBuild(9, "ZKTooltipHandler.getTooltip(DomNode,String)", 188).add("Value of tooltip id: ", (String)object3)).log();
                }
                if (!Misc.emptyOrNull((String)object3) && (object2 = documentNode.getElementById((String)object3)) != null) {
                    Node node;
                    if (g.level >= 9) {
                        ((LevelAwareLogBuilder)g.lvlBuild(9, "ZKTooltipHandler.getTooltip(DomNode,String)", 192).add("Get text of tooltipNode: ", object2)).log();
                    }
                    if (Misc.emptyOrNull((String)(object = Util.getCleanElementText((String)((Node)object2).getText()))) && (node = ((Node)object2).getAncestorOfClass("z-popup-content")) != null) {
                        object = Util.getCleanElementText((String)node.getText());
                    }
                    if (!Misc.emptyOrNull((String)object)) {
                        return object;
                    }
                }
            }
            object3 = null;
            object2 = documentNode.getElementsByClassName("z-popup");
            object = object2;
            int n2 = ((Node[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = object[i2];
                if (!(node instanceof DomNode)) continue;
                Integer n3 = ((DomNode)node).getZIndex();
                if (object3 == null && n3 != null) {
                    object3 = (DomNode)node;
                    continue;
                }
                if (n3 == null || ((DomNode)object3).getZIndex() >= n3) continue;
                object3 = (DomNode)node;
            }
            if (object3 != null && !Misc.emptyOrNull((String)(object = Util.getCleanElementText((String)((Node)object3).getText())))) {
                return object;
            }
            if (g.level >= 9) {
                ((LevelAwareLogBuilder)g.lvlBuild(9, "ZKTooltipHandler.getTooltip(DomNode,String)", 234).add("nothing found, go for default.")).log();
            }
            return null;
        }
    }

    public class ZKGenericMainAndWholeTextHandler
    extends ZKResolver_1_1_1.ZKGenericMainAndWholeTextHandler {
        public ZKGenericMainAndWholeTextHandler() {
            super(ZKResolver_1_2_0.this);
        }

        @Override
        public String getTextBase(Object object, String string) {
            if (!(object instanceof DomNode)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            String string2 = super.getTextBase(object, string);
            if (domNode.isMatchingClass(new String[]{"TreeNode", "TableCell"})) {
                DomNode domNode2;
                if (g.level >= 9) {
                    ((LevelAwareLogBuilder)g.lvlBuild(9, "ZKGenericMainAndWholeTextHandler.getTextBase(Object,String)", 119).add("Fix 1.1.1 text for tree nodes and table cells.")).log();
                }
                if (!(domNode.getAncestorOfClass("Tree") == null && domNode.getAncestorOfClass("TreeTable") == null || Misc.emptyOrNull((String)string) || (domNode2 = domNode.getElementByClassName(new String[]{"z-treecell-text", "z-label"})) == null)) {
                    string = Util.replaceNBSP((String)string);
                    string = string.replaceFirst("^(\\s)+", "");
                    return string;
                }
                return string;
            }
            if (domNode.isMatchingClass(new String[]{"TextField:CalendarTextField"})) {
                DomNode domNode3 = domNode.getElementByClassName("INPUT:TEXT");
                if (domNode3 != null) {
                    return domNode.getHelper().getWholeText(domNode3);
                }
            } else if (domNode.isMatchingClass(new String[]{"z-chosenbox"})) {
                return Util.getCleanElementText((String)domNode.getVisibleSimpleText());
            }
            return string2;
        }
    }
}

