/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.resolvers.web.generic;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.ElementDestroyedException;
import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.resolvers.web.BasicResolverInterface;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.check.BaseChecker;
import de.qfs.apps.qftest.client.web.check.ListChecker;
import de.qfs.apps.qftest.client.web.check.TableChecker;
import de.qfs.apps.qftest.client.web.check.TreeChecker;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.CheckerHelper;
import de.qfs.apps.qftest.extensions.checks.CheckerRegistry;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.web.TableHelper;
import de.qfs.apps.qftest.extensions.web.TreeHelper;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;

public class GenericChecker
extends BaseChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.resolvers.web.generic.GenericChecker");
    private BasicResolverInterface b;
    protected ArrayList checkerClasses = new ArrayList();
    protected GenericListChecker genericListChecker;
    protected GenericComboListChecker genericComboListChecker;
    protected GenericAccordionChecker genericAccordionChecker;
    protected GenericTabPanelChecker genericTabPanelChecker;
    protected GenericTableChecker tableChecker;
    protected GenericTreeChecker treeChecker;
    protected GenericTreeTableTreeChecker treeTableTreeChecker;
    protected boolean excludeHiddenItems;
    private WebEngine c;

    public GenericChecker(WebHelper webHelper) {
        super(webHelper);
    }

    public GenericChecker() {
        super(null);
        this.c = (WebEngine)Engine.threadInstance("web");
        this.helper = this.c.getHelper();
    }

    public GenericChecker(WebEngine webEngine) {
        super(null);
        this.c = webEngine;
        this.helper = webEngine.getHelper();
    }

    public void setBasicResolver(BasicResolverInterface basicResolverInterface) {
        this.b = basicResolverInterface;
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 186).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        if (domNode.isMatchingClass("MenuItem")) {
            DomNode domNode2 = this.getSelectableItemContent(null, domNode);
            if (domNode2 != null) {
                arrayList.add(CheckType.TEXT);
                arrayList.add(CheckType.SELECTED);
                arrayList.add(CheckType.ENABLED);
            } else {
                arrayList.add(CheckType.TEXT);
                arrayList.add(CheckType.ENABLED);
            }
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("CheckBox")) {
            arrayList.add(CheckType.CHECKED);
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("RadioButton")) {
            arrayList.add(CheckType.CHECKED);
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("ToggleButton")) {
            arrayList.add(CheckType.CHECKED);
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("TextField")) {
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.EDITABLE);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("TextArea")) {
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.EDITABLE);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("Spinner")) {
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.EDITABLE);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("ComboBox")) {
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.EDITABLE);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("Item")) {
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.EDITABLE);
            arrayList.add(CheckType.ENABLED);
            return arrayList.toArray(new CheckType[0]);
        }
        if (domNode.isMatchingClass("Window") && (domNode.getElementByClassName("Label:WindowTitle", "Window") != null || this.b.getGenericFeatureHandler().maybeAssignWindowTitle(domNode) != null)) {
            arrayList.add(CheckType.TITLE);
        }
        if (domNode.isMatchingClass("Panel") && (domNode.getElementsByClassName("Label:PanelTitle", "Panel") != null || this.b.getGenericFeatureHandler().maybeAssignPanelTitle(domNode) != null)) {
            arrayList.add(CheckType.TITLE);
        }
        for (String string : this.checkerClasses) {
            if (!domNode.isMatchingClass(string)) continue;
            arrayList.add(CheckType.TEXT);
            arrayList.add(CheckType.ENABLED);
            break;
        }
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) {
        String string;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 303).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier())) && (domNode.isMatchingClass("CheckBox") || domNode.isMatchingClass("RadioButton") || domNode.isMatchingClass("ToggleButton"))) {
            return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), this.isChecked(null, domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.CHECKED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.CHECKED.getIdentifier(), this.isChecked(null, domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.SELECTED.getIdentifier(), this.isSelected(null, domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.ENABLED.getIdentifier(), this.isEnabled(null, domNode));
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.EDITABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new BooleanCheckData(CheckType.EDITABLE.getIdentifier(), this.isEditable(null, domNode));
        }
        if (checkType.getDataType() == CheckDataType.STRING && CheckType.TITLE.getIdentifier().equals(checkType.getIdentifier()) && (string = this.getTitle(null, domNode)) != null) {
            return new StringCheckData(CheckType.TITLE.getIdentifier(), string);
        }
        return null;
    }

    public boolean isSelected(DomNode domNode, DomNode domNode2) {
        String string;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isSelected(DomNode,DomNode)", 375).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        if (domNode2 == null) {
            return false;
        }
        if (domNode2.isMatchingClass("OPTION")) {
            String string2 = domNode2.getAttribute("selected");
            return "1".equals(string2) || "selected".equals(string2);
        }
        if (!Options.cached_OPT_WEB_IGNORE_ARIA_ATTRIBUTES && !Misc.emptyOrNull((String)(string = domNode2.getAttribute("aria-selected")))) {
            return string.equals("true");
        }
        string = domNode2.getAttribute("class");
        if (!Misc.emptyOrNull((String)string)) {
            return string.contains("selected") || string.contains("active") || string.contains("highlight");
        }
        return false;
    }

    public boolean isChecked(DomNode domNode, DomNode domNode2) {
        Object object;
        Object object2;
        Object object3;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isChecked(DomNode,DomNode)", 422).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        if (domNode2 == null) {
            return false;
        }
        if (domNode2.isMatchingClass(new String[]{"INPUT:CHECKBOX", "INPUT:RADIO"})) {
            return "1".equals(domNode2.getAttribute("checked"));
        }
        if (domNode2.isMatchingClass(new String[]{"CheckBox", "RadioButton"})) {
            object3 = domNode2.getElementByClassName(new String[]{"INPUT:CHECKBOX", "INPUT:RADIO"});
            if (object3 != null) {
                return "1".equals(((DomNode)object3).getAttribute("checked"));
            }
            if ("LABEL".equals(domNode2.getTagName()) && domNode2.getAttribute("for") != null && (object2 = domNode2.getParent()) != null) {
                object = ((Node)object2).getElementsByClassName("INPUT");
                for (int i2 = 0; i2 < ((Node[])object).length; ++i2) {
                    String string;
                    String string2 = object[i2].getAttribute("id");
                    String string3 = domNode2.getAttribute("for");
                    if (string3 == null || string2 == null || !string2.equals(string3) || (string = ((DomNode)object[i2]).getAttribute("checked")) == null || !"checked".equals(string) && !"1".equals(string)) continue;
                    return true;
                }
            }
        }
        if (domNode2.isMatchingClass(new String[]{"Item", "TreeNode", "TableCell"}) && (object3 = domNode2.getElementByClassName(new String[]{"CheckBox", "RadioButton"})) != null) {
            return this.isChecked(domNode, (DomNode)object3);
        }
        if (!Options.cached_OPT_WEB_IGNORE_ARIA_ATTRIBUTES) {
            object3 = domNode2.getAttribute("aria-checked");
            if (!Misc.emptyOrNull((String)object3)) {
                return ((String)object3).equals("true") || ((String)object3).equals("mixed");
            }
            object2 = domNode2.getAttribute("aria-pressed");
            if (!Misc.emptyOrNull((String)object2)) {
                return ((String)object2).equals("true") || ((String)object2).equals("mixed");
            }
            object = domNode2.getAttribute("aria-selected");
            if (!Misc.emptyOrNull((String)object)) {
                if (((String)object).equals("true")) {
                    return true;
                }
                if (((String)object).equals("false")) {
                    return false;
                }
            }
        }
        if (!Misc.emptyOrNull((String)(object3 = domNode2.getAttribute("class")))) {
            return ((String)object3).contains("checked") && !((String)object3).contains("unchecked") || ((String)object3).contains("pressed") || ((String)object3).contains("active");
        }
        return false;
    }

    public boolean isEnabled(DomNode domNode, DomNode domNode2) {
        Node node;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isEnabled(DomNode,DomNode)", 519).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        if (domNode2 == null) {
            return false;
        }
        if (domNode2.isMatchingClass(new String[]{"CheckBox", "RadioButton"}) && "LABEL".equals(domNode2.getTagName()) && domNode2.getAttribute("for") != null && (node = domNode2.getParent()) != null) {
            Node[] nodeArray = node.getElementsByClassName("INPUT");
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                String string;
                String string2 = nodeArray[i2].getAttribute("id");
                String string3 = domNode2.getAttribute("for");
                if (string3 == null || string2 == null || !string2.equals(string3) || (string = ((DomNode)nodeArray[i2]).getAttribute("disabled")) == null || !"disabled".equals(string)) continue;
                return false;
            }
        }
        return this.helper.isEnabled(domNode2);
    }

    public String getTitle(DomNode domNode, DomNode domNode2) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getTitle(DomNode,DomNode)", 561).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        if (domNode2.isMatchingClass("Panel")) {
            return this.b.getGenericFeatureHandler().maybeAssignPanelTitle(domNode2);
        }
        if (domNode2.isMatchingClass("Window")) {
            return this.b.getGenericFeatureHandler().maybeAssignWindowTitle(domNode2);
        }
        return null;
    }

    public boolean isEditable(DomNode domNode, DomNode domNode2) {
        DomNode domNode3;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isEditable(DomNode,DomNode)", 588).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        if (domNode2 != null && domNode2.isMatchingClass(new String[]{"Spinner", "ComboBox"}) && (domNode3 = domNode2.getElementByClassName("TextField")) != null) {
            return this.isEditable(domNode, domNode3);
        }
        return this.helper.isEditable(domNode2);
    }

    public DomNode getSelectableItemContent(DomNode domNode, DomNode domNode2) {
        DomNode domNode3;
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSelectableItemContent(DomNode,DomNode)", 614).addDetail("container", (Object)domNode)).addDetail("node", (Object)domNode2)).log();
        }
        DomNode domNode4 = null;
        if (domNode != null && domNode2 != null && domNode2.isMatchingClass(new String[]{"TreeNode", "TableCell", "Item"}) && domNode2.getHelper().isDescendingFrom(domNode2, domNode) && (domNode4 = domNode2.getElementByClassName(new String[]{"CheckBox", "RadioButton"})) == null && (domNode3 = (DomNode)domNode2.getParent()) != null) {
            domNode4 = domNode3.getElementByClassName(new String[]{"CheckBox", "RadioButton"});
        }
        return domNode4;
    }

    public boolean getExcludeHiddenListItems() {
        return this.excludeHiddenItems;
    }

    public final void setExcludeHiddenListItems(boolean bl2) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExcludeHiddenListItems(boolean)", 663).addDetail("excludeHiddenItems", bl2)).log();
        }
        this.excludeHiddenItems = bl2;
        if (this.genericListChecker != null) {
            this.genericListChecker.setExcludeHiddenItems(bl2);
        }
        if (this.genericComboListChecker != null) {
            this.genericComboListChecker.setExcludeHiddenItems(bl2);
        }
        if (this.genericAccordionChecker != null) {
            this.genericAccordionChecker.setExcludeHiddenItems(bl2);
        }
        if (this.genericTabPanelChecker != null) {
            this.genericTabPanelChecker.setExcludeHiddenItems(bl2);
        }
    }

    public void register() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "register()", 689).log();
        }
        this.checkerClasses.add("MenuItem");
        this.checkerClasses.add("ToolBarItem");
        this.checkerClasses.add("Button");
        this.checkerClasses.add("CheckBox");
        this.checkerClasses.add("RadioButton");
        this.checkerClasses.add("ToggleButton");
        this.checkerClasses.add("TextField");
        this.checkerClasses.add("TextArea");
        this.checkerClasses.add("Spinner");
        this.checkerClasses.add("ComboBox");
        this.checkerClasses.add("List");
        this.checkerClasses.add("Accordion");
        this.checkerClasses.add("TabPanel");
        this.checkerClasses.add("Table");
        this.checkerClasses.add("Tree");
        this.checkerClasses.add("TreeTable");
        this.checkerClasses.add("TableCell");
        this.checkerClasses.add("TreeNode");
        this.checkerClasses.add("Label");
        this.checkerClasses.add("Link");
        this.checkerClasses.add("ProgressBar");
        this.checkerClasses.add("Slider");
        this.checkerClasses.add("Menu");
        this.checkerClasses.add("Toolbar");
        this.checkerClasses.add("ToolTip");
        this.checkerClasses.add("Calendar");
        this.checkerClasses.add("ScrollBar");
        this.checkerClasses.add("Popup");
        this.checkerClasses.add("Panel");
        this.checkerClasses.add("SplitPanel");
        this.checkerClasses.add("Indicator");
        this.checkerClasses.add("Window");
        for (String string : this.checkerClasses) {
            CheckerRegistry.instance().registerChecker(string, (Checker)this);
        }
        if (this.genericListChecker == null) {
            this.genericListChecker = new GenericListChecker(this.c);
        }
        this.genericListChecker.setExcludeHiddenItems(this.getExcludeHiddenListItems());
        CheckerRegistry.instance().registerChecker("List", (Checker)this.genericListChecker);
        this.checkerClasses.add("List");
        if (this.genericComboListChecker == null) {
            this.genericComboListChecker = new GenericComboListChecker(this.c);
        }
        this.genericComboListChecker.setExcludeHiddenItems(this.getExcludeHiddenListItems());
        CheckerRegistry.instance().registerChecker("List:ComboBoxList", (Checker)this.genericComboListChecker);
        this.checkerClasses.add("List:ComboBoxList");
        if (this.genericAccordionChecker == null) {
            this.genericAccordionChecker = new GenericAccordionChecker(this.c);
        }
        this.genericAccordionChecker.setExcludeHiddenItems(this.getExcludeHiddenListItems());
        CheckerRegistry.instance().registerChecker("Accordion", (Checker)this.genericAccordionChecker);
        this.checkerClasses.add("Accordion");
        if (this.genericTabPanelChecker == null) {
            this.genericTabPanelChecker = new GenericTabPanelChecker(this.c);
        }
        this.genericTabPanelChecker.setExcludeHiddenItems(this.getExcludeHiddenListItems());
        CheckerRegistry.instance().registerChecker("TabPanel", (Checker)this.genericTabPanelChecker);
        this.checkerClasses.add("TabPanel");
        if (this.treeChecker == null) {
            this.treeChecker = new GenericTreeChecker();
        }
        if (this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTreeHelperResolver() != null) {
            this.treeChecker.setTreeHelper(this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTreeHelperResolver());
            this.treeChecker.register();
        }
        if (this.tableChecker == null) {
            this.tableChecker = new GenericTableChecker();
        }
        if (this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTableHelper() != null) {
            this.tableChecker.setTableHelper(this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTableHelper());
            this.tableChecker.register();
        }
        if (this.treeTableTreeChecker == null) {
            this.treeTableTreeChecker = new GenericTreeTableTreeChecker(this.tableChecker);
        }
        if (this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTreeTableHelperResolver() != null) {
            this.treeTableTreeChecker.setTreeHelper(this.b.getGenericTableAndTreeAndTreeTableHandler().getGenericTreeTableHelperResolver());
            this.treeTableTreeChecker.register();
        }
    }

    public void unregister() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 804).log();
        }
        for (int i2 = 0; i2 < this.checkerClasses.size(); ++i2) {
            String string = (String)this.checkerClasses.get(i2);
            CheckerRegistry.instance().unregisterCheckers(string);
        }
        this.checkerClasses.clear();
        this.treeChecker.unregister();
        this.tableChecker.unregister();
    }

    public void setGenericListChecker(GenericListChecker genericListChecker) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setGenericListChecker(GenericListChecker)", 830).addDetail("genericListChecker", (Object)genericListChecker)).log();
        }
        this.genericListChecker = genericListChecker;
    }

    public GenericListChecker getGenericListChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericListChecker()", 844).log();
        }
        return this.genericListChecker;
    }

    public void setGenericComboListChecker(GenericComboListChecker genericComboListChecker) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setGenericComboListChecker(GenericComboListChecker)", 858).addDetail("genericComboListChecker", (Object)genericComboListChecker)).log();
        }
        this.genericComboListChecker = genericComboListChecker;
    }

    public GenericComboListChecker getGenericComboListChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericComboListChecker()", 872).log();
        }
        return this.genericComboListChecker;
    }

    public void setGenericAccordionChecker(GenericAccordionChecker genericAccordionChecker) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setGenericAccordionChecker(GenericAccordionChecker)", 886).addDetail("genericAccordionChecker", (Object)genericAccordionChecker)).log();
        }
        this.genericAccordionChecker = genericAccordionChecker;
    }

    public GenericAccordionChecker getGenericAccordionChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericAccordionChecker()", 900).log();
        }
        return this.genericAccordionChecker;
    }

    public void setGenericTabPanelChecker(GenericTabPanelChecker genericTabPanelChecker) {
        if (GenericChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setGenericTabPanelChecker(GenericTabPanelChecker)", 915).addDetail("genericTabPanelChecker", (Object)genericTabPanelChecker)).log();
        }
        this.genericTabPanelChecker = genericTabPanelChecker;
    }

    public GenericTabPanelChecker getGenericTabPanelChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericTabPanelChecker()", 929).log();
        }
        return this.genericTabPanelChecker;
    }

    public GenericTableChecker getGenericTableChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericTableChecker()", 943).log();
        }
        return this.tableChecker;
    }

    public void setGenericTreeChecker(GenericTreeChecker genericTreeChecker) {
        this.treeChecker = genericTreeChecker;
    }

    public GenericTreeChecker getGenericTreeChecker() {
        if (GenericChecker.a.level >= 7) {
            a.lvlBuild(7, "getGenericTreeChecker()", 970).log();
        }
        return this.treeChecker;
    }

    public void setGenericTableChecker(GenericTableChecker genericTableChecker) {
        this.tableChecker = genericTableChecker;
    }

    public class GenericTreeTableTreeChecker
    extends TreeChecker {
        private CheckType[] b;
        private CheckType[] c;
        private TableChecker d;

        public GenericTreeTableTreeChecker(TreeHelper treeHelper) {
            super(treeHelper);
            this.b = new CheckType[]{CheckType.VISIBLE_NESTED_NODES};
            this.c = new CheckType[]{CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
        }

        public GenericTreeTableTreeChecker(TableChecker tableChecker) {
            super(null);
            this.b = new CheckType[]{CheckType.VISIBLE_NESTED_NODES};
            this.c = new CheckType[]{CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
            this.d = tableChecker;
        }

        @Override
        public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
            CheckType[] checkTypeArray;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeTableTreeChecker.getSupportedCheckTypes(Object,Object)", 2519).addDetail("target", object)).addDetail("subItem", object2)).log();
            }
            if (!(object instanceof DomNode) || !this.helper.checkTree((DomNode)object)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            DomNode domNode2 = null;
            if (object2 != null) {
                try {
                    domNode2 = this.getElement(domNode, object2);
                    if (domNode2 == null || !this.helper.checkNode(domNode2)) {
                        return null;
                    }
                }
                catch (TestException testException) {
                    if (a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "GenericTreeTableTreeChecker.getSupportedCheckTypes(Object,Object)", 2536).add("ex", (Object)testException)).log();
                    }
                    return null;
                }
            }
            if (this.d != null && (checkTypeArray = this.d.getSupportedCheckTypes(object, object2)) != null) {
                ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
                for (CheckType checkType : checkTypeArray) {
                    if (checkType.getDataType() == CheckDataType.BOOLEAN) break;
                    arrayList.add(checkType);
                }
                if (object2 != null) {
                    arrayList.add(CheckType.VISIBLE_NESTED_SUBNODES);
                }
                arrayList.add(CheckType.VISIBLE_NESTED_NODES);
                return arrayList.toArray(new CheckType[0]);
            }
            return object2 == null ? this.b : this.c;
        }

        @Override
        public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeTableTreeChecker.getCheckData(Object,Object,CheckType)", 2580).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
            }
            if (!(object instanceof DomNode) || !this.helper.checkTree((DomNode)object)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            DomNode domNode2 = null;
            if (object2 != null) {
                try {
                    domNode2 = this.getElement(domNode, object2);
                    if (domNode2 == null || !this.helper.checkNode(domNode2)) {
                        return null;
                    }
                }
                catch (TestException testException) {
                    if (a.level >= 5) {
                        ((LevelAwareLogBuilder)a.lvlBuild(5, "GenericTreeTableTreeChecker.getCheckData(Object,Object,CheckType)", 2597).add("ex", (Object)testException)).log();
                    }
                    return null;
                }
            }
            String string = checkType.getIdentifier();
            String string2 = CheckType.NESTED_NODES.getIdentifier();
            String string3 = CheckType.VISIBLE_NESTED_NODES.getIdentifier();
            boolean bl2 = string2.equals(string);
            boolean bl3 = string3.equals(string);
            boolean bl4 = CheckType.NESTED_SUBNODES.getIdentifier().equals(string);
            boolean bl5 = CheckType.VISIBLE_NESTED_SUBNODES.getIdentifier().equals(string);
            if (object2 != null && checkType.getDataType() == CheckDataType.STRING_LIST && ((bl2 || bl3) && !Client.instance().isCaptureContext() || bl4 || bl5)) {
                boolean bl6 = bl3 || bl5;
                try {
                    ArrayList arrayList = new ArrayList();
                    this.helper.setTree(domNode);
                    TreeUtil.traverse((TreeAdapter)this.helper, (Object)domNode2, (TraversalCallback)new TreeChecker.a(domNode, arrayList, !bl6));
                    String string4 = bl6 ? string3 : string2;
                    return new StringItemsCheckData(string4, arrayList.toArray(new String[0]));
                }
                catch (Exception exception) {
                    if (a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "GenericTreeTableTreeChecker.getCheckData(Object,Object,CheckType)", 2621).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            if (checkType.getDataType() == CheckDataType.STRING_LIST && (bl2 || bl3) && (object2 == null || Client.instance().isCaptureContext())) {
                try {
                    ArrayList arrayList = new ArrayList();
                    this.helper.setTree(domNode);
                    DomNode domNode3 = this.helper.getRootNode(domNode);
                    DomNode[] domNodeArray = domNode3 == domNode ? this.helper.getChildNodes(domNode, domNode3) : new DomNode[]{domNode3};
                    for (DomNode domNode4 : domNodeArray) {
                        TreeUtil.traverse((TreeAdapter)this.helper, (Object)domNode4, (TraversalCallback)new TreeChecker.a(domNode, arrayList, !bl3));
                    }
                    return new StringItemsCheckData(string, arrayList.toArray(new String[0]));
                }
                catch (Exception exception) {
                    if (a.level >= 1) {
                        ((LevelAwareLogBuilder)a.lvlBuild(1, "GenericTreeTableTreeChecker.getCheckData(Object,Object,CheckType)", 2644).add("ex", (Object)exception)).log();
                    }
                    return null;
                }
            }
            return super.getCheckData(object, object2, checkType);
        }

        protected DomNode getElement(DomNode domNode, Object object) throws TestException {
            return (DomNode)ItemRegistry.instance().getElement(domNode, object);
        }

        @Override
        public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
            CheckData checkData;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeTableTreeChecker.getCheckDataAndItem(Object,Object,CheckType)", 2676).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
            }
            if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
                return null;
            }
            String string = checkType.getIdentifier();
            if (CheckType.NODE.getIdentifier().equals(string) || CheckType.NODE_VISIBLE.getIdentifier().equals(string) || CheckType.VISIBLE.getIdentifier().equals(string) && object2 != null || CheckType.ENABLED.getIdentifier().equals(string) && object2 != null || CheckType.IMAGE.getIdentifier().equals(string) && object2 != null || CheckType.NODE_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_ENABLED.getIdentifier().equals(string) || CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_CHECKED.getIdentifier().equals(string) || CheckType.NODE_ICON_IMAGE.getIdentifier().equals(string)) {
                return new Pair((Object)checkData, object2);
            }
            return super.getCheckDataAndItem(object, object2, checkType);
        }

        public void setTreeHelper(TreeHelper treeHelper) {
            this.helper = treeHelper;
        }
    }

    public class GenericTreeChecker
    extends TreeChecker {
        private CheckType[] b;
        private CheckType[] c;

        public GenericTreeChecker(TreeHelper treeHelper) {
            super(treeHelper);
            this.b = new CheckType[]{CheckType.VISIBLE_NESTED_NODES};
            this.c = new CheckType[]{CheckType.NODE, CheckType.NODE_SELECTED, CheckType.NODE_VISIBLE, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
        }

        public GenericTreeChecker() {
            super(null);
            this.b = new CheckType[]{CheckType.VISIBLE_NESTED_NODES};
            this.c = new CheckType[]{CheckType.NODE, CheckType.NODE_SELECTED, CheckType.NODE_VISIBLE, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
        }

        @Override
        public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
            DomNode[] domNodeArray;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeChecker.getSupportedCheckTypes(Object,Object)", 2231).addDetail("target", object)).addDetail("subItem", object2)).log();
            }
            if (!(object instanceof DomNode) || !this.helper.checkTree((DomNode)object)) {
                return null;
            }
            if (!(object2 == null || object2 instanceof DomNode && this.helper.checkNode((DomNode)object2))) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            DomNode domNode2 = (DomNode)object2;
            boolean bl2 = false;
            boolean bl3 = false;
            DomNode domNode3 = GenericChecker.this.getSelectableItemContent(domNode, domNode2);
            if (domNode3 != null) {
                bl2 = true;
            }
            if ((domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                bl3 = true;
            }
            if (bl2 && bl3) {
                return new CheckType[]{CheckType.NODE, CheckType.NODE_SELECTED, CheckType.NODE_CHECKED, CheckType.NODE_VISIBLE, CheckType.NODE_ICON_IMAGE, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
            }
            if (bl2 && !bl3) {
                return new CheckType[]{CheckType.NODE, CheckType.NODE_SELECTED, CheckType.NODE_VISIBLE, CheckType.NODE_CHECKED, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
            }
            if (!bl2 && bl3) {
                return new CheckType[]{CheckType.NODE, CheckType.NODE_SELECTED, CheckType.NODE_VISIBLE, CheckType.NODE_ICON_IMAGE, CheckType.VISIBLE_NESTED_SUBNODES, CheckType.VISIBLE_NESTED_NODES};
            }
            return object2 == null ? this.b : this.c;
        }

        @Override
        public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeChecker.getCheckData(Object,Object,CheckType)", 2305).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
            }
            if (!(object instanceof DomNode) || !this.helper.checkTree((DomNode)object)) {
                return null;
            }
            if (!(object2 == null || object2 instanceof DomNode && this.helper.checkNode((DomNode)object2))) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            DomNode domNode2 = (DomNode)object2;
            if (object2 != null) {
                DomNode[] domNodeArray;
                if (checkType.getDataType() == CheckDataType.STRING && ("default".equals(checkType.getIdentifier()) || CheckType.NODE.getIdentifier().equals(checkType.getIdentifier()) || "node".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                    if (domNode2 != null) {
                        return new StringCheckData(CheckType.ITEM.getIdentifier(), this.helper.getValue(domNode, domNode2));
                    }
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), "");
                }
                if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || "node_checked".equals(checkType.getIdentifier()) || CheckType.ITEM_CONTENT_SELECTED.getIdentifier().equals(checkType.getIdentifier())) && (domNodeArray = GenericChecker.this.getSelectableItemContent(domNode, domNode2)) != null) {
                    return new BooleanCheckData(CheckType.ITEM_CHECKED.getIdentifier(), GenericChecker.this.isChecked(domNode, domNode2));
                }
                if (checkType.getDataType() == CheckDataType.IMAGE && CheckType.NODE_ICON_IMAGE.getIdentifier().equals(checkType.getIdentifier()) && (domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                    WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
                    WebHelper webHelper = webEngine.getHelper();
                    ImageRep imageRep = webHelper.captureImage(domNodeArray[0]);
                    if (a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTreeChecker.getCheckData(Object,Object,CheckType)", 2359).add("image", (Object)imageRep)).log();
                    }
                    if (imageRep == null) {
                        if (a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "GenericTreeChecker.getCheckData(Object,Object,CheckType)", 2361).add("Cannot grab image for ", object)).log();
                        }
                    } else {
                        return new ImageCheckData(CheckType.NODE_ICON_IMAGE.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                    }
                }
                if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "node_visible".equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier()))) {
                    return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), domNode2.getHelper().isVisible(domNode2));
                }
                if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.NODE_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "node_selected".equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()))) {
                    return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), GenericChecker.this.isSelected(domNode, domNode2));
                }
                if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
                    return new BooleanCheckData(CheckType.ITEM_ENABLED.getIdentifier(), GenericChecker.this.isEnabled(domNode, domNode2));
                }
            }
            return super.getCheckData(object, object2, checkType);
        }

        @Override
        public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
            CheckData checkData;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTreeChecker.getCheckDataAndItem(Object,Object,CheckType)", 2414).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
            }
            if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
                return null;
            }
            String string = checkType.getIdentifier();
            if (CheckType.NODE.getIdentifier().equals(string) || CheckType.NODE_VISIBLE.getIdentifier().equals(string) || CheckType.VISIBLE.getIdentifier().equals(string) && object2 != null || CheckType.ENABLED.getIdentifier().equals(string) && object2 != null || CheckType.IMAGE.getIdentifier().equals(string) && object2 != null || CheckType.NODE_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_ENABLED.getIdentifier().equals(string) || CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_CHECKED.getIdentifier().equals(string) || CheckType.NODE_ICON_IMAGE.getIdentifier().equals(string)) {
                return new Pair((Object)checkData, object2);
            }
            return super.getCheckDataAndItem(object, object2, checkType);
        }

        public void setTreeHelper(TreeHelper treeHelper) {
            this.helper = treeHelper;
        }
    }

    public class GenericTableChecker
    extends TableChecker {
        public GenericTableChecker(TableHelper tableHelper) {
            super(tableHelper);
        }

        public GenericTableChecker() {
            super(null);
        }

        @Override
        public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTableChecker.getSupportedCheckTypes(Object,Object)", 1658).addDetail("target", object)).addDetail("subItem", object2)).log();
            }
            if (object2 == null || !(object instanceof DomNode) || !this.helper.checkTable((DomNode)object)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            boolean bl2 = false;
            boolean bl3 = false;
            int n2 = -1;
            int n3 = -1;
            if (object2 != null) {
                n2 = ((int[])object2)[0];
                n3 = ((int[])object2)[1];
            }
            DomNode domNode2 = null;
            if (n2 >= 0 && n2 < this.helper.getColumnCount(domNode) && n3 >= 0) {
                domNode2 = this.helper.getCell(domNode, n3, n2);
            }
            if (GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().isTreeTable(domNode)) {
                if (domNode2 != null) {
                    DomNode[] domNodeArray;
                    DomNode domNode3 = GenericChecker.this.getSelectableItemContent(domNode, domNode2);
                    if (domNode3 != null) {
                        bl2 = true;
                    }
                    if ((domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                        bl3 = true;
                    }
                }
            } else if (domNode2 != null) {
                DomNode[] domNodeArray;
                DomNode domNode4 = GenericChecker.this.getSelectableItemContent(domNode, domNode2);
                if (domNode4 != null) {
                    bl2 = true;
                }
                if ((domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                    bl3 = true;
                }
            }
            if (n3 < 0) {
                if (bl3) {
                    return new CheckType[]{CheckType.HEADER_FOR_TABLE, CheckType.COLUMN, CheckType.COLUMN_VISIBLE, CheckType.TITLE_IMAGE};
                }
                return new CheckType[]{CheckType.HEADER_FOR_TABLE, CheckType.COLUMN, CheckType.COLUMN_VISIBLE};
            }
            if (bl2 && bl3) {
                return new CheckType[]{CheckType.CELL, CheckType.COLUMN, CheckType.ROW, CheckType.CELL_SELECTED, CheckType.CELL_CHECKED, CheckType.CELL_VISIBLE, CheckType.NODE_ICON_IMAGE};
            }
            if (bl2 && !bl3) {
                return new CheckType[]{CheckType.CELL, CheckType.COLUMN, CheckType.ROW, CheckType.CELL_SELECTED, CheckType.CELL_VISIBLE, CheckType.CELL_CHECKED};
            }
            if (!bl2 && bl3) {
                return new CheckType[]{CheckType.CELL, CheckType.COLUMN, CheckType.ROW, CheckType.CELL_SELECTED, CheckType.CELL_VISIBLE, CheckType.NODE_ICON_IMAGE};
            }
            return new CheckType[]{CheckType.CELL, CheckType.COLUMN, CheckType.ROW, CheckType.CELL_SELECTED, CheckType.CELL_VISIBLE};
        }

        @Override
        public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTableChecker.getCheckData(Object,Object,CheckType)", 1781).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
            }
            if (object2 == null) {
                return null;
            }
            if (!(object instanceof DomNode) || !this.helper.checkTable((DomNode)object)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            if (object2 != null) {
                int n2 = ((int[])object2)[0];
                int n3 = ((int[])object2)[1];
                DomNode domNode2 = null;
                if (n2 >= 0) {
                    DomNode domNode3 = domNode2 = n3 >= 0 ? this.helper.getCell(domNode, n3, n2) : this.helper.getHeaderCell(domNode, n2);
                }
                if (checkType.getDataType() == CheckDataType.STRING && n3 >= 0 && ("default".equals(checkType.getIdentifier()) || CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || "cell".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                    if (domNode2 != null) {
                        return new StringCheckData(CheckType.ITEM.getIdentifier(), this.helper.getValue(domNode, domNode2));
                    }
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), "");
                }
                if (checkType.getDataType() == CheckDataType.STRING && (n3 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || "cell".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier())) || CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier())) {
                    DomNode domNode4 = this.helper.getHeaderCell(domNode, n2);
                    if (domNode4 != null) {
                        return new StringCheckData(CheckType.HEADER_FOR_TABLE.getIdentifier(), this.helper.getValue(domNode, domNode4));
                    }
                    return new StringCheckData(CheckType.HEADER_FOR_TABLE.getIdentifier(), "");
                }
                if (domNode2 != null) {
                    if (GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().isTreeTable(domNode)) {
                        DomNode[] domNodeArray;
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CONTENT_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "cell_checked".equals(checkType.getIdentifier()) || CheckType.CELL_CHECKED.getIdentifier().equals(checkType.getIdentifier())) && (domNodeArray = GenericChecker.this.getSelectableItemContent(domNode, domNode2)) != null) {
                            return new BooleanCheckData(CheckType.ITEM_CHECKED.getIdentifier(), GenericChecker.this.isChecked(domNode, (DomNode)domNodeArray));
                        }
                        if (checkType.getDataType() == CheckDataType.IMAGE && CheckType.NODE_ICON_IMAGE.getIdentifier().equals(checkType.getIdentifier()) && (domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
                            WebHelper webHelper = webEngine.getHelper();
                            ImageRep imageRep = webHelper.captureImage(domNodeArray[0]);
                            if (a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getCheckData(Object,Object,CheckType)", 1863).add("image", (Object)imageRep)).log();
                            }
                            if (imageRep == null) {
                                if (a.level >= 3) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(3, "GenericTableChecker.getCheckData(Object,Object,CheckType)", 1865).add("Cannot grab image for ", object)).log();
                                }
                            } else {
                                return new ImageCheckData(checkType.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                            }
                        }
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "cell_selected".equals(checkType.getIdentifier()) || CheckType.CELL_SELECTED.getIdentifier().equals(checkType.getIdentifier())) {
                            return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), GenericChecker.this.isSelected(domNode, domNode2));
                        }
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "cell_visible".equals(checkType.getIdentifier()) || CheckType.COLUMN_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
                            return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), domNode.getHelper().isVisible(domNode2));
                        }
                    } else {
                        DomNode[] domNodeArray;
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && (CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || "cell_checked".equals(checkType.getIdentifier()) || CheckType.CELL_CHECKED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_CONTENT_SELECTED.getIdentifier().equals(checkType.getIdentifier())) && (domNodeArray = GenericChecker.this.getSelectableItemContent(domNode, domNode2)) != null) {
                            return new BooleanCheckData(CheckType.ITEM_CHECKED.getIdentifier(), GenericChecker.this.isChecked(domNode, (DomNode)domNodeArray));
                        }
                        if (checkType.getDataType() == CheckDataType.IMAGE && CheckType.NODE_ICON_IMAGE.getIdentifier().equals(checkType.getIdentifier()) && (domNodeArray = GenericChecker.this.b.getGenericTableAndTreeAndTreeTableHandler().getIconNodes(domNode, domNode2)).length > 0) {
                            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
                            WebHelper webHelper = webEngine.getHelper();
                            ImageRep imageRep = webHelper.captureImage(domNodeArray[0]);
                            if (a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getCheckData(Object,Object,CheckType)", 1918).add("image", (Object)imageRep)).log();
                            }
                            if (imageRep == null) {
                                if (a.level >= 3) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(3, "GenericTableChecker.getCheckData(Object,Object,CheckType)", 1920).add("Cannot grab image for ", object)).log();
                                }
                            } else {
                                return new ImageCheckData(checkType.getIdentifier(), imageRep, -1, -1, -1, -1, -1, -1, false);
                            }
                        }
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "cell_selected".equals(checkType.getIdentifier()) || CheckType.CELL_SELECTED.getIdentifier().equals(checkType.getIdentifier())) {
                            return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), GenericChecker.this.isSelected(domNode, domNode2));
                        }
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) || "cell_enabled".equals(checkType.getIdentifier()) || CheckType.ITEM_ENABLED.getIdentifier().equals(checkType.getIdentifier())) {
                            return new BooleanCheckData(CheckType.ITEM_ENABLED.getIdentifier(), GenericChecker.this.isEnabled(domNode, domNode2));
                        }
                        if (checkType.getDataType() == CheckDataType.BOOLEAN && CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "cell_visible".equals(checkType.getIdentifier()) || CheckType.COLUMN_VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || CheckType.ITEM_VISIBLE.getIdentifier().equals(checkType.getIdentifier())) {
                            return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), domNode.getHelper().isVisible(domNode2));
                        }
                    }
                }
                if (checkType.getDataType() == CheckDataType.STRING_LIST && (n3 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.COLUMN.getIdentifier().equals(checkType.getIdentifier()))) {
                    return this.getColumnForCheck(domNode, n2);
                }
                if (checkType.getDataType() == CheckDataType.STRING_LIST && n3 >= 0 && CheckType.ROW.getIdentifier().equals(checkType.getIdentifier())) {
                    return this.getRowForCheck(domNode, n3);
                }
            }
            return null;
        }

        @Override
        public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
            CheckData checkData;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTableChecker.getCheckDataAndItem(Object,Object,CheckType)", 1996).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
            }
            if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
                return null;
            }
            String string = checkType.getIdentifier();
            if (CheckType.CELL.getIdentifier().equals(string) || CheckType.ITEM_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_ENABLED.getIdentifier().equals(string) || CheckType.ITEM_VISIBLE.getIdentifier().equals(string) || CheckType.COLUMN_VISIBLE.getIdentifier().equals(string) || CheckType.NODE_CHECKBOX_SELECTED.getIdentifier().equals(string) || CheckType.ITEM_CHECKED.getIdentifier().equals(string) || CheckType.NODE_ICON_IMAGE.getIdentifier().equals(string) || CheckType.VISIBLE.getIdentifier().equals(string) && object2 != null || CheckType.ENABLED.getIdentifier().equals(string) && object2 != null) {
                return new Pair((Object)checkData, object2);
            }
            return super.getCheckDataAndItem(object, object2, checkType);
        }

        public void setTableHelper(TableHelper tableHelper) {
            this.helper = tableHelper;
        }

        @Override
        protected StringItemsCheckData getColumnForCheck(DomNode domNode, int n2) throws TestException {
            block10: {
                if (a.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTableChecker.getColumnForCheck(DomNode,int)", 2053).addDetail("table", (Object)domNode)).addDetail("col", n2)).log();
                }
                int n3 = this.helper.getRowCount(domNode);
                if (a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getColumnForCheck(DomNode,int)", 2056).add("count", n3)).log();
                }
                Pair pair = CheckerHelper.instance().getStartAndCountParameters(n3, domNode, new SubItemIndex[]{new SubItemIndex(n2)});
                try {
                    int[] nArray = (int[])pair.getFirst();
                    if (pair.getSecond() != null) {
                        nArray[0] = ((int[])pair.getSecond())[1];
                    }
                    int n4 = nArray[0];
                    if (nArray[1] >= 0) {
                        n3 = Math.min(n3, n4 + nArray[1]);
                    }
                    if (a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getColumnForCheck(DomNode,int)", 2069).add("start", n4)).add("count", n3)).log();
                    }
                    String[] stringArray = new String[Math.max(0, n3 - n4)];
                    String string = "";
                    for (int i2 = n4; i2 < n3; ++i2) {
                        DomNode domNode2 = this.helper.getCell(domNode, i2, n2);
                        string = domNode2 != null ? this.helper.getValue(domNode, domNode2) : "";
                        stringArray[i2 - n4] = string;
                    }
                    return new StringItemsCheckData(CheckType.COLUMN.getIdentifier(), stringArray);
                }
                catch (ElementDestroyedException elementDestroyedException) {
                    domNode.getDocument().invalidateStructure();
                    if (a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "GenericTableChecker.getColumnForCheck(DomNode,int)", 2087).add("ex", (Object)elementDestroyedException)).log();
                    }
                }
                catch (Exception exception) {
                    if (a.level < 1) break block10;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "GenericTableChecker.getColumnForCheck(DomNode,int)", 2089).add("ex", (Object)exception)).log();
                }
            }
            return null;
        }

        @Override
        protected StringItemsCheckData getRowForCheck(DomNode domNode, int n2) throws TestException {
            block10: {
                int n3 = this.helper.getColumnCount(domNode);
                if (a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getRowForCheck(DomNode,int)", 2114).add("count", n3)).log();
                }
                Pair pair = CheckerHelper.instance().getStartAndCountParameters(n3, domNode, new SubItemIndex[0]);
                try {
                    int[] nArray = (int[])pair.getFirst();
                    if (pair.getSecond() != null) {
                        nArray[0] = ((int[])pair.getSecond())[0];
                    }
                    int n4 = nArray[0];
                    if (nArray[1] >= 0) {
                        n3 = Math.min(n3, n4 + nArray[1]);
                    }
                    if (a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "GenericTableChecker.getRowForCheck(DomNode,int)", 2127).add("start", n4)).add("count", n3)).log();
                    }
                    String[] stringArray = new String[Math.max(0, n3 - n4)];
                    String string = "";
                    for (int i2 = n4; i2 < n3; ++i2) {
                        if (this.helper.isValidCellIndex(domNode, n2, i2)) {
                            DomNode domNode2 = this.helper.getCell(domNode, n2, i2);
                            string = domNode2 != null ? this.helper.getValue(domNode, domNode2) : "";
                            stringArray[i2 - n4] = string;
                            continue;
                        }
                        stringArray[i2 - n4] = null;
                    }
                    return new StringItemsCheckData(CheckType.ROW.getIdentifier(), stringArray);
                }
                catch (ElementDestroyedException elementDestroyedException) {
                    domNode.getDocument().invalidateStructure();
                    if (a.level >= 3) {
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "GenericTableChecker.getRowForCheck(DomNode,int)", 2153).add("ex", (Object)elementDestroyedException)).log();
                    }
                }
                catch (Exception exception) {
                    if (a.level < 1) break block10;
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "GenericTableChecker.getRowForCheck(DomNode,int)", 2155).add("ex", (Object)exception)).log();
                }
            }
            return null;
        }
    }

    public class GenericTabPanelChecker
    extends ListChecker {
        public GenericTabPanelChecker(WebHelper webHelper) {
            super(webHelper, new String[]{"TabPanel"}, new String[]{"Item:TabPanelItem"}, CheckType.TAB, CheckType.CURRENT_TAB, CheckType.TABS, CheckType.TAB_SELECTED, CheckType.TAB_ENABLED, CheckType.TAB_VISIBLE, null, null);
        }

        public GenericTabPanelChecker() {
            super(null, new String[]{"TabPanel"}, new String[]{"Item:TabPanelItem"}, CheckType.TAB, CheckType.CURRENT_TAB, CheckType.TABS, CheckType.TAB_SELECTED, CheckType.TAB_ENABLED, CheckType.TAB_VISIBLE, null, null);
            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
            this.helper = webEngine.getHelper();
        }

        public GenericTabPanelChecker(WebEngine webEngine) {
            super(null, new String[]{"TabPanel"}, new String[]{"Item:TabPanelItem"}, CheckType.TAB, CheckType.CURRENT_TAB, CheckType.TABS, CheckType.TAB_SELECTED, CheckType.TAB_ENABLED, CheckType.TAB_VISIBLE, null, null);
            this.helper = webEngine.getHelper();
        }

        @Override
        protected boolean isEnabled(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTabPanelChecker.isEnabled(DomNode,DomNode)", 1565).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isEnabled(null, domNode2);
        }

        @Override
        protected boolean isSelected(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTabPanelChecker.isSelected(DomNode,DomNode)", 1584).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isSelected(domNode, domNode2);
        }

        @Override
        protected boolean isChecked(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericTabPanelChecker.isChecked(DomNode,DomNode)", 1604).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isChecked(domNode, domNode2);
        }
    }

    public class GenericAccordionChecker
    extends ListChecker {
        public GenericAccordionChecker(WebHelper webHelper) {
            super(webHelper, new String[]{"Accordion"}, new String[]{"Item:AccordionItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, null, null);
        }

        public GenericAccordionChecker() {
            super(null, new String[]{"Accordion"}, new String[]{"Item:AccordionItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, null, null);
            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
            this.helper = webEngine.getHelper();
        }

        public GenericAccordionChecker(WebEngine webEngine) {
            super(null, new String[]{"Accordion"}, new String[]{"Item:AccordionItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, null, null);
            this.helper = webEngine.getHelper();
        }

        @Override
        protected boolean isEnabled(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericAccordionChecker.isEnabled(DomNode,DomNode)", 1435).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isEnabled(null, domNode2);
        }

        @Override
        protected boolean isSelected(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericAccordionChecker.isSelected(DomNode,DomNode)", 1454).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isSelected(domNode, domNode2);
        }

        @Override
        protected boolean isChecked(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericAccordionChecker.isChecked(DomNode,DomNode)", 1473).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isChecked(domNode, domNode2);
        }
    }

    public class GenericComboListChecker
    extends ListChecker {
        public GenericComboListChecker(WebHelper webHelper) {
            super(webHelper, new String[]{"List:ComboBoxList"}, new String[]{"Item:ComboBoxListItem"}, CheckType.ITEM, CheckType.VALUE, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
        }

        public GenericComboListChecker() {
            super(null, new String[]{"List:ComboBoxList"}, new String[]{"Item:ComboBoxListItem"}, CheckType.ITEM, CheckType.VALUE, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
            this.helper = webEngine.getHelper();
        }

        public GenericComboListChecker(WebEngine webEngine) {
            super(null, new String[]{"List:ComboBoxList"}, new String[]{"Item:ComboBoxListItem"}, CheckType.ITEM, CheckType.VALUE, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
            this.helper = webEngine.getHelper();
        }

        @Override
        public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
            DomNode domNode;
            DomNode domNode2;
            DomNode domNode3;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericComboListChecker.getSupportedCheckTypes(Object,Object)", 1272).addDetail("target", object)).addDetail("subItem", object2)).log();
            }
            CheckType[] checkTypeArray = super.getSupportedCheckTypes(object, object2);
            if (object instanceof DomNode && object2 instanceof DomNode && checkTypeArray != null && (domNode3 = GenericChecker.this.getSelectableItemContent(domNode2 = (DomNode)object, domNode = (DomNode)object2)) != null) {
                CheckType[] checkTypeArray2 = new CheckType[checkTypeArray.length + 1];
                System.arraycopy(checkTypeArray, 0, checkTypeArray2, 0, checkTypeArray.length);
                checkTypeArray2[checkTypeArray.length] = CheckType.ITEM_CHECKED;
                return checkTypeArray2;
            }
            return checkTypeArray;
        }

        @Override
        protected boolean isEnabled(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericComboListChecker.isEnabled(DomNode,DomNode)", 1308).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isEnabled(null, domNode2);
        }

        @Override
        protected boolean isSelected(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericComboListChecker.isSelected(DomNode,DomNode)", 1327).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isSelected(domNode, domNode2);
        }

        @Override
        protected boolean isChecked(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericComboListChecker.isChecked(DomNode,DomNode)", 1346).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isChecked(domNode, domNode2);
        }
    }

    public class GenericListChecker
    extends ListChecker {
        public GenericListChecker(WebHelper webHelper) {
            super(webHelper, new String[]{"List"}, new String[]{"Item:ListItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
        }

        public GenericListChecker() {
            super(null, new String[]{"List"}, new String[]{"Item:ListItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
            WebEngine webEngine = (WebEngine)Engine.threadInstance("web");
            this.helper = webEngine.getHelper();
        }

        public GenericListChecker(WebEngine webEngine) {
            super(null, new String[]{"List"}, new String[]{"Item:ListItem"}, CheckType.ITEM, CheckType.CURRENT_ITEM, CheckType.ITEMS, CheckType.ITEM_SELECTED, CheckType.ITEM_ENABLED, CheckType.ITEM_VISIBLE, CheckType.ITEM_CHECKED, null);
            this.helper = webEngine.getHelper();
        }

        @Override
        public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
            DomNode domNode;
            DomNode domNode2;
            DomNode domNode3;
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericListChecker.getSupportedCheckTypes(Object,Object)", 1075).addDetail("target", object)).addDetail("subItem", object2)).log();
            }
            CheckType[] checkTypeArray = super.getSupportedCheckTypes(object, object2);
            if (object instanceof DomNode && object2 instanceof DomNode && checkTypeArray != null && (domNode3 = GenericChecker.this.getSelectableItemContent(domNode2 = (DomNode)object, domNode = (DomNode)object2)) != null) {
                CheckType[] checkTypeArray2 = new CheckType[checkTypeArray.length + 1];
                System.arraycopy(checkTypeArray, 0, checkTypeArray2, 0, checkTypeArray.length);
                checkTypeArray2[checkTypeArray.length] = CheckType.ITEM_CHECKED;
                return checkTypeArray2;
            }
            return checkTypeArray;
        }

        @Override
        public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericListChecker.getCheckData(Object,Object,CheckType)", 1112).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
            }
            if (!(object instanceof DomNode)) {
                return null;
            }
            DomNode domNode = (DomNode)object;
            if (!domNode.isMatchingClass(this.listClasses)) {
                return null;
            }
            return super.getCheckData(object, object2, checkType);
        }

        @Override
        protected boolean isEnabled(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericListChecker.isEnabled(DomNode,DomNode)", 1139).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isEnabled(null, domNode2);
        }

        @Override
        protected boolean isSelected(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericListChecker.isSelected(DomNode,DomNode)", 1158).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isSelected(domNode, domNode2);
        }

        @Override
        protected boolean isChecked(DomNode domNode, DomNode domNode2) {
            if (a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "GenericListChecker.isChecked(DomNode,DomNode)", 1177).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
            }
            return GenericChecker.this.isChecked(domNode, domNode2);
        }
    }
}

