/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.swt;

import de.qfs.apps.qftest.client.swt.WidgetHelper;
import de.qfs.apps.qftest.client.swt.l;
import de.qfs.apps.qftest.client.swt.z;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.image.BaseImageHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class SWTImageHelper
extends BaseImageHelper {
    private static final z logger = new z("de.qfs.apps.qftest.client.swt.SWTImageHelper");

    public SWTImageHelper() {
        if (SWTImageHelper.logger.level >= 7) {
            logger.lvlBuild(7, "SWTImageHelper.SWTImageHelper()", 40).log();
        }
    }

    public static final ImageRep grabScreenshot(Display display, int n2, int n3, int n4, int n5) {
        if (SWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "grabScreenshot(Display,int,int,int,int)", 60).addDetail("display", (Object)display)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
        }
        Image image = new Image((Device)display, n4, n5);
        GC gC = new GC((Drawable)display);
        gC.copyArea(image, n2, n3);
        gC.dispose();
        return new ImageRep(null, SWTImageHelper.deflateRGB((int[])SWTImageHelper.getARGB(image)), ImageRep.CompressionMode.BINARY, n4, n5);
    }

    public static final int[] getARGB(Image image) {
        if (SWTImageHelper.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getARGB(Image)", 85).addDetail("image", (Object)image)).log();
        }
        ImageData imageData = image.getImageData();
        int n2 = imageData.width;
        int n3 = imageData.height;
        int n4 = imageData.depth;
        if (SWTImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getARGB(Image)", 91).add("bitCount", n4)).log();
        }
        ImageData imageData2 = null;
        PaletteData paletteData = imageData.palette;
        if (imageData.alphaData == null) {
            imageData2 = imageData.getTransparencyMask();
        }
        int[] nArray = new int[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = imageData.getPixel(i3, i2);
                int n6 = imageData.alphaData != null ? imageData.getAlpha(i3, i2) : (imageData2 != null ? (imageData2.getPixel(i3, i2) == 0 ? 0 : 255) : 0);
                RGB rGB = paletteData.getRGB(n5);
                nArray[i2 * n2 + i3] = n6 << 24 | rGB.red << 16 | rGB.green << 8 | rGB.blue;
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageRep createImageRep(InputStream inputStream) {
        if (SWTImageHelper.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createImageRep(InputStream)", 139).add("stream", (Object)inputStream)).log();
        }
        Display display = this.getEngineDisplay();
        Image image = new Image((Device)display, inputStream);
        try {
            ImageRep imageRep = new ImageRep("", SWTImageHelper.getARGB(image), ImageRep.CompressionMode.BINARY, image.getImageData().width, image.getImageData().height);
            return imageRep;
        }
        finally {
            image.dispose();
        }
    }

    public Display getEngineDisplay() {
        l l2 = this.getWidgetHelper().getEngine();
        return l2.h();
    }

    public abstract WidgetHelper getWidgetHelper();
}

