/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.swt.items;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.swt.WidgetHelper;
import de.qfs.apps.qftest.client.swt.l;
import de.qfs.apps.qftest.client.swt.z;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemResolver;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.util.Misc;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TableItemResolver
implements ItemResolver {
    private static final z a = new z("de.qfs.apps.qftest.client.swt.items.TableItemResolver");
    protected WidgetHelper helper;

    public TableItemResolver(l l2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemResolver(SWTEngine)", 71).addDetail("engine", (Object)l2)).log();
        }
        this.helper = l2.getHelper();
    }

    public static TableItemResolver createResolver(l l2) {
        block7: {
            if (TableItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "createResolver(SWTEngine)", 90).addDetail("engine", (Object)l2)).log();
            }
            String string = SWT.getPlatformAndArch();
            try {
                if ("gtk-64".equals(string)) {
                    return (TableItemResolver)TableItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.gtk64.items.GtkTableItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("gtk".equals(string)) {
                    return (TableItemResolver)TableItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.gtk.items.GtkTableItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("win32-64".equals(string)) {
                    return (TableItemResolver)TableItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.win64.items.Win32TableItemResolver").getConstructor(l.class).newInstance(l2);
                }
                if ("win32".equals(string)) {
                    return (TableItemResolver)TableItemResolver.class.getClassLoader().loadClass("de.qfs.apps.qftest.client.swt.win32.items.Win32TableItemResolver").getConstructor(l.class).newInstance(l2);
                }
            }
            catch (Throwable throwable) {
                if (TableItemResolver.a.level < 1) break block7;
                ((LevelAwareLogBuilder)a.lvlBuild(1, "createResolver(SWTEngine)", 123).add("ex", (Object)throwable)).log();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object getItem(Object object, int n2, int n3) {
        Rectangle rectangle;
        int n4;
        Table table;
        block26: {
            if (TableItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItem(Object,int,int)", 146).addDetail("element", object)).addDetail("xu", n2)).addDetail("yu", n3)).log();
            }
            if (!(object instanceof Table)) {
                if (TableItemResolver.a.level >= 1) {
                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItem(Object,int,int)", 149).add("Internal error: Not a table", object)).log();
                }
                return null;
            }
            table = (Table)object;
            if (n2 < 0 || n3 < 0) {
                if (TableItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "getItem(Object,int,int)", 156).add("Negative coordinates: (")).add(n2)).add(",")).add(n3)).add(")")).log();
                }
                return null;
            }
            int n5 = table.getColumnCount();
            TableColumn[] tableColumnArray = table.getColumns();
            n4 = -1;
            if (n5 == 0) {
                if (table.getItemCount() == 0) {
                    return null;
                }
                rectangle = this.getUnscrolledBounds(table.getItem(0), 0);
                if (n2 < rectangle.x + rectangle.width) {
                    n4 = 0;
                    break block26;
                } else {
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 174).add("X outside column")).log();
                    }
                    return null;
                }
            }
            int n6 = 0;
            int[] nArray = table.getColumnOrder();
            for (int i2 = 0; i2 < tableColumnArray.length; ++i2) {
                if ((n6 += tableColumnArray[nArray[i2]].getWidth()) <= n2) continue;
                n4 = i2;
                break;
            }
            if (n4 >= 0) {
                n4 = nArray[n4];
            }
            if (n4 == -1) {
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 197).add("X coordinate outside all columns")).log();
                }
                return null;
            }
        }
        rectangle = this.helper.toScrolledLocation((Widget)table, new Point(n2, n3));
        if (table.getHeaderVisible() && rectangle.y < table.getHeaderHeight()) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 206).add("ret", n4)).log();
            }
            return n4;
        }
        if (table.getItemCount() == 0) {
            return null;
        }
        int n7 = -1;
        Rectangle rectangle2 = this.getUnscrolledBounds(table.getItem(0), 0);
        if (n3 < rectangle2.y) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 218).add("yu between header and row 0", n3)).log();
            }
            return n4;
        }
        if (table.getItemCount() == 1) {
            if (n3 >= rectangle2.y + rectangle2.height) {
                if (TableItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getItem(Object,int,int)", 225).add("Y coordinate outside rows")).log();
                }
                return null;
            }
            n7 = 0;
        } else {
            int n8 = this.getUnscrolledBounds((TableItem)table.getItem((int)1), (int)0).y - rectangle2.y;
            if (n3 - rectangle2.y >= table.getItemCount() * n8) {
                if (TableItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getItem(Object,int,int)", 232).add("Y coordinate outside rows")).log();
                }
                return null;
            }
            n7 = (n3 - rectangle2.y) / n8;
        }
        int[] nArray = new int[]{n4, n7};
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItem(Object,int,int)", 238).add("ret", (Object)nArray)).log();
        }
        return nArray;
    }

    @Override
    public String getItemValue(Object object, Object object2) throws BadItemException {
        String string;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemValue(Object,Object)", 254).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = TableItemResolver.getColRow(object, object2);
        Table table = (Table)object;
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n3 >= 0) {
            string = n2 < 0 ? table.getItem(n3).getText() : table.getItem(n3).getText(n2);
        } else if (table.getColumnCount() == 0) {
            if (TableItemResolver.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getItemValue(Object,Object)", 274).add("Don't know how to get name of a column if no columns exist.")).log();
            }
            string = "";
        } else {
            string = table.getColumn(n2).getText();
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemValue(Object,Object)", 280).add("ret", string)).log();
        }
        return Util.getCleanElementText((String)string);
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        SubItemIndex subItemIndex;
        int n2;
        int n3;
        SubItemIndex subItemIndex2;
        int n4;
        block19: {
            Table table;
            block18: {
                int n5;
                block16: {
                    block17: {
                        block15: {
                            if (TableItemResolver.a.level >= 7) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 297).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
                            }
                            if (!(object instanceof Table)) {
                                if (TableItemResolver.a.level >= 1) {
                                    ((LevelAwareLogBuilder)a.lvlBuild(1, "getItemForIndex(Object,SubItemIndex[])", 301).add("Internal error: Not a table", object)).log();
                                }
                                return null;
                            }
                            table = (Table)object;
                            n5 = table.getColumnCount();
                            n4 = -1;
                            subItemIndex2 = subItemIndexArray[0];
                            if (subItemIndex2.getType() != 1) break block15;
                            n4 = subItemIndex2.asNumber();
                            if (n4 >= 0) break block16;
                            n4 = n5 + n4;
                            break block16;
                        }
                        if (n5 != 0) break block17;
                        if (!subItemIndex2.matches("")) break block16;
                        n4 = 0;
                        break block16;
                    }
                    for (n3 = 0; n3 < n5; ++n3) {
                        Boolean bl2 = ItemRegistry.instance().matchesItemName(table, table.getColumn(n3).getText(), subItemIndex2.getIndex());
                        if (bl2 != null) {
                            if (!bl2.booleanValue()) continue;
                            if (TableItemResolver.a.level >= 9) {
                                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 330).add("item matcher matches.")).log();
                            }
                            n4 = n3;
                            break;
                        }
                        if (!subItemIndex2.matches(this.a(table, n3))) continue;
                        n4 = n3;
                        break;
                    }
                }
                if (n5 == 0 ? n4 != 0 : n4 < 0 || n4 >= table.getColumnCount()) {
                    throw new IndexNotFoundException(subItemIndex2);
                }
                if (subItemIndexArray.length < 2) {
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 358).add("ret", n4)).log();
                    }
                    return n4;
                }
                n3 = -1;
                n2 = table.getItemCount();
                subItemIndex = subItemIndexArray[1];
                if (subItemIndex.getType() != 1) break block18;
                n3 = subItemIndex.asNumber();
                if (n3 >= 0) break block19;
                n3 = n2 + n3;
                break block19;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Boolean bl3 = ItemRegistry.instance().matchesItemName(table, table.getItem(i2).getText(n4), subItemIndex.getIndex());
                if (bl3 != null) {
                    if (!bl3.booleanValue()) continue;
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 379).add("item matcher matches.")).log();
                    }
                    n3 = i2;
                    break;
                }
                if (!subItemIndex.matches(this.a(table, n4, i2))) continue;
                n3 = i2;
                break;
            }
        }
        if (n3 < 0 || n3 >= n2) {
            if (subItemIndex.isElementSyntax()) {
                return n4;
            }
            throw new IndexNotFoundException(subItemIndex2, subItemIndex);
        }
        ItemRegistry.instance().setIndexesResolved(2);
        int[] nArray = new int[]{n4, n3};
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 407).add("ret", (Object)nArray)).log();
        }
        return nArray;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws BadItemException {
        String string;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 426).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        Table table = (Table)object;
        int[] nArray = TableItemResolver.getColRow(object, object2);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = table.getColumnCount();
        int n6 = n2;
        if (n2 == 1) {
            if (n5 == 0) {
                n6 = 3;
            } else {
                string = this.a(table, n3);
                if (!Misc.emptyOrNull((String)string)) {
                    int n7;
                    for (n7 = 0; !(n7 >= n5 || n7 != n3 && Misc.equalOrNull((Object)string, (Object)this.a(table, n7))); ++n7) {
                    }
                    n6 = n7 == n5 ? 2 : 3;
                }
            }
        }
        string = n6 == 2 ? (n5 == 0 ? new SubItemIndex("") : new SubItemIndex(this.a(table, n3))) : (n5 == 0 ? new SubItemIndex(0) : new SubItemIndex(n3));
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 473).add("colIdx", (Object)string)).log();
        }
        if (n4 < 0) {
            return new SubItemIndex[]{string};
        }
        SubItemIndex subItemIndex = n2 == 2 ? (n5 == 0 ? new SubItemIndex(this.a(table, 0, n4)) : new SubItemIndex(this.a(table, n3, n4))) : new SubItemIndex(n4);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 488).add("rowIdx", (Object)subItemIndex)).log();
        }
        SubItemIndex[] subItemIndexArray = new SubItemIndex[]{string, subItemIndex};
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 490).add("ret", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    @Override
    public int[] getItemLocation(Object object, Object object2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemLocation(Object,Object)", 508).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = TableItemResolver.getColRow(object, object2);
        Table table = (Table)object;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int[] nArray2 = new int[2];
        if (n3 >= 0) {
            Rectangle rectangle = this.getUnscrolledBounds(table.getItem(n3), n2);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemLocation(Object,Object)", 520).add("bounds", (Object)rectangle)).log();
            }
            nArray2[0] = rectangle.x;
            nArray2[1] = rectangle.y;
        } else if (table.getColumnCount() != 0) {
            TableColumn[] tableColumnArray = table.getColumns();
            int[] nArray3 = table.getColumnOrder();
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemLocation(Object,Object)", 531).add("order", (Object)nArray3)).log();
            }
            nArray2[1] = 0;
            for (int i2 = 0; i2 < tableColumnArray.length && nArray3[i2] != n2; ++i2) {
                nArray2[0] = nArray2[0] + tableColumnArray[nArray3[i2]].getWidth();
            }
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemLocation(Object,Object)", 543).add("ret", (Object)nArray2)).log();
        }
        return nArray2;
    }

    @Override
    public int[] getItemSize(Object object, Object object2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemSize(Object,Object)", 561).addDetail("element", object)).addDetail("item", object2)).log();
        }
        int[] nArray = TableItemResolver.getColRow(object, object2);
        Table table = (Table)object;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int[] nArray2 = new int[]{0, 0};
        if (n3 >= 0) {
            Rectangle rectangle = this.getUnscrolledBounds(table.getItem(n3), n2);
            nArray2[0] = rectangle.width;
            nArray2[1] = this.getItemHeight(table);
        } else if (table.getColumnCount() == 0) {
            Rectangle rectangle = table.getBounds();
            nArray2[0] = rectangle.width;
            nArray2[1] = rectangle.height;
        } else {
            nArray2[0] = table.getColumn(n2).getWidth();
            nArray2[1] = this.helper.getHeaderHeight(table) + table.getItemCount() * this.getItemHeight(table);
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemSize(Object,Object)", 587).add("ret", (Object)nArray2)).log();
        }
        return nArray2;
    }

    @Override
    public Boolean repositionMouseEvent(Object object, Object object2, int[] nArray) throws BadItemException {
        int[] nArray2;
        int n2;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "repositionMouseEvent(Object,Object,int[])", 611).addDetail("element", object)).addDetail("item", object2)).addDetail("pos", (Object)nArray)).log();
        }
        if ((n2 = (nArray2 = TableItemResolver.getColRow(object, object2))[1]) >= 0 && nArray[0] >= 0 && nArray[1] >= 0) {
            if (Client.instance().getOptions().getBoolean("RepositionMiddle", true)) {
                nArray[0] = Integer.MAX_VALUE;
                nArray[1] = Integer.MAX_VALUE;
            } else {
                nArray[0] = Math.min(nArray[0], 1);
                nArray[1] = Math.min(nArray[1], 1);
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean scrollItemVisible(Object object, Object object2, int n2, int n3) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollItemVisible(Object,Object,int,int)", 650).addDetail("element", object)).addDetail("item", object2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        int[] nArray = TableItemResolver.getColRow(object, object2);
        Table table = (Table)object;
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = this.helper.getHeaderHeight(table);
        int[] nArray2 = this.getItemLocation(object, object2);
        int[] nArray3 = this.getItemSize(object, object2);
        if (n5 < 0) {
            Point point;
            if (n3 < n6) {
                point = this.helper.getScrollOffset(table);
                n3 = point.y;
            }
            return this.helper.scrollVisible((Widget)table, (Rectangle)(point = new Rectangle(nArray2[0], n3, nArray3[0], n3)), new Point(n2, n3)) ? Boolean.TRUE : Boolean.FALSE;
        }
        Rectangle rectangle = new Rectangle(nArray2[0], nArray2[1], nArray3[0], nArray3[1]);
        return this.helper.scrollVisible((Widget)table, rectangle, new Point(n2, n3)) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public int getItemCount(Object object, Object object2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemCount(Object,Object)", 699).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (object2 == null) {
            return ((Table)object).getColumnCount();
        }
        if (object2 instanceof Integer) {
            return ((Table)object).getItemCount();
        }
        if (object2 instanceof TableItem) {
            return -1;
        }
        return -1;
    }

    public static int[] getColRow(Object object, Object object2) throws BadItemException {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getColRow(Object,Object)", 735).addDetail("element", object)).addDetail("item", object2)).log();
        }
        if (!(object instanceof Table)) {
            if (TableItemResolver.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getColRow(Object,Object)", 739).add("Internal error: Not a Table", object)).log();
            }
            throw new BadItemException("Not a Table: " + object);
        }
        Table table = (Table)object;
        int n2 = -1;
        int n3 = -1;
        if (object2 instanceof Integer) {
            n2 = (Integer)object2;
        } else if (object2 instanceof int[] && ((int[])object2).length == 2) {
            n2 = ((int[])object2)[0];
            n3 = ((int[])object2)[1];
            if (n3 < 0 || n3 >= table.getItemCount()) {
                throw new BadItemException("Invalid row: " + n3);
            }
        } else {
            throw new BadItemException("Invalid item for Table: " + object2);
        }
        if (table.getColumnCount() == 0) {
            if (n2 != 0) {
                throw new BadItemException("Invalid column in a table without columns. Column: " + n2);
            }
        } else if (n2 < 0 || n2 >= table.getColumnCount()) {
            throw new BadItemException("Invalid column: " + n2);
        }
        return new int[]{n2, n3};
    }

    protected int getItemHeight(Table table) {
        if (table.getItemCount() < 2) {
            return table.getItemHeight();
        }
        return table.getItem((int)1).getBounds((int)0).y - table.getItem((int)0).getBounds((int)0).y;
    }

    protected abstract Rectangle getUnscrolledBounds(TableItem var1, int var2);

    private String a(Table table, int n2) {
        return Util.getFlatIdentifierText((String)ItemRegistry.instance().getItemName(table, n2, table.getColumn(n2).getText()));
    }

    private String a(Table table, int n2, int n3) {
        return Util.getFlatIdentifierText((String)ItemRegistry.instance().getItemName(table, new int[]{n2, n3}, table.getItem(n3).getText(n2)));
    }
}

