/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.web.WebEngine;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.script.modules.QF;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import javax.annotation.Nullable;

public interface BrowserPreferences {
    public static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.web.BrowserPreferences");

    public void deleteCache(@Nullable String var1);

    public void deleteAllCookies(@Nullable String var1);

    default public void setDirectDownload(@Nullable String string, String string2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setDirectDownload(String,String)", 48).addDetail("browser", string)).addDetail("downloadsDir", string2)).log();
        }
        QF.logMessage((String)"Download behavior can not be changed in QF-Driver-mode", (boolean)true, (boolean)false, (boolean)true);
    }

    default public void setUserAgent(@Nullable String string, String string2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setUserAgent(String,String)", 58).addDetail("browser", string)).addDetail("userAgent", string2)).log();
        }
        this.setStrPref(string, "general.useragent.override", string2);
    }

    default public void setCookiesBehavior(@Nullable String string, boolean bl2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setCookiesBehavior(String,boolean)", 65).addDetail("browser", string)).addDetail("enabled", bl2)).log();
        }
        int n2 = 2;
        if (bl2) {
            n2 = 0;
        }
        this.setIntPref(string, "network.cookie.cookieBehavior", n2);
    }

    public void setBoolPref(@Nullable String var1, String var2, boolean var3);

    public void setIntPref(@Nullable String var1, String var2, int var3);

    public void setStrPref(@Nullable String var1, String var2, String var3);

    public boolean getBoolPref(@Nullable String var1, String var2);

    public int getIntPref(@Nullable String var1, String var2);

    public String getStrPref(@Nullable String var1, String var2);

    default public void removePref(@Nullable String string, String string2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removePref(String,String)", 88).addDetail("browser", string)).addDetail("prefName", string2)).log();
        }
        if (string2 == null) {
            throw new IllegalArgumentException("prefName is marked non-null but is null");
        }
        System.out.println("removePref not implemented for QF-Driver connection mode.");
    }

    public int activateHTTPObserver(@Nullable String var1, boolean var2);

    public int activateObjectEvents(@Nullable String var1, boolean var2);

    default public void deleteCache() {
        if (BrowserPreferences.logger.level >= 7) {
            logger.lvlBuild(7, "deleteCache()", 111).log();
        }
        this.deleteCache(this.getDefaultBrowser());
    }

    default public void deleteAllCookies() {
        if (BrowserPreferences.logger.level >= 7) {
            logger.lvlBuild(7, "deleteAllCookies()", 115).log();
        }
        this.deleteAllCookies(this.getDefaultBrowser());
    }

    default public void setDirectDownload(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setDirectDownload(String)", 119).addDetail("downloadsDir", string)).log();
        }
        this.setDirectDownload(this.getDefaultBrowser());
    }

    default public void setUserAgent(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setUserAgent(String)", 123).addDetail("userAgent", string)).log();
        }
        this.setUserAgent(this.getDefaultBrowser(), string);
    }

    default public void setCookiesBehavior(boolean bl2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCookiesBehavior(boolean)", 127).addDetail("enabled", bl2)).log();
        }
        this.setCookiesBehavior(this.getDefaultBrowser(), bl2);
    }

    default public void setBoolPref(String string, boolean bl2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setBoolPref(String,boolean)", 132).addDetail("prefName", string)).addDetail("value", bl2)).log();
        }
        this.setBoolPref(this.getDefaultBrowser(), string, bl2);
    }

    default public void setIntPref(String string, int n2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setIntPref(String,int)", 136).addDetail("prefName", string)).addDetail("value", n2)).log();
        }
        this.setIntPref(this.getDefaultBrowser(), string, n2);
    }

    default public void setStrPref(String string, String string2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setStrPref(String,String)", 140).addDetail("prefName", string)).addDetail("value", string2)).log();
        }
        this.setStrPref(this.getDefaultBrowser(), string, string2);
    }

    default public boolean getBoolPref(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getBoolPref(String)", 144).addDetail("prefName", string)).log();
        }
        return this.getBoolPref(this.getDefaultBrowser(), string);
    }

    default public int getIntPref(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getIntPref(String)", 148).addDetail("prefName", string)).log();
        }
        return this.getIntPref(this.getDefaultBrowser(), string);
    }

    default public String getStrPref(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getStrPref(String)", 152).addDetail("prefName", string)).log();
        }
        return this.getStrPref(this.getDefaultBrowser(), string);
    }

    default public void removePref(String string) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removePref(String)", 156).addDetail("prefName", string)).log();
        }
        this.removePref(this.getDefaultBrowser(), string);
    }

    default public int activateHTTPObserver(boolean bl2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "activateHTTPObserver(boolean)", 165).addDetail("activate", bl2)).log();
        }
        return this.activateHTTPObserver(this.getDefaultBrowser(), bl2);
    }

    default public int activateObjectEvents(boolean bl2) {
        if (BrowserPreferences.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "activateObjectEvents(boolean)", 174).addDetail("activate", bl2)).log();
        }
        return this.activateObjectEvents(this.getDefaultBrowser(), bl2);
    }

    default public String getDefaultBrowser() {
        WebEngine webEngine;
        if (BrowserPreferences.logger.level >= 7) {
            logger.lvlBuild(7, "getDefaultBrowser()", 179).log();
        }
        if ((webEngine = (WebEngine)Engine.instance("web")) == null) {
            throw new TestException("No web engine found");
        }
        String string = webEngine.getDefaultBrowser();
        if (string == null) {
            throw new TestException("No default browser found");
        }
        return string;
    }
}

