/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.check;

import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.QFSChecker;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;

public class ListChecker
implements Checker,
QFSChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.check.ListChecker");
    protected WebHelper helper;
    protected boolean excludeHiddenItems;
    protected String[] listClasses;
    protected String[] itemClasses;
    protected CheckType itemType;
    protected CheckType currentItemType;
    protected CheckType allItemsType;
    protected CheckType itemSelectedType;
    protected CheckType itemVisibleType;
    protected CheckType itemEnabledType;
    protected CheckType itemCheckedType;
    protected String selectedCssClass;

    public ListChecker(WebHelper webHelper, String[] stringArray, String[] stringArray2, CheckType checkType, CheckType checkType2, CheckType checkType3, CheckType checkType4, String string) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListChecker(WebHelper,String[],String[],CheckType,CheckType,CheckType,CheckType,String)", 132).addDetail("helper", (Object)webHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).addDetail("currentItemType", (Object)checkType)).addDetail("allItemsType", (Object)checkType2)).addDetail("itemSelectedType", (Object)checkType3)).addDetail("itemEnabledType", (Object)checkType4)).addDetail("selectedCssClass", string)).log();
        }
        this.helper = webHelper;
        this.listClasses = stringArray;
        this.itemClasses = stringArray2;
        this.currentItemType = checkType;
        this.allItemsType = checkType2;
        this.itemEnabledType = checkType4;
        this.itemSelectedType = checkType3;
        this.selectedCssClass = string;
        this.itemType = CheckType.ITEM;
    }

    public ListChecker(WebHelper webHelper, String[] stringArray, String[] stringArray2, CheckType checkType, CheckType checkType2, CheckType checkType3, CheckType checkType4, CheckType checkType5, CheckType checkType6, CheckType checkType7, String string) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "ListChecker(WebHelper,String[],String[],CheckType,CheckType,CheckType,CheckType,CheckType,CheckType,CheckType,String)", 166).addDetail("helper", (Object)webHelper)).addDetail("listClasses", (Object)stringArray)).addDetail("itemClasses", (Object)stringArray2)).addDetail("itemType", (Object)checkType)).addDetail("currentItemType", (Object)checkType2)).addDetail("allItemsType", (Object)checkType3)).addDetail("itemSelectedType", (Object)checkType4)).addDetail("itemEnabledType", (Object)checkType5)).addDetail("itemVisibleType", (Object)checkType6)).addDetail("itemCheckedType", (Object)checkType7)).addDetail("selectedCssClass", string)).log();
        }
        this.helper = webHelper;
        this.listClasses = stringArray;
        this.itemClasses = stringArray2;
        this.itemType = checkType;
        this.currentItemType = checkType2;
        this.allItemsType = checkType3;
        this.itemEnabledType = checkType5;
        this.itemSelectedType = checkType4;
        this.itemVisibleType = checkType6;
        this.itemCheckedType = checkType7;
        this.selectedCssClass = string;
        if (checkType == null) {
            this.itemType = CheckType.ITEM;
        }
        if (checkType3 == null) {
            this.allItemsType = CheckType.ITEMS;
        }
        if (checkType6 == null) {
            this.itemVisibleType = CheckType.ITEM_VISIBLE;
        }
    }

    public final void setExcludeHiddenItems(boolean bl2) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExcludeHiddenItems(boolean)", 210).addDetail("excludeHiddenItems", bl2)).log();
        }
        this.excludeHiddenItems = bl2;
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 228).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (!(object instanceof DomNode) || !((DomNode)object).isMatchingClass(this.listClasses)) {
            return null;
        }
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        if (this.itemType != null) {
            arrayList.add(this.itemType);
        }
        if (this.currentItemType != null) {
            arrayList.add(this.currentItemType);
        }
        if (this.allItemsType != null) {
            arrayList.add(this.allItemsType);
        }
        if (this.itemVisibleType != null && object2 != null) {
            arrayList.add(this.itemVisibleType);
        }
        if (this.itemSelectedType != null && object2 != null) {
            arrayList.add(this.itemSelectedType);
        }
        if (this.itemEnabledType != null && object2 != null) {
            arrayList.add(this.itemEnabledType);
        }
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 276).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof DomNode)) {
            return null;
        }
        if (object2 != null && !(object2 instanceof Integer)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        if (!domNode.isMatchingClass(this.listClasses)) {
            return null;
        }
        Node[] nodeArray = this.getItems(domNode);
        Node node = null;
        if (object2 != null) {
            if (nodeArray == null || nodeArray.length <= (Integer)object2) {
                if (ListChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 297).add("Index " + object2 + " out of range, items", (Object)nodeArray)).log();
                }
                return null;
            }
            node = nodeArray[(Integer)object2];
        }
        if (ListChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 302).add("subItemNode", node)).log();
        }
        if (this.itemType != null && node != null && checkType.getDataType() == CheckDataType.STRING && (checkType.getIdentifier().equals(this.itemType.getIdentifier()) || "default".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.TEXT.getDescription()) || checkType.getDescription().equals(CheckType.ITEM.getDescription()) || checkType.getDescription().equals("tab") || checkType.getDescription().equals(CheckType.TAB.getDescription()))) {
            return new StringCheckData(CheckType.ITEM.getIdentifier(), this.helper.getWholeText(node));
        }
        if (this.currentItemType != null && checkType.getDataType() == CheckDataType.STRING && (checkType.getIdentifier().equals(this.currentItemType.getIdentifier()) || "default".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.CURRENT_TAB.getDescription()) || checkType.getDescription().equals(CheckType.CURRENT_ITEM.getDescription()) || checkType.getDescription().equals("current_tab") || checkType.getDescription().equals("tab_current") || checkType.getDescription().equals(CheckType.TAB_CURRENT.getDescription()) || checkType.getDescription().equals(CheckType.ITEM_CURRENT.getDescription()))) {
            int n2 = 0;
            for (Node node2 : nodeArray) {
                if (this.isSelected(domNode, (DomNode)node2)) {
                    String string = ItemRegistry.instance().getItemValue(domNode, domNode.getClassNames(), n2);
                    return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), string);
                }
                ++n2;
            }
            return new StringCheckData(CheckType.CURRENT_ITEM.getIdentifier(), null);
        }
        if (checkType.getDataType() == CheckDataType.STRING_LIST && (checkType.getIdentifier().equals(this.allItemsType.getIdentifier()) || "default".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.TABS.getDescription()) || "tabs".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.ITEMS.getDescription()))) {
            String[] stringArray = new String[nodeArray.length];
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                stringArray[i2] = ItemRegistry.instance().getItemValue(domNode, domNode.getClassNames(), i2);
            }
            return new StringItemsCheckData(CheckType.ITEMS.getIdentifier(), stringArray);
        }
        if (this.itemVisibleType != null && node instanceof DomNode && ((DomNode)node).isMatchingClass(this.itemClasses) && checkType.getDataType() == CheckDataType.BOOLEAN && (checkType.getIdentifier().equals(this.itemVisibleType.getIdentifier()) || CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) || "tab_visible".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.TAB_VISIBLE.getDescription()) || checkType.getDescription().equals(CheckType.ITEM_VISIBLE.getDescription()))) {
            if (ListChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 381).add("showing", this.helper.isVisible(node))).log();
            }
            return new BooleanCheckData(CheckType.ITEM_VISIBLE.getIdentifier(), this.helper.isVisible(node));
        }
        if (this.itemSelectedType != null && node instanceof DomNode && ((DomNode)node).isMatchingClass(this.itemClasses) && checkType.getDataType() == CheckDataType.BOOLEAN && (checkType.getIdentifier().equals(this.itemSelectedType.getIdentifier()) || CheckType.SELECTED.getIdentifier().equals(checkType.getIdentifier()) || "tab_selected".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.TAB_SELECTED.getDescription()) || checkType.getDescription().equals(CheckType.ITEM_SELECTED.getDescription()))) {
            return new BooleanCheckData(CheckType.ITEM_SELECTED.getIdentifier(), this.isSelected(domNode, (DomNode)node));
        }
        if (this.itemEnabledType != null && node instanceof DomNode && ((DomNode)node).isMatchingClass(this.itemClasses) && checkType.getDataType() == CheckDataType.BOOLEAN && (checkType.getIdentifier().equals(this.itemEnabledType.getIdentifier()) || "tab_enabled".equals(checkType.getIdentifier()) || checkType.getDescription().equals(CheckType.TAB_ENABLED.getDescription()) || checkType.getDescription().equals(CheckType.ENABLED.getDescription()) || checkType.getDescription().equals(CheckType.ITEM_ENABLED.getDescription()))) {
            return new BooleanCheckData(CheckType.ITEM_ENABLED.getIdentifier(), this.isEnabled(domNode, (DomNode)node));
        }
        if (this.itemCheckedType != null && node instanceof DomNode && ((DomNode)node).isMatchingClass(this.itemClasses) && checkType.getDataType() == CheckDataType.BOOLEAN && (checkType.getIdentifier().equals(this.itemCheckedType.getIdentifier()) || checkType.getDescription().equals(CheckType.ITEM_CHECKED.getDescription()) || checkType.getDescription().equals(CheckType.ITEM_CONTENT_SELECTED.getDescription()))) {
            return new BooleanCheckData(CheckType.ITEM_CHECKED.getIdentifier(), this.isChecked(domNode, (DomNode)node));
        }
        return null;
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 458).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.TEXT != null && CheckType.TEXT.getIdentifier().equals(checkType.getIdentifier()) || this.itemType != null && this.itemType.getIdentifier().equals(checkType.getIdentifier()) || this.itemVisibleType != null && this.itemVisibleType.getIdentifier().equals(checkType.getIdentifier()) || this.itemSelectedType != null && this.itemSelectedType.getIdentifier().equals(checkType.getIdentifier()) || this.itemEnabledType != null && this.itemEnabledType.getIdentifier().equals(checkType.getIdentifier()) || this.itemCheckedType != null && this.itemCheckedType.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        if (CheckType.VISIBLE.getIdentifier().equals(checkType.getIdentifier()) && object2 != null) {
            return new Pair((Object)checkData, object2);
        }
        if (CheckType.ENABLED.getIdentifier().equals(checkType.getIdentifier()) && object2 != null) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }

    protected Node[] getItems(DomNode domNode) {
        return domNode.getElementsByClassName(this.itemClasses, this.getStopClassesForItemClassTraversing(), false, false, this.excludeHiddenItems);
    }

    protected String[] getStopClassesForItemClassTraversing() {
        int n2 = Arrays.binarySearch(this.listClasses, "TabPanel");
        if (n2 >= 0) {
            return this.listClasses;
        }
        return Misc.mergeStringArrays((String[])this.listClasses, (String[])this.helper.getStandardListClasses().toArray(new String[1]));
    }

    protected boolean isSelected(DomNode domNode, DomNode domNode2) {
        boolean bl2;
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isSelected(DomNode,DomNode)", 548).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
        }
        boolean bl3 = bl2 = this.selectedCssClass != null && domNode2.hasCSSClass(this.selectedCssClass);
        if (ListChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "isSelected(DomNode,DomNode)", 551).add("sel", bl2)).log();
        }
        return bl2;
    }

    protected boolean isEnabled(DomNode domNode, DomNode domNode2) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isEnabled(DomNode,DomNode)", 566).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
        }
        return true;
    }

    protected boolean isChecked(DomNode domNode, DomNode domNode2) {
        if (ListChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isChecked(DomNode,DomNode)", 582).addDetail("list", (Object)domNode)).addDetail("item", (Object)domNode2)).log();
        }
        return true;
    }
}

