/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.check;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.RetryException;
import de.qfs.apps.qftest.client.de;
import de.qfs.apps.qftest.client.web.WebHelper;
import de.qfs.apps.qftest.client.web.check.BaseChecker;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.shared.data.check.BooleanCheckData;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.GeometryCheckData;
import de.qfs.apps.qftest.shared.data.check.ImageCheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.HashSet;

public class NodeChecker
extends BaseChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.check.NodeChecker");
    private static final HashSet b = new HashSet();

    public NodeChecker(WebHelper webHelper) {
        super(webHelper);
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "NodeChecker(WebHelper)", 77).addDetail("helper", (Object)webHelper)).log();
        }
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 95).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (!(object instanceof DomNode) || object2 != null) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        ArrayList<CheckType> arrayList = new ArrayList<CheckType>();
        String string = ((DomNode)object).getDefaultClassName();
        if (!b.contains(string)) {
            arrayList.add(CheckType.TEXT);
        }
        this.addAttrCheckTypes(domNode, arrayList);
        if ("A".equals(string)) {
            arrayList.add(CheckType.ATT_HREF);
        }
        this.addVisibleCheckType(domNode, arrayList);
        this.addImageCheckType(domNode, arrayList);
        arrayList.add(CheckType.GEOMETRY);
        arrayList.add(CheckType.TOOLTIP);
        return arrayList.toArray(new CheckType[0]);
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) {
        Object object3;
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 138).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (!(object instanceof DomNode) || object2 != null) {
            return null;
        }
        String string = checkType.getIdentifier();
        if (checkType.getDataType() == CheckDataType.STRING) {
            if (CheckType.ATT_CLASS.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_CLASS.getIdentifier(), ((Node)object).getAttribute("class"));
            }
            if (CheckType.ATT_HREF.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_HREF.getIdentifier(), ((Node)object).getAttribute("href"));
            }
            if (CheckType.ATT_ID.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_ID.getIdentifier(), ((Node)object).getAttribute("id"));
            }
            if (CheckType.ATT_LANG.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_LANG.getIdentifier(), ((Node)object).getAttribute("lang"));
            }
            if (CheckType.ATT_STYLE.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_STYLE.getIdentifier(), ((Node)object).getAttribute("style"));
            }
            if (CheckType.ATT_TITLE.getIdentifier().equals(string)) {
                return new StringCheckData(CheckType.ATT_TITLE.getIdentifier(), ((Node)object).getAttribute("title"));
            }
            if ("default".equals(string) || CheckType.TEXT.getIdentifier().equals(string)) {
                return new StringCheckData("default", this.helper.getWholeText(object));
            }
            if (CheckType.TOOLTIP.getIdentifier().equals(string)) {
                String string2;
                block27: {
                    string2 = null;
                    try {
                        string2 = this.helper.getTooltipText(object, object2);
                    }
                    catch (Throwable throwable) {
                        if (NodeChecker.a.level < 3) break block27;
                        ((LevelAwareLogBuilder)a.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 181).add("t", (Object)throwable)).log();
                    }
                }
                return new StringCheckData(CheckType.TOOLTIP.getIdentifier(), string2 == null ? "" : string2);
            }
            if (string.length() > 10 && string.startsWith("attribute:")) {
                String string3;
                String string4 = string.substring(10);
                if (NodeChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 189).add("attName", string4)).log();
                }
                return new StringCheckData(string, (string3 = ((DomNode)object).getAttribute(string4)) == null ? "" : string3);
            }
        }
        if (checkType.getDataType() == CheckDataType.BOOLEAN) {
            if (CheckType.VISIBLE.getIdentifier().equals(string)) {
                return new BooleanCheckData(CheckType.VISIBLE.getIdentifier(), true);
            }
            if (CheckType.FOCUSED.getIdentifier().equals(string)) {
                return new BooleanCheckData(CheckType.FOCUSED.getIdentifier(), ((DomNode)object).hasFocus());
            }
            if (string.length() > 10 && string.startsWith("attribute:")) {
                String string5;
                String string6 = string.substring(10);
                if (NodeChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 205).add("attName", string6)).log();
                }
                return new BooleanCheckData(string, (string5 = ((DomNode)object).getAttribute(string6)) != null && !string5.equals("0") && !string5.equalsIgnoreCase("false"));
            }
        }
        if (checkType.getDataType() == CheckDataType.IMAGE && ("default".equals(string) || CheckType.IMAGE.getIdentifier().equals(string))) {
            object3 = this.helper.captureImage((DomNode)object);
            if (NodeChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getCheckData(Object,Object,CheckType)", 216).add("image", object3)).log();
            }
            if (object3 == null) {
                de de2;
                if (NodeChecker.a.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getCheckData(Object,Object,CheckType)", 218).add("Cannot grab image for ")).add(object)).log();
                }
                if ((de2 = Client.instance().getRetryContext()) != null) {
                    throw new RetryException(new TestException("Cannot grab image for " + object), 10L);
                }
            } else {
                return new ImageCheckData("default", object3, -1, -1, -1, -1, -1, -1, false);
            }
        }
        if (checkType.getDataType() == CheckDataType.GEOMETRY && ("default".equals(string) || CheckType.GEOMETRY.getIdentifier().equals(string)) && (object3 = this.helper.getGeometry(object)) != null) {
            return new GeometryCheckData("default", object3.x, object3.y, object3.width, object3.height);
        }
        return null;
    }

    protected void addAttrCheckTypes(DomNode domNode, ArrayList arrayList) {
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addAttrCheckTypes(DomNode,ArrayList)", 255).addDetail("node", (Object)domNode)).addDetail("types", (Object)arrayList)).log();
        }
        if (!Misc.emptyOrNull((String)domNode.getAttribute("class"))) {
            arrayList.add(CheckType.ATT_CLASS);
        }
        if (!Misc.emptyOrNull((String)domNode.getAttribute("id"))) {
            arrayList.add(CheckType.ATT_ID);
        }
        if (!Misc.emptyOrNull((String)domNode.getAttribute("lang"))) {
            arrayList.add(CheckType.ATT_LANG);
        }
        if (!Misc.emptyOrNull((String)domNode.getAttribute("style"))) {
            arrayList.add(CheckType.ATT_STYLE);
        }
        if (!Misc.emptyOrNull((String)domNode.getAttribute("title"))) {
            arrayList.add(CheckType.ATT_TITLE);
        }
    }

    protected void addImageCheckType(DomNode domNode, ArrayList arrayList) {
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addImageCheckType(DomNode,ArrayList)", 288).addDetail("node", (Object)domNode)).addDetail("types", (Object)arrayList)).log();
        }
        arrayList.add(CheckType.IMAGE);
    }

    protected void addVisibleCheckType(DomNode domNode, ArrayList arrayList) {
        if (NodeChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addVisibleCheckType(DomNode,ArrayList)", 302).addDetail("node", (Object)domNode)).addDetail("types", (Object)arrayList)).log();
        }
        arrayList.add(CheckType.VISIBLE);
    }

    static {
        b.add("#text");
        b.add("BR");
        b.add("IMG");
        b.add("INPUT:CHECKBOX");
        b.add("INPUT:RADIO");
        b.add("SELECT");
    }
}

