/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.check;

import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.extensions.checks.CheckDataType;
import de.qfs.apps.qftest.extensions.checks.CheckType;
import de.qfs.apps.qftest.extensions.checks.Checker;
import de.qfs.apps.qftest.extensions.checks.CheckerHelper;
import de.qfs.apps.qftest.extensions.checks.CheckerRegistry;
import de.qfs.apps.qftest.extensions.checks.QFSChecker;
import de.qfs.apps.qftest.extensions.web.TableHelper;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.data.check.CheckData;
import de.qfs.apps.qftest.shared.data.check.StringCheckData;
import de.qfs.apps.qftest.shared.data.check.StringItemsCheckData;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;

public class TableChecker
implements Checker,
QFSChecker {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.web.check.TableChecker");
    protected TableHelper helper;

    public TableChecker(TableHelper tableHelper) {
        this.helper = tableHelper;
    }

    public void register() {
        if (TableChecker.a.level >= 7) {
            a.lvlBuild(7, "register()", 80).log();
        }
        for (String string : this.helper.getTableClasses()) {
            CheckerRegistry.instance().registerChecker(string, (Checker)this);
        }
    }

    public void unregister() {
        if (TableChecker.a.level >= 7) {
            a.lvlBuild(7, "unregister()", 94).log();
        }
        for (String string : this.helper.getTableClasses()) {
            CheckerRegistry.instance().unregisterChecker(string, (Checker)this);
        }
    }

    @Override
    public CheckType[] getSupportedCheckTypes(Object object, Object object2) {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSupportedCheckTypes(Object,Object)", 115).addDetail("target", object)).addDetail("subItem", object2)).log();
        }
        if (object2 == null || !(object instanceof DomNode) || !this.helper.checkTable((DomNode)object)) {
            return null;
        }
        int n2 = -1;
        int n3 = -1;
        if (object2 != null) {
            if (object2 instanceof int[]) {
                n2 = ((int[])object2)[0];
                n3 = ((int[])object2)[1];
            } else {
                if (TableChecker.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getSupportedCheckTypes(Object,Object)", 135).add("This object is not resolved as table item, so skip it.")).log();
                }
                return null;
            }
        }
        if (n3 == -1) {
            return new CheckType[]{CheckType.HEADER_FOR_TABLE, CheckType.COLUMN};
        }
        return new CheckType[]{CheckType.CELL, CheckType.HEADER_FOR_TABLE, CheckType.COLUMN, CheckType.ROW};
    }

    @Override
    public CheckData getCheckData(Object object, Object object2, CheckType checkType) throws TestException {
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckData(Object,Object,CheckType)", 170).addDetail("target", object)).addDetail("subItem", object2)).addDetail("type", (Object)checkType)).log();
        }
        if (object2 == null) {
            return null;
        }
        if (!(object instanceof DomNode) || !this.helper.checkTable((DomNode)object)) {
            return null;
        }
        DomNode domNode = (DomNode)object;
        if (object2 != null && object2 instanceof int[]) {
            int n2 = ((int[])object2)[0];
            int n3 = ((int[])object2)[1];
            if (checkType.getDataType() == CheckDataType.STRING && n3 >= 0 && ("default".equals(checkType.getIdentifier()) || CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || "cell".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier()))) {
                DomNode domNode2 = this.helper.getCell(domNode, n3, n2);
                if (domNode2 != null) {
                    return new StringCheckData(CheckType.ITEM.getIdentifier(), this.helper.getValue(domNode, domNode2));
                }
                return new StringCheckData(CheckType.ITEM.getIdentifier(), "");
            }
            if (checkType.getDataType() == CheckDataType.STRING && (n3 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.CELL.getIdentifier().equals(checkType.getIdentifier()) || "cell".equals(checkType.getIdentifier()) || CheckType.ITEM.getIdentifier().equals(checkType.getIdentifier())) || CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier())) {
                DomNode domNode3 = this.helper.getHeaderCell(domNode, n2);
                if (domNode3 != null) {
                    return new StringCheckData(CheckType.HEADER_FOR_TABLE.getIdentifier(), this.helper.getValue(domNode, domNode3));
                }
                return new StringCheckData(CheckType.ITEM.getIdentifier(), "");
            }
            if (checkType.getDataType() == CheckDataType.STRING_LIST && (n3 < 0 && "default".equals(checkType.getIdentifier()) || CheckType.COLUMN.getIdentifier().equals(checkType.getIdentifier()))) {
                return this.getColumnForCheck(domNode, n2);
            }
            if (checkType.getDataType() == CheckDataType.STRING_LIST && n3 >= 0 && CheckType.ROW.getIdentifier().equals(checkType.getIdentifier())) {
                return this.getRowForCheck(domNode, n3);
            }
        }
        return null;
    }

    protected StringItemsCheckData getColumnForCheck(DomNode domNode, int n2) throws TestException {
        int n3 = this.helper.getRowCount(domNode);
        if (TableChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getColumnForCheck(DomNode,int)", 258).add("count", n3)).log();
        }
        Pair pair = CheckerHelper.instance().getStartAndCountParameters(n3, domNode, new SubItemIndex[]{new SubItemIndex(n2)});
        try {
            int[] nArray = (int[])pair.getFirst();
            if (pair.getSecond() != null) {
                nArray[0] = ((int[])pair.getSecond())[1];
            }
            int n4 = nArray[0];
            if (nArray[1] >= 0) {
                n3 = Math.min(n3, n4 + nArray[1]);
            }
            if (TableChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getColumnForCheck(DomNode,int)", 271).add("start", n4)).add("count", n3)).log();
            }
            String[] stringArray = new String[Math.max(0, n3 - n4)];
            for (int i2 = n4; i2 < n3; ++i2) {
                stringArray[i2 - n4] = this.helper.getValue(domNode, this.helper.getCell(domNode, i2, n2));
            }
            return new StringItemsCheckData(CheckType.COLUMN.getIdentifier(), stringArray);
        }
        catch (Exception exception) {
            if (TableChecker.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getColumnForCheck(DomNode,int)", 278).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    protected StringItemsCheckData getRowForCheck(DomNode domNode, int n2) throws TestException {
        int n3 = this.helper.getColumnCount(domNode);
        if (TableChecker.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getRowForCheck(DomNode,int)", 301).add("count", n3)).log();
        }
        Pair pair = CheckerHelper.instance().getStartAndCountParameters(n3, domNode, new SubItemIndex[0]);
        try {
            int[] nArray = (int[])pair.getFirst();
            if (pair.getSecond() != null) {
                nArray[0] = ((int[])pair.getSecond())[0];
            }
            int n4 = nArray[0];
            if (nArray[1] >= 0) {
                n3 = Math.min(n3, n4 + nArray[1]);
            }
            if (TableChecker.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getRowForCheck(DomNode,int)", 314).add("start", n4)).add("count", n3)).log();
            }
            String[] stringArray = new String[Math.max(0, n3 - n4)];
            for (int i2 = n4; i2 < n3; ++i2) {
                stringArray[i2 - n4] = this.helper.isValidCellIndex(domNode, n2, i2) ? this.helper.getValue(domNode, this.helper.getCell(domNode, n2, i2)) : null;
            }
            return new StringItemsCheckData(CheckType.ROW.getIdentifier(), stringArray);
        }
        catch (Exception exception) {
            if (TableChecker.a.level >= 1) {
                ((LevelAwareLogBuilder)a.lvlBuild(1, "getRowForCheck(DomNode,int)", 331).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    public Pair getCheckDataAndItem(Object object, Object object2, CheckType checkType) throws TestException {
        CheckData checkData;
        if (TableChecker.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCheckDataAndItem(Object,Object,CheckType)", 352).addDetail("target", object)).addDetail("item", object2)).addDetail("type", (Object)checkType)).log();
        }
        if ((checkData = this.getCheckData(object, object2, checkType)) == null) {
            return null;
        }
        if (CheckType.CELL.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        if (CheckType.COLUMN.getIdentifier().equals(checkType.getIdentifier()) || CheckType.HEADER_FOR_TABLE.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, (Object)new int[]{((int[])object2)[0], -1});
        }
        if (CheckType.ROW.getIdentifier().equals(checkType.getIdentifier())) {
            return new Pair((Object)checkData, object2);
        }
        return new Pair((Object)checkData, null);
    }
}

