/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.dom;

import de.qfs.apps.qftest.client.web.Browser;
import de.qfs.apps.qftest.client.web.dom.DocumentNode;
import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.apps.qftest.client.web.dom.Node;
import de.qfs.apps.qftest.client.web.t;
import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.util.Map;
import javax.annotation.Nullable;

public class FrameNode
extends Node {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.client.web.dom.FrameNode");
    public static final String FRAME_NODE = "FRAME_NODE";
    private final DocumentNode c;
    protected long a;
    private String d;
    private String e;

    protected FrameNode(DocumentNode documentNode, long l2) {
        super(l2);
        if (FrameNode.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "FrameNode(DocumentNode,long)", 83).addDetail("doc", (Object)documentNode)).addDetail("handle", l2)).log();
        }
        this.c = documentNode;
        documentNode.setNode(-l2, this);
    }

    @Override
    public DomNode getByXPath(String string) {
        return null;
    }

    @Override
    public Node getParent() {
        this.checkDispatch("FrameNode.getParent");
        long l2 = FrameNode.getParentFrame(this.c.d, this.p, '\u0000');
        if (l2 == 0L) {
            if (FrameNode.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getParent()", 116).add("Cannot get parent document of frame")).log();
            }
            return null;
        }
        long l3 = FrameNode.getFrameDocument(this.c.d, l2, '\u0000');
        if (l3 != 0L) {
            return DocumentNode.getDocument(l3);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.getChildDocument() == null ? 0 : 1;
    }

    @Override
    public Node getChild(int n2) {
        if (n2 == 0) {
            return this.getChildDocument();
        }
        throw new IllegalArgumentException("Illegal child index: " + n2);
    }

    public DocumentNode getChildDocument() {
        this.checkDispatch("FrameNode.getChildDocument");
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getChildDocument()", 173).add("doc.browser", (Object)this.c.d)).add("handle", this.p)).log();
        }
        long l2 = FrameNode.getFrameDocument(this.c.d, this.p, '\u0000');
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getChildDocument()", 175).add("documentHandle", l2)).log();
        }
        if (l2 == 0L) {
            if (FrameNode.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getChildDocument()", 177).add("Cannot get document of frame.")).log();
            }
            return null;
        }
        DocumentNode documentNode = DocumentNode.getDocument(l2);
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getChildDocument()", 181).add("ret", (Object)documentNode)).log();
        }
        return documentNode;
    }

    @Override
    public DocumentNode getDocument() {
        return this.c;
    }

    @Override
    public Object evalJS(String string, @Nullable Map map) throws TestException {
        if (FrameNode.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "evalJS(String,Map<String, Object>)", 216).addDetail("script", string)).addDetail("bindings", (Object)map)).log();
        }
        Object object = null;
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode != null) {
            object = documentNode.evalJS(string, map);
        }
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "evalJS(String,Map<String, Object>)", 222).add("ret", object)).log();
        }
        return object;
    }

    @Override
    public Object evalJS(String string) throws TestException {
        return this.evalJS(string, Util.createKeyValueMap((Object[])new Object[0]));
    }

    @Override
    public Object callJS(String string, @Nullable Map map) throws TestException {
        if (FrameNode.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "callJS(String,Map<String, Object>)", 242).addDetail("script", string)).addDetail("bindings", (Object)map)).log();
        }
        Object object = null;
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode != null) {
            object = documentNode.callJS(string, map);
        }
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "callJS(String,Map<String, Object>)", 248).add("ret", object)).log();
        }
        return object;
    }

    @Override
    public Object callJS(String string) throws TestException {
        return this.evalJS(string, Util.createKeyValueMap((Object[])new Object[0]));
    }

    @Override
    public Node getElementById(String string) {
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode == null) {
            return null;
        }
        return documentNode.getElementById(string);
    }

    @Override
    public Node[] getElementsById(String string) {
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode == null) {
            return NO_NODES;
        }
        return documentNode.getElementsById(string);
    }

    @Override
    public Node[] getElementsByTagName(String string) {
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode == null) {
            return NO_NODES;
        }
        if ("DOCUMENT".equals(string)) {
            return new Node[]{documentNode};
        }
        return documentNode.getElementsByTagName(string);
    }

    @Override
    public Node[] getElementsByIdAndTagname(String string, String string2) {
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode == null) {
            return NO_NODES;
        }
        return documentNode.getElementsByIdAndTagname(string, string2);
    }

    @Override
    public Node[] getElementsByClassName(String string) {
        DocumentNode documentNode = this.getChildDocument();
        if (documentNode == null) {
            return NO_NODES;
        }
        if (documentNode.isMatchingClass(string)) {
            return new Node[]{documentNode};
        }
        return documentNode.getElementsByClassName(string);
    }

    @Override
    public Browser getBrowser() {
        return this.c.getBrowser();
    }

    @Override
    public String getNodeType() {
        return FRAME_NODE;
    }

    @Override
    public String getTagName() {
        return "FRAME";
    }

    public String getFrameName() {
        if (this.d == null) {
            this.checkDispatch("FrameNode.getFrameName");
            this.d = FrameNode.getName(this.c.d, this.p, '\u0000');
        }
        return this.d;
    }

    public String getFrameUrl() {
        if (this.getEngine().isEventDispatchThread()) {
            this.e = DocumentNode.normalizeUrl(FrameNode.getUrl(this.c.d, this.p, '\u0000'));
        }
        return this.e;
    }

    public int[] getGeometry() {
        this.checkDispatch("FrameNode.getGeometry");
        return FrameNode.getGeometry(this.c.d, this.p, '\u0000');
    }

    public int[] getGeometry(boolean bl2) {
        this.checkDispatch("FrameNode.getGeometry");
        return FrameNode.getGeometry(this.c.d, this.p, bl2);
    }

    @Nullable
    public Node getFrameElement() {
        Node node;
        block11: {
            if (FrameNode.b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "getFrameElement()", 506).add("this", (Object)this)).log();
            }
            if (this.a == 0L) {
                try {
                    node = this.getChildDocument();
                    if (node != null) {
                        Integer n2 = (Integer)((DocumentNode)node).callJS("if (window.frameElement) { return window.frameElement._qf_handle; }");
                        Node node2 = this.getParent();
                        if (FrameNode.b.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getFrameElement()", 515).add("handle", (Object)n2)).add("pdoc", (Object)node2)).log();
                        }
                        if (n2 != null && node2 instanceof DocumentNode) {
                            Node node3 = (Node)((DocumentNode)node2).callJS(String.format("return document._qf_handlemap[%d]", (int)n2));
                            if (FrameNode.b.level >= 9) {
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "getFrameElement()", 519).add("frameNode", (Object)node3)).log();
                            }
                            if (node3 != null) {
                                this.setFrameElementHandle(node3.getHandle());
                            }
                        }
                    }
                }
                catch (TestException testException) {
                    if (FrameNode.b.level < 5) break block11;
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "getFrameElement()", 526).add("ex", (Object)testException)).log();
                }
            }
        }
        if (this.a == 0L) {
            return null;
        }
        node = this.getParent();
        if (node instanceof DocumentNode) {
            return ((DocumentNode)node).getNode(this.a);
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FrameNode@");
        stringBuffer.append(super.hashCode());
        stringBuffer.append('/');
        stringBuffer.append(System.identityHashCode(this));
        if (this.q) {
            stringBuffer.append("(destroyed)");
        }
        stringBuffer.append("[name=");
        try {
            stringBuffer.append(this.getFrameName());
        }
        catch (Exception exception) {
            stringBuffer.append("<ex:" + exception.getMessage() + ">");
        }
        stringBuffer.append(",url=");
        stringBuffer.append(this.getFrameUrl());
        stringBuffer.append(",handle=");
        stringBuffer.append(this.getHandleHex());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static long getParentFrame(Browser browser, long l2, char c2) {
        if (browser instanceof t) {
            return ((t)((Object)browser)).n(l2);
        }
        return FrameNode.getParentFrame(browser, l2);
    }

    public static long getFrameDocument(Browser browser, long l2, char c2) {
        if (FrameNode.b.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getFrameDocument(Browser,long,char)", 614).addDetail("browser", (Object)browser)).addDetail("frame", l2)).addDetail("wrapped", c2)).log();
        }
        if (browser instanceof t) {
            return ((t)((Object)browser)).o(l2);
        }
        return FrameNode.getFrameDocument(browser, l2);
    }

    public static String getName(Browser browser, long l2, char c2) {
        if (browser instanceof t) {
            return ((t)((Object)browser)).m(l2);
        }
        return FrameNode.getName(browser, l2);
    }

    public static String getUrl(Browser browser, long l2, char c2) {
        if (browser instanceof t) {
            return ((t)((Object)browser)).l(l2);
        }
        return FrameNode.getUrl(browser, l2);
    }

    public static int[] getGeometry(Browser browser, long l2, char c2) {
        if (browser instanceof t) {
            return ((t)((Object)browser)).p(l2);
        }
        return FrameNode.getGeometry(browser, l2);
    }

    public static int[] getGeometry(Browser browser, long l2, boolean bl2) {
        if (browser instanceof t) {
            return ((t)((Object)browser)).c(l2, bl2);
        }
        return FrameNode.getGeometry(browser, l2);
    }

    private static native long getParentFrame(Browser var0, long var1);

    private static native long getFrameDocument(Browser var0, long var1);

    private static native String getName(Browser var0, long var1);

    private static native String getUrl(Browser var0, long var1);

    private static native int[] getGeometry(Browser var0, long var1);

    public FrameNode setFrameElementHandle(long l2) {
        this.a = l2;
        return this;
    }
}

