/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.dom;

import de.qfs.apps.qftest.client.web.dom.DomNode;
import de.qfs.lib.json.Json;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;

public class PseudoAttribute {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.web.dom.PseudoAttribute");
    public static final String ATTR_VALUE_UNDEFINED = "<<UNDEF-VALUE>>";
    final String name;
    final String code;
    final boolean cachable;
    final String jsDefinition;

    public PseudoAttribute(String string, String string2, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("code is marked non-null but is null");
        }
        this.name = string;
        this.code = string2;
        this.cachable = bl2;
        this.jsDefinition = this.defineJsDefinition(string2);
    }

    protected String defineJsDefinition(String string) {
        return Json.value((String)string).toString();
    }

    public String getValue(DomNode domNode) {
        if (domNode == null) {
            throw new IllegalArgumentException("domNode is marked non-null but is null");
        }
        Object object = null;
        try {
            object = domNode.evalJS(this.code);
        }
        catch (Exception exception) {
            if (PseudoAttribute.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getValue(DomNode)", 86).add("e", (Object)exception)).log();
            }
            return ATTR_VALUE_UNDEFINED;
        }
        return object == null ? null : object.toString();
    }

    public static boolean isUndefinedValue(String string) {
        return ATTR_VALUE_UNDEFINED.equals(string);
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PseudoAttribute)) {
            return false;
        }
        PseudoAttribute pseudoAttribute = (PseudoAttribute)object;
        if (!pseudoAttribute.canEqual(this)) {
            return false;
        }
        if (this.isCachable() != pseudoAttribute.isCachable()) {
            return false;
        }
        String string = this.getName();
        String string2 = pseudoAttribute.getName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getCode();
        String string4 = pseudoAttribute.getCode();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getJsDefinition();
        String string6 = pseudoAttribute.getJsDefinition();
        return !(string5 == null ? string6 != null : !string5.equals(string6));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PseudoAttribute;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = n2 * 59 + (this.isCachable() ? 79 : 97);
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getCode();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getJsDefinition();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        return n2;
    }

    public String toString() {
        return "PseudoAttribute(name=" + this.getName() + ", code=" + this.getCode() + ", cachable=" + this.isCachable() + ", jsDefinition=" + this.getJsDefinition() + ")";
    }

    public String getJsDefinition() {
        return this.jsDefinition;
    }
}

