/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.web.event;

import de.qfs.apps.qftest.client.web.event.KeyboardRelatedEvent;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.Serializable;

public class MouseEvent
extends KeyboardRelatedEvent
implements Serializable {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.web.event.MouseEvent");
    private static final long serialVersionUID = -3671381455692220528L;
    public static final int TYPE_MOUSEMOVE = 1;
    public static final int TYPE_MOUSEOVER = 2;
    public static final int TYPE_MOUSEOUT = 3;
    public static final int TYPE_MOUSEDOWN = 4;
    public static final int TYPE_MOUSEUP = 5;
    public static final int TYPE_CLICK = 6;
    public static final int TYPE_DBLCLICK = 7;
    public static final int TYPE_MOUSEDOWN_FOR_CHECK = 8;
    public static final int TYPE_MOUSEUP_FOR_CHECK = 9;
    public static final int TYPE_CLICK_FOR_CHECK = 10;
    private static final String[] MOUSE_EVENT_NAMES = new String[]{"mousemove", "mouseover", "mouseout", "mousedown", "mouseup", "click", "dblclick", "mousedown-for-check", "mouseup-for-check", "click-for-check"};
    private int m_iButton = 0;
    private int m_iClientX;
    private int m_iClientY;
    private int m_iScreenX;
    private int m_iScreenY;

    public MouseEvent() {
        super(202);
    }

    public MouseEvent(long l2) {
        super(202, l2);
    }

    public MouseEvent(long l2, long l3) {
        super(202, l2, l3);
    }

    protected MouseEvent(int n2) {
        super(n2);
    }

    public int getButton() {
        return this.m_iButton;
    }

    public void setButton(int n2) {
        this.m_iButton = n2;
    }

    public int getClientX() {
        return this.m_iClientX;
    }

    public void setClientX(int n2) {
        this.m_iClientX = n2;
    }

    public int getClientY() {
        return this.m_iClientY;
    }

    public void setClientY(int n2) {
        this.m_iClientY = n2;
    }

    public int getScreenX() {
        return this.m_iScreenX;
    }

    public void setScreenX(int n2) {
        this.m_iScreenX = n2;
    }

    public int getScreenY() {
        return this.m_iScreenY;
    }

    public void setScreenY(int n2) {
        this.m_iScreenY = n2;
    }

    @Override
    public String getTypeStr() {
        return this.getTypeStr(MOUSE_EVENT_NAMES);
    }

    @Override
    public void setTypeStr(String string) {
        this.setTypeStr(string, MOUSE_EVENT_NAMES);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MouseEvent@");
        stringBuffer.append(super.hashCode());
        stringBuffer.append("[id=").append(this.getIdentifier());
        int n2 = this.getType();
        stringBuffer.append(",type=").append(n2);
        String string = this.getTypeStr();
        if (!Misc.emptyOrNull((String)string)) {
            stringBuffer.append("(").append(string).append(")");
        }
        stringBuffer.append(",button=").append(this.getButton());
        stringBuffer.append(",x=").append(this.getClientX());
        stringBuffer.append(",y=").append(this.getClientY());
        stringBuffer.append(",screenx=").append(this.getScreenX());
        stringBuffer.append(",screeny=").append(this.getScreenY());
        stringBuffer.append(",cursorposition=").append(this.getCursorposition());
        stringBuffer.append(",keys=").append(this.getPressedModifierKeys());
        stringBuffer.append(",bubbles=").append(this.isBubbles());
        stringBuffer.append(",uniqueId=").append(this.uniqueId);
        stringBuffer.append(",orderId=").append(this.orderId);
        stringBuffer.append(",timestamp=").append(this.getTimestamp());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String getMouseEventName(int n2) {
        try {
            return MOUSE_EVENT_NAMES[n2 - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (MouseEvent.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getMouseEventName(int)", 192).add("ex", (Object)indexOutOfBoundsException)).log();
            }
            return "";
        }
    }
}

