/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.items;

import de.qfs.apps.qftest.client.win.WinHelper;
import de.qfs.apps.qftest.client.win.toolkit.WinControl;
import de.qfs.apps.qftest.client.win.windriver.InvalidHandleException;
import de.qfs.apps.qftest.extensions.items.ItemParentResolver;
import de.qfs.apps.qftest.extensions.items.ItemRegistry;
import de.qfs.apps.qftest.extensions.items.ItemValueResolver;
import de.qfs.apps.qftest.shared.data.SubItemIndex;
import de.qfs.apps.qftest.shared.exceptions.BadItemException;
import de.qfs.apps.qftest.shared.exceptions.IndexNotFoundException;
import de.qfs.apps.qftest.shared.exceptions.TestException;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.Arrays;

public class TableItemResolver
implements ItemParentResolver {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.win.items.TableItemResolver");
    protected WinHelper helper;
    protected String[] tableClasses;
    protected String[] cellClasses;
    protected String[] rowClasses;
    protected String[] headerRowClasses;
    protected String[] headerClasses;
    protected TableItemValueResolver itemValueResolver = new TableItemValueResolver();

    public TableItemResolver(WinHelper winHelper, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemResolver(WinHelper,String[],String[],String[],String[],String[])", 62).addDetail("helper", (Object)winHelper)).addDetail("tableClasses", (Object)stringArray)).addDetail("rowClasses", (Object)stringArray2)).addDetail("cellClasses", (Object)stringArray3)).addDetail("headerRowClasses", (Object)stringArray4)).addDetail("headerClasses", (Object)stringArray5)).log();
        }
        this.helper = winHelper;
        this.tableClasses = stringArray;
        this.rowClasses = stringArray2;
        this.cellClasses = stringArray3;
        this.headerRowClasses = stringArray4;
        this.headerClasses = stringArray5;
    }

    public static TableItemResolver createAndRegister(WinHelper winHelper) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "createAndRegister(WinHelper)", 83).addDetail("helper", (Object)winHelper)).log();
        }
        String[] stringArray = new String[]{"Table"};
        String[] stringArray2 = new String[]{"TableRow"};
        String[] stringArray3 = new String[]{"TableCell"};
        String[] stringArray4 = new String[]{"TableHeader"};
        String[] stringArray5 = new String[]{"TableHeaderCell"};
        TableItemResolver tableItemResolver = new TableItemResolver(winHelper, stringArray, stringArray2, stringArray3, stringArray4, stringArray5);
        for (String string : stringArray) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
            ItemRegistry.instance().registerItemValueResolver(string, tableItemResolver.getItemValueResolver());
        }
        for (String string : stringArray3) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
        }
        for (String string : stringArray5) {
            ItemRegistry.instance().registerItemParentResolver(string, (ItemParentResolver)tableItemResolver);
        }
        return tableItemResolver;
    }

    public void unregister() {
        for (String string : this.tableClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
            ItemRegistry.instance().unregisterItemValueResolver(string, this.getItemValueResolver());
        }
        for (String string : this.cellClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
        for (String string : this.headerClasses) {
            ItemRegistry.instance().unregisterItemParentResolver(string, (ItemParentResolver)this);
        }
    }

    public final ItemValueResolver getItemValueResolver() {
        return this.itemValueResolver;
    }

    @Override
    public Object[] getParentAndItem(Object object) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getParentAndItem(Object)", 145).addDetail("element", object)).log();
        }
        WinControl winControl = (WinControl)object;
        WinControl winControl2 = this.helper.getAncestorOfClass(winControl, this.tableClasses);
        int n2 = -1;
        int n3 = -1;
        if (winControl.isMatchingClass(this.cellClasses)) {
            WinControl winControl3 = this.helper.getAncestorOfClass(winControl, this.rowClasses);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 152).add("row", (Object)winControl3)).log();
            }
            WinControl[] winControlArray = winControl3.getElementsByClassName(this.cellClasses);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 154).add("cells", (Object)winControlArray)).log();
            }
            for (int i2 = 0; i2 < winControlArray.length; ++i2) {
                if (winControl != winControlArray[i2]) continue;
                n2 = i2;
                break;
            }
            WinControl[] winControlArray2 = winControl2.getElementsByClassName(this.rowClasses);
            for (int i3 = 0; i3 < winControlArray2.length; ++i3) {
                if (winControl3 != winControlArray2[i3]) continue;
                n3 = i3;
                break;
            }
        } else if (winControl.isMatchingClass(this.headerClasses)) {
            WinControl winControl4 = this.helper.getAncestorOfClass(winControl, this.headerRowClasses);
            if (winControl4 == null) {
                if (TableItemResolver.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getParentAndItem(Object)", 171).add("No header")).log();
                }
                return null;
            }
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 174).add("header", (Object)winControl4)).log();
            }
            WinControl[] winControlArray = winControl4.getElementsByClassName(this.headerClasses);
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 176).add("cells", (Object)winControlArray)).log();
            }
            for (int i4 = 0; i4 < winControlArray.length; ++i4) {
                if (winControl != winControlArray[i4]) continue;
                n2 = i4;
                break;
            }
        } else {
            return null;
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getParentAndItem(Object)", 186).add("table", (Object)winControl2)).add("colIdx", n2)).add("rowIdx", n3)).log();
        }
        return new Object[]{winControl2, new int[]{n2, n3}};
    }

    @Override
    public Object getElement(Object object, Object object2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getElement(Object,Object)", 194).addDetail("element", object)).addDetail("item", object2)).log();
        }
        WinControl winControl = (WinControl)object;
        int n2 = ((int[])object2)[0];
        int n3 = ((int[])object2)[1];
        if (n3 < 0) {
            WinControl winControl2 = null;
            WinControl[] winControlArray = this.getColumnHeaders(winControl);
            if (0 <= n2 && n2 < winControlArray.length) {
                winControl2 = winControlArray[n2];
            }
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 206).add("header", (Object)winControl2)).log();
            }
            return winControl2;
        }
        WinControl[] winControlArray = winControl.getElementsByClassName(this.rowClasses);
        int n4 = winControlArray.length;
        if (0 > n3 || n3 >= n4) {
            return null;
        }
        WinControl winControl3 = winControlArray[n3];
        WinControl[] winControlArray2 = winControl3.getElementsByClassName(this.cellClasses);
        if (0 > n2 || n2 >= winControlArray2.length) {
            return null;
        }
        WinControl winControl4 = winControlArray2[n2];
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 221).add("ctrl", (Object)winControl4)).log();
        }
        if (Options.cached_OPT_PLAY_SCROLL_ITEM && ("Uia.ListItem".equals(winControl3.getUiaType()) && "WinForm".equals(winControl3.getFramework()) || !this.a(winControl, winControl3))) {
            boolean bl2 = winControl4.getDriver().scrollIntoView(winControl4.getHandle());
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 229).add("scrolled", bl2)).log();
            }
            if (!bl2) {
                bl2 = this.a(winControl, n3);
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getElement(Object,Object)", 233).add("scrolled", bl2)).log();
                }
            }
        }
        return winControl4;
    }

    @Override
    public Object getItemForIndex(Object object, SubItemIndex[] subItemIndexArray) throws TestException {
        WinControl winControl;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemForIndex(Object,SubItemIndex[])", 244).addDetail("element", object)).addDetail("idx", (Object)subItemIndexArray)).log();
        }
        if (!(winControl = (WinControl)object).isMatchingClass(this.tableClasses)) {
            if (TableItemResolver.a.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(3, "getItemForIndex(Object,SubItemIndex[])", 249).add("Not a table: ")).add((Object)winControl)).log();
            }
            throw new BadItemException("Not a " + Arrays.deepToString(this.tableClasses) + ": " + String.valueOf(object));
        }
        int[] nArray = new int[]{-1, -1};
        try {
            int n2;
            SubItemIndex subItemIndex;
            block21: {
                block20: {
                    int n3;
                    SubItemIndex subItemIndex2;
                    block19: {
                        block18: {
                            if (winControl.isChildrenInvalid()) {
                                this.helper.rescanHierarchy(winControl, null);
                            }
                            subItemIndex2 = subItemIndexArray[0];
                            n3 = this.getVisibleColumnCount(winControl);
                            if (subItemIndex2.getType() != 1) break block18;
                            nArray[0] = subItemIndex2.asNumber();
                            if (nArray[0] >= 0) break block19;
                            nArray[0] = n3 + nArray[0];
                            break block19;
                        }
                        subItemIndex = this.getColumnHeaders(winControl);
                        if (((WinControl[])subItemIndex).length > 0) {
                            for (n2 = 0; n2 < ((WinControl[])subItemIndex).length; ++n2) {
                                if (!subItemIndex2.matches(this.getResolvedHeaderName(winControl, n2))) continue;
                                nArray[0] = n2;
                                break;
                            }
                        }
                    }
                    if (nArray[0] < 0 || nArray[0] >= n3) {
                        if (TableItemResolver.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 282).add("item[0]", nArray[0])).dumpStack();
                        }
                        throw new IndexNotFoundException(subItemIndex2);
                    }
                    if (subItemIndexArray.length == 1) {
                        return nArray;
                    }
                    subItemIndex = subItemIndexArray[1];
                    n2 = this.getRowCount(winControl);
                    if (subItemIndex.getType() != 1) break block20;
                    nArray[1] = subItemIndex.asNumber();
                    if (nArray[1] >= 0) break block21;
                    nArray[1] = n2 + nArray[1];
                    break block21;
                }
                int n4 = 0;
                while (n4 < n2) {
                    if (!subItemIndex.matches(this.getResolvedName(winControl, new int[]{nArray[0], n4++}))) continue;
                    nArray[1] = n4;
                    break;
                }
            }
            if (nArray[1] < 0 || nArray[1] >= n2) {
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 306).add("item[1]", nArray[1])).log();
                }
                if (subItemIndex.isElementSyntax()) {
                    nArray[1] = -1;
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 310).add("Returning item for column: ")).addAll("item", (Object)nArray)).log();
                    }
                    return nArray;
                }
                throw new IndexNotFoundException(subItemIndex);
            }
        }
        catch (InvalidHandleException invalidHandleException) {
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 317).add("ex", (Object)invalidHandleException)).log();
            }
            throw new IndexNotFoundException(subItemIndexArray);
        }
        ItemRegistry.instance().setIndexesResolved(2);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemForIndex(Object,SubItemIndex[])", 322).add("item", (Object)nArray)).log();
        }
        return nArray;
    }

    @Override
    public SubItemIndex[] getItemIndex(Object object, Object object2, int n2) throws TestException {
        String string;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getItemIndex(Object,Object,int)", 330).addDetail("element", object)).addDetail("item", object2)).addDetail("type", n2)).log();
        }
        int n3 = ((int[])object2)[0];
        int n4 = ((int[])object2)[1];
        SubItemIndex[] subItemIndexArray = new SubItemIndex[2];
        WinControl winControl = (WinControl)object;
        switch (n2) {
            case 1: 
            case 2: {
                string = this.getResolvedHeaderName(winControl, n3);
                if (!Misc.emptyOrNull((String)string)) {
                    subItemIndexArray[0] = new SubItemIndex(string, "\\#@&%");
                    break;
                }
            }
            case 3: {
                subItemIndexArray[0] = new SubItemIndex(n3);
            }
        }
        if (n4 < 0) {
            return new SubItemIndex[]{subItemIndexArray[0]};
        }
        switch (n2) {
            case 2: {
                subItemIndexArray[1] = new SubItemIndex(this.getResolvedName(winControl, (int[])object2), "\\#@&%");
                break;
            }
            case 1: {
                string = this.getResolvedName(winControl, (int[])object2);
                if (Misc.emptyOrNull((String)string)) {
                    subItemIndexArray[1] = new SubItemIndex(n4);
                    break;
                }
                String string2 = string.toLowerCase();
                if ("true".equals(string2) || "false".equals(string2)) {
                    subItemIndexArray[1] = new SubItemIndex(n4);
                    break;
                }
                subItemIndexArray[1] = new SubItemIndex(string, "\\#@&%");
                break;
            }
            case 3: {
                subItemIndexArray[1] = new SubItemIndex(n4);
            }
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getItemIndex(Object,Object,int)", 379).add("result", (Object)subItemIndexArray)).log();
        }
        return subItemIndexArray;
    }

    public String getResolvedName(WinControl winControl, int[] nArray) {
        String string = this.getDefaultName(winControl, nArray);
        return ItemRegistry.instance().getItemName(winControl, this.tableClasses, nArray, string);
    }

    public String getDefaultName(WinControl winControl, int[] nArray) {
        String string = null;
        WinControl winControl2 = TableItemResolver.getCell(winControl, nArray, this.rowClasses, this.cellClasses);
        if (winControl2 != null) {
            string = this.helper.getWholeText(winControl2);
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getDefaultName(WinControl,int[])", 416).add("name", string)).log();
        }
        return string;
    }

    public int getRowCount(WinControl winControl) {
        return TableItemResolver.getRowCount(winControl, this.rowClasses);
    }

    public String getResolvedHeaderName(WinControl winControl, int n2) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getResolvedHeaderName(WinControl,int)", 440).addDetail("table", (Object)winControl)).addDetail("col", n2)).log();
        }
        String string = this.getDefaultHeaderName(winControl, n2);
        String string2 = ItemRegistry.instance().getItemName(winControl, this.tableClasses, new int[]{n2, -1}, string);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getResolvedHeaderName(WinControl,int)", 445).add("name", string2)).log();
        }
        return string2;
    }

    public String getDefaultHeaderName(WinControl winControl, int n2) {
        WinControl winControl2;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getDefaultHeaderName(WinControl,int)", 452).addDetail("table", (Object)winControl)).addDetail("col", n2)).log();
        }
        WinControl[] winControlArray = this.getColumnHeaders(winControl);
        String string = "";
        if (0 <= n2 && n2 < winControlArray.length && (winControl2 = winControlArray[n2]) != null) {
            string = winControl2.getUiaName();
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getDefaultHeaderName(WinControl,int)", 462).add("headerName", string)).log();
        }
        return string;
    }

    public int getVisibleColumnCount(WinControl winControl) {
        WinControl[] winControlArray;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVisibleColumnCount(WinControl)", 469).addDetail("table", (Object)winControl)).log();
        }
        if ((winControlArray = this.getColumnHeaders(winControl)).length > 0) {
            return winControlArray.length;
        }
        WinControl[] winControlArray2 = winControl.getElementsByClassName(this.rowClasses);
        if (winControlArray2.length > 0) {
            WinControl[] winControlArray3 = winControlArray2[0].getElementsByClassName(this.cellClasses);
            return winControlArray3.length;
        }
        return 0;
    }

    public WinControl[] getColumnHeaders(WinControl winControl) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getColumnHeaders(WinControl)", 486).addDetail("table", (Object)winControl)).log();
        }
        WinControl[] winControlArray = winControl.getElementsByClassName(this.headerRowClasses);
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getColumnHeaders(WinControl)", 491).add("headers", (Object)winControlArray)).log();
        }
        if (winControlArray.length > 0) {
            WinControl[] winControlArray2 = winControlArray[0].getElementsByClassName(this.headerClasses);
            return winControlArray2;
        }
        return WinControl.EMPTY_ARRAY;
    }

    private boolean a(WinControl winControl, WinControl winControl2) {
        int n2;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "isRowVisible(WinControl,WinControl)", 502).addDetail("table", (Object)winControl)).addDetail("row", (Object)winControl2)).log();
        }
        if (!this.helper.isVisible(winControl2)) {
            return false;
        }
        WinControl winControl3 = this.a(winControl);
        if (winControl3 == null) {
            return true;
        }
        int n3 = 0;
        WinControl[] winControlArray = winControl.getElementsByClassName(this.headerRowClasses);
        if (winControlArray.length > 0) {
            n3 += winControlArray[0].getSize()[1];
        }
        WinControl[] winControlArray2 = winControl.getElementsByClassName(this.rowClasses);
        for (n2 = 0; n2 < winControlArray2.length; ++n2) {
            if (this.helper.isVisible(winControlArray2[n2])) {
                n3 += winControlArray2[n2].getSize()[1];
            }
            if (winControl2 == winControlArray2[n2]) break;
        }
        n2 = winControl3.getSize()[1];
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "isRowVisible(WinControl,WinControl)", 527).add("sumHeight", n3)).add("maxHeight", n2)).log();
        }
        return n3 <= n2;
    }

    private boolean a(WinControl winControl, int n2) {
        block12: {
            int n3;
            if (TableItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "scrollRowVisible(WinControl,int)", 537).addDetail("table", (Object)winControl)).addDetail("rowIdx", n2)).log();
            }
            if ((n3 = this.getRowCount(winControl)) == 0 || n3 == 1) {
                return false;
            }
            WinControl winControl2 = this.a(winControl);
            if (winControl2 == null) {
                if (TableItemResolver.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "scrollRowVisible(WinControl,int)", 545).add("No ScrollBar")).log();
                }
                return false;
            }
            String string = winControl2.getDriver().getAttribute(winControl2.getHandle(), "value");
            String string2 = "" + Math.round(n2 * 100 / (n3 - 1));
            winControl2.getDriver().setAttribute(winControl2.getHandle(), "value", string2);
            String string3 = winControl2.getDriver().getAttribute(winControl2.getHandle(), "value");
            if (TableItemResolver.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "scrollRowVisible(WinControl,int)", 553).add("oldValue", string)).add("newValue", string2)).add("value", string3)).log();
            }
            try {
                int n4 = Integer.parseInt(string);
                int n5 = Integer.parseInt(string2);
                int n6 = Integer.parseInt(string3);
                if (n4 < n5 && n6 < n5) {
                    int n7 = Math.round((n2 + 1) * 100 / (n3 - 1));
                    string2 = "" + Math.min(100, n7 == n5 ? n7 + 1 : n7);
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "scrollRowVisible(WinControl,int)", 561).add("newValue", string2)).log();
                    }
                    winControl2.getDriver().setAttribute(winControl2.getHandle(), "value", string2);
                } else if (n4 > n5 && n6 > n5) {
                    int n8 = Math.round((n2 - 1) * 100 / (n3 - 1));
                    string2 = "" + Math.max(0, n8 == n5 ? n8 - 1 : n8);
                    if (TableItemResolver.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "scrollRowVisible(WinControl,int)", 566).add("newValue", string2)).log();
                    }
                    winControl2.getDriver().setAttribute(winControl2.getHandle(), "value", string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (TableItemResolver.a.level < 3) break block12;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "scrollRowVisible(WinControl,int)", 570).add("ex", (Object)numberFormatException)).log();
            }
        }
        return true;
    }

    private WinControl a(WinControl winControl) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVerticalScrollBar(WinControl)", 584).addDetail("table", (Object)winControl)).log();
        }
        WinControl winControl2 = null;
        int n2 = winControl.getChildCount();
        for (int i2 = 0; i2 < 2; ++i2) {
            int[] nArray;
            WinControl winControl3;
            if (i2 >= n2 || !(winControl3 = winControl.getChild(i2)).isMatchingClass("ScrollBar") || (nArray = winControl3.getSize())[0] >= nArray[1]) continue;
            winControl2 = winControl3;
            break;
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getVerticalScrollBar(WinControl)", 601).add("scrollBar", winControl2)).log();
        }
        return winControl2;
    }

    public static WinControl getCell(WinControl winControl, int[] nArray, String[] stringArray, String[] stringArray2) {
        WinControl[] winControlArray;
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getCell(WinControl,int[],String[],String[])", 623).addDetail("table", (Object)winControl)).addDetail("item", (Object)nArray)).addDetail("rowClasses", (Object)stringArray)).addDetail("cellClasses", (Object)stringArray2)).log();
        }
        WinControl winControl2 = null;
        WinControl[] winControlArray2 = winControl.getElementsByClassName(stringArray);
        if (winControlArray2.length > nArray[1] && (winControlArray = winControlArray2[nArray[1]].getElementsByClassName(stringArray2)).length > nArray[0]) {
            winControl2 = winControlArray[nArray[0]];
        }
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getCell(WinControl,int[],String[],String[])", 633).add("cell", winControl2)).log();
        }
        return winControl2;
    }

    public static int getRowCount(WinControl winControl, String[] stringArray) {
        if (TableItemResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getRowCount(WinControl,String[])", 640).addDetail("table", (Object)winControl)).addDetail("rowClasses", (Object)stringArray)).log();
        }
        WinControl[] winControlArray = winControl.getElementsByClassName(stringArray);
        int n2 = winControlArray.length;
        if (TableItemResolver.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getRowCount(WinControl,String[])", 644).add("count", n2)).log();
        }
        return n2;
    }

    public class TableItemValueResolver
    implements ItemValueResolver,
    BaseHelper {
        @Override
        public String getItemValue(Object object, Object object2) {
            int[] nArray;
            if (TableItemResolver.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "TableItemValueResolver.getItemValue(Object,Object)", 661).addDetail("element", object)).addDetail("item", object2)).log();
            }
            if ((nArray = (int[])object2)[1] < 0) {
                return TableItemResolver.this.getDefaultHeaderName((WinControl)object, nArray[0]);
            }
            return TableItemResolver.this.getDefaultName((WinControl)object, nArray);
        }
    }
}

