/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.windriver;

import de.qfs.apps.qftest.client.win.windriver.WinCallbacks;
import de.qfs.apps.qftest.client.win.windriver.WinDriver;
import de.qfs.apps.qftest.client.win.windriver.event.CallbackEvent;
import de.qfs.apps.qftest.client.win.windriver.event.ConnectionListener;
import de.qfs.apps.qftest.client.win.windriver.event.WinEvent;
import de.qfs.apps.qftest.client.win.windriver.event.WinEventFilter;
import de.qfs.apps.qftest.shared.Globals;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;

public class DefaultWinDriver
implements WinCallbacks,
WinDriver,
WinEventFilter {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.win.windriver.DefaultWinDriver");
    public static final int DEFAULT_HIGHLIGHT_COLOR = -1;
    public static final int BUSY_PANE_HIGHLIGHT_COLOR = -2;
    private ArrayList filters = new ArrayList();
    private ArrayList connListeners = new ArrayList();
    private ArrayList callbacksHandlers = new ArrayList();
    private LinkedList runnablesToDispatch = new LinkedList();
    private Thread dispatchThread = null;
    private boolean checkDispatch = true;

    public DefaultWinDriver() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "DefaultWinDriver()", 57).log();
        }
        try {
            String string = Globals.getGlobalString((String)"qftestversiondir", null);
            if (DefaultWinDriver.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "DefaultWinDriver()", 61).add("versiondir", string)).log();
            }
            if (string != null) {
                String string2 = string + "\\windriver\\";
                string2 = string2 + (Misc.JAVA_IS_64_BIT ? "win64\\" : "win32\\");
                File file = new File(string2);
                File file2 = new File(file, "qfclib.dll");
                File file3 = new File(file, "windriver.dll");
                if (file2.isFile() && file3.isFile()) {
                    System.load(string2 + "msvcr120.dll");
                    System.load(string2 + "msvcp120.dll");
                    System.load(file2.getPath());
                    System.load(file3.getPath());
                } else {
                    System.err.println("Error: WinDriver Library is missing.");
                    System.exit(1);
                }
            } else {
                System.err.println("Error: WinDriver Library is missing.");
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            if (DefaultWinDriver.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "DefaultWinDriver()", 83).add("ex", (Object)throwable)).log();
            }
            System.exit(1);
        }
    }

    @Override
    public int setupLogging() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "setupLogging()", 91).log();
        }
        this.SetupNativeLogging();
        return 0;
    }

    @Override
    public int startClient(String string) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "startClient(String)", 104).addDetail("command", string)).log();
        }
        int n2 = this.StartClient(string);
        return n2;
    }

    @Override
    public int attachClient(int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "attachClient(int)", 113).addDetail("threadId", n2)).log();
        }
        int n3 = this.AttachClient(n2);
        return n3;
    }

    @Override
    public int attachClient(String string) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "attachClient(String)", 122).addDetail("titleRe", string)).log();
        }
        int n2 = this.AttachClient(string);
        return n2;
    }

    @Override
    public int attachUiaClient(String string, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "attachUiaClient(String,int)", 131).addDetail("titleRe", string)).addDetail("timeout", n2)).log();
        }
        int n3 = this.AttachUiaClient(string, n2);
        return n3;
    }

    public void cacheExistingWindowHandles() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "cacheExistingWindowHandles()", 140).log();
        }
        this.CacheExistingWindowHandles();
    }

    @Override
    public void detachClient() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "detachClient()", 148).log();
        }
        this.DetachClient();
        this.dispatchThread = null;
    }

    @Override
    public int getThreadId() {
        return this.GetThreadId();
    }

    @Override
    public boolean isConnected() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "isConnected()", 166).log();
        }
        return this.IsConnected();
    }

    @Override
    public void terminate() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "terminate()", 174).log();
        }
        this.Terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean filterEvent(WinEvent winEvent) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "filterEvent(WinEvent)", 186).addDetail("event", (Object)winEvent)).log();
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = Thread.currentThread();
            this.dispatchThread.setName("WinEventDispatchThread");
            if (DefaultWinDriver.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "filterEvent(WinEvent)", 191).add("dispatchThread", (Object)this.dispatchThread)).log();
            }
        }
        boolean bl2 = true;
        if (winEvent.getType() == 100) {
            for (ConnectionListener connectionListener : this.connListeners) {
                connectionListener.onConnect();
            }
        } else if (winEvent.getType() == 101) {
            for (ConnectionListener connectionListener : this.connListeners) {
                connectionListener.onTerminate();
            }
        } else if (winEvent instanceof CallbackEvent) {
            DefaultWinDriver defaultWinDriver = this;
            synchronized (defaultWinDriver) {
                if (!this.runnablesToDispatch.isEmpty()) {
                    Runnable runnable = (Runnable)this.runnablesToDispatch.removeFirst();
                    if (DefaultWinDriver.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "filterEvent(WinEvent)", 206).add("runnable", (Object)runnable)).log();
                    }
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        if (DefaultWinDriver.logger.level >= 5) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "filterEvent(WinEvent)", 210).add("ex", (Object)throwable)).log();
                        }
                    }
                } else if (DefaultWinDriver.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "filterEvent(WinEvent)", 213).add("Internal error: No runnable to dispatch")).log();
                }
                this.notifyAll();
            }
        } else {
            for (WinEventFilter winEventFilter : this.filters) {
                try {
                    if (winEventFilter.filterEvent(winEvent)) continue;
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    if (DefaultWinDriver.logger.level < 3) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "filterEvent(WinEvent)", 224).add("ex", (Object)throwable)).log();
                }
            }
        }
        return bl2;
    }

    @Override
    public void addEventFilter(WinEventFilter winEventFilter) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addEventFilter(WinEventFilter)", 234).addDetail("filter", (Object)winEventFilter)).log();
        }
        this.filters.remove(winEventFilter);
        this.filters.add(winEventFilter);
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addConnectionListener(ConnectionListener)", 243).addDetail("listener", (Object)connectionListener)).log();
        }
        this.connListeners.remove(connectionListener);
        this.connListeners.add(connectionListener);
    }

    @Override
    public void enableEventListeners(int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "enableEventListeners(int)", 252).addDetail("mode", n2)).log();
        }
        this.EnableEventListeners(n2);
    }

    @Override
    public void enableCheckMode(boolean bl2, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "enableCheckMode(boolean,int)", 260).addDetail("enable", bl2)).addDetail("mode", n2)).log();
        }
        this.EnableCheckMode(bl2, n2);
    }

    @Override
    public void enableRecordingMode(boolean bl2, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "enableRecordingMode(boolean,int)", 268).addDetail("enable", bl2)).addDetail("mode", n2)).log();
        }
        this.EnableRecordingMode(bl2, n2);
    }

    @Override
    public void onPrepareRecording(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onPrepareRecording(long)", 280).addDetail("handle", l2)).log();
        }
        for (WinCallbacks winCallbacks : this.callbacksHandlers) {
            winCallbacks.onPrepareRecording(l2);
        }
    }

    @Override
    public void onDefaultCheck(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onDefaultCheck(long)", 290).addDetail("handle", l2)).log();
        }
        for (WinCallbacks winCallbacks : this.callbacksHandlers) {
            winCallbacks.onDefaultCheck(l2);
        }
    }

    @Override
    public String[] onContextCheck(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "onContextCheck(long)", 300).addDetail("handle", l2)).log();
        }
        String[] stringArray = new String[]{};
        for (WinCallbacks winCallbacks : this.callbacksHandlers) {
            stringArray = winCallbacks.onContextCheck(l2);
        }
        return stringArray;
    }

    @Override
    public void onCheckSelect(long l2, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "onCheckSelect(long,int)", 313).addDetail("handle", l2)).addDetail("index", n2)).log();
        }
        for (WinCallbacks winCallbacks : this.callbacksHandlers) {
            winCallbacks.onCheckSelect(l2, n2);
        }
    }

    @Override
    public void addCallbacksHandler(WinCallbacks winCallbacks) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addCallbacksHandler(WinCallbacks)", 323).addDetail("handler", (Object)winCallbacks)).log();
        }
        this.callbacksHandlers.remove(winCallbacks);
        this.callbacksHandlers.add(winCallbacks);
    }

    @Override
    public long getNativeHandle(long l2) {
        this.checkDispatch();
        return this.GetNativeHandle(l2);
    }

    @Override
    public String getClassName(long l2) {
        this.checkDispatch();
        return this.GetClassName(l2);
    }

    @Override
    public String[] getClassNames(long l2) {
        this.checkDispatch();
        return this.GetClassNames(l2);
    }

    @Override
    public long getParent(long l2) {
        this.checkDispatch();
        return this.GetParent(l2);
    }

    @Override
    public long[] getChildren(long l2) {
        this.checkDispatch();
        return this.GetChildren(l2);
    }

    @Override
    public String[] getChildrenWithAttributes(long l2, String[] stringArray) {
        this.checkDispatch();
        return this.GetChildrenWithAttributes(l2, stringArray);
    }

    @Override
    public String[] getHierarchyWithAttributes(long l2, String[] stringArray, long[] lArray) {
        this.checkDispatch();
        return this.GetHierarchyWithAttributes(l2, stringArray, lArray);
    }

    @Override
    public int[] getBounds(long l2) {
        this.checkDispatch();
        return this.GetBounds(l2);
    }

    @Override
    public String getAttribute(long l2, String string) {
        this.checkDispatch();
        return this.GetAttribute(l2, string);
    }

    @Override
    public boolean setAttribute(long l2, String string, String string2) {
        this.checkDispatch();
        return this.SetAttribute(l2, string, string2);
    }

    @Override
    public String[] getAttributes(long l2, String[] stringArray) {
        this.checkDispatch();
        return this.GetAttributes(l2, stringArray);
    }

    @Override
    public String evalJS(long l2, String string) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "evalJS(long,String)", 435).addDetail("handle", l2)).addDetail("code", string)).log();
        }
        this.checkDispatch();
        return this.EvalJS(l2, string);
    }

    @Override
    public void highlight(long l2, int n2, int n3) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(long,int,int)", 444).addDetail("handle", l2)).addDetail("duration", n2)).addDetail("color", n3)).log();
        }
        this.Highlight(l2, n2, n3);
    }

    @Override
    public boolean isViaHWnd() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "isViaHWnd()", 453).log();
        }
        return this.IsViaHWnd();
    }

    @Override
    public void setViaHWnd(boolean bl2) {
        this.SetViaHWnd(bl2);
    }

    @Override
    public boolean isUia8() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "isUia8()", 469).log();
        }
        return this.IsUia8();
    }

    @Override
    public boolean setTimeouts(int n2, int n3) {
        return this.SetTimeouts(n2, n3);
    }

    @Override
    public long getElementFromPoint(int n2, int n3) {
        return this.GetElementFromPoint(n2, n3);
    }

    @Override
    public void releaseControls() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "releaseControls()", 493).log();
        }
        this.ReleaseControls();
    }

    @Override
    public String getWindowClassName(long l2) {
        return this.GetWindowClassName(l2);
    }

    @Override
    public String getWindowText(long l2) {
        return this.GetWindowText(l2);
    }

    @Override
    public boolean setWindowText(long l2, String string) {
        return this.SetWindowText(l2, string);
    }

    @Override
    public int getWindowLong(long l2, int n2) {
        return this.GetWindowLong(l2, n2);
    }

    @Override
    public long sendMessage(long l2, int n2, long l3, long l4) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "sendMessage(long,int,long,long)", 535).addDetail("hwnd", l2)).addDetail("msg", n2)).addDetail("wParam", l3)).addDetail("lParam", l4)).log();
        }
        return this.SendMessage(l2, n2, l3, l4);
    }

    @Override
    public void postMessage(long l2, int n2, long l3, long l4) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "postMessage(long,int,long,long)", 543).addDetail("hwnd", l2)).addDetail("msg", n2)).addDetail("wParam", l3)).addDetail("lParam", l4)).log();
        }
        this.PostMessage(l2, n2, l3, l4);
    }

    @Override
    public long[] getToplevels() {
        this.checkDispatch();
        return this.GetToplevels();
    }

    @Override
    public long[] getElementsByProperty(long l2, String string, String string2) {
        this.checkDispatch();
        return this.GetElementsByProperty(l2, string, string2);
    }

    @Override
    public long[] findAllWindows(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "findAllWindows(long)", 573).addDetail("rootWindow", l2)).log();
        }
        this.checkDispatch();
        return this.FindAllWindows(l2);
    }

    @Override
    public void triggerThread() {
        if (DefaultWinDriver.logger.level >= 7) {
            logger.lvlBuild(7, "triggerThread()", 586).log();
        }
        this.TriggerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeLater(Runnable runnable) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "invokeLater(Runnable)", 594).addDetail("runnable", (Object)runnable)).log();
        }
        DefaultWinDriver defaultWinDriver = this;
        synchronized (defaultWinDriver) {
            this.runnablesToDispatch.addLast(runnable);
            this.triggerThread();
        }
    }

    @Override
    public boolean isEventDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    public void checkDispatch() {
        if (this.checkDispatch && !this.isEventDispatchThread()) {
            throw new InvalidThreadException();
        }
    }

    public void checkNonDispatch() {
        if (this.checkDispatch && this.isEventDispatchThread()) {
            throw new InvalidThreadException();
        }
    }

    @Override
    public void simulateMouseEvent(long l2, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "simulateMouseEvent(long,int,int,int,int,int,int)", 642).addDetail("handle", l2)).addDetail("eventId", n2)).addDetail("button", n3)).addDetail("x", n4)).addDetail("y", n5)).addDetail("modifiers", n6)).addDetail("count", n7)).log();
        }
        this.SimulateMouseEvent(l2, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public void simulateKeyStroke(long l2, char c2, int n2, int n3) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "simulateKeyStroke(long,char,int,int)", 650).addDetail("handle", l2)).addDetail("c", c2)).addDetail("keycode", n2)).addDetail("modifiers", n3)).log();
        }
        this.SimulateKeyStroke(l2, c2, n2, n3);
    }

    @Override
    public void setFocus(long l2) {
        this.SetFocus(l2);
    }

    @Override
    public boolean move(long l2, int n2, int n3) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "move(long,int,int)", 666).addDetail("handle", l2)).addDetail("x", n2)).addDetail("y", n3)).log();
        }
        return this.Move(l2, n2, n3);
    }

    @Override
    public boolean resize(long l2, int n2, int n3) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "resize(long,int,int)", 674).addDetail("handle", l2)).addDetail("width", n2)).addDetail("height", n3)).log();
        }
        return this.Resize(l2, n2, n3);
    }

    @Override
    public boolean close(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "close(long)", 682).addDetail("handle", l2)).log();
        }
        return this.Close(l2);
    }

    @Override
    public boolean bringToFront(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "bringToFront(long)", 690).addDetail("handle", l2)).log();
        }
        return this.BringToFront(l2);
    }

    @Override
    public void doDefaultAction(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "doDefaultAction(long)", 698).addDetail("handle", l2)).log();
        }
        this.DoDefaultAction(l2);
    }

    @Override
    public void invoke(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "invoke(long)", 706).addDetail("handle", l2)).log();
        }
        this.Invoke(l2);
    }

    @Override
    public void select(long l2, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "select(long,int)", 714).addDetail("handle", l2)).addDetail("mode", n2)).log();
        }
        this.Select(l2, n2);
    }

    @Override
    public boolean toggle(long l2, int n2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "toggle(long,int)", 722).addDetail("handle", l2)).addDetail("mode", n2)).log();
        }
        return this.Toggle(l2, n2);
    }

    @Override
    public boolean expand(long l2, boolean bl2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "expand(long,boolean)", 730).addDetail("handle", l2)).addDetail("expand", bl2)).log();
        }
        return this.Expand(l2, bl2);
    }

    @Override
    public void scroll(long l2, double d2, double d3) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "scroll(long,double,double)", 738).addDetail("handle", l2)).addDetail("horizPercent", d2)).addDetail("vertPercent", d3)).log();
        }
        this.Scroll(l2, d2, d3);
    }

    @Override
    public boolean scrollIntoView(long l2) {
        if (DefaultWinDriver.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "scrollIntoView(long)", 746).addDetail("handle", l2)).log();
        }
        return this.ScrollIntoView(l2);
    }

    @Override
    public void setPref(String string, String string2) {
        this.SetPreference(string, string2);
    }

    @Override
    public String getPref(String string) {
        return this.GetPreference(string);
    }

    @Override
    public double getScreenScaleFactor() {
        return this.GetScreenScaleFactor();
    }

    public native int SetupNativeLogging();

    public native int StartClient(String var1);

    public native int AttachClient(int var1);

    public native int AttachClient(String var1);

    public native int AttachUiaClient(String var1, int var2);

    public native void CacheExistingWindowHandles();

    public native void DetachClient();

    public native int GetThreadId();

    public native boolean IsConnected();

    public native void EnableEventListeners(int var1);

    public native void EnableCheckMode(boolean var1, int var2);

    public native void EnableRecordingMode(boolean var1, int var2);

    public native void SetPreference(String var1, String var2);

    public native String GetPreference(String var1);

    public native long GetNativeHandle(long var1);

    public native String GetClassName(long var1);

    public native String[] GetClassNames(long var1);

    public native long GetParent(long var1);

    public native long[] GetChildren(long var1);

    public native String[] GetChildrenWithAttributes(long var1, String[] var3);

    public native String[] GetHierarchyWithAttributes(long var1, String[] var3, long[] var4);

    public native int[] GetBounds(long var1);

    public native String GetAttribute(long var1, String var3);

    public native boolean SetAttribute(long var1, String var3, String var4);

    public native String[] GetAttributes(long var1, String[] var3);

    public native String EvalJS(long var1, String var3);

    public native void Highlight(long var1, int var3, int var4);

    public native long[] GetToplevels();

    public native long[] GetElementsByProperty(long var1, String var3, String var4);

    public native long[] FindAllWindows(long var1);

    public native boolean IsViaHWnd();

    public native void SetViaHWnd(boolean var1);

    public native boolean IsUia8();

    public native boolean SetTimeouts(int var1, int var2);

    public native long GetElementFromPoint(int var1, int var2);

    public native void ReleaseControls();

    public native String GetWindowClassName(long var1);

    public native String GetWindowText(long var1);

    public native boolean SetWindowText(long var1, String var3);

    public native int GetWindowLong(long var1, int var3);

    public native long SendMessage(long var1, int var3, long var4, long var6);

    public native void PostMessage(long var1, int var3, long var4, long var6);

    public native void SimulateMouseEvent(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    public native void SimulateKeyStroke(long var1, char var3, int var4, int var5);

    public native void SetFocus(long var1);

    public native boolean Move(long var1, int var3, int var4);

    public native boolean Resize(long var1, int var3, int var4);

    public native boolean Close(long var1);

    public native boolean BringToFront(long var1);

    public native void DoDefaultAction(long var1);

    public native void Invoke(long var1);

    public native void Select(long var1, int var3);

    public native boolean Toggle(long var1, int var3);

    public native boolean Expand(long var1, boolean var3);

    public native void Scroll(long var1, double var3, double var5);

    public native boolean ScrollIntoView(long var1);

    public native double GetScreenScaleFactor();

    public native void TriggerThread();

    public native void Terminate();

    public class InvalidThreadException
    extends RuntimeException {
        public InvalidThreadException() {
            super("Method called from invalid thread.");
            if (DefaultWinDriver.logger.level >= 7) {
                logger.lvlBuild(7, "InvalidThreadException.InvalidThreadException()", 856).log();
            }
        }
    }
}

