/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.win.windriver.event;

import de.qfs.lib.log.QFLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WinEvent {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.client.win.windriver.event.WinEvent");
    private static final Map eventTypeMap = new HashMap();
    private static final Map eventCodeMap = new HashMap();
    public static final int EvtConnect = 100;
    public static final int EvtTerminate = 101;
    public static final int EvtCallback = 120;
    public static final int EvtKey = 201;
    public static final int EvtMouse = 202;
    public static final int EvtChange = 203;
    public static final int EvtUia = 204;
    public static final int EvtMsaa = 205;
    public static final int EvtSize = 301;
    public static final int EvtClose = 302;
    public static final int TYPE_KEYEVENT = 201;
    public static final int TYPE_MOUSEEVENT = 202;
    public static final int WM_KEYDOWN = 256;
    public static final int WM_KEYUP = 257;
    public static final int WM_SYSKEYDOWN = 260;
    public static final int WM_SYSKEYUP = 261;
    public static final int WM_MOUSEMOVE = 512;
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_LBUTTONDBLCLK = 515;
    public static final int WM_RBUTTONDOWN = 516;
    public static final int WM_RBUTTONUP = 517;
    public static final int WM_RBUTTONDBLCLK = 518;
    public static final int WM_MBUTTONDOWN = 519;
    public static final int WM_MBUTTONUP = 520;
    public static final int WM_MBUTTONDBLCLK = 521;
    public static final int UIA_MenuOpened = 20003;
    public static final int UIA_MenuClosed = 20007;
    public static final int UIA_WindowOpened = 20016;
    public static final int UIA_WindowClosed = 20017;
    public static final int UIA_ExpandCollapseState = 30070;
    public static final int UIA_PropertyChanged = 4096;
    public static final int UIA_StructureChanged = 4097;
    public static final int MSAA_MenuOpened = 4;
    public static final int MSAA_MenuClosed = 5;
    public static final int MSAA_MenuPopupOpened = 6;
    public static final int MSAA_MenuPopupClosed = 7;
    public static final int MSAA_WindowOpened = 16;
    public static final int MSAA_WindowClosed = 17;
    public static final int MSAA_ObjectCreate = 32768;
    public static final int MSAA_ObjectDestroy = 32769;
    public static final int MSAA_ObjectShow = 32770;
    public static final int MSAA_ObjectHide = 32771;
    public static final int WIN_VK_RETURN = 13;
    public static final int WIN_VK_DELETE = 46;
    public static final int WIN_VK_SHIFT = 160;
    public static final int WIN_VK_CONTROL = 162;
    public static final int WIN_VK_ALT = 164;
    protected long timestamp;
    protected int type;
    protected long handle;
    protected int code;

    public static String eventTypeToString(int n2) {
        EventType eventType = (EventType)((Object)eventTypeMap.get(n2));
        if (eventType != null) {
            return eventType.getName();
        }
        return "" + n2;
    }

    public static String eventCodeToString(int n2) {
        EventCode eventCode = (EventCode)((Object)eventCodeMap.get(n2));
        if (eventCode != null) {
            return eventCode.getName();
        }
        return "" + n2;
    }

    public static boolean eventCodeKnown(int n2) {
        return eventCodeMap.containsKey(n2);
    }

    public static boolean eventCodeInteresting(int n2) {
        EventCode eventCode = (EventCode)((Object)eventCodeMap.get(n2));
        if (eventCode != null) {
            return eventCode.isInteresting();
        }
        return false;
    }

    public WinEvent() {
        this.timestamp = System.currentTimeMillis();
    }

    public WinEvent(int n2, long l2, int n3) {
        this.timestamp = 0L;
        this.type = n2;
        this.handle = l2;
        this.code = n3;
    }

    public WinEvent(int n2, long l2, int n3, long l3) {
        this.timestamp = l3;
        this.type = n2;
        this.handle = l2;
        this.code = n3;
    }

    public boolean eventCodeKnown() {
        return eventCodeMap.containsKey(this.code);
    }

    public boolean isInteresting() {
        return WinEvent.eventCodeInteresting(this.code);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[").append(this.paramString()).append("]");
        return stringBuilder.toString();
    }

    protected String paramString() {
        StringBuilder stringBuilder = new StringBuilder("handle=");
        stringBuilder.append(this.handle).append(",type=").append(WinEvent.eventTypeToString(this.type)).append(",code=").append(WinEvent.eventCodeToString(this.code));
        if (this.timestamp > 0L) {
            stringBuilder.append(",time=").append(new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(this.timestamp)));
        }
        return stringBuilder.toString();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getType() {
        return this.type;
    }

    public long getHandle() {
        return this.handle;
    }

    public int getCode() {
        return this.code;
    }

    static {
        for (EventType enum_ : EventType.values()) {
            eventTypeMap.put(enum_.getType(), enum_);
        }
        for (Enum enum_ : EventCode.values()) {
            eventCodeMap.put(((EventCode)enum_).getCode(), enum_);
        }
    }

    static enum EventType {
        EvtConnect(100, "EvtConnect"),
        EvtTerminate(101, "EvtTerminate"),
        EvtCallback(120, "EvtCallback"),
        EvtKey(201, "EvtKey"),
        EvtMouse(202, "EvtMouse"),
        EvtChange(203, "EvtChange"),
        EvtUia(204, "EvtUia"),
        EvtMsaa(205, "EvtMsaa"),
        EvtSize(301, "EvtSize"),
        EvtClose(302, "EvtClose");

        private final int type;
        private final String name;

        /*
         * WARNING - void declaration
         */
        private EventType() {
            void var4_1;
            void var3_2;
            this.type = var3_2;
            this.name = var4_1;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    static enum EventCode {
        WM_KEYDOWN(256, "WM_KEYDOWN"),
        WM_KEYUP(257, "WM_KEYUP"),
        WM_SYSKEYDOWN(260, "WM_SYSKEYDOWN"),
        WM_SYSKEYUP(261, "WM_SYSKEYUP"),
        WM_MOUSEMOVE(512, "WM_MOUSEMOVE"),
        WM_LBUTTONDOWN(513, "WM_LBUTTONDOWN"),
        WM_LBUTTONUP(514, "WM_LBUTTONUP"),
        WM_LBUTTONDBLCLK(515, "WM_LBUTTONDBLCLK"),
        WM_RBUTTONDOWN(516, "WM_RBUTTONDOWN"),
        WM_RBUTTONUP(517, "WM_RBUTTONUP"),
        WM_RBUTTONDBLCLK(518, "WM_RBUTTONDBLCLK"),
        WM_MBUTTONDOWN(519, "WM_MBUTTONDOWN"),
        WM_MBUTTONUP(520, "WM_MBUTTONUP"),
        WM_MBUTTONDBLCLK(521, "WM_MBUTTONDBLCLK"),
        UIA_MenuOpened(20003, "UIA_MenuOpened"),
        UIA_MenuClosed(20007, "UIA_MenuClosed"),
        UIA_WindowOpened(20016, "UIA_WindowOpened"),
        UIA_WindowClosed(20017, "UIA_WindowClosed"),
        UIA_ExpandCollapseState(30070, "UIA_ExpandCollapseState"),
        UIA_PropertyChanged(4096, "UIA_PropertyChanged"),
        UIA_StructureChanged(4097, "UIA_StructureChanged", false),
        MSAA_MenuOpened(4, "MSAA_MenuOpened"),
        MSAA_MenuClosed(5, "MSAA_MenuClosed"),
        MSAA_MenuPopupOpened(6, "MSAA_MenuPopupOpened"),
        MSAA_MenuPopupClosed(7, "MSAA_MenuPopupClosed"),
        MSAA_WindowOpened(16, "MSAA_WindowOpened"),
        MSAA_WindowClosed(17, "MSAA_WindowClosed"),
        MSAA_ObjectCreate(32768, "MSAA_ObjectCreate", false),
        MSAA_ObjectDestroy(32769, "MSAA_ObjectDestroy", false),
        MSAA_ObjectShow(32770, "MSAA_ObjectShow", false),
        MSAA_ObjectHide(32771, "MSAA_ObjectHide", false);

        private final int code;
        private final String name;
        private final boolean interesting;

        /*
         * WARNING - void declaration
         */
        private EventCode() {
            this((String)var1_-1, (int)var2_-1, (int)var3_2, (String)var4_1, true);
            void var4_1;
            void var3_2;
            void var2_-1;
            void var1_-1;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EventCode(boolean bl2) {
            void var5_3;
            void var4_2;
            this.code = bl2 ? 1 : 0;
            this.name = var4_2;
            this.interesting = var5_3;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInteresting() {
            return this.interesting;
        }
    }
}

