/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.extensions.generic;

import de.qfs.apps.qftest.client.Engine;
import de.qfs.apps.qftest.client.PrivilegedRunnable;
import de.qfs.apps.qftest.extensions.BusyApplicationDetector;
import de.qfs.apps.qftest.extensions.EventSynchronizer;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;

public class GenericEventSynchronizer
implements EventSynchronizer {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.extensions.generic.GenericEventSynchronizer");
    private final PrivilegedRunnable b;
    protected int sleepTime = 99;
    protected int initialSleepTime = 10;
    protected int duration = 10000;

    public GenericEventSynchronizer(final BusyApplicationDetector busyApplicationDetector) {
        if (GenericEventSynchronizer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "GenericEventSynchronizer(BusyApplicationDetector)", 51).addDetail("busyResolver", (Object)busyApplicationDetector)).log();
        }
        if (busyApplicationDetector == null) {
            throw new IllegalArgumentException("busyResolver is marked non-null but is null");
        }
        this.b = new PrivilegedRunnable(){

            @Override
            public void doRun() {
                if (a.level >= 7) {
                    a.lvlBuild(7, "GenericEventSynchronizer(BusyApplicationDetector).PrivilegedRunnable<Boolean>.doRun()", 56).log();
                }
                Boolean bl2 = busyApplicationDetector.applicationIsBusy();
                this.setReturnValue(bl2);
            }
        };
    }

    @Override
    public void sync(Object object) {
        Boolean bl2;
        if (GenericEventSynchronizer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "sync(Object)", 65).addDetail("context", object)).log();
        }
        if (this.duration <= 0) {
            return;
        }
        long l2 = System.currentTimeMillis() + (long)this.getDuration();
        if (GenericEventSynchronizer.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "sync(Object)", 73).add("until", l2)).log();
        }
        try {
            if (this.getInitialSleepTime() > 0) {
                if (GenericEventSynchronizer.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "sync(Object)", 77).add("Sleep initialsleeptime: ", this.getInitialSleepTime())).log();
                }
                Thread.sleep(this.getInitialSleepTime());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (Boolean.TRUE.equals(bl2 = (Boolean)((Engine)object).safeInvokeNow(this.b, new Class[0])) && System.currentTimeMillis() <= l2) {
            try {
                int n2 = this.getSleepTime();
                if (n2 <= 0) continue;
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getSleepTime() {
        if (GenericEventSynchronizer.a.level >= 7) {
            a.lvlBuild(7, "getSleepTime()", 38).log();
        }
        return this.sleepTime;
    }

    public GenericEventSynchronizer setSleepTime(int n2) {
        if (GenericEventSynchronizer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setSleepTime(int)", 38).addDetail("sleepTime", n2)).log();
        }
        this.sleepTime = n2;
        return this;
    }

    public int getInitialSleepTime() {
        if (GenericEventSynchronizer.a.level >= 7) {
            a.lvlBuild(7, "getInitialSleepTime()", 43).log();
        }
        return this.initialSleepTime;
    }

    public GenericEventSynchronizer setInitialSleepTime(int n2) {
        if (GenericEventSynchronizer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setInitialSleepTime(int)", 43).addDetail("initialSleepTime", n2)).log();
        }
        this.initialSleepTime = n2;
        return this;
    }

    public int getDuration() {
        if (GenericEventSynchronizer.a.level >= 7) {
            a.lvlBuild(7, "getDuration()", 48).log();
        }
        return this.duration;
    }

    public GenericEventSynchronizer setDuration(int n2) {
        if (GenericEventSynchronizer.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setDuration(int)", 48).addDetail("duration", n2)).log();
        }
        this.duration = n2;
        return this;
    }
}

