/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.lib.log.Logger;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Blocker
extends EventQueue {
    private static final Blocker instance = new Blocker();
    private Vector blockedComponents = new Vector();
    private EventQueue sysQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.Blocker");

    private Blocker() {
        this.sysQ.push(this);
    }

    public static synchronized Blocker Instance() {
        return instance;
    }

    public void setBlocking(Component component, boolean bl) {
        if (bl) {
            if (!this.blockedComponents.contains(component)) {
                this.blockedComponents.add(component);
            }
        } else {
            this.blockedComponents.remove(component);
        }
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        Component component;
        boolean bl;
        if (Blocker.logger.level >= 7) {
            logger.log(7, "dispatchEvent(AWTEvent)", Blocker.logger.level < 8 ? "" : "event: " + aWTEvent);
        }
        if ((bl = this.isSourceBlocked(component = Blocker.getSource(aWTEvent))) && aWTEvent instanceof InputEvent) {
            return;
        }
        super.dispatchEvent(aWTEvent);
    }

    private static Component getSource(AWTEvent aWTEvent) {
        Component component = null;
        if (aWTEvent instanceof MouseEvent && aWTEvent.getID() != 506 && aWTEvent.getID() != 504 && aWTEvent.getID() != 505 && aWTEvent.getID() != 503 && aWTEvent.getID() != 502) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (aWTEvent instanceof KeyEvent && aWTEvent.getSource() instanceof Component) {
            component = SwingUtilities.findFocusOwner((Component)aWTEvent.getSource());
        }
        return component;
    }

    public boolean isSourceBlocked(Component component) {
        if (component == null) {
            return false;
        }
        Enumeration enumeration = this.blockedComponents.elements();
        while (enumeration.hasMoreElements()) {
            Component component2 = (Component)enumeration.nextElement();
            if (!SwingUtilities.isDescendingFrom(component, component2)) continue;
            return true;
        }
        return false;
    }
}

