/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.apps.qftest.demo.Incrementer;
import de.qfs.apps.qftest.demo.IncrementerImpl;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Increment {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.Increment");

    public static void main(String[] stringArray) {
        Log.setOutputLevel((int)4);
        final ArgsParser argsParser = new ArgsParser();
        argsParser.setOptions(new String[]{"+host", "+port"});
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
            LogSetup.instance().setupLogging("increment", argsParser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = Increment.makeFrame(argsParser);
                SwingUtil.centerWindow((Window)jFrame);
                SwingUtil.closeOnEscape((Window)jFrame);
                jFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        Increment.exit(0);
                    }
                });
                jFrame.show();
            }
        });
    }

    private static JFrame makeFrame(ArgsParser argsParser) {
        Object object;
        String string;
        Serializable serializable;
        Object object2;
        IncrementerImpl incrementerImpl;
        JButton jButton;
        JTextField jTextField;
        Grid grid;
        JFrame jFrame;
        block6: {
            jFrame = new JFrame("Increment demo");
            grid = new Grid();
            jFrame.getContentPane().add((Component)grid);
            grid.addGlue();
            SwingUtil.prepareKeymaps();
            jTextField = new JTextField("1");
            jTextField.setName("value");
            jTextField.setPreferredSize(new Dimension(200, jTextField.getPreferredSize().height));
            grid.addLine(new Component[]{jTextField});
            grid.addGlue();
            jButton = new JButton("Increment");
            jButton.setName("increment");
            int n = argsParser.getInt("port", -1);
            if (Increment.logger.level >= 9) {
                logger.build("makeFrame()").add("port: ").add(n).log(9);
            }
            incrementerImpl = null;
            object2 = null;
            if (n > 0) {
                try {
                    incrementerImpl = new IncrementerImpl();
                    if (Increment.logger.level >= 9) {
                        logger.build("makeFrame(ArgsParser)").add("incrementer: ").add((Object)incrementerImpl).log(9);
                    }
                    serializable = InetAddress.getByName(argsParser.getString("host", "localhost"));
                    string = ((InetAddress)serializable).getHostAddress();
                    object = LocateRegistry.getRegistry(string, n);
                    object2 = (Incrementer)object.lookup("incr");
                    if (Increment.logger.level >= 9) {
                        logger.build("makeFrame(ArgsParser)").add("rmiIncrementer: ").add(object2).log(9);
                    }
                }
                catch (Throwable throwable) {
                    if (Increment.logger.level < 1) break block6;
                    logger.log(1, "makeFrame()", throwable);
                }
            }
        }
        serializable = incrementerImpl;
        string = object2;
        jButton.addActionListener(new ActionListener((Incrementer)((Object)serializable), (Incrementer)((Object)string)){
            final /* synthetic */ Incrementer val$fincr;
            final /* synthetic */ Incrementer val$frincr;
            {
                this.val$fincr = incrementer;
                this.val$frincr = incrementer2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    block8: {
                        n = Integer.parseInt(jTextField.getText());
                        if (this.val$fincr != null) {
                            try {
                                n = this.val$frincr.increment(n);
                                if (logger.level >= 9) {
                                    logger.build("makeFrame(ArgsParser)").add("val: ").add(n).log(9);
                                }
                                int n2 = this.val$frincr.call(this.val$fincr, n);
                                if (logger.level >= 9) {
                                    logger.build("makeFrame(ArgsParser)").add("val2: ").add(n2).log(9);
                                }
                                break block8;
                            }
                            catch (Throwable throwable) {
                                if (logger.level >= 1) {
                                    logger.log(1, "makeFrame(ArgsParser)", throwable);
                                }
                                break block8;
                            }
                        }
                        ++n;
                    }
                    jTextField.setText("" + n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        jFrame.getRootPane().setDefaultButton(jButton);
        jButton.setPreferredSize(new Dimension(100, jButton.getPreferredSize().height));
        object = new JButton("Exit");
        ((Component)object).setName("exit");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Increment.exit(0);
            }
        });
        ((JComponent)object).setPreferredSize(new Dimension(100, ((JComponent)object).getPreferredSize().height));
        grid.addLine(new Component[]{jButton, Box.createHorizontalGlue(), object});
        jFrame.pack();
        return jFrame;
    }

    private static void exit(int n) {
        LogSetup.instance().stopLogging();
        System.exit(n);
    }
}

