/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.apps.qftest.demo.Increment;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public abstract class MenuDemo {
    private static ActionListener exitAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MenuDemo.exit(0);
        }
    };

    public static void main(String[] stringArray) {
        Log.setOutputLevel((int)4);
        ArgsParser argsParser = new ArgsParser();
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
            LogSetup.instance().setupLogging("menu", argsParser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = MenuDemo.makeFrame();
        SwingUtil.centerWindow((Window)jFrame);
        SwingUtil.closeOnEscape((Window)jFrame);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MenuDemo.exit(0);
            }
        });
        new JDK11BugThread().start();
        jFrame.show();
    }

    private static JFrame makeFrame() {
        JFrame jFrame = new JFrame("Menu demo");
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setName("MenuBar");
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setName("mFile");
        jMenu.setMnemonic('f');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New...");
        jMenuItem.setName("miNew");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open...");
        jMenuItem.setName("miOpen");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setName("miSave");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as...");
        jMenuItem.setName("miSaveAs");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setName("miExit");
        jMenuItem.addActionListener(exitAction);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic('h');
        jMenu.setName("mHelp");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("About...");
        jMenuItem.setName("miAbout");
        jMenu.add(jMenuItem);
        JTextField jTextField = new JTextField();
        jTextField.setName("text");
        jFrame.getContentPane().add(jTextField);
        jFrame.pack();
        return jFrame;
    }

    private static void exit(int n) {
        LogSetup.instance().stopLogging();
        System.exit(n);
    }

    private static class JDK11BugThread
    extends Thread {
        Class[] bug = new Class[]{Increment.class, Log.class, Logger.class};

        public JDK11BugThread() {
            this.setDaemon(true);
            this.setName("JDK1.1 Bug Workaroud Thread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JDK11BugThread.sleep(3600000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

