/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.FxCarConfig;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.AccessoriesStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.InfoStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.LoginStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MessageBox;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.PurchaseOrderStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.SpecialsStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.StatisticsStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.VehiclesStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ViewOrderStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Defaults;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Special;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Vehicle;
import java.util.Collection;
import java.util.InputMismatchException;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.util.Callback;

public class MainStage
extends CarConfigFxStage {
    FxCarConfig runnerClass;
    MainStage mainStage = this;
    public LinkedList vehicles;
    public LinkedList specials;
    public LinkedList accessories;
    public Vehicle selectedVehicle;
    public Special selectedSpecial;
    public LinkedList selectedAccessories = new LinkedList();
    public GridPane accessoryGridPane;
    public GridPane vehicleGridPane;
    TabPane tabpane;
    private TableView vehiclesView;
    private ComboBox specialsSelection;
    private TextArea specialsArea;
    private TableView accessoryView;
    public CheckBox accessoryChkBox;
    private TextField basePrice;
    private TextField specialsPrice;
    private TextField discountValue;
    private TextField calculatedPrice;
    private boolean specialsPaneEventLocked = false;

    public MainStage(CarConfigFxParameters carConfigFxParameters, FxCarConfig fxCarConfig) {
        super(carConfigFxParameters);
        this.setTitle("CarConfigurator JavaFX");
        this.runnerClass = fxCarConfig;
        this.vehicles = Defaults.getDefaultVehicles(carConfigFxParameters.getLanguage());
        this.accessories = Defaults.getDefaultAccessories(carConfigFxParameters.getLanguage());
        this.specials = Defaults.getDefaultSpecials(carConfigFxParameters.getLanguage(), this.accessories);
        this.selectedSpecial = (Special)this.specials.getFirst();
        BorderPane borderPane = new BorderPane();
        borderPane.setId("CarConfiguratorFX");
        borderPane.setStyle(this.getCSSString());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        VBox vBox = new VBox();
        vBox.getChildren().setAll((Object[])new Node[]{this.makeMenu(carConfigFxParameters)});
        borderPane.setTop((Node)vBox);
        borderPane.setCenter(this.makeCenterTablePanels());
        borderPane.setBottom((Node)this.makeCalculationPane());
        this.updateAllPanes();
    }

    private MenuBar makeMenu(CarConfigFxParameters carConfigFxParameters) {
        MenuBar menuBar = new MenuBar();
        menuBar.setId("MenuBar");
        Menu menu = new Menu(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.file.name"), LangCountrySettings.getLanguageString("menu.file.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId("mFile");
        menuBar.getMenus().add((Object)menu);
        MenuItem menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.file.reset.name"), LangCountrySettings.getLanguageString("menu.file.reset.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miReset");
        menuItem.setOnAction((EventHandler)new miResetActionHandler(this));
        menu.getItems().add((Object)menuItem);
        if (carConfigFxParameters.getLogin()) {
            menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.file.logout.name"), LangCountrySettings.getLanguageString("menu.file.logout.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId("miLogout");
            menuItem.setOnAction((EventHandler)new miLogoutActionHandler(this));
            menu.getItems().add((Object)menuItem);
        }
        menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.file.exit.name"), LangCountrySettings.getLanguageString("menu.file.exit.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miExit");
        menuItem.setOnAction((EventHandler)new miExitActionHandler());
        menu.getItems().add((Object)menuItem);
        menu = new Menu(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.options.name"), LangCountrySettings.getLanguageString("menu.options.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId("mOptions");
        menuBar.getMenus().add((Object)menu);
        menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.options.vehicles.name"), LangCountrySettings.getLanguageString("menu.options.vehicles.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miVehicles");
        menuItem.setOnAction((EventHandler)new miVehiclesActionHandler(this));
        menu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.options.specials.name"), LangCountrySettings.getLanguageString("menu.options.specials.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miSpecials");
        menuItem.setOnAction((EventHandler)new miSpecialsActionHandler(this));
        menu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.options.accessories.name"), LangCountrySettings.getLanguageString("menu.options.accessories.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miAccessories");
        menuItem.setOnAction((EventHandler)new miAccessoriesActionHandler(this));
        menu.getItems().add((Object)menuItem);
        if (this.isStandardUser()) {
            menu = new Menu(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.order.name"), LangCountrySettings.getLanguageString("menu.order.mnemonic")));
            menu.setMnemonicParsing(true);
            menu.setId("mOrder");
            menuBar.getMenus().add((Object)menu);
            menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.order.view.name"), LangCountrySettings.getLanguageString("menu.order.view.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId("miViewOrder");
            menuItem.setOnAction((EventHandler)new miViewOrderActionHandler(this));
            menu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.order.send.name"), LangCountrySettings.getLanguageString("menu.order.send.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId("miSendOrder");
            menuItem.setOnAction((EventHandler)new miSendOrderActionHandler(this));
            menu.getItems().add((Object)menuItem);
            menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.order.statistics.name"), LangCountrySettings.getLanguageString("menu.order.statistics.mnemonic")));
            menuItem.setMnemonicParsing(true);
            menuItem.setId("miShowStatistics");
            menuItem.setOnAction((EventHandler)new miStatisticsActionHandler(this));
            menu.getItems().add((Object)menuItem);
        }
        menu = new Menu(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.help.name"), LangCountrySettings.getLanguageString("menu.help.mnemonic")));
        menu.setMnemonicParsing(true);
        menu.setId("mHelp");
        menuBar.getMenus().add((Object)menu);
        menuItem = new MenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.help.about.name"), LangCountrySettings.getLanguageString("menu.help.about.mnemonic")));
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miInfo");
        menuItem.setOnAction((EventHandler)new miInfoActionHandler(this.params.getNewVersion()));
        menu.getItems().add((Object)menuItem);
        CheckMenuItem checkMenuItem = new CheckMenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.help.buggy.name"), LangCountrySettings.getLanguageString("menu.help.buggy.mnemonic")));
        checkMenuItem.setMnemonicParsing(true);
        checkMenuItem.setId("miBuggy");
        checkMenuItem.setOnAction((EventHandler)new miBuggyActionHandler(this));
        checkMenuItem.setSelected(carConfigFxParameters.getBuggy());
        menu.getItems().add((Object)checkMenuItem);
        CheckMenuItem checkMenuItem2 = new CheckMenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.help.newversion.name"), LangCountrySettings.getLanguageString("menu.help.newversion.mnemonic")));
        checkMenuItem2.setMnemonicParsing(true);
        checkMenuItem2.setOnAction((EventHandler)new miNewVersionActionHandler(this));
        checkMenuItem2.setSelected(carConfigFxParameters.getNewVersion());
        checkMenuItem2.setId("miNewVersion");
        menu.getItems().add((Object)checkMenuItem2);
        CheckMenuItem checkMenuItem3 = new CheckMenuItem(this.toMnemonicMenuString(LangCountrySettings.getLanguageString("menu.help.loadtest.name"), LangCountrySettings.getLanguageString("menu.help.loadtest.mnemonic")));
        checkMenuItem3.setMnemonicParsing(true);
        checkMenuItem3.setId("miLoadtest");
        checkMenuItem3.setOnAction((EventHandler)new miLoadTestActionHandler(this));
        checkMenuItem3.setSelected(carConfigFxParameters.getLoadTest());
        menu.getItems().add((Object)checkMenuItem3);
        return menuBar;
    }

    public boolean isStandardUser() {
        return Utility.isStandardUser(this.params.getUser());
    }

    public String toMnemonicMenuString(String string, String string2) {
        String string3 = null;
        char c = Character.toLowerCase(string2.charAt(0));
        for (int i = 0; i < string.length(); ++i) {
            if (Character.toLowerCase(string.charAt(i)) != c) continue;
            string3 = string.substring(0, i) + "_" + string.substring(i);
            break;
        }
        return string3 == null ? string : string3;
    }

    public Node makeCenterTablePanels() {
        this.tabpane = new TabPane();
        this.tabpane.setPrefWidth(400.0);
        this.tabpane.setPrefHeight(300.0);
        this.tabpane.setId("TabbedPane");
        Tab tab = new Tab();
        Tab tab2 = new Tab();
        Tab tab3 = new Tab();
        tab.setId("VehicleTablePanel");
        tab2.setId("SpecialsPanel");
        tab3.setId("AccessoryTablePanel");
        tab.setText(LangCountrySettings.getLanguageString("panel.vehicles.name"));
        tab2.setText(LangCountrySettings.getLanguageString("panel.specials.name"));
        tab3.setText(LangCountrySettings.getLanguageString("panel.accessories.name"));
        tab.setContent(this.makeVehiclesTabContent());
        tab2.setContent(this.makeSpecialsTabContent());
        tab3.setContent(this.makeAccessoriesTabContent());
        this.tabpane.getTabs().addAll((Object[])new Tab[]{tab, tab2, tab3});
        this.tabpane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.tabpane.getSelectionModel().select(this.params.getSelectedTab());
        return this.tabpane;
    }

    public GridPane makeCalculationPane() {
        GridPane gridPane = new GridPane();
        gridPane.setId("CalculatorPanel");
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(45.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(45.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setPercentWidth(10.0);
        columnConstraints3.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints3);
        this.basePrice = new TextField("");
        this.basePrice.setText("$ 0.00");
        this.basePrice.setId("BasePrice");
        this.basePrice.setEditable(false);
        this.basePrice.setStyle("-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;");
        Label label = new Label(LangCountrySettings.getLanguageString("panel.vehicles.label"));
        label.setLabelFor((Node)this.basePrice);
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)this.basePrice, 1, 0);
        this.specialsPrice = new TextField("");
        this.specialsPrice.setId("SpecialsPrice");
        this.specialsPrice.setText("$ 0.00");
        this.specialsPrice.setEditable(false);
        this.specialsPrice.setStyle("-fx-alignment: center-right; -fx-border-color: null;-fx-background-color: null; -fx-select-on-focus:false;");
        Label label2 = new Label(LangCountrySettings.getLanguageString("panel.specials.label"));
        label2.setLabelFor((Node)this.specialsPrice);
        gridPane.add((Node)label2, 0, 1);
        gridPane.add((Node)this.specialsPrice, 1, 1);
        this.discountValue = new TextField("0%");
        this.discountValue.setId("DiscountValue");
        this.discountValue.setEditable(true);
        this.discountValue.setStyle("-fx-alignment: center-right;");
        this.discountValue.setMaxWidth(50.0);
        this.discountValue.setOnMousePressed(new EventHandler(){

            public void handle(MouseEvent mouseEvent) {
                MainStage.this.discountValue.selectAll();
            }
        });
        this.discountValue.setOnKeyReleased(new EventHandler(){

            public void handle(KeyEvent keyEvent) {
                MainStage.this.updateDiscount();
            }
        });
        Label label3 = new Label(LangCountrySettings.getLanguageString("panel.price.discount"));
        label3.setLabelFor((Node)this.discountValue);
        gridPane.add((Node)label3, 0, 2);
        gridPane.add((Node)this.discountValue, 1, 2);
        this.calculatedPrice = new TextField("$ 0.00");
        this.calculatedPrice.setId("CalculatedPrice");
        this.calculatedPrice.setEditable(false);
        this.calculatedPrice.setStyle("-fx-text-fill: blue; -fx-alignment: center-right; -fx-background-color: null; -fx-border-color: null; -fx-select-on-focus:false;");
        Label label4 = new Label(LangCountrySettings.getLanguageString("panel.price.calculated"));
        label4.setStyle("-fx-text-fill: blue; -fx-alignment: center-right; -fx-background-color: null; -fx-border-color: null; -fx-select-on-focus:false;");
        label4.setLabelFor((Node)this.calculatedPrice);
        gridPane.add((Node)label4, 0, 3);
        gridPane.add((Node)this.calculatedPrice, 1, 3);
        Button button = new Button("-5%");
        button.setOnAction((EventHandler)new GrantDiscountButtonListener());
        gridPane.add((Node)button, 2, 3);
        return gridPane;
    }

    public void updateDiscount() {
        try {
            double d = Utility.parseDiscount(this.params.getBuggy(), this.discountValue.getText());
            this.params.setDiscount(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = LangCountrySettings.getLanguageString("error.discount.invalid");
            MessageBox.showOkDialog(this.mainStage, null, "CarConfigurator - Error", string);
            this.params.setDiscount(0.0);
            this.discountValue.setText("0%");
        }
        catch (InputMismatchException inputMismatchException) {
            String string = LangCountrySettings.getLanguageString("error.discount.hundred");
            MessageBox.showOkDialog(this.mainStage, null, "CarConfigurator - Error", string);
            this.params.setDiscount(0.0);
            this.discountValue.setText("0%");
        }
        this.updateCalculationPane();
    }

    public void updateAllPanes() {
        this.updateCalculationPane();
        this.updateVehiclesPane();
        this.updateSpecialsPane();
        this.updateAccessoriesPane();
    }

    public void updateCalculationPane() {
        double d = this.selectedVehicle == null ? 0.0 : this.selectedVehicle.price;
        this.basePrice.setText(Utility.convertDoubleToPriceString(d, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
        double d2 = this.selectedSpecial != null ? this.selectedSpecial.price : 0.0;
        this.specialsPrice.setText(Utility.convertDoubleToPriceString(d2, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
        double d3 = Utility.calculateFinalPrice(this.params.getBuggy(), this.selectedVehicle, this.selectedSpecial, this.params.getDiscount(), this.selectedAccessories, this.accessoryChkBox.isSelected());
        this.calculatedPrice.setText(Utility.convertDoubleToPriceString(d3, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
    }

    public void updateVehiclesPane() {
        this.vehicleGridPane.getChildren().remove((Object)this.vehiclesView);
        this.vehiclesView = new TableView();
        this.vehiclesView.setId("VehicleTable");
        this.vehiclesView.setEditable(false);
        this.vehiclesView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.vehiclesView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new VehiclesTableSelectedIndizesChangedEventHandler(this));
        this.vehiclesView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.vehicleGridPane.add((Node)this.vehiclesView, 0, 1);
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn.setMinWidth(50.0);
        tableColumn2.setMinWidth(10.0);
        tableColumn3.setMinWidth(50.0);
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText("Modell");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Model");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        if (this.params.getNewVersion()) {
            this.vehiclesView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        } else {
            this.vehiclesView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn3});
        }
        this.mainStage.vehiclesView.getItems().clear();
        this.mainStage.vehiclesView.setItems(FXCollections.observableArrayList((Collection)this.mainStage.vehicles));
        if (this.mainStage.selectedVehicle != null) {
            this.mainStage.vehiclesView.getSelectionModel().select((Object)this.mainStage.selectedVehicle);
        }
        ((TableColumn)this.mainStage.vehiclesView.getColumns().get(1)).setVisible(false);
        ((TableColumn)this.mainStage.vehiclesView.getColumns().get(1)).setVisible(true);
    }

    public void updateSpecialsPane() {
        this.specialsPaneEventLocked = true;
        this.specialsSelection.getItems().clear();
        for (Special special : this.specials) {
            this.specialsSelection.getItems().add((Object)special);
        }
        this.specialsSelection.getSelectionModel().select((Object)this.selectedSpecial);
        if (this.selectedSpecial != null) {
            this.specialsArea.setText(this.selectedSpecial.description);
        } else {
            this.specialsArea.setText("");
        }
        this.specialsPaneEventLocked = false;
    }

    public Node makeVehiclesTabContent() {
        GridPane gridPane;
        this.vehicleGridPane = gridPane = new GridPane();
        gridPane.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setId("VehicleTablePanel");
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(LangCountrySettings.getLanguageString("panel.vehicles.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.vehiclesView = new TableView();
        this.vehiclesView.setId("VehicleTable");
        this.vehiclesView.setEditable(false);
        this.vehiclesView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.vehiclesView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new VehiclesTableSelectedIndizesChangedEventHandler(this));
        this.vehiclesView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.add((Node)this.vehiclesView, 0, 1);
        return gridPane;
    }

    public Node makeSpecialsTabContent() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPrefHeight(Double.MAX_VALUE);
        gridPane.setMaxHeight(Double.MAX_VALUE);
        gridPane.setId("SpecialsPanel");
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(LangCountrySettings.getLanguageString("panel.specials.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.specialsSelection = new ComboBox();
        this.specialsSelection.setId("SpecialsCombo");
        this.specialsSelection.setMaxWidth(Double.MAX_VALUE);
        this.specialsSelection.valueProperty().addListener((ChangeListener)new SpecialsSelectionValueChangedEventHandler(this));
        gridPane.add((Node)this.specialsSelection, 0, 1);
        this.specialsArea = new TextArea();
        this.specialsArea.setId("SpecialsArea");
        this.specialsArea.setEditable(false);
        this.specialsArea.setMaxWidth(Double.MAX_VALUE);
        this.specialsArea.setPrefHeight(2.147483647E9);
        this.specialsArea.setMaxHeight(Double.MAX_VALUE);
        gridPane.add((Node)this.specialsArea, 0, 2);
        return gridPane;
    }

    public Node makeAccessoriesTabContent() {
        GridPane gridPane;
        this.accessoryGridPane = gridPane = new GridPane();
        gridPane.setPadding(new Insets(7.0, 7.0, 7.0, 7.0));
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPrefHeight(Double.MAX_VALUE);
        gridPane.setMaxHeight(Double.MAX_VALUE);
        gridPane.setId("AccessoryTablePanel");
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        Label label = new Label(LangCountrySettings.getLanguageString("panel.accessories.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.accessoryView = new TableView();
        this.accessoryView.setId("AccessoryTable");
        this.accessoryView.setEditable(false);
        this.accessoryView.getSelectionModel().setCellSelectionEnabled(false);
        this.accessoryView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.add((Node)this.accessoryView, 0, 1);
        this.accessoryChkBox = new CheckBox(LangCountrySettings.getLanguageString("panel.accessories.withprice"));
        this.accessoryChkBox.setId("AddAccessoryPriceChkbox");
        this.accessoryChkBox.selectedProperty().setValue(Boolean.TRUE);
        this.accessoryChkBox.selectedProperty().addListener((ChangeListener)new AddAccessoryToFinalPriceChkBoxEventHandler());
        gridPane.add((Node)this.accessoryChkBox, 0, 2);
        return gridPane;
    }

    public void updateAccessoriesPane() {
        this.accessoryGridPane.getChildren().remove((Object)this.accessoryView);
        this.accessoryView = new TableView();
        this.accessoryView.setId("AccessoryTable");
        this.accessoryView.setEditable(false);
        this.accessoryView.getSelectionModel().setCellSelectionEnabled(false);
        this.accessoryView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.accessoryGridPane.add((Node)this.accessoryView, 0, 1);
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        TableColumn tableColumn4 = new TableColumn();
        tableColumn.setMinWidth(30.0);
        tableColumn2.setMinWidth(200.0);
        tableColumn3.setMinWidth(50.0);
        tableColumn4.setMinWidth(100.0);
        CheckboxCellCallback checkboxCellCallback = new CheckboxCellCallback();
        tableColumn.setCellFactory((Callback)checkboxCellCallback);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("this"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn4.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText(" ");
            tableColumn2.setText("Beschreibung");
            tableColumn3.setText("ID");
            tableColumn4.setText("Preis");
        } else {
            tableColumn.setText(" ");
            tableColumn2.setText("Description");
            tableColumn3.setText("ID");
            tableColumn4.setText("Price");
        }
        this.accessoryView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4});
        this.accessoryView.getItems().setAll((Collection)this.accessories);
    }

    class GrantDiscountButtonListener
    implements EventHandler {
        GrantDiscountButtonListener() {
        }

        public void handle(ActionEvent actionEvent) {
            int n = 5;
            if (MainStage.this.params.getBuggy()) {
                n = 3;
            }
            double d = 0.0;
            try {
                d = Utility.parseDiscount(MainStage.this.params.getBuggy(), MainStage.this.discountValue.getText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InputMismatchException inputMismatchException) {
                // empty catch block
            }
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += (double)n) > 99.0) {
                d = 99.0;
            }
            MainStage.this.params.setDiscount(d);
            MainStage.this.discountValue.setText(d + "%");
            MainStage.this.updateCalculationPane();
        }
    }

    public class CheckboxCellCallback
    implements Callback {
        public TableCell call(TableColumn tableColumn) {
            return new CheckBoxAccessoryTableCell(MainStage.this.mainStage);
        }
    }

    public static class CheckBoxAccessoryTableCell
    extends TableCell {
        private final CheckBox checkBox;
        private ObservableValue ov;
        private Accessory accessory;
        private MainStage mainStage;
        private boolean blockEventHandling = false;

        public CheckBoxAccessoryTableCell(MainStage mainStage) {
            this.mainStage = mainStage;
            this.checkBox = new CheckBox();
            this.checkBox.visibleProperty().setValue(Boolean.valueOf(false));
            this.checkBox.setAlignment(Pos.CENTER);
            this.checkBox.selectedProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object object, Object object2) {
                    if (accessory == null || blockEventHandling) {
                        return;
                    }
                    if (!((CheckBoxAccessoryTableCell)this).mainStage.selectedAccessories.remove(accessory)) {
                        ((CheckBoxAccessoryTableCell)this).mainStage.selectedAccessories.add(accessory);
                    }
                    mainStage.updateCalculationPane();
                }
            });
            this.setAlignment(Pos.CENTER);
            this.setGraphic((Node)this.checkBox);
        }

        protected void updateItem(Accessory accessory, boolean bl) {
            this.blockEventHandling = true;
            super.updateItem((Object)accessory, bl);
            if (!bl) {
                this.accessory = accessory;
                this.ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                this.checkBox.setVisible(true);
                this.checkBox.setSelected(this.mainStage.selectedAccessories.contains(accessory));
            }
            this.blockEventHandling = false;
        }
    }

    class AddAccessoryToFinalPriceChkBoxEventHandler
    implements ChangeListener {
        AddAccessoryToFinalPriceChkBoxEventHandler() {
        }

        public void changed(ObservableValue observableValue, Object object, Object object2) {
            MainStage.this.updateCalculationPane();
        }
    }

    class SpecialsSelectionValueChangedEventHandler
    implements ChangeListener {
        MainStage mainStage;

        public SpecialsSelectionValueChangedEventHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void changed(ObservableValue observableValue, Object object, Object object2) {
            if (MainStage.this.specialsPaneEventLocked) {
                return;
            }
            this.mainStage.selectedSpecial = (Special)this.mainStage.specialsSelection.getSelectionModel().getSelectedItem();
            if (this.mainStage.selectedSpecial != null) {
                this.mainStage.specialsArea.setText(this.mainStage.selectedSpecial.description);
            }
            this.mainStage.updateCalculationPane();
        }
    }

    class VehiclesTableSelectedIndizesChangedEventHandler
    implements ChangeListener {
        public MainStage mainStage;

        public VehiclesTableSelectedIndizesChangedEventHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void changed(ObservableValue observableValue, Vehicle vehicle, Vehicle vehicle2) {
            this.mainStage.selectedVehicle = (Vehicle)this.mainStage.vehiclesView.getSelectionModel().getSelectedItem();
            if (MainStage.this.params.getBuggy() && this.mainStage.vehiclesView.getSelectionModel().getSelectedIndex() == MainStage.this.vehicles.size() - 1) {
                this.mainStage.selectedVehicle = null;
            }
            this.mainStage.updateCalculationPane();
        }
    }

    class miLoadTestActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miLoadTestActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            MainStage.this.params.setLoadTest(!MainStage.this.params.getLoadTest());
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            checkMenuItem.setSelected(MainStage.this.params.getLoadTest());
        }
    }

    class miNewVersionActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miNewVersionActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            MainStage.this.params.setNewVersion(!MainStage.this.params.getNewVersion());
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            checkMenuItem.setSelected(MainStage.this.params.getNewVersion());
            this.mainStage.updateAllPanes();
        }
    }

    class miBuggyActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miBuggyActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            MainStage.this.params.setBuggyMode(!MainStage.this.params.getBuggy());
            CheckMenuItem checkMenuItem = (CheckMenuItem)actionEvent.getSource();
            checkMenuItem.setSelected(MainStage.this.params.getBuggy());
            this.mainStage.updateAllPanes();
        }
    }

    class miInfoActionHandler
    implements EventHandler {
        private boolean newVersion;

        public miInfoActionHandler(boolean bl) {
            this.newVersion = bl;
        }

        public void handle(ActionEvent actionEvent) {
            InfoStage infoStage = new InfoStage(MainStage.this.mainStage.params);
            infoStage.initModality(Modality.WINDOW_MODAL);
            infoStage.initOwner(MainStage.this.getScene().getWindow());
            infoStage.showAndWait();
        }
    }

    class miSendOrderActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miSendOrderActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            PurchaseOrderStage purchaseOrderStage = new PurchaseOrderStage(this.mainStage);
            purchaseOrderStage.initModality(Modality.WINDOW_MODAL);
            purchaseOrderStage.initOwner(MainStage.this.getScene().getWindow());
            purchaseOrderStage.showAndWait();
        }
    }

    class miStatisticsActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miStatisticsActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            StatisticsStage statisticsStage = new StatisticsStage(this.mainStage);
            statisticsStage.initModality(Modality.WINDOW_MODAL);
            statisticsStage.initOwner(MainStage.this.getScene().getWindow());
            statisticsStage.showAndWait();
        }
    }

    class miViewOrderActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miViewOrderActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            ViewOrderStage viewOrderStage = new ViewOrderStage(this.mainStage);
            viewOrderStage.initModality(Modality.WINDOW_MODAL);
            viewOrderStage.initOwner(MainStage.this.getScene().getWindow());
            viewOrderStage.showAndWait();
        }
    }

    class miAccessoriesActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miAccessoriesActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            AccessoriesStage accessoriesStage = new AccessoriesStage(this.mainStage);
            accessoriesStage.initModality(Modality.WINDOW_MODAL);
            accessoriesStage.initOwner(MainStage.this.getScene().getWindow());
            accessoriesStage.showAndWait();
            this.mainStage.updateAllPanes();
        }
    }

    class miSpecialsActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miSpecialsActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            SpecialsStage specialsStage = new SpecialsStage(this.mainStage);
            specialsStage.initModality(Modality.WINDOW_MODAL);
            specialsStage.initOwner(MainStage.this.getScene().getWindow());
            specialsStage.showAndWait();
            this.mainStage.updateAllPanes();
        }
    }

    class miVehiclesActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miVehiclesActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            VehiclesStage vehiclesStage = new VehiclesStage(this.mainStage);
            vehiclesStage.initModality(Modality.WINDOW_MODAL);
            vehiclesStage.initOwner(MainStage.this.getScene().getWindow());
            vehiclesStage.showAndWait();
            this.mainStage.updateAllPanes();
        }
    }

    class miExitActionHandler
    implements EventHandler {
        miExitActionHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class miLogoutActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miLogoutActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            this.mainStage.close();
            LoginStage loginStage = new LoginStage(MainStage.this.params);
            loginStage.showAndWait();
            if (loginStage.getCurrentLoginState().equals((Object)LoginStage.LOGINSTATE.LOGIN_DENIED)) {
                System.exit(1);
            }
        }
    }

    class miResetActionHandler
    implements EventHandler {
        private MainStage mainStage;

        public miResetActionHandler(MainStage mainStage2) {
            this.mainStage = mainStage2;
        }

        public void handle(ActionEvent actionEvent) {
            MainStage.this.params.setDiscount(0.0);
            MainStage.this.runnerClass.restartApplication = true;
            MainStage.this.params.setSelectedTab(MainStage.this.tabpane.getSelectionModel().getSelectedIndex());
            MainStage.this.params.setXPos((int)this.mainStage.getX());
            MainStage.this.params.setYPos((int)this.mainStage.getY());
            this.mainStage.hide();
        }
    }
}

