/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Special;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;

public class SpecialDetailsStage
extends CarConfigFxStage {
    public SpecialDetailsStage(CarConfigFxParameters carConfigFxParameters, Special special) {
        super(carConfigFxParameters);
        String string = LangCountrySettings.getLanguageString("dialog.specialdetails.title");
        if (special != null) {
            string = string + " " + special.name;
        }
        this.setTitle(string);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        TreeView treeView = new TreeView(this.getTreeChildren(special));
        treeView.setId("DetailsTree");
        treeView.setMaxHeight(Double.MAX_VALUE);
        treeView.setMaxWidth(Double.MAX_VALUE);
        treeView.setPrefWidth(450.0);
        treeView.setPrefHeight(200.0);
        treeView.getSelectionModel().select(0);
        borderPane.setCenter((Node)treeView);
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        flowPane.setStyle("-fx-border: 1px solid #000");
        Button button = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button.setId("CloseButton");
        button.setOnAction((EventHandler)new CloseButtonEventHandler(this));
        flowPane.getChildren().add((Object)button);
        borderPane.setBottom((Node)flowPane);
    }

    public TreeItem getTreeChildren(Special special) {
        TreeItem treeItem3;
        TreeItem treeItem2 = null;
        String string = null;
        if (special != null) {
            treeItem2 = new String[special.containingAccessories.size()];
            int n = 0;
            for (TreeItem treeItem3 : special.containingAccessories) {
                treeItem2[n++] = treeItem3.name;
            }
            string = special.description;
        }
        TreeItem treeItem4 = new TreeItem();
        treeItem4.setValue((Object)LangCountrySettings.getLanguageString("dialog.specialdetails.tree.information"));
        TreeItem treeItem5 = new TreeItem();
        treeItem5.setValue((Object)LangCountrySettings.getLanguageString("dialog.specialdetails.tree.accessories"));
        for (String string2 : treeItem2) {
            TreeItem treeItem6 = new TreeItem();
            treeItem6.setValue((Object)string2);
            treeItem5.getChildren().add((Object)treeItem6);
        }
        treeItem3 = new TreeItem();
        treeItem3.setValue((Object)LangCountrySettings.getLanguageString("dialog.specialdetails.tree.description"));
        if (string != null && !string.isEmpty()) {
            TreeItem treeItem7 = new TreeItem();
            treeItem7.setValue((Object)string.replace('\n', ' '));
            treeItem3.getChildren().add((Object)treeItem7);
        }
        treeItem4.getChildren().addAll((Object[])new TreeItem[]{treeItem5, treeItem3});
        return treeItem4;
    }

    class CloseButtonEventHandler
    implements EventHandler {
        private Stage toClose;

        public CloseButtonEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }
}

