/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Special;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.stage.Stage;

public class SpecialOverviewStage
extends CarConfigFxStage {
    public SpecialOverviewStage(CarConfigFxParameters carConfigFxParameters, Special special) {
        super(carConfigFxParameters);
        String string = LangCountrySettings.getLanguageString("dialog.specialoverview.title");
        if (special != null) {
            string = string + " " + special.name;
        }
        this.setTitle(string);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        Pane pane = this.getGraph(special);
        pane.setPrefWidth(600.0);
        pane.setPrefHeight(400.0);
        borderPane.setCenter((Node)pane);
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button.setId("CloseButton");
        button.setOnAction((EventHandler)new CloseButtonEventHandler(this));
        flowPane.getChildren().add((Object)button);
        borderPane.setBottom((Node)flowPane);
    }

    public Pane getGraph(Special special) {
        Pane pane = new Pane();
        pane.setMaxWidth(Double.MAX_VALUE);
        pane.setMaxHeight(Double.MAX_VALUE);
        Node node = this.getNode(special == null ? "-XXX-" : special.name, 200.0, 20.0, 120.0, 30.0);
        pane.getChildren().add((Object)node);
        if (special != null) {
            int n = 0;
            for (Accessory accessory : special.containingAccessories) {
                Node node2 = this.getNode(accessory.name, 50 + 120 * n, n * 50 + 150, 120.0, 30.0);
                pane.getChildren().add((Object)node2);
                Line line = this.getEdge(260.0, 35.0, 110 + 120 * n, n * 50 + 165);
                pane.getChildren().add((Object)line);
                line.toBack();
                ++n;
            }
        }
        return pane;
    }

    public Node getNode(String string, double d, double d2, double d3, double d4) {
        FlowPane flowPane = new FlowPane();
        flowPane.setStyle("-fx-border-color: black; -fx-border-solid; -fx-border-width: 1; -fx-background-color: white;");
        flowPane.setAlignment(Pos.CENTER);
        flowPane.getChildren().add((Object)new Label(string));
        flowPane.setLayoutX(d);
        flowPane.setLayoutY(d2);
        flowPane.setMaxHeight(d4);
        flowPane.setMaxWidth(d3);
        flowPane.setPrefHeight(d4);
        flowPane.setPrefWidth(d3);
        flowPane.setMinHeight(d4);
        flowPane.setMinWidth(d3);
        return flowPane;
    }

    public Line getEdge(double d, double d2, double d3, double d4) {
        return new Line(d, d2, d3, d4);
    }

    class CloseButtonEventHandler
    implements EventHandler {
        private Stage toClose;

        public CloseButtonEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }
}

