/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MessageBox;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.SpecialDetailsStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.SpecialOverviewStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Special;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;

public class SpecialsStage
extends CarConfigFxStage {
    MainStage mainStage;
    SpecialsStage specialsStage = this;
    public LinkedList specials;
    public Special selectedSpecial;
    public Special savedSelectedSpecial;
    public LinkedList allAccessories;
    public LinkedList currentSelectedContainingAccessory = new LinkedList();
    TableView allSpecialsTableView;
    TextField spcialsModelNameTextField;
    TextField specialPriceTextField;
    TextField specialSeperatedPriceTextField;
    TextArea currentSpecialsDescription;
    TableView currentSpecialContainingAccessoryTableView;

    public SpecialsStage(MainStage mainStage) {
        super(mainStage.params);
        Special special2;
        this.setTitle(LangCountrySettings.getLanguageString("dialog.specials.name"));
        this.mainStage = mainStage;
        this.specials = new LinkedList();
        for (Special special2 : mainStage.specials) {
            Special special3 = special2.clone();
            if (mainStage.selectedSpecial == special2) {
                this.savedSelectedSpecial = special3;
            }
            this.specials.add(special3);
        }
        this.allAccessories = mainStage.accessories;
        if (!mainStage.specials.isEmpty()) {
            this.selectedSpecial = (Special)this.specials.getFirst();
            this.currentSelectedContainingAccessory = ((Special)this.specials.getFirst()).containingAccessories;
        } else {
            this.currentSelectedContainingAccessory = new LinkedList();
        }
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        borderPane.setId("SpecialsDialog");
        special2 = new Scene((Parent)borderPane);
        this.setScene((Scene)special2);
        borderPane.setPrefHeight(500.0);
        borderPane.setPrefWidth(700.0);
        borderPane.setCenter(this.createMiddleElements());
        borderPane.setRight(this.createRightElements());
        this.updateEverything();
    }

    public Node createMiddleElements() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        gridPane.setPrefHeight(600.0);
        gridPane.setPrefWidth(350.0);
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        gridPane.add(this.createMiddleElementsFirstTableNode(), 0, 1);
        gridPane.add(this.createMiddleElementsSecondTableNode(), 0, 2);
        gridPane.add(this.createMiddleElementsThirdTableNode(), 0, 3);
        gridPane.add(this.createMiddleElementsFourthTableNode(), 0, 4);
        return gridPane;
    }

    public Node createMiddleElementsFirstTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.specials.label"));
        label.setStyle("-fx-text-fill: blue;");
        label.setId("SpecialsName");
        gridPane.add((Node)label, 0, 0);
        this.allSpecialsTableView = new TableView();
        this.allSpecialsTableView.setId("SpecialsTable");
        this.allSpecialsTableView.setMinWidth(0.0);
        this.allSpecialsTableView.setMinHeight(0.0);
        this.allSpecialsTableView.setMaxWidth(Double.MAX_VALUE);
        this.allSpecialsTableView.setMaxHeight(Double.MAX_VALUE);
        this.allSpecialsTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new SecialsSelectionCangedEventHandler());
        this.allSpecialsTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.setId("SpecialsTablePanel");
        gridPane.add((Node)this.allSpecialsTableView, 0, 1);
        return gridPane;
    }

    public Node createMiddleElementsSecondTableNode() {
        BorderPane borderPane;
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().hgrow(Priority.SOMETIMES).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints});
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.specials.edit.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.spcialsModelNameTextField = new TextField();
        this.spcialsModelNameTextField.setMinHeight(30.0);
        this.spcialsModelNameTextField.setId("SpecialsName");
        gridPane.add((Node)this.spcialsModelNameTextField, 0, 1);
        Label label2 = new Label(LangCountrySettings.getLanguageString("dialog.specials.edit.price"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label2, 1, 0);
        this.specialPriceTextField = new TextField();
        this.specialPriceTextField.setMinHeight(30.0);
        this.specialPriceTextField.setId("SpecialsPrice");
        if (this.params.getNewVersion()) {
            borderPane = new BorderPane();
            borderPane.setId("NewGroupingPanel");
            borderPane.setCenter((Node)this.specialPriceTextField);
        } else {
            gridPane.add((Node)this.specialPriceTextField, 1, 1);
        }
        borderPane = new Label(LangCountrySettings.getLanguageString("dialog.specials.edit.seperateprice"));
        borderPane.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)borderPane, 1, 2);
        this.specialSeperatedPriceTextField = new TextField();
        this.specialSeperatedPriceTextField.setMinHeight(30.0);
        this.specialSeperatedPriceTextField.setId("SpecialsSeparatePrices");
        this.specialSeperatedPriceTextField.setEditable(false);
        gridPane.setId("SpecialsDialogEditPanel");
        gridPane.add((Node)this.specialSeperatedPriceTextField, 1, 3);
        return gridPane;
    }

    public Node createMiddleElementsThirdTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.vehicles.edit.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.currentSpecialsDescription = new TextArea();
        this.currentSpecialsDescription.setId("SpecialsDialogArea");
        this.currentSpecialsDescription.setMinHeight(100.0);
        this.currentSpecialsDescription.setMaxWidth(Double.MAX_VALUE);
        this.currentSpecialsDescription.setMaxHeight(Double.MAX_VALUE);
        gridPane.add((Node)this.currentSpecialsDescription, 0, 1);
        return gridPane;
    }

    public Node createMiddleElementsFourthTableNode() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        gridPane.setVgap(3.0);
        gridPane.setHgap(3.0);
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.specials.contained"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 0);
        this.currentSpecialContainingAccessoryTableView = new TableView();
        this.currentSpecialContainingAccessoryTableView.setId("AccessoryTable");
        this.currentSpecialContainingAccessoryTableView.setMinHeight(0.0);
        this.currentSpecialContainingAccessoryTableView.setMinWidth(0.0);
        this.currentSpecialContainingAccessoryTableView.setMaxHeight(Double.MAX_VALUE);
        this.currentSpecialContainingAccessoryTableView.setMaxWidth(Double.MAX_VALUE);
        this.currentSpecialContainingAccessoryTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.setId("AccessorySpecialsTablePanel");
        gridPane.add((Node)this.currentSpecialContainingAccessoryTableView, 0, 1);
        return gridPane;
    }

    public Node createRightElements() {
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderPane.setId("changeButtonPanel");
        VBox vBox = new VBox();
        vBox.setSpacing(3.0);
        Button button = new Button(LangCountrySettings.getLanguageString("button.new"));
        button.setId("NewButton");
        button.setOnAction((EventHandler)new ButtonNewEventHandler());
        button.setMaxWidth(Double.MAX_VALUE);
        Button button2 = new Button(LangCountrySettings.getLanguageString("button.change"));
        button2.setId("ChangeButton");
        button2.setOnAction((EventHandler)new ButtonChangeEventHandler());
        button2.setMaxWidth(Double.MAX_VALUE);
        Button button3 = new Button(LangCountrySettings.getLanguageString("button.delete"));
        button3.setId("DeleteButton");
        button3.setOnAction((EventHandler)new ButtonDeleteEventHandler());
        button3.setMaxWidth(Double.MAX_VALUE);
        Button button4 = new Button(LangCountrySettings.getLanguageString("button.details"));
        button4.setId("DetailsButton");
        button4.setOnAction((EventHandler)new ButtonDetailsEventHandler());
        button4.setMaxWidth(Double.MAX_VALUE);
        Button button5 = new Button(LangCountrySettings.getLanguageString("button.overview"));
        button5.setId("OverviewButton");
        button5.setOnAction((EventHandler)new ButtonOverviewEventHandler());
        button5.setMaxWidth(Double.MAX_VALUE);
        vBox.getChildren().addAll((Object[])new Node[]{button, button2, button3, button4, button5});
        borderPane.setTop((Node)vBox);
        VBox vBox2 = new VBox();
        vBox2.setSpacing(3.0);
        Button button6 = new Button(LangCountrySettings.getLanguageString("button.cancel"));
        button6.setId("CancelButton");
        button6.setOnAction((EventHandler)new ButtonCancelEventHandler(this));
        button6.setMaxWidth(Double.MAX_VALUE);
        Button button7 = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button7.setId("OkButton");
        button7.setOnAction((EventHandler)new ButtonOkEventHandler(this));
        button7.setMaxWidth(Double.MAX_VALUE);
        vBox2.getChildren().addAll((Object[])new Node[]{button6, button7});
        borderPane.setBottom((Node)vBox2);
        return borderPane;
    }

    public void updateEverything() {
        this.updateSpecialTableView();
        this.updateNamePriceInformations();
        this.updateDescriptionInformation();
        this.updateAccessoryTableView();
    }

    public void updateSpecialTableView() {
        TableColumn tableColumn = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText("Modelle");
        } else {
            tableColumn.setText("Models");
        }
        this.allSpecialsTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn});
        this.allSpecialsTableView.getItems().setAll((Collection)this.specials);
    }

    public void updateNamePriceInformations() {
        if (this.selectedSpecial != null) {
            this.spcialsModelNameTextField.setText(this.selectedSpecial.name);
            this.specialPriceTextField.setText(Utility.convertDoubleToPriceString(this.selectedSpecial.price, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
            double d = 0.0;
            for (Accessory accessory : this.currentSelectedContainingAccessory) {
                d += accessory.price;
            }
            this.specialSeperatedPriceTextField.setText(Utility.convertDoubleToPriceString(d, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
        }
    }

    public void updateDescriptionInformation() {
        if (this.selectedSpecial != null) {
            this.currentSpecialsDescription.setText(this.selectedSpecial.description);
        }
    }

    public void updateAccessoryTableView() {
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        TableColumn tableColumn4 = new TableColumn();
        tableColumn.setMaxWidth(50.0);
        tableColumn.setMinWidth(50.0);
        tableColumn3.setPrefWidth(30.0);
        tableColumn4.setPrefWidth(100.0);
        CheckboxCellCallback checkboxCellCallback = new CheckboxCellCallback();
        tableColumn.setCellFactory((Callback)checkboxCellCallback);
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("this"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn4.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText(" ");
            tableColumn2.setText("Beschreibung");
            tableColumn3.setText("ID");
            tableColumn4.setText("Preis");
        } else {
            tableColumn.setText(" ");
            tableColumn2.setText("Description");
            tableColumn3.setText("ID");
            tableColumn4.setText("Price");
        }
        this.currentSpecialContainingAccessoryTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4});
        this.currentSpecialContainingAccessoryTableView.getItems().setAll((Collection)this.allAccessories);
    }

    public class CheckboxCellCallback
    implements Callback {
        public TableCell call(TableColumn tableColumn) {
            return new CheckBoxAccessoryTableCell(SpecialsStage.this.specialsStage);
        }
    }

    public static class CheckBoxAccessoryTableCell
    extends TableCell {
        private final CheckBox checkBox;
        private ObservableValue ov;
        private Accessory accessory;
        private SpecialsStage specialsStage;
        private boolean blockEventHandling = false;

        public CheckBoxAccessoryTableCell(SpecialsStage specialsStage) {
            this.specialsStage = specialsStage;
            this.checkBox = new CheckBox();
            this.checkBox.visibleProperty().setValue(Boolean.valueOf(false));
            this.checkBox.setAlignment(Pos.CENTER);
            this.checkBox.selectedProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object object, Object object2) {
                    if (accessory == null || blockEventHandling) {
                        return;
                    }
                    if (!((CheckBoxAccessoryTableCell)this).specialsStage.currentSelectedContainingAccessory.remove(accessory)) {
                        ((CheckBoxAccessoryTableCell)this).specialsStage.currentSelectedContainingAccessory.add(accessory);
                    }
                    specialsStage.updateNamePriceInformations();
                }
            });
            this.setAlignment(Pos.CENTER);
            this.setGraphic((Node)this.checkBox);
        }

        protected void updateItem(Accessory accessory, boolean bl) {
            this.blockEventHandling = true;
            super.updateItem((Object)accessory, bl);
            if (!bl) {
                this.accessory = accessory;
                this.ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                this.checkBox.setVisible(true);
                this.checkBox.setSelected(this.specialsStage.currentSelectedContainingAccessory.contains(accessory));
                this.specialsStage.updateNamePriceInformations();
            }
            this.blockEventHandling = false;
        }
    }

    public class SecialsSelectionCangedEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, Special special, Special special2) {
            SpecialsStage.this.specialsStage.selectedSpecial = (Special)SpecialsStage.this.specialsStage.allSpecialsTableView.getSelectionModel().getSelectedItem();
            if (SpecialsStage.this.specialsStage.selectedSpecial == null && !SpecialsStage.this.specialsStage.specials.isEmpty()) {
                SpecialsStage.this.specialsStage.selectedSpecial = (Special)SpecialsStage.this.specialsStage.specials.getFirst();
            }
            SpecialsStage.this.specialsStage.currentSelectedContainingAccessory = SpecialsStage.this.specialsStage.selectedSpecial != null ? SpecialsStage.this.specialsStage.selectedSpecial.containingAccessories : new LinkedList();
            SpecialsStage.this.updateNamePriceInformations();
            SpecialsStage.this.updateDescriptionInformation();
            SpecialsStage.this.updateAccessoryTableView();
        }
    }

    class ButtonCancelEventHandler
    implements EventHandler {
        Stage toClose;

        public ButtonCancelEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }

    class ButtonOkEventHandler
    implements EventHandler {
        Stage stage;

        public ButtonOkEventHandler(Stage stage) {
            this.stage = stage;
        }

        public void handle(ActionEvent actionEvent) {
            SpecialsStage.this.mainStage.specials = SpecialsStage.this.specialsStage.specials;
            Special special = SpecialsStage.this.mainStage.selectedSpecial = SpecialsStage.this.specialsStage.savedSelectedSpecial == null ? SpecialsStage.this.specialsStage.savedSelectedSpecial : SpecialsStage.this.specialsStage.selectedSpecial;
            if (SpecialsStage.this.params.getLoadTest()) {
                Utility.simulateLoadTest();
            }
            SpecialsStage.this.specialsStage.close();
        }
    }

    class ButtonOverviewEventHandler
    implements EventHandler {
        ButtonOverviewEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            SpecialOverviewStage specialOverviewStage = new SpecialOverviewStage(SpecialsStage.this.params, SpecialsStage.this.specialsStage.selectedSpecial);
            specialOverviewStage.initModality(Modality.WINDOW_MODAL);
            specialOverviewStage.initOwner(SpecialsStage.this.getScene().getWindow());
            specialOverviewStage.showAndWait();
        }
    }

    class ButtonDetailsEventHandler
    implements EventHandler {
        ButtonDetailsEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            SpecialDetailsStage specialDetailsStage = new SpecialDetailsStage(SpecialsStage.this.params, SpecialsStage.this.specialsStage.selectedSpecial);
            specialDetailsStage.initModality(Modality.WINDOW_MODAL);
            specialDetailsStage.initOwner(SpecialsStage.this.getScene().getWindow());
            specialDetailsStage.showAndWait();
        }
    }

    class ButtonDeleteEventHandler
    implements EventHandler {
        ButtonDeleteEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            if (SpecialsStage.this.specialsStage.selectedSpecial != null) {
                SpecialsStage.this.specialsStage.specials.remove(SpecialsStage.this.specialsStage.selectedSpecial);
                SpecialsStage.this.specialsStage.selectedSpecial = !SpecialsStage.this.specialsStage.specials.isEmpty() ? (Special)SpecialsStage.this.specialsStage.specials.getFirst() : null;
                SpecialsStage.this.specialsStage.allSpecialsTableView.getSelectionModel().clearSelection();
                SpecialsStage.this.specialsStage.allSpecialsTableView.getItems().setAll((Collection)SpecialsStage.this.specialsStage.specials);
                SpecialsStage.this.specialsStage.updateNamePriceInformations();
                SpecialsStage.this.specialsStage.updateDescriptionInformation();
                SpecialsStage.this.specialsStage.updateAccessoryTableView();
            }
        }
    }

    class ButtonChangeEventHandler
    implements EventHandler {
        ButtonChangeEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            if (SpecialsStage.this.specialsStage.selectedSpecial == null) {
                return;
            }
            String string = SpecialsStage.this.specialsStage.spcialsModelNameTextField.getText();
            String string2 = SpecialsStage.this.specialsStage.currentSpecialsDescription.getText();
            LinkedList linkedList = (LinkedList)SpecialsStage.this.specialsStage.currentSelectedContainingAccessory.clone();
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(SpecialsStage.this.specialsStage.specialPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(SpecialsStage.this.specialsStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            SpecialsStage.this.specialsStage.selectedSpecial.name = string;
            SpecialsStage.this.specialsStage.selectedSpecial.description = string2;
            SpecialsStage.this.specialsStage.selectedSpecial.containingAccessories = linkedList;
            SpecialsStage.this.specialsStage.selectedSpecial.price = d;
            ((TableColumn)SpecialsStage.this.specialsStage.allSpecialsTableView.getColumns().get(0)).setVisible(false);
            ((TableColumn)SpecialsStage.this.specialsStage.allSpecialsTableView.getColumns().get(0)).setVisible(true);
            SpecialsStage.this.specialsStage.updateNamePriceInformations();
            SpecialsStage.this.specialsStage.updateDescriptionInformation();
            SpecialsStage.this.specialsStage.updateAccessoryTableView();
        }
    }

    class ButtonNewEventHandler
    implements EventHandler {
        ButtonNewEventHandler() {
        }

        public void handle(ActionEvent actionEvent) {
            String string = SpecialsStage.this.specialsStage.spcialsModelNameTextField.getText();
            String string2 = SpecialsStage.this.specialsStage.currentSpecialsDescription.getText();
            LinkedList linkedList = (LinkedList)SpecialsStage.this.specialsStage.currentSelectedContainingAccessory.clone();
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(SpecialsStage.this.specialsStage.specialPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(SpecialsStage.this.specialsStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            Special special = new Special(string, string2, linkedList, d);
            SpecialsStage.this.specialsStage.specials.add(special);
            SpecialsStage.this.specialsStage.allSpecialsTableView.getItems().add((Object)special);
            SpecialsStage.this.specialsStage.allSpecialsTableView.getSelectionModel().select((Object)special);
            SpecialsStage.this.specialsStage.updateNamePriceInformations();
            SpecialsStage.this.specialsStage.updateDescriptionInformation();
            SpecialsStage.this.specialsStage.updateAccessoryTableView();
        }
    }
}

