/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.lib.util.Misc;
import java.util.Calendar;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.util.Callback;

public class StatisticsStage
extends CarConfigFxStage {
    MainStage mainStage;

    public StatisticsStage(MainStage mainStage) {
        super(mainStage.params);
        this.mainStage = mainStage;
        String string = "--";
        if (mainStage.selectedVehicle != null && !Misc.emptyOrNull((String)mainStage.selectedVehicle.name)) {
            string = mainStage.selectedVehicle.name;
        }
        this.setTitle(LangCountrySettings.getLanguageString("dialog.statistics.name") + " - " + string);
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        borderPane.setCenter(this.createMiddleElementsPane(string));
        borderPane.setBottom(this.createBottonOkPane());
        this.setResizable(false);
    }

    public Node createMiddleElementsPane(String string) {
        GridPane gridPane = new GridPane();
        gridPane.add(this.createVehicleDetailsElements(), 0, 0);
        gridPane.add(this.createTableElements(string), 0, 1);
        return gridPane;
    }

    public Node createTableElements(String string) {
        GridPane gridPane = new GridPane();
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(3);
        ObservableList observableList = FXCollections.observableArrayList();
        if ("Minigolf".equals(string)) {
            observableList.add((Object)new Object[]{n, 10});
            observableList.add((Object)new Object[]{n - 1, 32});
            observableList.add((Object)new Object[]{n - 2, 12});
            observableList.add((Object)new Object[]{n - 3, 2});
            observableList.add((Object)new Object[]{n - 4, 21});
            observableList.add((Object)new Object[]{n - 5, 12});
        } else if ("Rolo".equals(string)) {
            observableList.add((Object)new Object[]{n, 3});
            observableList.add((Object)new Object[]{n - 1, 8});
        } else if ("I5".equals(string)) {
            observableList.add((Object)new Object[]{n, 3});
            observableList.add((Object)new Object[]{n - 1, 12});
            observableList.add((Object)new Object[]{n - 2, 0});
            observableList.add((Object)new Object[]{n - 3, 19});
        } else if ("Rassant".equals(string)) {
            observableList.add((Object)new Object[]{n, 8});
            observableList.add((Object)new Object[]{n - 1, 2});
            observableList.add((Object)new Object[]{n - 2, 22});
            observableList.add((Object)new Object[]{n - 3, 4});
            observableList.add((Object)new Object[]{n - 4, 6});
            observableList.add((Object)new Object[]{n - 5, 15});
        } else if ("Rassant Family".equals(string)) {
            observableList.add((Object)new Object[]{n, 1});
            observableList.add((Object)new Object[]{n - 1, 13});
            observableList.add((Object)new Object[]{n - 2, 5});
            observableList.add((Object)new Object[]{n - 3, 27});
            observableList.add((Object)new Object[]{n - 4, 11});
        } else {
            observableList.add((Object)new Object[]{n, 0});
        }
        TableView tableView = new TableView(observableList);
        tableView.setItems(observableList);
        TableColumn tableColumn = new TableColumn(LangCountrySettings.getStatisticsWeek());
        TableColumn tableColumn2 = new TableColumn(LangCountrySettings.getStatisticsAmount());
        tableColumn.setMinWidth(100.0);
        tableColumn2.setMinWidth(100.0);
        tableView.getColumns().add((Object)tableColumn);
        tableView.getColumns().add((Object)tableColumn2);
        tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                Object[] objectArray = (Object[])cellDataFeatures.getValue();
                return new ReadOnlyObjectWrapper(objectArray[0]);
            }
        });
        tableColumn2.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                Object[] objectArray = (Object[])cellDataFeatures.getValue();
                return new ReadOnlyObjectWrapper(objectArray[1]);
            }
        });
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        int n2 = 70 * observableList.size();
        gridPane.setPrefHeight((double)n2);
        gridPane.add((Node)tableView, 0, 0);
        return gridPane;
    }

    public Node createVehicleDetailsElements() {
        GridPane gridPane = new GridPane();
        GridPane gridPane2 = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane2.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane2.getColumnConstraints().add((Object)columnConstraints2);
        gridPane.add((Node)gridPane2, 0, 0);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.vehicle.label"));
        gridPane2.add((Node)label, 0, 0);
        String string = LangCountrySettings.getLanguageString("error.purchaseorder.novehicle");
        if (this.mainStage.selectedVehicle != null) {
            string = this.mainStage.selectedVehicle.name;
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        gridPane2.add((Node)textField, 1, 0);
        return gridPane;
    }

    public Node createBottonOkPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button.setId("OKButton");
        button.setOnAction((EventHandler)new OkButtonEventHandler(this));
        flowPane.getChildren().add((Object)button);
        return flowPane;
    }

    class OkButtonEventHandler
    implements EventHandler {
        Stage toClose;

        public OkButtonEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }
}

