/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MessageBox;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Vehicle;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class VehiclesStage
extends CarConfigFxStage {
    VehiclesStage vehiclesStage = this;
    MainStage mainStage;
    public Vehicle savedSelectedVehicle;
    public Vehicle selectedVehicle;
    public LinkedList vehicles;
    TextField vehiclesNameTextField;
    TextField vehiclesIdTextField;
    TextField vehiclesPriceTextField;
    TableView vehiclesTablePanelTableView;

    public VehiclesStage(MainStage mainStage) {
        super(mainStage.params);
        this.setTitle(LangCountrySettings.getLanguageString("dialog.vehicles.name"));
        this.mainStage = mainStage;
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        borderPane.setId("VehiclesDialog");
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        borderPane.setPrefHeight(400.0);
        borderPane.setPrefWidth(600.0);
        borderPane.setCenter(this.createMiddleElements());
        borderPane.setRight(this.createRightElements());
        this.vehicles = new LinkedList();
        for (Vehicle vehicle : mainStage.vehicles) {
            Vehicle vehicle2 = vehicle.clone();
            if (mainStage.selectedVehicle == vehicle) {
                this.savedSelectedVehicle = vehicle2;
            }
            this.vehicles.add(vehicle2);
        }
        this.updateVehicleViewTable();
    }

    public Node createMiddleElements() {
        Label label;
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setPrefWidth(300.0);
        gridPane.setPrefHeight(100.0);
        Label label2 = new Label(LangCountrySettings.getLanguageString("dialog.vehicles.label"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label2, 0, 1);
        this.vehiclesTablePanelTableView = new TableView();
        this.vehiclesTablePanelTableView.setId("VehiclesTable");
        this.vehiclesTablePanelTableView.setMaxHeight(Double.MAX_VALUE);
        this.vehiclesTablePanelTableView.setMaxWidth(Double.MAX_VALUE);
        this.vehiclesTablePanelTableView.setEditable(false);
        this.vehiclesTablePanelTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.vehiclesTablePanelTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new OnVehicleTableColumnClickEventHandler());
        this.vehiclesTablePanelTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        gridPane.add((Node)this.vehiclesTablePanelTableView, 0, 2);
        this.vehiclesTablePanelTableView.setId("VehiclesTable");
        gridPane.setId("VehicleDialogTablePanel");
        GridPane gridPane2 = new GridPane();
        gridPane2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints2 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints3 = ColumnConstraintsBuilder.create().maxWidth(Double.MAX_VALUE).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints4 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints5 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        gridPane2.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3, columnConstraints4, columnConstraints5});
        gridPane2.setHgap(3.0);
        gridPane2.setId("VehicleDialogEditPanel");
        Label label3 = new Label(LangCountrySettings.getLanguageString("dialog.vehicles.edit.name"));
        label3.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label3, 0, 0);
        this.vehiclesNameTextField = new TextField("");
        this.vehiclesNameTextField.setMaxWidth(120.0);
        this.vehiclesNameTextField.setId("VehicleName");
        gridPane2.add((Node)this.vehiclesNameTextField, 0, 1);
        if (this.params.getNewVersion()) {
            label = new Label(LangCountrySettings.getLanguageString("dialog.vehicles.edit.id"));
            label.setStyle("-fx-text-fill: blue;");
            gridPane2.add((Node)label, 2, 0);
            this.vehiclesIdTextField = new TextField("");
            this.vehiclesIdTextField.setMaxWidth(36.0);
            this.vehiclesIdTextField.setId("VehicleId");
            gridPane2.add((Node)this.vehiclesIdTextField, 2, 1);
        }
        label = new Label(LangCountrySettings.getLanguageString("dialog.vehicles.edit.price"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label, 3, 0);
        this.vehiclesPriceTextField = new TextField("");
        this.vehiclesPriceTextField.setMaxWidth(80.0);
        this.vehiclesPriceTextField.setId("VehiclePrice");
        gridPane2.add((Node)this.vehiclesPriceTextField, 3, 1);
        borderPane.setCenter((Node)gridPane);
        if (this.params.getNewVersion()) {
            borderPane.setTop((Node)gridPane2);
        } else {
            borderPane.setBottom((Node)gridPane2);
        }
        return borderPane;
    }

    public Node createRightElements() {
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderPane.setId("changeButtonPanel");
        VBox vBox = new VBox();
        vBox.setSpacing(3.0);
        Button button = new Button(LangCountrySettings.getLanguageString("button.new"));
        button.setId("NewButton");
        button.setOnAction((EventHandler)new OnNewButtonEventHandler());
        button.setMaxWidth(Double.MAX_VALUE);
        Button button2 = new Button(LangCountrySettings.getLanguageString("button.change"));
        button2.setId("ChangeButton");
        button2.setOnAction((EventHandler)new OnChangeButtonEventHandler());
        button2.setMaxWidth(Double.MAX_VALUE);
        Button button3 = new Button(LangCountrySettings.getLanguageString("button.delete"));
        button3.setId("DeleteButton");
        button3.setOnAction((EventHandler)new OnDeleteButtonEventHandler());
        button3.setMaxWidth(Double.MAX_VALUE);
        vBox.getChildren().addAll((Object[])new Node[]{button, button2, button3});
        borderPane.setTop((Node)vBox);
        VBox vBox2 = new VBox();
        vBox2.setSpacing(3.0);
        Button button4 = new Button(LangCountrySettings.getLanguageString("button.cancel"));
        button4.setId("CancelButton");
        button4.setOnAction((EventHandler)new OnCancelButtonEventHandler());
        button4.setMaxWidth(Double.MAX_VALUE);
        Button button5 = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button5.setId("OkButton");
        button5.setOnAction((EventHandler)new OnOkButtonEventHandler());
        button5.setMaxWidth(Double.MAX_VALUE);
        vBox2.getChildren().addAll((Object[])new Node[]{button4, button5});
        borderPane.setBottom((Node)vBox2);
        return borderPane;
    }

    public void updateVehicleViewTable() {
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn.setMinWidth(50.0);
        tableColumn2.setMinWidth(10.0);
        tableColumn3.setMinWidth(50.0);
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText("Modell");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Model");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        if (this.params.getNewVersion()) {
            this.vehiclesTablePanelTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        } else {
            this.vehiclesTablePanelTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn3});
        }
        this.vehiclesStage.vehiclesTablePanelTableView.setItems(FXCollections.observableArrayList((Collection)this.vehiclesStage.vehicles));
        if (this.vehiclesStage.selectedVehicle != null) {
            this.vehiclesStage.vehiclesTablePanelTableView.getSelectionModel().select((Object)this.vehiclesStage.selectedVehicle);
        }
    }

    public class OnOkButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            VehiclesStage.this.mainStage.vehicles = VehiclesStage.this.vehiclesStage.vehicles;
            Vehicle vehicle = VehiclesStage.this.mainStage.selectedVehicle = VehiclesStage.this.vehiclesStage.vehicles.contains(VehiclesStage.this.vehiclesStage.savedSelectedVehicle) ? VehiclesStage.this.vehiclesStage.savedSelectedVehicle : null;
            if (VehiclesStage.this.params.getLoadTest()) {
                Utility.simulateLoadTest();
            }
            if (VehiclesStage.this.params.getBuggy()) {
                new Thread(){

                    @Override
                    public void run() {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                }.start();
            }
            VehiclesStage.this.vehiclesStage.close();
        }
    }

    public class OnCancelButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            VehiclesStage.this.vehiclesStage.close();
        }
    }

    public class OnDeleteButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            if (VehiclesStage.this.vehiclesStage.selectedVehicle != null) {
                VehiclesStage.this.vehiclesStage.vehicles.remove(VehiclesStage.this.vehiclesStage.selectedVehicle);
                VehiclesStage.this.vehiclesStage.selectedVehicle = null;
                VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getSelectionModel().clearSelection();
                VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getItems().setAll((Collection)VehiclesStage.this.vehiclesStage.vehicles);
            }
        }
    }

    public class OnChangeButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            if (VehiclesStage.this.vehiclesStage.selectedVehicle == null) {
                return;
            }
            String string = VehiclesStage.this.vehiclesStage.vehiclesNameTextField.getText();
            String string2 = "";
            if (VehiclesStage.this.params.getNewVersion()) {
                string2 = VehiclesStage.this.vehiclesStage.vehiclesIdTextField.getText();
            }
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(VehiclesStage.this.vehiclesStage.vehiclesPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(VehiclesStage.this.vehiclesStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            VehiclesStage.this.vehiclesStage.selectedVehicle.name = string;
            if (VehiclesStage.this.params.getNewVersion()) {
                VehiclesStage.this.vehiclesStage.selectedVehicle.id = string2;
            }
            VehiclesStage.this.vehiclesStage.selectedVehicle.price = d;
            ((TableColumn)VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getColumns().get(0)).setVisible(false);
            ((TableColumn)VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getColumns().get(0)).setVisible(true);
        }
    }

    public class OnNewButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            String string = VehiclesStage.this.vehiclesStage.vehiclesNameTextField.getText();
            String string2 = "";
            if (VehiclesStage.this.params.getNewVersion()) {
                string2 = VehiclesStage.this.vehiclesStage.vehiclesIdTextField.getText();
            }
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(VehiclesStage.this.vehiclesStage.vehiclesPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(VehiclesStage.this.vehiclesStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            Vehicle vehicle = new Vehicle(string, string2, d);
            VehiclesStage.this.vehiclesStage.vehicles.add(vehicle);
            VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getItems().add((Object)vehicle);
            VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getSelectionModel().select(VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getItems().size() - 1);
        }
    }

    public class OnVehicleTableColumnClickEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, Vehicle vehicle, Vehicle vehicle2) {
            VehiclesStage.this.vehiclesStage.selectedVehicle = (Vehicle)VehiclesStage.this.vehiclesStage.vehiclesTablePanelTableView.getSelectionModel().getSelectedItem();
            if (VehiclesStage.this.vehiclesStage.selectedVehicle != null) {
                VehiclesStage.this.vehiclesStage.vehiclesNameTextField.setText(VehiclesStage.this.vehiclesStage.selectedVehicle.name);
                if (VehiclesStage.this.params.getNewVersion()) {
                    VehiclesStage.this.vehiclesStage.vehiclesIdTextField.setText(VehiclesStage.this.vehiclesStage.selectedVehicle.id);
                }
                VehiclesStage.this.vehiclesStage.vehiclesPriceTextField.setText(Utility.convertDoubleToPriceString(VehiclesStage.this.vehiclesStage.selectedVehicle.price, "", LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
            }
        }
    }
}

