/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.structures;

import java.util.List;
import java.util.Locale;
import javafx.scene.text.Font;

public class CarConfigFxParameters {
    private boolean buggy = false;
    private int xPos = 0;
    private int yPos = 0;
    private Language lang = Language.ENGLISH;
    private Font font = Font.getDefault();
    private boolean splash = false;
    private boolean login = false;
    private boolean loadTest = false;
    private boolean help = false;
    private boolean newVersion = false;
    private double discountValue = 0.0;
    private int selectedTab = 0;
    private String user = "tester";

    public CarConfigFxParameters() {
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals(new Locale("de", "", "").getLanguage())) {
            this.lang = Language.GERMAN;
        }
    }

    public CarConfigFxParameters(String[] stringArray) {
        this();
        this.parseCarConfigParameters(stringArray);
    }

    public CarConfigFxParameters(List list) {
        this(list.toArray(new String[list.size()]));
    }

    public void setBuggyMode(boolean bl) {
        this.buggy = bl;
    }

    public void setXPos(int n) {
        this.xPos = n;
    }

    public void setYPos(int n) {
        this.yPos = n;
    }

    public void setLanguage(Language language) {
        this.lang = language;
    }

    public void setFontFamilyName(String string) {
        this.font = new Font(string, this.font.getSize());
    }

    public void setFontSize(double d) {
        this.font = new Font(this.font.getName(), d);
    }

    public void setSplash(boolean bl) {
        this.splash = bl;
    }

    public void setLogin(boolean bl) {
        this.login = bl;
    }

    public void setLoadTest(boolean bl) {
        this.loadTest = bl;
    }

    public void setHelp(boolean bl) {
        this.help = bl;
    }

    public void setNewVersion(boolean bl) {
        this.newVersion = bl;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setDiscount(double d) {
        this.discountValue = d;
    }

    public void setSelectedTab(int n) {
        this.selectedTab = n;
    }

    public String getUser() {
        return this.user;
    }

    public boolean getBuggy() {
        return this.buggy;
    }

    public int getXPos() {
        return this.xPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    public Font getFont() {
        return this.font;
    }

    public Language getLanguage() {
        return this.lang;
    }

    public boolean getSplash() {
        return this.splash;
    }

    public boolean getLoadTest() {
        return this.loadTest;
    }

    public boolean getLogin() {
        return this.login;
    }

    public boolean getHelp() {
        return this.help;
    }

    public boolean getNewVersion() {
        return this.newVersion;
    }

    public double getDiscount() {
        return this.discountValue;
    }

    public int getSelectedTab() {
        return this.selectedTab;
    }

    public void parseCarConfigParameters(String[] stringArray) {
        if (stringArray.length > 0 && !stringArray[0].startsWith("-")) {
            if ("de".equalsIgnoreCase(stringArray[0])) {
                this.setLanguage(Language.GERMAN);
            } else {
                this.setLanguage(Language.ENGLISH);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if ("-fontsize".equalsIgnoreCase(stringArray[i])) {
                try {
                    this.setFontSize(Double.valueOf(stringArray[++i]));
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-pos.x".equalsIgnoreCase(stringArray[i])) {
                try {
                    this.setXPos(Integer.valueOf(stringArray[++i]));
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-pos.y".equalsIgnoreCase(stringArray[i])) {
                try {
                    this.setYPos(Integer.valueOf(stringArray[++i]));
                }
                catch (Exception exception) {}
                continue;
            }
            if ("-loadtest".equalsIgnoreCase(stringArray[i])) {
                this.setLoadTest(true);
                continue;
            }
            if ("-splash".equalsIgnoreCase(stringArray[i])) {
                this.setSplash(true);
                continue;
            }
            if ("-newversion".equalsIgnoreCase(stringArray[i])) {
                this.setNewVersion(true);
                continue;
            }
            if ("-buggy".equalsIgnoreCase(stringArray[i])) {
                this.setBuggyMode(true);
                continue;
            }
            if ("-login".equalsIgnoreCase(stringArray[i])) {
                this.setLogin(true);
                continue;
            }
            if ("-lang".equalsIgnoreCase(stringArray[i])) {
                try {
                    if ("de".equalsIgnoreCase(stringArray[++i])) {
                        this.setLanguage(Language.GERMAN);
                        continue;
                    }
                    this.setLanguage(Language.ENGLISH);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!"-help".equalsIgnoreCase(stringArray[i])) continue;
            this.setHelp(true);
        }
    }

    public static enum Language {
        GERMAN,
        ENGLISH;

    }
}

