/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.structures;

import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;

public class Vehicle
implements Cloneable {
    public String name;
    public String id;
    public double price;

    public Vehicle() {
        this.name = "myNewVehicle";
        this.id = "?";
        this.price = 0.0;
    }

    public Vehicle(String string, double d) {
        this.name = string;
        this.price = d;
    }

    public Vehicle(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.price = Utility.convertStringToPriceDouble(string2, string3, string4.charAt(0), string5.charAt(0));
    }

    public Vehicle(String string, String string2, double d) {
        this.name = string;
        this.id = string2;
        this.price = d;
    }

    public Vehicle(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        this.id = string2;
        this.price = Utility.convertStringToPriceDouble(string3, string4, string5.charAt(0), string6.charAt(0));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPrice() {
        return Utility.convertDoubleToPriceString(this.price, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            Vehicle vehicle = (Vehicle)object;
            return this.name.equals(vehicle.name) && this.id.equals(vehicle.id) && this.price == vehicle.price;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareVehiclesByName(Vehicle vehicle) {
        return this.name.compareTo(vehicle.name);
    }

    public int compareVehiclesById(Vehicle vehicle) {
        return this.id.compareTo(vehicle.id);
    }

    public int compareVehiclesByPrice(Vehicle vehicle) {
        if (this.price == vehicle.price) {
            return 0;
        }
        if (this.price > vehicle.price) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "[@Vehicle: name: \"" + this.name + "\"; id: \"" + this.id + "\"; price: \"" + this.price + "\" ]";
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + this.name.hashCode();
        n = 37 * n + this.id.hashCode();
        n = 37 * n + (int)(Double.doubleToLongBits(this.price) ^ Double.doubleToLongBits(this.price) >>> 32);
        return n;
    }

    public Vehicle clone() {
        Vehicle vehicle = new Vehicle(this.name, this.id, this.price);
        return vehicle;
    }
}

