/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.Logger;
import java.util.Collection;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;

public class FxDragAndDropDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.FxDragAndDropDemo");
    public static ObservableList elementsLeft = FXCollections.observableArrayList((Object[])new String[]{"red", "green", "blue", "yellow", "cyan", "magenta"});
    public static ObservableList elmentsRight = FXCollections.observableArrayList((Object[])new String[]{"orange", "mauve", "khaki", "pink", "seegreen"});

    public static Node getRootNode() {
        if (FxDragAndDropDemo.logger.level >= 7) {
            logger.log(7, "getRootNode()", "");
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(4.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("DnDDemo");
        ListView listView = new ListView();
        listView.setId("leftList");
        listView.setItems(FXCollections.observableArrayList((Collection)elementsLeft));
        listView.setOnDragDetected((EventHandler)new OnDragDetectedEventHandler());
        listView.setOnDragOver((EventHandler)new OnDragOverEventHandler());
        listView.setOnDragDropped((EventHandler)new OnDragDroppedEventHandler());
        listView.setOnDragDone((EventHandler)new OnDragDoneEventHandler());
        gridPane.add((Node)listView, 0, 0);
        ListView listView2 = new ListView();
        listView2.setId("rightList");
        listView2.setItems(FXCollections.observableArrayList((Collection)elmentsRight));
        listView2.setOnDragDetected((EventHandler)new OnDragDetectedEventHandler());
        listView2.setOnDragOver((EventHandler)new OnDragOverEventHandler());
        listView2.setOnDragDropped((EventHandler)new OnDragDroppedEventHandler());
        listView2.setOnDragDone((EventHandler)new OnDragDoneEventHandler());
        gridPane.add((Node)listView2, 1, 0);
        return gridPane;
    }

    static class OnDragDoneEventHandler
    implements EventHandler {
        OnDragDoneEventHandler() {
        }

        public void handle(DragEvent dragEvent) {
            int n;
            ListView listView = (ListView)dragEvent.getGestureSource();
            if (dragEvent.getTransferMode() == TransferMode.MOVE && (n = listView.getSelectionModel().getSelectedIndex()) >= 0) {
                listView.getItems().remove(n);
                listView.getSelectionModel().clearSelection();
                if (listView.getItems().size() > 0) {
                    listView.getSelectionModel().select(n);
                }
            }
            dragEvent.consume();
        }
    }

    static class OnDragDroppedEventHandler
    implements EventHandler {
        OnDragDroppedEventHandler() {
        }

        public void handle(DragEvent dragEvent) {
            ListView listView = (ListView)dragEvent.getGestureTarget();
            String string = dragEvent.getDragboard().getString();
            if (dragEvent.getTransferMode() == TransferMode.LINK) {
                string = "->" + string;
            }
            listView.getItems().add((Object)string);
            dragEvent.setDropCompleted(true);
            dragEvent.consume();
        }
    }

    static class OnDragOverEventHandler
    implements EventHandler {
        OnDragOverEventHandler() {
        }

        public void handle(DragEvent dragEvent) {
            if (logger.level >= 7) {
                Logger.Builder builder = logger.build("handle(DragEvent)");
                (logger.level < 8 ? builder : builder.add("event: ").add((Object)dragEvent)).log(7);
            }
            dragEvent.acceptTransferModes(TransferMode.ANY);
            dragEvent.consume();
        }
    }

    public static class OnDragDetectedEventHandler
    implements EventHandler {
        public void handle(MouseEvent mouseEvent) {
            Object object;
            Logger.Builder builder;
            if (logger.level >= 7) {
                builder = logger.build("handle(MouseEvent)");
                (logger.level < 8 ? builder : builder.add("event: ").add((Object)mouseEvent)).log(7);
            }
            String string = (object = (builder = (ListView)mouseEvent.getSource()).getSelectionModel().getSelectedItem()) == null ? "" : object.toString();
            TransferMode transferMode = TransferMode.MOVE;
            if (mouseEvent.isControlDown()) {
                transferMode = mouseEvent.isShiftDown() ? TransferMode.LINK : TransferMode.COPY;
            }
            Dragboard dragboard = builder.startDragAndDrop(new TransferMode[]{transferMode});
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(string);
            dragboard.setContent((Map)clipboardContent);
            mouseEvent.consume();
        }
    }
}

