/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.util.DaemonThread;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class FxHiddenComponentDemo {
    public static Node getRootNode() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("HiddenComponentDemo");
        Button button = new Button("Hide component");
        button.setId("hideButton");
        final TextField textField = new TextField();
        textField.setPromptText("Timeout angeben!");
        Button button2 = new Button("Show component");
        button2.setId("showButton");
        final Label label = new Label("Component currently not hidden");
        label.setId("hiddenComponent");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                label.setVisible(false);
                actionEvent.consume();
            }
        });
        final AtomicInteger atomicInteger = new AtomicInteger();
        button2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                long l;
                try {
                    l = Long.valueOf(textField.getText());
                }
                catch (Exception exception) {
                    l = 0L;
                }
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, runnable -> new DaemonThread(runnable, "HiddenComponentDemo setVisibleThread " + atomicInteger.incrementAndGet()));
                scheduledThreadPoolExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        label.setVisible(true);
                    }
                }, l, TimeUnit.MILLISECONDS);
                actionEvent.consume();
            }
        });
        gridPane.add((Node)button, 0, 0);
        gridPane.add((Node)textField, 0, 1);
        gridPane.add((Node)button2, 1, 0);
        gridPane.add((Node)label, 1, 1);
        return gridPane;
    }
}

