/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;

public class FxLargeTableDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxLargeTableDemo");

    public FxLargeTableDemo() {
        if (FxLargeTableDemo.logger.level >= 7) {
            logger.lvlBuild(7, "FxLargeTableDemo.FxLargeTableDemo()", 40).log();
        }
    }

    public static Node getRootNode() {
        if (FxLargeTableDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getRootNode()", 60).log();
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("LargeTableDemo");
        gridPane.add((Node)FxLargeTableDemo.createTableview(), 0, 0);
        return gridPane;
    }

    public static TableView createTableview() {
        if (FxLargeTableDemo.logger.level >= 7) {
            logger.lvlBuild(7, "createTableview()", 80).log();
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i = 0; i < 2000; ++i) {
            observableList.add((Object)("item " + i));
        }
        TableView tableView = new TableView(observableList);
        TableColumn tableColumn = new TableColumn("Left");
        tableColumn.setMinWidth(20.0);
        tableColumn.setId("LeftColumn");
        TableColumn tableColumn2 = new TableColumn("Right");
        tableColumn2.setMinWidth(20.0);
        tableColumn2.setId("RightColumn");
        tableView.getColumns().addAll((Object[])new TableColumn[]{tableColumn, tableColumn2});
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                String string = (String)cellDataFeatures.getValue();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "createTableview().Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>.call(CellDataFeatures<String, String>)", 102).add("value", string)).log();
                }
                return new ReadOnlyObjectWrapper((Object)("Left " + string));
            }
        });
        tableColumn.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "createTableview().Callback<TableColumn<String, String>, TableCell<String, String>>.call(TableColumn<String, String>)", 109).addDetail("table", (Object)tableColumn)).log();
                }
                TableCell tableCell = new TableCell(){

                    public void updateIndex(int n) {
                        if (logger.level >= 7) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createTableview().Callback<TableColumn<String, String>, TableCell<String, String>>.call(TableColumn<String, String>).TableCell<String, String>.updateIndex(int)", 113).addDetail("idx", n)).log();
                        }
                        super.updateIndex(n);
                        String string = (String)this.getItem();
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createTableview().Callback<TableColumn<String, String>, TableCell<String, String>>.call(TableColumn<String, String>).TableCell<String, String>.updateIndex(int)", 116).add("item", string)).log();
                        }
                        this.setText(string);
                        this.getTooltip().setText("Tooltip: " + string);
                    }
                };
                tableCell.setTooltip(new Tooltip());
                return tableCell;
            }
        });
        tableColumn2.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                String string = (String)cellDataFeatures.getValue();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "createTableview().Callback<TableColumn.CellDataFeatures<String, String>, ObservableValue<String>>.call(CellDataFeatures<String, String>)", 131).add("value", string)).log();
                }
                return new ReadOnlyObjectWrapper((Object)("Right " + (String)cellDataFeatures.getValue()));
            }
        });
        tableView.setId("Long table");
        return tableView;
    }

    private static enum Types {
        CHECKBOX,
        COMBOBOX,
        CHOICEBOX,
        TEXT;


        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Types() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Types.Types()", 44).log();
            }
        }
    }
}

