/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.Logger;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;

public abstract class FxMenuDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.MenuDemo");

    public static Node getRootNode() {
        if (FxMenuDemo.logger.level >= 7) {
            logger.log(7, "getRootNode()", "");
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("MenuDemo");
        final Label label = new Label("Selected: ");
        label.setId("result");
        gridPane.add((Node)label, 0, 2);
        MenuBar menuBar = new MenuBar();
        menuBar.setId("bar");
        Menu menu = new Menu("_Pulldown");
        menu.setMnemonicParsing(true);
        menu.setId("mPulldown");
        MenuItem menuItem = new MenuItem("_Item");
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miItem");
        menuItem.setOnAction((EventHandler)new Handler(label, "Item"));
        menu.getItems().add((Object)menuItem);
        MenuItem menuItem2 = new MenuItem("_Disabled item");
        menuItem2.setMnemonicParsing(true);
        menuItem2.setId("miDisabledItem");
        menuItem2.setDisable(true);
        menu.getItems().add((Object)menuItem2);
        Menu menu2 = new Menu("_Menu");
        menu2.setMnemonicParsing(true);
        menu2.setId("miMenu");
        menu.getItems().add((Object)menu2);
        menuItem = new MenuItem("_First item");
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miFirstItem");
        menuItem.setOnAction((EventHandler)new Handler(label, "First item"));
        menu2.getItems().add((Object)menuItem);
        menuItem = new MenuItem("_Second item");
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miSecondItem");
        menuItem.setOnAction((EventHandler)new Handler(label, "Second item"));
        menu2.getItems().add((Object)menuItem);
        menuItem = new MenuItem("_Third item");
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miThirdItem");
        menuItem.setOnAction((EventHandler)new Handler(label, "Third item"));
        menu2.getItems().add((Object)menuItem);
        CheckMenuItem checkMenuItem = new CheckMenuItem("_SubCheck me");
        checkMenuItem.setMnemonicParsing(true);
        checkMenuItem.setId("miSubCheck");
        menu2.getItems().add((Object)checkMenuItem);
        menu2.getItems().add((Object)new SeparatorMenuItem());
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem radioMenuItem = new RadioMenuItem("SubRadio _1");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miSubRadioFirst");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu2.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("SubRadio _2");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miSubRadioSecond");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu2.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("SubRadio _3");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miSubRadioThird");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu2.getItems().add((Object)radioMenuItem);
        checkMenuItem = new CheckMenuItem("_Check me");
        checkMenuItem.setMnemonicParsing(true);
        checkMenuItem.setId("miCheck");
        menu.getItems().add((Object)checkMenuItem);
        menu.getItems().add((Object)new SeparatorMenuItem());
        toggleGroup = new ToggleGroup();
        radioMenuItem = new RadioMenuItem("Radio _1");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miRadioFirst");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("Radio _2");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miRadioSecond");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("Radio _3");
        radioMenuItem.setMnemonicParsing(true);
        radioMenuItem.setId("miRadioThird");
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        menu.getItems().add((Object)new SeparatorMenuItem());
        Slider slider = new Slider(0.0, 10.0, 0.0);
        slider.setBlockIncrement(1.0);
        slider.setMajorTickUnit(1.0);
        slider.setMinorTickCount(0);
        slider.setSnapToTicks(true);
        slider.setId("cmiSlider");
        Label label2 = new Label();
        label2.setId("cmiLabel");
        label2.setAlignment(Pos.CENTER);
        label2.textProperty().bind((ObservableValue)slider.valueProperty().asString());
        VBox vBox = new VBox(2.0);
        vBox.getChildren().addAll((Object[])new Node[]{slider, label2});
        CustomMenuItem customMenuItem = new CustomMenuItem((Node)vBox);
        customMenuItem.setId("miCustom");
        menu.getItems().add((Object)customMenuItem);
        Menu menu3 = new Menu("_Small");
        menu3.setMnemonicParsing(true);
        menu3.setId("mSmall");
        menuItem = new MenuItem("_This is a very wide menu item to check vertical first movement.");
        menuItem.setMnemonicParsing(true);
        menuItem.setId("miWide");
        menuItem.setOnAction((EventHandler)new Handler(label, "Wide"));
        menu3.getItems().add((Object)menuItem);
        Menu menu4 = new Menu("_Empty");
        menu4.setMnemonicParsing(true);
        menu4.setId("mEmpty");
        Menu menu5 = new Menu("Me_gaMenu");
        menu5.setMnemonicParsing(true);
        menu5.setId("mMegaMenu");
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(10.0);
        gridPane2.setVgap(4.0);
        gridPane2.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        gridPane2.add((Node)new Label("Top left"), 0, 0);
        gridPane2.add((Node)new Label("Top right"), 0, 1);
        gridPane2.add((Node)new Label("Bottom left"), 1, 0);
        gridPane2.add((Node)new Label("Bottom right"), 1, 1);
        menuItem = new CustomMenuItem((Node)gridPane2);
        menuItem.setId("miMegaItem");
        menuItem.setOnAction((EventHandler)new Handler(label, "Mega"));
        menu5.getItems().add((Object)menuItem);
        menuBar.getMenus().addAll((Object[])new Menu[]{menu, menu3, menu4, menu5});
        gridPane.add((Node)menuBar, 0, 0);
        final Label label3 = new Label("Click for popup");
        label3.setId("popup");
        label3.setContextMenu(FxMenuDemo.createPopup(label, ""));
        label3.setOnMouseClicked(new EventHandler(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                    FxMenuDemo.createPopup(label, "-left").show((Node)label3, Side.LEFT, 0.0, 0.0);
                    FxMenuDemo.createPopup(label, "-right").show((Node)label3, Side.LEFT, 350.0, 0.0);
                }
            }
        });
        gridPane.add((Node)label3, 0, 1);
        return gridPane;
    }

    private static ContextMenu createPopup(Label label, String string) {
        if (string == null) {
            throw new IllegalArgumentException("suffix is marked non-null but is null");
        }
        boolean bl = string.length() == 0;
        MenuItem menuItem = new MenuItem("_Outer item" + string);
        menuItem.setMnemonicParsing(true);
        menuItem.setOnAction((EventHandler)new Handler(label, "Outer"));
        if (bl) {
            menuItem.setId("miOuter" + string);
        }
        MenuItem menuItem2 = new MenuItem("_Disabled item" + string);
        menuItem2.setMnemonicParsing(true);
        menuItem2.setDisable(true);
        if (bl) {
            menuItem2.setId("miDisabledItem");
        }
        Menu menu = new Menu("_Submenu" + string);
        menu.setMnemonicParsing(true);
        if (bl) {
            menu.setId("miSubmenu" + string);
        }
        MenuItem menuItem3 = new MenuItem("_Inner item" + string);
        menuItem3.setMnemonicParsing(true);
        if (bl) {
            menuItem3.setId("miInner" + string);
        }
        menuItem3.setOnAction((EventHandler)new Handler(label, "Inner"));
        menu.getItems().add((Object)menuItem3);
        CheckMenuItem checkMenuItem = new CheckMenuItem("_PopSubCheck me" + string);
        checkMenuItem.setMnemonicParsing(true);
        if (bl) {
            checkMenuItem.setId("miPopSubCheck" + string);
        }
        menu.getItems().add((Object)checkMenuItem);
        menu.getItems().add((Object)new SeparatorMenuItem());
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioMenuItem radioMenuItem = new RadioMenuItem("PopSubRadio _1" + string);
        radioMenuItem.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem.setId("miPopSubRadioFirst" + string);
        }
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("PopSubRadio _2" + string);
        radioMenuItem.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem.setId("miPopSubRadioSecond" + string);
        }
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        radioMenuItem = new RadioMenuItem("PopSubRadio _3" + string);
        radioMenuItem.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem.setId("miPopSubRadioThird" + string);
        }
        radioMenuItem.setToggleGroup(toggleGroup);
        menu.getItems().add((Object)radioMenuItem);
        checkMenuItem = new CheckMenuItem("_PopCheck me + suffix");
        checkMenuItem.setMnemonicParsing(true);
        if (bl) {
            checkMenuItem.setId("miPopCheck" + string);
        }
        toggleGroup = new ToggleGroup();
        RadioMenuItem radioMenuItem2 = new RadioMenuItem("PopRadio _1" + string);
        radioMenuItem2.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem2.setId("miPopRadioFirst" + string);
        }
        radioMenuItem2.setToggleGroup(toggleGroup);
        RadioMenuItem radioMenuItem3 = new RadioMenuItem("PopRadio _2" + string);
        radioMenuItem3.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem3.setId("miPopRadioSecond" + string);
        }
        radioMenuItem3.setToggleGroup(toggleGroup);
        RadioMenuItem radioMenuItem4 = new RadioMenuItem("PopRadio _3" + string);
        radioMenuItem4.setMnemonicParsing(true);
        if (bl) {
            radioMenuItem4.setId("miPopRadioThird" + string);
        }
        radioMenuItem4.setToggleGroup(toggleGroup);
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{menuItem, menuItem2, menu, checkMenuItem, new SeparatorMenuItem(), radioMenuItem2, radioMenuItem3, radioMenuItem4});
        return contextMenu;
    }

    public static class Handler
    implements EventHandler {
        private Label label;
        private String toSet;

        public Handler(Label label, String string) {
            this.label = label;
            this.toSet = string;
        }

        public void handle(ActionEvent actionEvent) {
            this.label.setText("Selected: " + this.toSet);
        }
    }
}

