/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.apps.qftest.demo.multi.Multi;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import de.qfs.lib.util.Reflector;
import java.awt.Dialog;
import java.io.File;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class FxMulti
extends Application
implements Thread.UncaughtExceptionHandler {
    private static final String FX_MULTI_DEMO_PACKAGE = FxMulti.class.getPackage().getName();
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.FxMulti");
    private Stage primaryStage;
    private SimpleStringProperty statusText = new SimpleStringProperty("Done.");
    private BorderPane mainPane;
    private boolean exceptionShowing;

    public static void main(String[] stringArray) {
        Log.setOutputLevel((int)2);
        LogSetup.instance().setupInitialLogging("fxmulti");
        ArgsParser argsParser = new ArgsParser();
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LogSetup.instance().setupLogging("fxmulti", argsParser);
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("main(String[])");
            (FxMulti.logger.level < 8 ? builder : builder.add("args: ").addAll((Object[])stringArray)).log(7);
        }
        FxMulti.launch((String[])stringArray);
    }

    public void start(Stage stage) throws Exception {
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("start(Stage)");
            (FxMulti.logger.level < 8 ? builder : builder.add("primaryStage: ").add((Object)stage)).log(7);
        }
        this.init(stage);
        stage.setX(20.0);
        stage.setY(20.0);
        stage.show();
    }

    private void init(Stage stage) {
        block3: {
            Logger.Builder builder;
            if (FxMulti.logger.level >= 7) {
                builder = logger.build("init(Stage)");
                (FxMulti.logger.level < 8 ? builder : builder.add("primaryStage: ").add((Object)stage)).log(7);
            }
            this.primaryStage = stage;
            stage.setTitle("FX Multi Demo");
            stage.setWidth(600.0);
            stage.setHeight(600.0);
            builder = new StackPane();
            builder.setId("FXMulti");
            BorderPane borderPane = new BorderPane();
            borderPane.setTop((Node)this.initMenus(stage));
            borderPane.setCenter((Node)this.initMainView());
            borderPane.setBottom(this.initStatusBar());
            builder.getChildren().add((Object)borderPane);
            stage.setScene(new Scene((Parent)builder));
            try {
                stage.getProperties().put((Object)"hostServices", (Object)this.getHostServices());
            }
            catch (Throwable throwable) {
                if (FxMulti.logger.level < 3) break block3;
                logger.log(3, "init(Stage)", throwable);
            }
        }
    }

    private Pane initMainView() {
        if (FxMulti.logger.level >= 7) {
            logger.log(7, "initMainView()", "");
        }
        this.mainPane = new BorderPane();
        this.mainPane.setId("MainView");
        this.mainPane.setStyle("-fx-background-color: grey; -fx-padding: 10px");
        if (FxMulti.logger.level >= 9) {
            logger.build("initMainView()").add("mainPane: ").add((Object)this.mainPane).log(9);
        }
        return this.mainPane;
    }

    private MenuBar initMenus(Stage stage) {
        Logger.Builder builder;
        if (FxMulti.logger.level >= 7) {
            builder = logger.build("initMenus(Stage)");
            (FxMulti.logger.level < 8 ? builder : builder.add("stage: ").add((Object)stage)).log(7);
        }
        builder = new MenuBar();
        builder.setId("MainMenuBar");
        this.addMenuToBar((MenuBar)builder, this.buildFileMenu(stage));
        this.addMenuToBar((MenuBar)builder, this.buildDemoMenu());
        this.addMenuToBar((MenuBar)builder, this.buildEmbedMenu());
        this.addMenuToBar((MenuBar)builder, this.buildMiscMenu());
        this.addMenuToBar((MenuBar)builder, this.buildHelpMenu());
        return builder;
    }

    private void addMenuToBar(MenuBar menuBar, Menu menu) {
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("addMenuToBar(MenuBar,Menu)");
            (FxMulti.logger.level < 8 ? builder : builder.add("menuBar: ").add((Object)menuBar).add(", menu: ").add((Object)menu)).log(7);
        }
        if (menu == null) {
            return;
        }
        menuBar.getMenus().add((Object)menu);
    }

    private Menu buildFileMenu(final Stage stage) {
        Logger.Builder builder;
        if (FxMulti.logger.level >= 7) {
            builder = logger.build("buildFileMenu(Stage)");
            (FxMulti.logger.level < 8 ? builder : builder.add("stage: ").add((Object)stage)).log(7);
        }
        builder = new Menu("_File");
        builder.setMnemonicParsing(true);
        builder.setId("mFile");
        this.addActionToMenu((Menu)builder, "miNew", "_New...", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                FxMulti.this.mainPane.getChildren().clear();
                FxMulti.this.statusText.set("Done.");
            }
        });
        this.addActionToMenu((Menu)builder, "miOpen", "_Open...", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                FxMulti.this.showFileDialog(stage, false);
            }
        });
        this.addActionToMenu((Menu)builder, "miSave", "_Save", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                FxMulti.this.statusText.set("Saved.");
            }
        });
        this.addActionToMenu((Menu)builder, "miSaveAs", "Save _as...", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                FxMulti.this.showFileDialog(stage, true);
            }
        });
        builder.getItems().add((Object)new SeparatorMenuItem());
        this.addActionToMenu((Menu)builder, "miExit", "_Exit", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                stage.close();
            }
        });
        return builder;
    }

    private void addActionToMenu(Menu menu, String string, String string2, EventHandler eventHandler) {
        Logger.Builder builder;
        if (FxMulti.logger.level >= 7) {
            builder = logger.build("addActionToMenu(Menu,String,String,EventHandler)");
            (FxMulti.logger.level < 8 ? builder : builder.add("menu: ").add((Object)menu).add(", id: ").add(string).add(", label: ").add(string2)).log(7);
        }
        if (eventHandler == null) {
            return;
        }
        builder = new MenuItem(string2);
        builder.setMnemonicParsing(true);
        builder.setId(string);
        builder.setOnAction(eventHandler);
        menu.getItems().add((Object)builder);
    }

    private Menu buildDemoMenu() {
        if (FxMulti.logger.level >= 7) {
            logger.log(7, "buildDemoMenu()", "");
        }
        Menu menu = new Menu("_Demos");
        menu.setMnemonicParsing(true);
        menu.setId("mDemos");
        this.addItemToDemoMenu(menu, "miAccordion", "A_ccordion", "FxAccordionDemo");
        this.addItemToDemoMenu(menu, "miComboBox", "_ComboBox", "FxComboDemo");
        this.addItemToDemoMenu(menu, "miDisabledComponents", "D_isabled Components", "FxDisabledDemo");
        this.addItemToDemoMenu(menu, "miDragAndDrop", "Dra_g and Drop", "FxDragAndDropDemo");
        this.addItemToDemoMenu(menu, "miHiddenComponent", "Hid_den Component", "FxHiddenComponentDemo");
        this.addItemToDemoMenu(menu, "hlList", "_Hyperlink", "FxHyperlinkDemo");
        this.addItemToDemoMenu(menu, "miList", "_List", "FxListDemo");
        this.addItemToDemoMenu(menu, "miLargeList", "L_arge List", "FxLargeListDemo");
        this.addItemToDemoMenu(menu, "miManyNodes", "Many Nodes", "FxManyNodesDemo");
        this.addItemToDemoMenu(menu, "miMenu", "_Menus", "FxMenuDemo");
        this.addItemToDemoMenu(menu, "miSpecialMenu", "Special Men_us", "FxSpecialMenuItem");
        this.addItemToDemoMenu(menu, "miMisc", "Misc", "FxMiscDemo");
        this.addItemToDemoMenu(menu, "miRadio", "_RadioButton & Checkbox", "FxRadioBtnCheckBoxDemo");
        this.addItemToDemoMenu(menu, "miItemResolver", "Item_Resolver", "FXitemResolverDemo");
        this.addItemToDemoMenu(menu, "miService", "Ser_vice", "FxServiceDemo");
        this.addItemToDemoMenu(menu, "miSlider", "_Slider", "FxSliderDemo");
        this.addItemToDemoMenu(menu, "miSplitpane", "S_plitpane", "FxSplitPaneDemo");
        this.addItemToDemoMenu(menu, "miSubScene", "_SubScene", "FxSubScene");
        this.addItemToDemoMenu(menu, "miTab", "Ta_b", "FxTabDemo");
        this.addItemToDemoMenu(menu, "miTable", "Tab_le", "FxTableDemo");
        this.addItemToDemoMenu(menu, "miLargeTable", "Lar_ge Table", "FxLargeTableDemo");
        this.addItemToDemoMenu(menu, "miFxml", "Table - F_xml", "FxmlDemo");
        this.addItemToDemoMenu(menu, "miNestedColumnsTable", "N_estedColumnsTable", "FxNestedColumnsTableDemo");
        this.addItemToDemoMenu(menu, "miText", "_Text", "FxTextDemo");
        this.addItemToDemoMenu(menu, "miTitledPane", "TitledPane", "FxTitledPaneDemo");
        this.addItemToDemoMenu(menu, "miTree", "T_ree", "FxTreeDemo");
        this.addItemToDemoMenu(menu, "miTreeTable", "TreeTab_le", "FxTreeTableDemo");
        this.addItemToDemoMenu(menu, "miNestedColumnsTreeTable", "Ne_stedColumns TreeTable", "FxNestedColumnsTreeTableDemo");
        this.addItemToDemoMenu(menu, "miVBox", "_VBox", "FxVBoxDemo");
        this.addItemToDemoMenu(menu, "miWebView", "_WebView", "FxWebViewDemo");
        this.addItemToDemoMenu(menu, "miWindow", "_Windows", "FxWindowDemo");
        this.addItemToDemoMenu(menu, "miContainer", "_Container", "FxContainerDemo");
        return menu;
    }

    private void addItemToDemoMenu(Menu menu, String string, String string2, String string3) {
        Object object;
        if (FxMulti.logger.level >= 7) {
            object = logger.build("addDemoToMenu(Menu,String,String,String)");
            (FxMulti.logger.level < 8 ? object : object.add("menu: ").add((Object)menu).add(", id: ").add(string).add(", label: ").add(string2).add(", className: ").add(string3)).log(7);
        }
        assert (menu != null);
        assert (string3 != null);
        object = FX_MULTI_DEMO_PACKAGE + "." + string3;
        Class clazz = this.tryToLoadClass((String)object);
        EventHandler eventHandler = this.getDemoMenuAction(clazz);
        this.addActionToMenu(menu, string, string2, eventHandler);
    }

    protected EventHandler getDemoMenuAction(final Class clazz) {
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("getDemoMenuAction(Class<?>)");
            (FxMulti.logger.level < 8 ? builder : builder.add("targetClass: ").add((Object)clazz)).log(7);
        }
        if (clazz == null) {
            return null;
        }
        return new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                block2: {
                    try {
                        FxMulti.this.showDemo((Node)Reflector.call((Class)clazz, (String)"getRootNode"));
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 1) break block2;
                        logger.log(1, "handle(ActionEvent)", throwable);
                    }
                }
            }
        };
    }

    private Class tryToLoadClass(String string) {
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("tryToLoadClass(String)");
            (FxMulti.logger.level < 8 ? builder : builder.add("fullQualifiedClassName: ").add(string)).log(7);
        }
        try {
            return Class.forName(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof UnsupportedClassVersionError) {
                return null;
            }
            if (throwable instanceof ClassNotFoundException) {
                if (FxMulti.logger.level >= 5) {
                    logger.log(5, "handle(ActionEvent)", "Class not found: " + string);
                }
                return null;
            }
            if (FxMulti.logger.level >= 1) {
                logger.log(1, "handle(ActionEvent)", throwable);
            }
            return null;
        }
    }

    private Menu buildEmbedMenu() {
        Class clazz;
        if (FxMulti.logger.level >= 7) {
            logger.log(7, "buildEmbedMenu()", "");
        }
        if ((clazz = this.tryToLoadClass(FX_MULTI_DEMO_PACKAGE + ".FxSwingNodeDemo")) == null) {
            return null;
        }
        Menu menu = new Menu("_Embedding");
        menu.setMnemonicParsing(true);
        menu.setId("mEmbed");
        this.addItemToEmbedMenu(menu, "miTwoDialogs", "Two _dialogs", clazz, "dialogs");
        this.addItemToEmbedMenu(menu, "miDND", "_Drag & Drop", clazz, "dnd");
        this.addItemToEmbedMenu(menu, "miNestedPopups", "_Nested popups", clazz, "nested");
        this.addItemToEmbedMenu(menu, "miTable", "_Table", clazz, "table");
        return menu;
    }

    private void addItemToEmbedMenu(Menu menu, String string, String string2, final Class clazz, final String string3) {
        if (FxMulti.logger.level >= 7) {
            Logger.Builder builder = logger.build("addItemToEmbedMenu(Menu,String,String,Class<?>,String)");
            (FxMulti.logger.level < 8 ? builder : builder.add("menu: ").add((Object)menu).add(", id: ").add(string).add(", label: ").add(string2).add(", swingNodeDemoClass: ").add((Object)clazz).add(", methodName: ").add(string3)).log(7);
        }
        this.addActionToMenu(menu, string, string2, new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                block2: {
                    try {
                        FxMulti.this.showDemo((Node)Reflector.call((Class)clazz, (String)"getRootNode", String.class, (Object)string3));
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 1) break block2;
                        logger.log(1, "handle(ActionEvent)", throwable);
                    }
                }
            }
        });
    }

    private Menu buildMiscMenu() {
        if (FxMulti.logger.level >= 7) {
            logger.log(7, "buildMiscMenu()", "");
        }
        Menu menu = new Menu("_Misc");
        menu.setMnemonicParsing(true);
        menu.setId("mMisc");
        Thread.currentThread().setUncaughtExceptionHandler(this);
        this.addActionToMenu(menu, "miThrow", "_Throw exception", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                throw new RuntimeException("Dummy exception thrown to debug exception handling.");
            }
        });
        this.addActionToMenu(menu, "miThrowLater", "Throw exception _later", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                new Timer("Throw-Later", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                throw new RuntimeException("Dummy exception thrown later to debug exception handling.");
                            }
                        });
                    }
                }, 500L);
            }
        });
        this.addActionToMenu(menu, "miSwingDialog", "Swing dialog", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                JDialog jDialog = new JDialog((Dialog)null, "Modal Swing dialog");
                jDialog.setModal(true);
                jDialog.getContentPane().add(new JButton("dummy"));
                jDialog.setVisible(true);
            }
        });
        this.addActionToMenu(menu, "miSwingDialog2", "Swing dialog 2", new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDialog jDialog = new JDialog((Dialog)null, "Modal Swing dialog");
                        jDialog.setModal(true);
                        jDialog.getContentPane().add(new JButton("dummy"));
                        jDialog.setVisible(true);
                    }
                });
            }
        });
        this.addBrowseItemsToMiscMenu(menu);
        return menu;
    }

    protected void addBrowseItemsToMiscMenu(Menu menu) {
        Menu menu2 = new Menu("_External Browser via FX");
        menu2.setMnemonicParsing(true);
        menu2.setId("mExternalBrowserFx");
        menu.getItems().add((Object)menu2);
        EventHandler eventHandler = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                String string = ((MenuItem)actionEvent.getSource()).getText();
                URI uRI = Multi.getDemoUri(string);
                try {
                    FxMulti.this.getHostServices().showDocument(uRI.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.addActionToMenu(menu2, "miHttpBrowserFx", "http URL", eventHandler);
        this.addActionToMenu(menu2, "miHttpsBrowserFx", "https URL", eventHandler);
        this.addActionToMenu(menu2, "miFileBrowserFx", "file URL", eventHandler);
        Menu menu3 = new Menu("E_xternal Browser via Desktop");
        menu3.setMnemonicParsing(true);
        menu3.setId("mExternalBrowserDesktop");
        menu.getItems().add((Object)menu3);
        EventHandler eventHandler2 = new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                String string = ((MenuItem)actionEvent.getSource()).getText();
                URI uRI = Multi.getDemoUri(string);
                try {
                    Multi.openBrowser(uRI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.addActionToMenu(menu3, "miHttpBrowserDesktop", "http URL", eventHandler2);
        this.addActionToMenu(menu3, "miHttpsBrowserDesktop", "https URL", eventHandler2);
        this.addActionToMenu(menu3, "miFileBrowserDesktop", "file URL", eventHandler2);
    }

    private Menu buildHelpMenu() {
        Menu menu = new Menu("_Help");
        menu.setMnemonicParsing(true);
        menu.setId("mHelp");
        return menu;
    }

    private Node initStatusBar() {
        if (FxMulti.logger.level >= 7) {
            logger.log(7, "initStatusBar()", "");
        }
        VBox vBox = new VBox();
        vBox.setStyle("-fx-background-color: gainsboro");
        Text text = new Text();
        text.textProperty().bind((ObservableValue)this.statusText);
        vBox.getChildren().add((Object)text);
        return vBox;
    }

    private void showFileDialog(Stage stage, boolean bl) {
        FileChooser fileChooser = new FileChooser();
        if (bl) {
            File file = fileChooser.showSaveDialog((Window)stage);
            if (null != file) {
                this.statusText.set("Saved " + file.toString());
            }
        } else {
            File file = fileChooser.showOpenDialog((Window)stage);
            if (null != file) {
                this.statusText.set("Opened " + file.toString());
            }
        }
    }

    private void showDemo(Node node) {
        this.mainPane.setCenter(node);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Logger.Builder builder;
        if (FxMulti.logger.level >= 7) {
            builder = logger.build("uncaughtException(Thread,Throwable)");
            (FxMulti.logger.level < 8 ? builder : builder.add("thread: ").add((Object)thread).add(", ex: ").add((Object)throwable)).log(7);
        }
        if (FxMulti.logger.level >= 5) {
            logger.log(5, "uncaughtException(Thread,Throwable)", throwable);
        }
        if (this.primaryStage != null && !this.exceptionShowing) {
            builder = new Stage();
            builder.initOwner((Window)this.primaryStage);
            builder.initModality(Modality.WINDOW_MODAL);
            builder.setTitle("Handling uncaught exception");
            Button button = new Button("Close");
            button.setId("bClose");
            button.setOnAction(new EventHandler((Stage)builder){
                final /* synthetic */ Stage val$stage;
                {
                    this.val$stage = stage;
                }

                public void handle(ActionEvent actionEvent) {
                    this.val$stage.close();
                    FxMulti.this.exceptionShowing = false;
                }
            });
            BorderPane borderPane = new BorderPane();
            borderPane.setId("UncaughtExceptionDialog");
            borderPane.setCenter((Node)button);
            builder.setScene(new Scene((Parent)borderPane, 300.0, 100.0));
            builder.setX(this.primaryStage.getX() + 100.0);
            builder.setY(this.primaryStage.getY() + 50.0);
            this.exceptionShowing = true;
            builder.show();
        }
    }
}

